/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.Koin;
import org.koin.error.MissingPropertyException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0001J\u001a\u0010\f\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001b\u0010\u0013\u001a\u00020\t2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0015\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u0002H\u0018\"\u0006\b\u0000\u0010\u0018\u0018\u00012\u0006\u0010\n\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0019J&\u0010\u0017\u001a\u0002H\u0018\"\u0006\b\u0000\u0010\u0018\u0018\u00012\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u0002H\u0018H\u0086\b\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u001eR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/koin/core/property/PropertyRegistry;", "", "()V", "properties", "Ljava/util/HashMap;", "", "getProperties", "()Ljava/util/HashMap;", "add", "", "key", "value", "addAll", "props", "", "clear", "containsKey", "", "delete", "deleteAll", "keys", "", "([Ljava/lang/String;)V", "getProperty", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "import", "", "Ljava/util/Properties;", "koin-core"})
public final class PropertyRegistry {
    @NotNull
    private final HashMap<String, Object> properties = new HashMap();

    @NotNull
    public final HashMap<String, Object> getProperties() {
        return this.properties;
    }

    private final <T> T getProperty(String key) {
        Object object = this.getProperties().get(key);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        if (object == null) {
            throw (Throwable)new MissingPropertyException("Can't find property '" + key + '\'');
        }
        return (T)object;
    }

    private final <T> T getProperty(String key, T defaultValue) {
        Object object = this.getProperties().get(key);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        Object object2 = object;
        if (object == null) {
            object2 = defaultValue;
        }
        Object value = object2;
        Koin.Companion.getLogger().debug("[Property] get " + key + " << '" + value + '\'');
        return (T)value;
    }

    public final void addAll(@NotNull Map<String, ? extends Object> props) {
        Intrinsics.checkParameterIsNotNull(props, (String)"props");
        Koin.Companion.getLogger().debug("[Property] add properties " + props.size());
        Map map = this.properties;
        map.putAll(props);
    }

    public final int import(@NotNull Properties properties) {
        Object it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        Set<Object> set = properties.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"properties.keys");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = element$iv$iv;
            if (!(it instanceof String && properties.get(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Object t = it;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)t;
            Object object = properties.get(it);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"properties[it]!!");
            this.add(string, object);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        Collection collection = (List)destination$iv$iv;
        return collection.size();
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.properties.containsKey(key);
    }

    public final void add(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Koin.Companion.getLogger().debug("[Property] set " + key + " >> '" + value + '\'');
        Map map = this.properties;
        Pair pair = new Pair((Object)key, value);
        map.put(pair.getFirst(), pair.getSecond());
    }

    public final void delete(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Koin.Companion.getLogger().debug("[Property] delete " + key);
        this.properties.remove(key);
    }

    public final void deleteAll(@NotNull String[] keys) {
        Intrinsics.checkParameterIsNotNull((Object)keys, (String)"keys");
        for (Object element$iv : (Object[])keys) {
            String it = (String)element$iv;
            this.delete(it);
        }
    }

    public final void clear() {
        this.properties.clear();
    }
}

