/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.property;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.Koin;
import org.koin.error.MissingPropertyException;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u0002H\u0010\"\u0006\b\u0000\u0010\u0010\u0018\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0011J&\u0010\u000f\u001a\u0002H\u0010\"\u0006\b\u0000\u0010\u0010\u0018\u00012\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u0002H\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0001R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/koin/core/property/PropertyRegistry;", "", "()V", "properties", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getProperties", "()Ljava/util/HashMap;", "addAll", "", "props", "", "delete", "key", "getProperty", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "setProperty", "value", "koin-core"})
public final class PropertyRegistry {
    @NotNull
    private final HashMap<String, Object> properties = new HashMap();

    @NotNull
    public final HashMap<String, Object> getProperties() {
        return this.properties;
    }

    private final <T> T getProperty(String key) {
        Object object = this.getProperties().get(key);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        if (object == null) {
            throw (Throwable)new MissingPropertyException("Can't find property '" + key + '\'');
        }
        return (T)object;
    }

    private final <T> T getProperty(String key, T defaultValue) {
        Object object = this.getProperties().get(key);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        Object object2 = object;
        if (object == null) {
            object2 = defaultValue;
        }
        return (T)object2;
    }

    public final void setProperty(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Koin.Companion.getLogger().log("set property " + key + " -> " + value);
        Map map = this.properties;
        Object object = value;
        map.put(key, object);
    }

    public final void addAll(@NotNull Map<String, ? extends Object> props) {
        Intrinsics.checkParameterIsNotNull(props, (String)"props");
        Koin.Companion.getLogger().log("addAll properties " + props);
        Map map = this.properties;
        map.putAll(props);
    }

    public final void delete(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Koin.Companion.getLogger().log("delete property " + key);
        this.properties.remove(key);
    }
}

