/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.wpc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ProcessorImpl
extends AbstractProcessor {
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "LPT1", "LPT2", "LPT3"));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elements = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getRootElements()) {
            String[] tokens;
            PackageElement p = elements.getPackageOf(element);
            for (String t : tokens = p.getQualifiedName().toString().split("\\.")) {
                if (!RESERVED_WORDS.contains(t.toUpperCase(Locale.ENGLISH))) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Package name " + p.getQualifiedName() + " contains " + t + ", which is a reserved word in Windows. See http://support.microsoft.com/kb/74496/en-us", element);
            }
        }
        return false;
    }
}

