/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.QueryParameter;

public class QueryParameterAnnotationProcessor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;

    public QueryParameterAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    public void process() {
        try {
            for (TypeDeclaration d : this.env.getTypeDeclarations()) {
                if (!(d instanceof ClassDeclaration)) continue;
                ClassDeclaration cd = (ClassDeclaration)d;
                for (MethodDeclaration m : cd.getMethods()) {
                    if (!this.hasQueryParameterAnnotation(m)) continue;
                    this.write(m);
                }
            }
        }
        catch (IOException e) {
            this.env.getMessager().printError(e.getMessage());
        }
    }

    private boolean hasQueryParameterAnnotation(MethodDeclaration m) {
        for (ParameterDeclaration p : m.getParameters()) {
            if (p.getAnnotation(QueryParameter.class) == null) continue;
            return true;
        }
        return false;
    }

    private void write(MethodDeclaration m) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (ParameterDeclaration p : m.getParameters()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(p.getSimpleName());
        }
        File f = new File(m.getDeclaringType().getQualifiedName().replace('.', '/') + "/" + m.getSimpleName() + ".stapler");
        this.env.getMessager().printNotice("Generating " + f);
        OutputStream os = this.env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", f);
        IOUtils.write((StringBuffer)buf, (OutputStream)os, (String)"UTF-8");
        os.close();
    }
}

