/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConstructorProcessor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;

    public ConstructorProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    public void process() {
        try {
            for (TypeDeclaration d : this.env.getTypeDeclarations()) {
                if (!(d instanceof ClassDeclaration)) continue;
                ClassDeclaration cd = (ClassDeclaration)d;
                for (ConstructorDeclaration c : cd.getConstructors()) {
                    if (c.getAnnotation(DataBoundConstructor.class) != null) {
                        this.write(c);
                        continue;
                    }
                    String javadoc = c.getDocComment();
                    if (javadoc == null || !javadoc.contains("@stapler-constructor")) continue;
                    this.write(c);
                }
            }
        }
        catch (IOException e) {
            this.env.getMessager().printError(e.getMessage());
        }
    }

    private void write(ConstructorDeclaration c) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (ParameterDeclaration p : c.getParameters()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(p.getSimpleName());
        }
        File f = new File(c.getDeclaringType().getQualifiedName().replace('.', '/') + ".stapler");
        this.env.getMessager().printNotice("Generating " + f);
        OutputStream os = this.env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", f);
        Properties p = new Properties();
        p.put("constructor", buf.toString());
        p.store(os, null);
        os.close();
    }
}

