/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.array.ObjectArrayMorpher;
import net.sf.ezmorph.bean.BeanMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.AbstractJSON;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONObject
extends AbstractJSON
implements JSON,
Map<String, Object>,
Comparable {
    private static final Log log = LogFactory.getLog(JSONObject.class);
    private boolean nullObject;
    private Map properties = new TreeMap();

    public static JSONObject fromObject(Object object) {
        return JSONObject.fromObject(object, new JsonConfig());
    }

    public static JSONObject fromObject(Object object, JsonConfig jsonConfig) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (object instanceof JSONObject) {
            return JSONObject._fromJSONObject((JSONObject)object, jsonConfig);
        }
        if (object instanceof DynaBean) {
            return JSONObject._fromDynaBean((DynaBean)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof JSONString) {
            return JSONObject._fromJSONString((JSONString)object, jsonConfig);
        }
        if (object instanceof Map) {
            return JSONObject._fromMap((Map)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONObject._fromString((String)object, jsonConfig);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObject._fromBean(object, jsonConfig);
    }

    public Object toBean() {
        return JSONObject.toBean(this);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        Map props = JSONUtils.getProperties(jsonObject);
        DynaBean dynaBean = JSONUtils.newDynaBean(jsonObject, new JsonConfig());
        for (String name : jsonObject.names()) {
            String key = JSONUtils.convertToJavaIdentifier(name, new JsonConfig());
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            try {
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        dynaBean.set(key, (Object)JSONArray.toList((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                        dynaBean.set(key, value);
                        continue;
                    }
                    dynaBean.set(key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    dynaBean.set(key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                dynaBean.set(key, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type" + type, e);
            }
        }
        return dynaBean;
    }

    public Object toBean(Class beanClass) {
        return JSONObject.toBean(this, beanClass);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        jsonConfig.setClassMap(classMap);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        HashMap bean;
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        Class beanClass = jsonConfig.getRootClass();
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = jsonConfig.getNewBeanInstanceStrategy().newInstance(beanClass, jsonObject);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return JSONObject.toBean(jsonObject, bean, jsonConfig);
    }

    private static Property getProperty(Class beanClass, Object bean, String key, JsonConfig jsonConfig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (Map.class.isAssignableFrom(beanClass)) {
            return new PropertyOnMap(key);
        }
        key = jsonConfig.isSkipJavaIdentifierTransformationInMapKeys() ? key : JSONUtils.convertToJavaIdentifier(key, jsonConfig);
        try {
            return new FieldProperty(bean.getClass().getField(key));
        }
        catch (NoSuchFieldException e) {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)bean, (String)key);
            if (pd != null) {
                return new MethodProperty(pd);
            }
            return null;
        }
    }

    public static Object toBean(JSONObject jsonObject, Object bean, JsonConfig jsonConfig) {
        if (jsonObject == null || jsonObject.isNullObject() || bean == null) {
            return bean;
        }
        Class<?> rootClass = bean.getClass();
        if (rootClass.isInterface()) {
            throw new JSONException("Root bean is an interface. " + rootClass);
        }
        Map classMap = jsonConfig.getClassMap();
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        Map props = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        for (String name : jsonObject.names()) {
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(bean, name, value)) continue;
            try {
                Property pd = JSONObject.getProperty(rootClass, bean, name, jsonConfig);
                if (pd == null) continue;
                if (!pd.isWritable()) {
                    log.warn((Object)("Property '" + pd.name() + "' has no write method. SKIPPED."));
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    JsonConfig jsc;
                    Class targetClass;
                    if (value instanceof JSONArray) {
                        if (List.class.isAssignableFrom(pd.type())) {
                            targetClass = JSONObject.findTargetClass(pd.name(), classMap);
                            targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                            jsc = jsonConfig.copy();
                            jsc.setRootClass(targetClass);
                            jsc.setClassMap(classMap);
                            List list = JSONArray.toList((JSONArray)value, jsc);
                            pd.set(bean, list);
                            continue;
                        }
                        Class innerType = JSONUtils.getInnerComponentType(pd.type());
                        Class targetInnerType = JSONObject.findTargetClass(pd.name(), classMap);
                        if (innerType == Object.class && targetInnerType != null && targetInnerType != Object.class) {
                            innerType = targetInnerType;
                        }
                        JsonConfig jsc2 = jsonConfig.copy();
                        jsc2.setRootClass(innerType);
                        jsc2.setClassMap(classMap);
                        Object array = JSONArray.toArray((JSONArray)value, jsc2);
                        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class == innerType || JSONUtils.isString(innerType)) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        } else if (!array.getClass().equals(pd.type()) && !pd.type().equals(Object.class)) {
                            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
                            if (IdentityObjectMorpher.getInstance().equals((Object)morpher)) {
                                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher((Morpher)new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                                JSONUtils.getMorpherRegistry().registerMorpher((Morpher)beanMorpher);
                            }
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        pd.set(bean, array);
                        continue;
                    }
                    if (String.class == type || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (pd != null) {
                            if (jsonConfig.isHandleJettisonEmptyElement() && "".equals(value)) {
                                pd.set(bean, null);
                                continue;
                            }
                            if (!pd.type().isInstance(value)) {
                                Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(pd.type());
                                if (IdentityObjectMorpher.getInstance().equals((Object)morpher)) {
                                    log.warn((Object)("Can't transform property '" + pd.name() + "' from " + type.getName() + " into " + pd.type().getName() + ". Will register a default BeanMorpher"));
                                    JSONUtils.getMorpherRegistry().registerMorpher((Morpher)new BeanMorpher(pd.type(), JSONUtils.getMorpherRegistry()));
                                }
                                pd.set(bean, JSONUtils.getMorpherRegistry().morph(pd.type(), value));
                                continue;
                            }
                            pd.set(bean, value);
                            continue;
                        }
                        if (bean instanceof Map) {
                            pd.set(bean, value);
                            continue;
                        }
                        log.warn((Object)("Tried to assign property " + pd.name() + ":" + type.getName() + " to bean of class " + bean.getClass().getName()));
                        continue;
                    }
                    if (pd != null) {
                        targetClass = pd.type();
                        if (jsonConfig.isHandleJettisonSingleElementArray()) {
                            JSONArray array = new JSONArray().element(value, jsonConfig);
                            Class newTargetClass = JSONObject.findTargetClass(pd.name(), classMap);
                            newTargetClass = newTargetClass == null ? JSONObject.findTargetClass(name, classMap) : newTargetClass;
                            JsonConfig jsc3 = jsonConfig.copy();
                            jsc3.setRootClass(newTargetClass);
                            jsc3.setClassMap(classMap);
                            if (targetClass.isArray()) {
                                pd.set(bean, JSONArray.toArray(array, jsc3));
                                continue;
                            }
                            if (Collection.class.isAssignableFrom(targetClass)) {
                                pd.set(bean, JSONArray.toList(array, jsc3));
                                continue;
                            }
                            if (JSONArray.class.isAssignableFrom(targetClass)) {
                                pd.set(bean, array);
                                continue;
                            }
                            pd.set(bean, JSONObject.toBean((JSONObject)value, jsc3));
                            continue;
                        }
                        if (targetClass == Object.class) {
                            targetClass = JSONObject.findTargetClass(pd.name(), classMap);
                            targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                        }
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(targetClass);
                        jsc.setClassMap(classMap);
                        pd.set(bean, JSONObject.toBean((JSONObject)value, jsc));
                        continue;
                    }
                    if (bean instanceof Map) {
                        targetClass = JSONObject.findTargetClass(pd.name(), classMap);
                        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(targetClass);
                        jsc.setClassMap(classMap);
                        if (targetClass != null) {
                            pd.set(bean, JSONObject.toBean((JSONObject)value, jsc));
                            continue;
                        }
                        pd.set(bean, JSONObject.toBean((JSONObject)value));
                        continue;
                    }
                    log.warn((Object)("Tried to assign property " + pd.name() + ":" + type.getName() + " to bean of class " + bean.getClass().getName()));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + pd.name() + ":" + type.getName()));
                    pd.set(bean, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                pd.set(bean, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type " + type, e);
            }
        }
        return bean;
    }

    private static JSONObject _fromBean(Object bean, JsonConfig jsonConfig) {
        JSONObject.fireObjectStartEvent(jsonConfig);
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JsonBeanProcessor processor = jsonConfig.findJsonBeanProcessor(bean.getClass());
        if (processor != null) {
            try {
                JSONObject json = processor.processBean(bean, jsonConfig);
                if (json == null) {
                    json = new JSONObject(true);
                }
                JSONObject.removeInstance(bean);
                JSONObject.fireObjectEndEvent(jsonConfig);
                return json;
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            Class<?> beanClass = bean.getClass();
            for (int i = 0; i < pds.length; ++i) {
                String key = pds[i].getName();
                if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransientField(key, beanClass)) continue;
                Class<?> type = pds[i].getPropertyType();
                if (pds[i].getReadMethod() != null) {
                    Object value = PropertyUtils.getProperty((Object)bean, (String)key);
                    if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                    if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value, jsonConfig))) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                    JSONObject.setValue(jsonObject, key, value, type, jsonConfig);
                    continue;
                }
                String warning = "Property '" + key + "' has no read method. SKIPPED";
                JSONObject.fireWarnEvent(warning, jsonConfig);
                log.warn((Object)warning);
            }
            for (Field f : bean.getClass().getFields()) {
                String key = f.getName();
                if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && Modifier.isTransient(f.getModifiers())) continue;
                Class<?> type = f.getType();
                f.setAccessible(true);
                Object value = f.get(bean);
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value, jsonConfig))) {
                    throw new JSONException("Value is not a valid JSON value. " + value);
                }
                JSONObject.setValue(jsonObject, key, value, type, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (Exception e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromDynaBean(DynaBean bean, JsonConfig jsonConfig) {
        JSONObject.fireObjectStartEvent(jsonConfig);
        if (bean == null) {
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject jsonObject = new JSONObject();
        try {
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (int i = 0; i < props.length; ++i) {
                DynaProperty dynaProperty = props[i];
                String key = dynaProperty.getName();
                if (exclusions.contains(key)) continue;
                Class type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(type, key);
                if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value, jsonConfig))) {
                    throw new JSONException("Value is not a valid JSON value. " + value);
                }
                JSONObject.setValue(jsonObject, key, value, type, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONObject(JSONObject object, JsonConfig jsonConfig) {
        JSONObject.fireObjectStartEvent(jsonConfig);
        if (object == null || object.isNullObject()) {
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(object)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(object);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(object);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(object);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray sa = object.names();
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        for (String key : sa) {
            if (exclusions.contains(key)) continue;
            Object value = object.opt(key);
            if (jsonPropertyFilter != null && jsonPropertyFilter.apply(object, key, value)) continue;
            if (jsonObject.properties.containsKey(key)) {
                jsonObject.accumulate(key, value, jsonConfig);
                JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                continue;
            }
            jsonObject._setInternal(key, value, jsonConfig);
            JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
        }
        JSONObject.removeInstance(object);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONString(JSONString string, JsonConfig jsonConfig) {
        return JSONObject._fromJSONTokener(new JSONTokener(string.toJSONString()), jsonConfig);
    }

    private static JSONObject _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        JSONObject.fireObjectStartEvent(jsonConfig);
        try {
            if (tokener.matches("null.*")) {
                JSONObject.fireObjectEndEvent(jsonConfig);
                return new JSONObject(true);
            }
            if (tokener.nextClean() != '{') {
                throw tokener.syntaxError("A JSONObject text must begin with '{'");
            }
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            JSONObject jsonObject = new JSONObject();
            block14: while (true) {
                Object value;
                Object v;
                char c = tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw tokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                tokener.back();
                String key = tokener.nextValue(jsonConfig).toString();
                c = tokener.nextClean();
                if (c == '=') {
                    if (tokener.next() != '>') {
                        tokener.back();
                    }
                } else if (c != ':') {
                    throw tokener.syntaxError("Expected a ':' after a key");
                }
                if (!JSONUtils.isFunctionHeader(v = tokener.nextValue(jsonConfig))) {
                    if (exclusions.contains(key)) {
                        switch (tokener.nextClean()) {
                            case ',': 
                            case ';': {
                                if (tokener.nextClean() == '}') {
                                    JSONObject.fireObjectEndEvent(jsonConfig);
                                    return jsonObject;
                                }
                                tokener.back();
                                continue block14;
                            }
                            case '}': {
                                JSONObject.fireObjectEndEvent(jsonConfig);
                                return jsonObject;
                            }
                        }
                        throw tokener.syntaxError("Expected a ',' or '}'");
                    }
                    if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, v)) {
                        if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                            value = "\"" + v + "\"";
                            if (jsonObject.properties.containsKey(key)) {
                                jsonObject.accumulate(key, value, jsonConfig);
                                JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                            } else {
                                jsonObject.element(key, value, jsonConfig);
                                JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
                            }
                        } else if (jsonObject.properties.containsKey(key)) {
                            jsonObject.accumulate(key, v, jsonConfig);
                            JSONObject.firePropertySetEvent(key, v, true, jsonConfig);
                        } else {
                            jsonObject.element(key, v, jsonConfig);
                            JSONObject.firePropertySetEvent(key, v, false, jsonConfig);
                        }
                    }
                } else {
                    char ch;
                    String params = JSONUtils.getFunctionParams((String)v);
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    while ((ch = tokener.next()) != '\u0000') {
                        if (ch == '{') {
                            ++i;
                        }
                        if (ch == '}') {
                            --i;
                        }
                        sb.append(ch);
                        if (i != 0) continue;
                        break;
                    }
                    if (i != 0) {
                        throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                    }
                    String text = sb.toString();
                    text = text.substring(1, text.length() - 1).trim();
                    value = new JSONFunction(params != null ? StringUtils.split((String)params, (String)",") : null, text);
                    if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, value)) {
                        if (jsonObject.properties.containsKey(key)) {
                            jsonObject.accumulate(key, value, jsonConfig);
                            JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                        } else {
                            jsonObject.element(key, value, jsonConfig);
                            JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
                        }
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == '}') {
                            JSONObject.fireObjectEndEvent(jsonConfig);
                            return jsonObject;
                        }
                        tokener.back();
                        continue block14;
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or '}'");
        }
        catch (JSONException jsone) {
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
    }

    private static JSONObject _fromMap(Map map, JsonConfig jsonConfig) {
        JSONObject.fireObjectStartEvent(jsonConfig);
        if (map == null) {
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(map)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(map);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(map);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(map);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        try {
            for (Map.Entry entry : map.entrySet()) {
                String key;
                Object k = entry.getKey();
                String string = key = k instanceof String ? (String)k : String.valueOf(k);
                if (exclusions.contains(key)) continue;
                Object value = entry.getValue();
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(map, key, value)) continue;
                if (value != null) {
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass(), key);
                    if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value, jsonConfig))) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                    JSONObject.setValue(jsonObject, key, value, value.getClass(), jsonConfig);
                    continue;
                }
                if (jsonObject.properties.containsKey(key)) {
                    jsonObject.accumulate(key, JSONNull.getInstance());
                    JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), true, jsonConfig);
                    continue;
                }
                jsonObject.element(key, JSONNull.getInstance());
                JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), false, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(map);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(map);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(map);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromString(String str, JsonConfig jsonConfig) {
        if (str == null || "null".compareToIgnoreCase(str) == 0) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        return JSONObject._fromJSONTokener(new JSONTokener(str), jsonConfig);
    }

    private static Class findTargetClass(String key, Map classMap) {
        Class targetClass = (Class)classMap.get(key);
        if (targetClass == null) {
            for (Map.Entry entry : classMap.entrySet()) {
                if (!RegexpUtils.getMatcher((String)entry.getKey()).matches(key)) continue;
                targetClass = (Class)entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static boolean isTransientField(String name, Class beanClass) {
        try {
            Field field = beanClass.getDeclaredField(name);
            return (field.getModifiers() & 0x80) == 128;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void setValue(JSONObject jsonObject, String key, Object value, Class type, JsonConfig jsonConfig) {
        boolean accumulated = false;
        if (value == null) {
            value = JSONUtils.isArray(type) ? new JSONArray() : (JSONUtils.isNumber(type) ? (JSONUtils.isDouble(type) ? (Number)new Double(0.0) : (Number)new Integer(0)) : (JSONUtils.isBoolean(type) ? Boolean.FALSE : (JSONUtils.isString(type) ? "" : JSONNull.getInstance())));
        }
        if (jsonObject.properties.containsKey(key)) {
            if (String.class.isAssignableFrom(type)) {
                Object o = jsonObject.opt(key);
                if (o instanceof JSONArray) {
                    ((JSONArray)o).addString((String)value);
                } else {
                    jsonObject.properties.put(key, new JSONArray().element(o).addString((String)value));
                }
            } else {
                jsonObject.accumulate(key, value, jsonConfig);
            }
            accumulated = true;
        } else if (String.class.isAssignableFrom(type)) {
            jsonObject.properties.put(key, value);
        } else {
            jsonObject._setInternal(key, value, jsonConfig);
        }
        value = jsonObject.opt(key);
        if (accumulated) {
            JSONArray array = (JSONArray)value;
            value = array.get(array.size() - 1);
        }
        JSONObject.firePropertySetEvent(key, value, accumulated, jsonConfig);
    }

    public JSONObject() {
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject accumulate(String key, boolean value) {
        return this._accumulate(key, value ? Boolean.TRUE : Boolean.FALSE, new JsonConfig());
    }

    public JSONObject accumulate(String key, double value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, int value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, long value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value, JsonConfig jsonConfig) {
        return this._accumulate(key, value, jsonConfig);
    }

    public void accumulateAll(Map map) {
        this.accumulateAll(map, new JsonConfig());
    }

    public void accumulateAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONObject) {
            int size2;
            JSONObject other = (JSONObject)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value, new JsonConfig());
    }

    public boolean containsValue(Object value, JsonConfig jsonConfig) {
        try {
            value = this.processValue(value, jsonConfig);
        }
        catch (JSONException e) {
            return false;
        }
        return this.properties.containsValue(value);
    }

    public JSONObject element(String key, boolean value) {
        this.verifyIsNull();
        return this.element(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject element(String key, Collection value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Collection value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (value instanceof JSONArray) {
            return this.setInternal(key, value, jsonConfig);
        }
        return this.element(key, JSONArray.fromObject(value, jsonConfig));
    }

    public JSONObject element(String key, double value) {
        this.verifyIsNull();
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        return this.element(key, d);
    }

    public JSONObject element(String key, int value) {
        this.verifyIsNull();
        return this.element(key, new Integer(value));
    }

    public JSONObject element(String key, long value) {
        this.verifyIsNull();
        return this.element(key, new Long(value));
    }

    public JSONObject element(String key, Map value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Map value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (value instanceof JSONObject) {
            return this.setInternal(key, value, jsonConfig);
        }
        return this.element(key, JSONObject.fromObject(value, jsonConfig), jsonConfig);
    }

    public JSONObject element(String key, Object value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            value = this.processValue(key, value, jsonConfig);
            this.setInternal(key, value, jsonConfig);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject elementOpt(String key, Object value) {
        return this.elementOpt(key, value, new JsonConfig());
    }

    public JSONObject elementOpt(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.element(key, value, jsonConfig);
        }
        return this;
    }

    @Override
    public Set entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.isNullObject()) {
            return other.isNullObject();
        }
        if (other.isNullObject()) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (String key : this.properties.keySet()) {
            if (!other.properties.containsKey(key)) {
                return false;
            }
            Object o1 = this.properties.get(key);
            Object o2 = other.properties.get(key);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public Object get(String key) {
        this.verifyIsNull();
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            try {
                return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
            }
            catch (Exception e) {
                throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null && o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public String getString(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o.toString();
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    @Override
    public int hashCode() {
        int hashcode = 19;
        if (this.isNullObject()) {
            return hashcode + JSONNull.getInstance().hashCode();
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            hashcode += key.hashCode() + JSONUtils.hashCode(value);
        }
        return hashcode;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        this.verifyIsNull();
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator keys() {
        this.verifyIsNull();
        return this.properties.keySet().iterator();
    }

    @Override
    public Set keySet() {
        return this.properties.keySet();
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.element(keys.next());
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Object previous = this.properties.get(key);
        this.element(String.valueOf(key), value);
        return previous;
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, new JsonConfig());
    }

    public void putAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.properties.put(key, value);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.element(key, value, jsonConfig);
            }
        }
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        this.verifyIsNull();
        return this.properties.size();
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.size(); ++i) {
            ja.element(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    @Override
    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    protected void write(Writer writer, AbstractJSON.WritingVisitor visitor) throws IOException {
        if (this.isNullObject()) {
            writer.write(JSONNull.getInstance().toString());
            return;
        }
        boolean b = false;
        Iterator keys = this.keys();
        writer.write(123);
        while (keys.hasNext()) {
            if (b) {
                writer.write(44);
            }
            Object k = keys.next();
            writer.write(JSONUtils.quote(k.toString()));
            writer.write(58);
            Object v = this.properties.get(k);
            if (v instanceof JSON) {
                visitor.on((JSON)v, writer);
            } else {
                visitor.on(v, writer);
            }
            b = true;
        }
        writer.write(125);
    }

    private JSONObject _accumulate(String key, Object value, JsonConfig jsonConfig) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        if (!this.has(key)) {
            this.setInternal(key, value, jsonConfig);
        } else {
            Object o = this.opt(key);
            if (o instanceof JSONArray) {
                ((JSONArray)o).element(value, jsonConfig);
            } else {
                this.setInternal(key, new JSONArray().element(o).element(value, jsonConfig), jsonConfig);
            }
        }
        return this;
    }

    private Object _processValue(Object value, JsonConfig jsonConfig) {
        if (value != null && Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof JSON) {
            return JSONSerializer.toJSON(value, jsonConfig);
        }
        if (JSONUtils.isFunction(value)) {
            if (value instanceof String) {
                value = JSONFunction.parse((String)value);
            }
            return value;
        }
        if (value instanceof JSONString) {
            return JSONSerializer.toJSON(value, jsonConfig);
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value, jsonConfig);
        }
        if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (value == null) {
                return "";
            }
            return str;
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return String.valueOf(value);
        }
        return JSONObject.fromObject(value, jsonConfig);
    }

    private JSONObject _setInternal(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        this.properties.put(key, this._processValue(value, jsonConfig));
        return this;
    }

    private Object processValue(Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value, jsonConfig);
    }

    private Object processValue(String key, Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass(), key)) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value, jsonConfig);
    }

    private JSONObject setInternal(String key, Object value, JsonConfig jsonConfig) {
        return this._setInternal(key, this.processValue(key, value, jsonConfig), jsonConfig);
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }

    private static class FieldProperty
    implements Property {
        private final Field f;

        private FieldProperty(Field f) {
            this.f = f;
        }

        public boolean isWritable() {
            return true;
        }

        public Class type() {
            return this.f.getType();
        }

        public String name() {
            return this.f.getName();
        }

        public void set(Object bean, Object value) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            this.f.set(bean, value);
        }
    }

    private static class MethodProperty
    implements Property {
        private final PropertyDescriptor pd;

        private MethodProperty(PropertyDescriptor pd) {
            this.pd = pd;
        }

        public boolean isWritable() {
            return this.pd.getWriteMethod() != null;
        }

        public String name() {
            return this.pd.getName();
        }

        public Class type() {
            return this.pd.getPropertyType();
        }

        public void set(Object bean, Object value) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            PropertyUtils.setSimpleProperty((Object)bean, (String)this.pd.getName(), (Object)value);
        }
    }

    private static class PropertyOnMap
    implements Property {
        private final String name;

        private PropertyOnMap(String name) {
            this.name = name;
        }

        public boolean isWritable() {
            return true;
        }

        public String name() {
            return this.name;
        }

        public Class type() {
            return Object.class;
        }

        public void set(Object bean, Object value) {
            ((Map)bean).put(this.name, value);
        }
    }

    private static interface Property {
        public boolean isWritable();

        public Class type();

        public String name();

        public void set(Object var1, Object var2) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException;
    }
}

