/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONException;
import net.sf.json.JsonConfig;
import net.sf.json.util.JsonEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractJSON {
    private static ThreadLocal cycleSet = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashSet();
        }
    };
    private static final Log log = LogFactory.getLog(AbstractJSON.class);

    AbstractJSON() {
    }

    protected static boolean addInstance(Object instance) {
        return AbstractJSON.getCycleSet().add(instance);
    }

    protected static void fireArrayEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onArrayEnd();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireArrayStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onArrayStart();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireElementAddedEvent(int index, Object element, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onElementAdded(index, element);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireErrorEvent(JSONException jsone, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onError(jsone);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireObjectEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onObjectEnd();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireObjectStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onObjectStart();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void firePropertySetEvent(String key, Object value, boolean accumulated, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onPropertySet(key, value, accumulated);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireWarnEvent(String warning, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (JsonEventListener listener : jsonConfig.getJsonEventListeners()) {
                try {
                    listener.onWarning(warning);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void removeInstance(Object instance) {
        AbstractJSON.getCycleSet().remove(instance);
    }

    private static Set getCycleSet() {
        return (Set)cycleSet.get();
    }
}

