/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.pgp.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.kohsuke.maven.pgp.PgpMojo;
import org.kohsuke.maven.pgp.SecretKeyLoader;

@Component(role=SecretKeyLoader.class, hint="keyring")
public class KeyRingLoader
extends SecretKeyLoader {
    public PGPSecretKey load(PgpMojo mojo, String specifier) throws IOException {
        Map<String, String> opts = this.parseQueryParameters(specifier);
        File keyFile = opts.containsKey("keyring") ? new File(opts.get("keyring")) : new File(new File(System.getProperty("user.home")), ".gnupg/secring.gpg");
        if (!keyFile.exists()) {
            throw new IOException("No such key ring file exists: " + keyFile);
        }
        String id = opts.get("id");
        InputStream in = PGPUtil.getDecoderStream((InputStream)new FileInputStream(keyFile));
        try {
            Object obj;
            PGPObjectFactory pgpFact = new PGPObjectFactory(in);
            while ((obj = pgpFact.nextObject()) != null) {
                if (!(obj instanceof PGPSecretKeyRing)) {
                    throw new IOException("Expecting a secret key but found " + obj);
                }
                PGPSecretKeyRing key = (PGPSecretKeyRing)obj;
                if (id == null) {
                    PGPSecretKey pGPSecretKey = key.getSecretKey();
                    return pGPSecretKey;
                }
                Iterator jtr = key.getSecretKeys();
                while (jtr.hasNext()) {
                    PGPSecretKey skey = (PGPSecretKey)jtr.next();
                    if (id.equalsIgnoreCase(Long.toHexString(skey.getPublicKey().getKeyID() & 0xFFFFFFFFFFFFFFFFL))) {
                        PGPSecretKey pGPSecretKey = skey;
                        return pGPSecretKey;
                    }
                    Iterator ktr = skey.getUserIDs();
                    while (ktr.hasNext()) {
                        String s = (String)ktr.next();
                        if (!s.contains(id)) continue;
                        PGPSecretKey pGPSecretKey = skey;
                        return pGPSecretKey;
                    }
                }
            }
            throw new IOException("No key that matches " + id + " was found in " + keyFile);
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] args) throws IOException {
        new KeyRingLoader().load(null, "id=D50582E6");
    }
}

