/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.pgp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;

class Signer {
    private final PGPPrivateKey privateKey;
    private final PGPPublicKey publicKey;
    static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();

    Signer(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    Signer(PGPSecretKey secretKey, char[] passphrase) {
        try {
            this.privateKey = secretKey.extractPrivateKey(passphrase, (Provider)PROVIDER);
            if (this.privateKey == null) {
                throw new IllegalArgumentException("Unsupported signing key" + (secretKey.getKeyEncryptionAlgorithm() == 3 ? ": RSA (sign-only) is unsupported by BouncyCastle" : ""));
            }
            this.publicKey = secretKey.getPublicKey();
        }
        catch (PGPException e) {
            throw new IllegalArgumentException("Passphrase is incorrect", e);
        }
    }

    PGPSignature sign(InputStream in) throws IOException, PGPException, GeneralSecurityException {
        int len;
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.publicKey.getAlgorithm(), 2, (Provider)PROVIDER);
        sGen.initSign(0, this.privateKey);
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            sGen.update(buf, 0, len);
        }
        return sGen.generate();
    }

    void sign(InputStream in, OutputStream signatureOutput) throws PGPException, IOException, GeneralSecurityException {
        BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(signatureOutput));
        this.sign(in).encode((OutputStream)bOut);
        bOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sign(File in, File signature) throws PGPException, IOException, GeneralSecurityException {
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(in));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(signature));
        try {
            this.sign(fin, out);
        }
        finally {
            ((InputStream)fin).close();
            ((OutputStream)out).close();
        }
    }
}

