/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.pgp;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.kohsuke.maven.pgp.PassphraseLoader;
import org.kohsuke.maven.pgp.SecretKeyLoader;
import org.kohsuke.maven.pgp.Signer;

public class PgpMojo
extends AbstractMojo {
    public String secretkey;
    public String passphrase;
    private boolean skip;
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public PlexusContainer container;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        ArrayList attached = new ArrayList(this.project.getAttachedArtifacts());
        PGPSecretKey secretKey = this.loadSecretKey();
        Signer signer = new Signer(secretKey, this.loadPassPhrase(secretKey).toCharArray());
        if (!"pom".equals(this.project.getPackaging())) {
            this.sign(signer, this.project.getArtifact());
        }
        File pomToSign = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".pom");
        try {
            FileUtils.copyFile((File)this.project.getFile(), (File)pomToSign);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying POM for signing.", (Exception)e);
        }
        this.getLog().debug((CharSequence)("Generating signature for " + pomToSign));
        DefaultArtifact a2 = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), VersionRange.createFromVersion((String)this.project.getVersion()), null, "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
        a2.setFile(pomToSign);
        this.sign(signer, (Artifact)a2);
        for (DefaultArtifact a2 : attached) {
            this.sign(signer, (Artifact)a2);
        }
    }

    public PGPSecretKey loadSecretKey() throws MojoExecutionException {
        if (this.secretkey == null) {
            this.secretkey = System.getenv("PGP_SECRETKEY");
        }
        if (this.secretkey == null) {
            throw new MojoExecutionException("No PGP secret key is configured. Either do so in POM, or via -Dpgp.secretkey, or the PGP_SECRETKEY environment variable");
        }
        int head = this.secretkey.indexOf(58);
        if (head < 0) {
            throw new MojoExecutionException("Invalid secret key string. It needs to start with a scheme like 'FOO:': " + this.secretkey);
        }
        String scheme = this.secretkey.substring(0, head);
        try {
            SecretKeyLoader kfl = (SecretKeyLoader)this.container.lookup(SecretKeyLoader.class.getName(), scheme);
            return kfl.load(this, this.secretkey.substring(head + 1));
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Invalid secret key scheme '" + scheme + "'. If this is your custom scheme, perhaps you forgot to specify it in <dependency> to this plugin?", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load key from " + this.secretkey, (Exception)e);
        }
    }

    public String loadPassPhrase(PGPSecretKey key) throws MojoExecutionException {
        if (this.passphrase == null) {
            this.passphrase = System.getenv("PGP_PASSPHRASE");
        }
        if (this.passphrase == null) {
            throw new MojoExecutionException("No PGP passphrase is configured. Either do so in POM, or via -Dpgp.passphrase, or the PGP_PASSPHRASE environment variable");
        }
        int head = this.passphrase.indexOf(58);
        if (head < 0) {
            throw new MojoExecutionException("Invalid passphrase string. It needs to start with a scheme like 'FOO:': " + this.passphrase);
        }
        String scheme = this.passphrase.substring(0, head);
        try {
            PassphraseLoader pfl = (PassphraseLoader)this.container.lookup(PassphraseLoader.class.getName(), scheme);
            return pfl.load(this, key, this.passphrase.substring(head + 1));
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Invalid pass phrase scheme '" + scheme + "'. If this is your custom scheme, perhaps you forgot to specify it in <dependency> to this plugin?", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load passphrase from " + this.passphrase, (Exception)e);
        }
    }

    protected void sign(Signer signer, Artifact a) throws MojoExecutionException {
        File file = a.getFile();
        String name = file.getName() + ".asc";
        File signature = new File(this.outputDirectory, name);
        try {
            signer.sign(a.getFile(), signature);
        }
        catch (PGPException e) {
            throw new MojoExecutionException("Failed to sign " + a.getFile(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to sign " + a.getFile(), (Exception)e);
        }
        catch (GeneralSecurityException e) {
            throw new MojoExecutionException("Failed to sign " + a.getFile(), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, a.getArtifactHandler().getExtension() + ".asc", a.getClassifier(), signature);
    }
}

