/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.JIExcepInfo;

public class MSExcel3 {
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;
    private IJIDispatch dispatchOfWorkSheets = null;
    private IJIDispatch dispatchOfWorkBook = null;

    public MSExcel3(String address, String[] args) throws JIException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        this.comServer = new JIComServer(JIProgId.valueOf("Excel.Application"), address, session);
    }

    public void startExcel() throws JIException {
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject(this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    public void showExcel() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Visible");
        JIVariant variant = new JIVariant(Boolean.TRUE);
        this.dispatch.put(dispId, variant);
        this.dispatch.put("DisplayAlerts", new JIVariant(Boolean.TRUE));
    }

    public void createWorkSheet() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Workbooks");
        JIVariant outVal = this.dispatch.get(dispId);
        IJIDispatch dispatchOfWorkBooks = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        JIVariant[] outVal2 = dispatchOfWorkBooks.callMethodA("Open", new Object[]{new JIString("C:\\temp\\chart.xls"), Boolean.TRUE, Boolean.TRUE, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatchOfWorkBook = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal = this.dispatchOfWorkBook.get("Worksheets");
        this.dispatchOfWorkSheets = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        outVal2 = this.dispatchOfWorkSheets.get("Item", new Object[]{new JIVariant(1)});
        IJIDispatch sheet = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal2 = sheet.get("Range", new Object[]{new JIString("A1:B19"), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch range = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        Integer[][] newValue = new Integer[][]{{new Integer(121), new Integer(117)}, {new Integer(111), new Integer(156)}, {new Integer(132), new Integer(138)}, {new Integer(116), new Integer(119)}, {new Integer(148), new Integer(126)}, {new Integer(163), new Integer(143)}, {new Integer(174), new Integer(135)}, {new Integer(136), new Integer(142)}, {new Integer(142), new Integer(163)}, {new Integer(121), new Integer(117)}, {new Integer(111), new Integer(156)}, {new Integer(132), new Integer(138)}, {new Integer(116), new Integer(119)}, {new Integer(148), new Integer(126)}, {new Integer(163), new Integer(143)}, {new Integer(174), new Integer(135)}, {new Integer(136), new Integer(142)}, {new Integer(142), new Integer(163)}, {new Integer(121), new Integer(117)}};
        range.put("Value", new JIVariant(new JIArray(newValue)));
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int j = 0;
        while (j < 60) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Integer temp1 = newValue[0][0];
            Integer temp2 = newValue[0][1];
            int i = 0;
            i = 1;
            while (i < newValue.length) {
                int k = 0;
                while (k < newValue[i - 1].length) {
                    newValue[i - 1][k] = newValue[i][k];
                    ++k;
                }
                ++i;
            }
            newValue[i - 1][0] = temp1;
            newValue[i - 1][1] = temp2;
            range.put("Value", new JIVariant(new JIArray(newValue)));
            ++j;
        }
        outVal2 = sheet.get("ChartObjects", new Object[]{JIVariant.OPTIONAL_PARAM()});
        IJIDispatch chartObjects = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal2 = chartObjects.callMethodA("Add", new Object[]{new Double(100.0), new Double(30.0), new Double(400.0), new Double(250.0)});
        IJIDispatch chartObject = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal = chartObject.get("Chart");
        IJIDispatch chart = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        chart.callMethod("SetSourceData", new Object[]{range, JIVariant.OPTIONAL_PARAM()});
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        outVal = sheet.get("PageSetup");
        IJIDispatch pageSetup = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        pageSetup.put("Orientation", new JIVariant(2));
        pageSetup.put("Zoom", new JIVariant(100));
        try {
            sheet.callMethod("PrintOut", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        }
        catch (JIException e) {
            e.printStackTrace();
            JIExcepInfo excepInfo = sheet.getLastExcepInfo();
            System.out.println("Error Code in EXCEPINFO: " + excepInfo.getErrorCode());
        }
        this.dispatchOfWorkBook.callMethod("close", new Object[]{Boolean.FALSE, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatch.callMethod("Quit");
        JISession.destroySession(this.dispatch.getAssociatedSession());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            MSExcel3 test = new MSExcel3(args[0], args);
            test.startExcel();
            test.showExcel();
            test.createWorkSheet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

