/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewEvent;
import org.kohsuke.github.Requester;

public class GHPullRequestReviewBuilder {
    private final GHPullRequest pr;
    private final Requester builder;
    private final List<ReviewComment> comments = new ArrayList<ReviewComment>();

    GHPullRequestReviewBuilder(GHPullRequest pr) {
        this.pr = pr;
        this.builder = pr.root().createRequest();
    }

    public GHPullRequestReviewBuilder commitId(String commitId) {
        this.builder.with("commit_id", commitId);
        return this;
    }

    public GHPullRequestReviewBuilder body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHPullRequestReviewBuilder event(GHPullRequestReviewEvent event) {
        this.builder.with("event", event.action());
        return this;
    }

    public GHPullRequestReviewBuilder comment(String body, String path, int position) {
        this.comments.add(new DraftReviewComment(body, path, position));
        return this;
    }

    public GHPullRequestReviewBuilder multiLineComment(String body, String path, int startLine, int endLine) {
        this.comments.add(new MultilineDraftReviewComment(body, path, startLine, endLine));
        return this;
    }

    public GHPullRequestReviewBuilder singleLineComment(String body, String path, int line) {
        this.comments.add(new SingleLineDraftReviewComment(body, path, line));
        return this;
    }

    public GHPullRequestReview create() throws IOException {
        return ((Requester)((Requester)((Requester)this.builder.method("POST")).with("comments", this.comments)).withUrlPath(this.pr.getApiRoute() + "/reviews", new String[0])).fetch(GHPullRequestReview.class).wrapUp(this.pr);
    }

    static class DraftReviewComment
    implements ReviewComment {
        private String body;
        private String path;
        private int position;

        DraftReviewComment(String body, String path, int position) {
            this.body = body;
            this.path = path;
            this.position = position;
        }

        @Override
        public String getBody() {
            return this.body;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public int getPosition() {
            return this.position;
        }
    }

    static class MultilineDraftReviewComment
    implements ReviewComment {
        private final String body;
        private final String path;
        private final int line;
        private final int start_line;

        MultilineDraftReviewComment(String body, String path, int startLine, int line) {
            this.body = body;
            this.path = path;
            this.line = line;
            this.start_line = startLine;
        }

        @Override
        public String getBody() {
            return this.body;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }

        public int getStartLine() {
            return this.start_line;
        }
    }

    static class SingleLineDraftReviewComment
    implements ReviewComment {
        private final String body;
        private final String path;
        private final int line;

        SingleLineDraftReviewComment(String body, String path, int line) {
            this.body = body;
            this.path = path;
            this.line = line;
        }

        @Override
        public String getBody() {
            return this.body;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }
    }

    private static interface ReviewComment {
        public String getBody();

        public String getPath();
    }
}

