/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.impl.AccessRestrictionFactory;
import org.kohsuke.accmod.impl.ErrorListener;
import org.kohsuke.accmod.impl.Location;
import org.kohsuke.accmod.impl.RestrictedElement;
import org.kohsuke.accmod.impl.Restrictions;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Checker {
    public final ClassLoader dependencies;
    private final ErrorListener errorListener;
    private final Properties properties;
    private final Map<String, Restrictions> restrictions = new HashMap<String, Restrictions>();
    private final AccessRestrictionFactory factory;
    private final Log log;
    private int line;
    private static final String RESTRICTED_DESCRIPTOR = Type.getDescriptor(Restricted.class);

    public Checker(ClassLoader dependencies, ErrorListener errorListener, Properties properties, Log log) throws IOException {
        this.dependencies = dependencies;
        this.errorListener = errorListener;
        this.properties = properties;
        this.factory = new AccessRestrictionFactory(dependencies);
        this.log = log;
        this.loadAccessRestrictions();
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void check(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("Directory " + f.getName() + " is empty when it should not be");
            }
            for (File c : files) {
                this.check(c);
            }
            return;
        }
        if (f.getPath().endsWith(".class")) {
            this.checkClass(f);
        }
    }

    private void loadAccessRestrictions() throws IOException {
        Enumeration<URL> res = this.dependencies.getResources("META-INF/annotations/" + Restricted.class.getName());
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            this.loadRestrictions(url.openStream(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRestrictions(InputStream stream, final boolean isInTheInspectedModule) throws IOException {
        String className;
        if (stream == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        while ((className = r.readLine()) != null) {
            InputStream is = this.dependencies.getResourceAsStream(className.replace('.', '/') + ".class");
            if (is == null) {
                this.errorListener.onWarning(null, null, "Failed to find class file for " + className);
                continue;
            }
            try {
                new ClassReader(is).accept(new ClassVisitor(589824){
                    private String className;

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        this.className = name;
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return this.onAnnotationFor(this.className, desc);
                    }

                    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                        return new FieldVisitor(589824){

                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                return this.onAnnotationFor(className + '.' + name, desc);
                            }
                        };
                    }

                    public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                        return new MethodVisitor(589824){

                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                return this.onAnnotationFor(className + '.' + methodName + methodDesc, desc);
                            }
                        };
                    }

                    private AnnotationVisitor onAnnotationFor(final String keyName, String desc) {
                        if (RESTRICTED_DESCRIPTOR.equals(desc)) {
                            RestrictedElement target = new RestrictedElement(){

                                public boolean isInTheInspectedModule() {
                                    return isInTheInspectedModule;
                                }

                                public String toString() {
                                    return keyName;
                                }
                            };
                            return new Restrictions.Parser(target){

                                @Override
                                public void visitEnd() {
                                    try {
                                        Checker.this.restrictions.put(keyName, this.build(Checker.this.factory));
                                    }
                                    catch (ClassNotFoundException e) {
                                        this.failure(e);
                                    }
                                    catch (InstantiationException e) {
                                        this.failure(e);
                                    }
                                    catch (IllegalAccessException e) {
                                        this.failure(e);
                                    }
                                }

                                private void failure(Exception e) {
                                    Checker.this.errorListener.onError((Throwable)e, null, "Failed to load restrictions");
                                }
                            };
                        }
                        return null;
                    }
                }, 1);
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClass(File clazz) throws IOException {
        try (FileInputStream in = new FileInputStream(clazz);){
            ClassReader cr = new ClassReader((InputStream)in);
            cr.accept((ClassVisitor)new RestrictedClassVisitor(), 4);
        }
    }

    private Iterable<Restrictions> getRestrictions(String keyName, Set<Type> skippedTypes) {
        int newIdx;
        ArrayList<Restrictions> rs = new ArrayList<Restrictions>();
        Restrictions r = this.restrictions.get(keyName);
        if (r != null && skippedTypes.isEmpty()) {
            rs.add(r);
        }
        int idx = Integer.MAX_VALUE;
        while (!((newIdx = keyName.lastIndexOf(46, idx)) == -1 && (newIdx = keyName.lastIndexOf(36, idx)) == -1 || skippedTypes.contains(Type.getObjectType((String)(keyName = keyName.substring(0, idx = newIdx)))))) {
            r = this.restrictions.get(keyName);
            if (r == null) continue;
            ArrayList<AccessRestriction> applicable = new ArrayList<AccessRestriction>();
            for (AccessRestriction ar : r) {
                if (!ar.appliesToNested()) continue;
                applicable.add(ar);
            }
            if (applicable.isEmpty()) continue;
            rs.add(new Restrictions(r.target, applicable));
        }
        return rs;
    }

    private static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    private static String topLevelClass(String a) {
        int i = a.indexOf(36);
        if (i == -1) {
            return a;
        }
        return a.substring(0, i);
    }

    private static boolean sameClassFile(String currentClass, String owner) {
        return Checker.topLevelClass(currentClass).equals(Checker.topLevelClass(owner));
    }

    private class RestrictedAnnotationVisitor
    extends AnnotationVisitor {
        private Set<Type> skippedRestrictedClasses;

        public RestrictedAnnotationVisitor() {
            super(589824);
            this.skippedRestrictedClasses = new HashSet<Type>();
        }

        public Set<Type> getSkippedTypes() {
            return this.skippedRestrictedClasses;
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationVisitor(589824){

                public void visit(String name, Object value) {
                    Type type = value instanceof Type ? (Type)value : Type.getType(value.getClass());
                    Checker.this.log.debug((CharSequence)String.format("Skipping @%s class: %s", Restricted.class.getSimpleName(), type.getClassName()));
                    RestrictedAnnotationVisitor.this.skippedRestrictedClasses.add(type);
                    super.visit(name, value);
                }
            };
        }
    }

    private class RestrictedMethodVisitor
    extends MethodVisitor {
        private final Set<Type> skippedTypesFromParent;
        private Location currentLocation;
        private RestrictedAnnotationVisitor annotationVisitor;
        private final String currentClass;

        private Set<Type> getSkippedTypes() {
            HashSet<Type> allSkippedTypes = new HashSet<Type>(this.skippedTypesFromParent);
            allSkippedTypes.addAll(this.annotationVisitor.getSkippedTypes());
            return allSkippedTypes;
        }

        public RestrictedMethodVisitor(Location currentLocation, String currentClass, Set<Type> skippedTypes) {
            super(589824);
            this.annotationVisitor = new RestrictedAnnotationVisitor();
            Checker.this.log.debug((CharSequence)String.format("New method visitor at %s#%s", currentLocation.getClassName(), currentLocation.getMethodName()));
            this.currentLocation = currentLocation;
            this.skippedTypesFromParent = skippedTypes;
            this.currentClass = currentClass;
        }

        public void visitLineNumber(int _line, Label start) {
            Checker.this.line = _line;
        }

        public void visitTypeInsn(int opcode, String type) {
            switch (opcode) {
                case 187: {
                    if (Checker.sameClassFile(this.currentClass, type)) {
                        return;
                    }
                    for (Restrictions r : Checker.this.getRestrictions(type, this.getSkippedTypes())) {
                        r.instantiated(this.currentLocation, Checker.this.errorListener);
                    }
                    break;
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Checker.this.log.debug((CharSequence)String.format("Visiting method %s#%s", owner, name));
            if (Checker.sameClassFile(this.currentClass, owner)) {
                return;
            }
            for (Restrictions r : Checker.this.getRestrictions(owner + '.' + name + desc, this.getSkippedTypes())) {
                r.invoked(this.currentLocation, Checker.this.errorListener);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            Checker.this.log.debug((CharSequence)String.format("Visiting field '%s %s' in type %s", desc, name, owner));
            if (Checker.sameClassFile(this.currentClass, owner)) {
                return;
            }
            Iterable rs = Checker.this.getRestrictions(owner + '.' + name, this.getSkippedTypes());
            switch (opcode) {
                case 178: 
                case 180: {
                    for (Restrictions r : rs) {
                        r.read(this.currentLocation, Checker.this.errorListener);
                    }
                    break;
                }
                case 179: 
                case 181: {
                    for (Restrictions r : rs) {
                        r.written(this.currentLocation, Checker.this.errorListener);
                    }
                    break;
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return Type.getType(SuppressRestrictedWarnings.class).equals((Object)Type.getType((String)desc)) ? this.annotationVisitor : super.visitAnnotation(desc, visible);
        }
    }

    private class RestrictedClassVisitor
    extends ClassVisitor {
        private String className;
        private String methodName;
        private String methodDesc;
        private String superName;
        private String[] interfaces;
        private RestrictedAnnotationVisitor annotationVisitor;
        private final Location currentLocation;

        private Set<Type> getSkippedTypes() {
            return this.annotationVisitor.getSkippedTypes();
        }

        public RestrictedClassVisitor() {
            super(589824);
            this.annotationVisitor = new RestrictedAnnotationVisitor();
            this.currentLocation = new Location(){

                public String getClassName() {
                    return RestrictedClassVisitor.this.className.replace('/', '.');
                }

                public String getMethodName() {
                    return RestrictedClassVisitor.this.methodName;
                }

                public String getMethodDescriptor() {
                    return RestrictedClassVisitor.this.methodDesc;
                }

                public int getLineNumber() {
                    return Checker.this.line;
                }

                public String toString() {
                    return RestrictedClassVisitor.this.className + ':' + Checker.this.line;
                }

                public ClassLoader getDependencyClassLoader() {
                    return Checker.this.dependencies;
                }

                public String getProperty(String key) {
                    return Checker.this.properties.getProperty(key);
                }
            };
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            if (Checker.isSynthetic(access)) {
                return;
            }
            this.superName = superName;
            this.interfaces = interfaces;
        }

        public void visitEnd() {
            if (this.superName != null) {
                for (Restrictions r : Checker.this.getRestrictions(this.superName, this.getSkippedTypes())) {
                    r.usedAsSuperType(this.currentLocation, Checker.this.errorListener);
                }
            }
            if (this.interfaces != null) {
                for (String intf : this.interfaces) {
                    for (Restrictions r : Checker.this.getRestrictions(intf, this.getSkippedTypes())) {
                        r.usedAsInterface(this.currentLocation, Checker.this.errorListener);
                    }
                }
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.methodName = name;
            this.methodDesc = desc;
            if (Checker.isSynthetic(access)) {
                return null;
            }
            return new RestrictedMethodVisitor(this.currentLocation, this.className, this.annotationVisitor.getSkippedTypes());
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return Type.getType(SuppressRestrictedWarnings.class).equals((Object)Type.getType((String)desc)) ? this.annotationVisitor : super.visitAnnotation(desc, visible);
        }
    }
}

