/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bybit.service;

import io.github.resilience4j.ratelimiter.RateLimiter;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.bybit.BybitAdapters;
import org.knowm.xchange.bybit.BybitExchange;
import org.knowm.xchange.bybit.dto.BybitCategory;
import org.knowm.xchange.bybit.dto.BybitResult;
import org.knowm.xchange.bybit.dto.account.BybitCancelAllOrdersPayload;
import org.knowm.xchange.bybit.dto.account.BybitCancelAllOrdersResponse;
import org.knowm.xchange.bybit.dto.trade.BybitAmendOrderPayload;
import org.knowm.xchange.bybit.dto.trade.BybitCancelOrderPayload;
import org.knowm.xchange.bybit.dto.trade.BybitOrder;
import org.knowm.xchange.bybit.dto.trade.BybitOrderResponse;
import org.knowm.xchange.bybit.dto.trade.BybitOrderType;
import org.knowm.xchange.bybit.dto.trade.BybitPlaceOrderPayload;
import org.knowm.xchange.bybit.dto.trade.BybitSide;
import org.knowm.xchange.bybit.dto.trade.details.BybitOrderDetail;
import org.knowm.xchange.bybit.dto.trade.details.BybitOrderDetails;
import org.knowm.xchange.bybit.dto.trade.details.BybitTimeInForce;
import org.knowm.xchange.bybit.service.BybitBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.instrument.Instrument;

public class BybitTradeServiceRaw
extends BybitBaseService {
    protected BybitTradeServiceRaw(BybitExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    BybitResult<BybitOrderDetails<BybitOrderDetail>> getBybitOrder(BybitCategory category, Instrument instrument, String orderId) throws IOException {
        BybitResult<BybitOrderDetails<BybitOrderDetail>> bybitOrder;
        String symbol = null;
        if (instrument != null) {
            symbol = BybitAdapters.convertToBybitSymbol(instrument);
        }
        if (!(bybitOrder = this.bybitAuthenticated.getOrders(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), category.getValue(), symbol, orderId)).isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(bybitOrder);
        }
        return bybitOrder;
    }

    BybitResult<BybitOrderResponse> amendOrder(BybitCategory category, String symbol, String orderId, String orderLinkId, String triggerPrice, String qty, String price, String tpslMode, String takeProfit, String stopLoss, String tpTriggerBy, String slTriggerBy, String triggerBy, String tpLimitPrice, String slLimitPrice) throws IOException {
        RateLimiter rateLimiter = this.getAmendOrderRateLimiter(category);
        BybitAmendOrderPayload payload = new BybitAmendOrderPayload(category, symbol, orderId, orderLinkId, triggerPrice, qty, price, tpslMode, takeProfit, stopLoss, tpTriggerBy, slTriggerBy, triggerBy, tpLimitPrice, slLimitPrice);
        BybitResult amendOrder = (BybitResult)this.decorateApiCall(() -> this.bybitAuthenticated.amendOrder(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload)).withRateLimiter(rateLimiter).withRateLimiter(this.rateLimiter("global")).call();
        if (!amendOrder.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(amendOrder);
        }
        return amendOrder;
    }

    BybitResult<BybitOrderResponse> placeOrder(BybitCategory category, String symbol, BybitSide side, BybitOrderType orderType, BigDecimal qty, BigDecimal limitPrice, String orderLinkId, BigDecimal stopLoss, BybitOrder.SlTriggerBy slTriggerBy, BigDecimal slLimitPrice, BybitOrderType slOrderType, boolean reduceOnly, int positionIdx, BybitTimeInForce timeInForce) throws IOException {
        BybitResult placeOrder;
        BybitPlaceOrderPayload payload = new BybitPlaceOrderPayload(category, symbol, side, orderType, qty, orderLinkId, positionIdx, limitPrice);
        if (stopLoss != null && slTriggerBy != null && slLimitPrice != null && slOrderType != null) {
            payload.setStopLoss(stopLoss.toString());
            payload.setSlTriggerBy(slTriggerBy.getValue());
            payload.setSlLimitPrice(slLimitPrice.toString());
            payload.setSlOrderType(slOrderType.getValue());
            if (slOrderType.equals((Object)BybitOrderType.MARKET)) {
                payload.setTpslMode(BybitOrder.TpslMode.FULL.getValue());
            } else {
                payload.setTpslMode(BybitOrder.TpslMode.PARTIAL.getValue());
            }
        }
        if (reduceOnly) {
            payload.setReduceOnly("true");
        }
        if (timeInForce != null) {
            payload.setTimeInForce(timeInForce.getValue());
        }
        if (!(placeOrder = (BybitResult)this.decorateApiCall(() -> this.bybitAuthenticated.placeOrder(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload)).withRateLimiter(this.getCreateOrderRateLimiter(category)).withRateLimiter(this.rateLimiter("global")).call()).isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(placeOrder);
        }
        return placeOrder;
    }

    BybitResult<BybitOrderResponse> cancelOrder(BybitCategory category, String symbol, String orderId, String orderLinkId) throws IOException {
        RateLimiter rateLimiter = this.getCancelOrderRateLimiter(category);
        BybitCancelOrderPayload payload = new BybitCancelOrderPayload(category, symbol, orderId, orderLinkId);
        return (BybitResult)this.decorateApiCall(() -> this.bybitAuthenticated.cancelOrder(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload)).withRateLimiter(rateLimiter).withRateLimiter(this.rateLimiter("global")).call();
    }

    BybitResult<BybitCancelAllOrdersResponse> cancelAllOrders(String category, String symbol, String baseCoin, String settleCoin, String orderFilter, String stopOrderType) throws IOException {
        BybitCancelAllOrdersPayload payload = new BybitCancelAllOrdersPayload(category, symbol, baseCoin, settleCoin, orderFilter, stopOrderType);
        BybitResult<BybitCancelAllOrdersResponse> response = this.bybitAuthenticated.cancelAllOrders(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload);
        if (!response.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(response);
        }
        return response;
    }

    private RateLimiter getCreateOrderRateLimiter(BybitCategory category) {
        switch (category) {
            case LINEAR: 
            case INVERSE: {
                return this.rateLimiter("orderCreateLinearAndInverse");
            }
            case SPOT: {
                return this.rateLimiter("orderCreateSpot");
            }
            case OPTION: {
                return this.rateLimiter("orderCreateOption");
            }
        }
        return null;
    }

    private RateLimiter getCancelOrderRateLimiter(BybitCategory category) {
        switch (category) {
            case LINEAR: 
            case INVERSE: {
                return this.rateLimiter("orderCancelLinearAndInverse");
            }
            case SPOT: {
                return this.rateLimiter("orderCancelSpot");
            }
            case OPTION: {
                return this.rateLimiter("orderCancelOption");
            }
        }
        return null;
    }

    private RateLimiter getAmendOrderRateLimiter(BybitCategory category) {
        switch (category) {
            case LINEAR: 
            case INVERSE: {
                return this.rateLimiter("orderAmendLinearAndInverse");
            }
            case SPOT: {
                return this.rateLimiter("orderAmendSpot");
            }
            case OPTION: {
                return this.rateLimiter("orderAmendOption");
            }
        }
        return null;
    }
}

