/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bybit.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.bybit.BybitAdapters;
import org.knowm.xchange.bybit.BybitExchange;
import org.knowm.xchange.bybit.dto.BybitCategory;
import org.knowm.xchange.bybit.dto.BybitResult;
import org.knowm.xchange.bybit.dto.account.BybitAccountInfoResponse;
import org.knowm.xchange.bybit.dto.account.allcoins.BybitAllCoinsBalance;
import org.knowm.xchange.bybit.dto.account.feerates.BybitFeeRates;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitAccountBalance;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitAccountType;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitWalletBalance;
import org.knowm.xchange.bybit.service.BybitAccountServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;

public class BybitAccountService
extends BybitAccountServiceRaw
implements AccountService {
    private final BybitAccountType accountType;

    public BybitAccountService(BybitExchange exchange, BybitAccountType accountType, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
        this.accountType = accountType;
    }

    public AccountInfo getAccountInfo() throws IOException {
        List<Wallet> adaptedWallets = this.getAdaptedWallets();
        return new AccountInfo(adaptedWallets);
    }

    public boolean setLeverage(Instrument instrument, double leverage) throws IOException {
        BybitCategory category = BybitAdapters.getCategory(instrument);
        int retCode = this.setLeverageRaw(category, BybitAdapters.convertToBybitSymbol(instrument), leverage).getRetCode();
        return retCode == 0 || retCode == 110043;
    }

    public boolean switchPositionMode(BybitCategory category, Instrument instrument, String coin, int mode) throws IOException {
        int retCode;
        String symbol = "";
        if (instrument != null) {
            symbol = BybitAdapters.convertToBybitSymbol(instrument);
        }
        return (retCode = this.switchPositionModeRaw(category, symbol, coin, mode).getRetCode()) == 0 || retCode == 110025;
    }

    private List<Wallet> getAdaptedWallets() throws IOException {
        switch (this.accountType) {
            case CONTRACT: 
            case UNIFIED: 
            case SPOT: {
                return this.getAdaptedBalanceWallets();
            }
            case INVESTMENT: 
            case OPTION: 
            case FUND: {
                return this.getAdaptedAllCoinsWallets();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.accountType));
    }

    private List<Wallet> getAdaptedAllCoinsWallets() throws IOException {
        BybitResult<BybitAllCoinsBalance> allCoinsBalanceResult = this.getAllCoinsBalance(this.accountType);
        BybitAllCoinsBalance allCoinsBalance = allCoinsBalanceResult.getResult();
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        wallets.add(BybitAdapters.adaptBybitBalances(allCoinsBalance));
        return wallets;
    }

    private List<Wallet> getAdaptedBalanceWallets() throws IOException {
        BybitResult<BybitWalletBalance> walletBalances = this.getWalletBalances(this.accountType);
        BybitWalletBalance walletBalancesResult = walletBalances.getResult();
        List<BybitAccountBalance> accounts = walletBalancesResult.getList();
        return accounts.stream().map(bybitAccountBalance -> BybitAdapters.adaptBybitBalances(bybitAccountBalance.getCoin())).collect(Collectors.toList());
    }

    public BybitResult<BybitFeeRates> getFeeRates(BybitCategory category, Instrument instrument) throws IOException {
        String symbol = null;
        if (instrument != null) {
            symbol = BybitAdapters.convertToBybitSymbol(instrument);
        }
        return this.getFeeRatesRaw(category, symbol);
    }

    public BybitAccountInfoResponse accountInfo() throws IOException {
        return this.accountInfoRaw().getResult();
    }
}

