/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bybit;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.knowm.xchange.bybit.dto.BybitCategory;
import org.knowm.xchange.bybit.dto.BybitResult;
import org.knowm.xchange.bybit.dto.account.allcoins.BybitAllCoinBalance;
import org.knowm.xchange.bybit.dto.account.allcoins.BybitAllCoinsBalance;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitCoinWalletBalance;
import org.knowm.xchange.bybit.dto.marketdata.instruments.BybitInstrumentInfo;
import org.knowm.xchange.bybit.dto.marketdata.instruments.linear.BybitLinearInverseInstrumentInfo;
import org.knowm.xchange.bybit.dto.marketdata.instruments.option.BybitOptionInstrumentInfo;
import org.knowm.xchange.bybit.dto.marketdata.instruments.spot.BybitSpotInstrumentInfo;
import org.knowm.xchange.bybit.dto.marketdata.tickers.BybitTicker;
import org.knowm.xchange.bybit.dto.marketdata.tickers.linear.BybitLinearInverseTicker;
import org.knowm.xchange.bybit.dto.marketdata.tickers.option.BybitOptionTicker;
import org.knowm.xchange.bybit.dto.marketdata.tickers.spot.BybitSpotTicker;
import org.knowm.xchange.bybit.dto.trade.BybitOrderStatus;
import org.knowm.xchange.bybit.dto.trade.BybitSide;
import org.knowm.xchange.bybit.dto.trade.details.BybitOrderDetail;
import org.knowm.xchange.bybit.service.BybitException;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.derivative.OptionsContract;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;

public class BybitAdapters {
    private static final ThreadLocal<SimpleDateFormat> OPTION_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("ddMMMyy", Locale.US));
    public static final List<String> QUOTE_CURRENCIES = Arrays.asList("USDT", "USDC", "USDE", "EUR", "BRL", "PLN", "TRY", "SOL", "BTC", "ETH", "DAI", "BRZ");

    public static Wallet adaptBybitBalances(List<BybitCoinWalletBalance> coinWalletBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>(coinWalletBalances.size());
        for (BybitCoinWalletBalance bybitCoinBalance : coinWalletBalances) {
            BigDecimal availableToWithdraw = bybitCoinBalance.getAvailableToWithdraw().isEmpty() ? BigDecimal.ZERO : new BigDecimal(bybitCoinBalance.getAvailableToWithdraw());
            balances.add(new Balance(new Currency(bybitCoinBalance.getCoin()), new BigDecimal(bybitCoinBalance.getEquity()), availableToWithdraw));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static Wallet adaptBybitBalances(BybitAllCoinsBalance allCoinsBalance) {
        ArrayList<Balance> balances = new ArrayList<Balance>(allCoinsBalance.getBalance().size());
        for (BybitAllCoinBalance coinBalance : allCoinsBalance.getBalance()) {
            balances.add(new Balance(new Currency(coinBalance.getCoin()), coinBalance.getWalletBalance(), coinBalance.getTransferBalance()));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static BybitSide getSideString(Order.OrderType type) {
        if (type == Order.OrderType.ASK || type == Order.OrderType.EXIT_BID) {
            return BybitSide.SELL;
        }
        if (type == Order.OrderType.BID || type == Order.OrderType.EXIT_ASK) {
            return BybitSide.BUY;
        }
        throw new IllegalArgumentException("invalid order type");
    }

    public static Order.OrderType getOrderType(BybitSide side) {
        if ("sell".equalsIgnoreCase(side.name())) {
            return Order.OrderType.ASK;
        }
        if ("buy".equalsIgnoreCase(side.name())) {
            return Order.OrderType.BID;
        }
        throw new IllegalArgumentException("invalid order type");
    }

    public static String convertToBybitSymbol(Instrument instrument) {
        BybitCategory category = BybitAdapters.getCategory(instrument);
        switch (category) {
            case SPOT: {
                return String.format("%s%s", instrument.getBase(), instrument.getCounter()).toUpperCase();
            }
            case LINEAR: {
                FuturesContract futuresContract = (FuturesContract)instrument;
                if (futuresContract.isPerpetual() && !instrument.getCounter().getSymbol().equals("USDC")) {
                    return String.format("%s%s", instrument.getBase(), instrument.getCounter());
                }
                if (futuresContract.isPerpetual() && instrument.getCounter().getSymbol().equals("USDC")) {
                    return String.format("%sPERP", instrument.getBase());
                }
                return String.format("%s-%s", instrument.getBase(), futuresContract.getPrompt());
            }
            case INVERSE: {
                FuturesContract futuresContract = (FuturesContract)instrument;
                return String.format("%s%s%s", futuresContract.getBase(), futuresContract.getCounter(), futuresContract.isPerpetual() ? "" : futuresContract.getPrompt()).toUpperCase();
            }
            case OPTION: {
                OptionsContract optionsContract = (OptionsContract)instrument;
                return String.format("%s-%s-%s-%s", optionsContract.getBase(), OPTION_DATE_FORMAT.get().format(optionsContract.getExpireDate()), optionsContract.getStrike(), optionsContract.getType().equals((Object)OptionsContract.OptionType.PUT) ? "P" : "C").toUpperCase();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)category));
    }

    public static CurrencyPair guessSymbol(String symbol) {
        for (String quoteCurrency : QUOTE_CURRENCIES) {
            if (!symbol.endsWith(quoteCurrency)) continue;
            int splitIndex = symbol.lastIndexOf(quoteCurrency);
            return new CurrencyPair(symbol.substring(0, splitIndex), symbol.substring(splitIndex));
        }
        int splitIndex = symbol.length() - 3;
        return new CurrencyPair(symbol.substring(0, splitIndex), symbol.substring(splitIndex));
    }

    public static Instrument adaptInstrumentInfo(BybitInstrumentInfo instrumentInfo) {
        if (instrumentInfo instanceof BybitSpotInstrumentInfo) {
            return new CurrencyPair(instrumentInfo.getBaseCoin(), instrumentInfo.getQuoteCoin());
        }
        if (instrumentInfo instanceof BybitLinearInverseInstrumentInfo) {
            return new FuturesContract(new CurrencyPair(instrumentInfo.getBaseCoin(), instrumentInfo.getQuoteCoin()), BybitAdapters.getPrompt((BybitLinearInverseInstrumentInfo)instrumentInfo));
        }
        if (instrumentInfo instanceof BybitOptionInstrumentInfo) {
            try {
                BybitOptionInstrumentInfo optionInstrumentInfo = (BybitOptionInstrumentInfo)instrumentInfo;
                String[] parts = optionInstrumentInfo.getSymbol().split("-");
                String expireDateString = parts[1];
                BigDecimal strike = new BigDecimal(parts[2]);
                return new OptionsContract.Builder().currencyPair(new CurrencyPair(instrumentInfo.getBaseCoin(), instrumentInfo.getQuoteCoin())).expireDate(OPTION_DATE_FORMAT.get().parse(expireDateString)).strike(strike).type(optionInstrumentInfo.getOptionsType().equals((Object)BybitOptionInstrumentInfo.OptionType.CALL) ? OptionsContract.OptionType.CALL : OptionsContract.OptionType.PUT).build();
            }
            catch (ParseException e) {
                throw new ExchangeException("Unable to convert instrument info.", (Throwable)e);
            }
        }
        throw new IllegalStateException("Unexpected instrument info instance: " + instrumentInfo.getClass().getSimpleName());
    }

    public static InstrumentMetaData symbolToCurrencyPairMetaData(BybitSpotInstrumentInfo instrumentInfo) {
        return new InstrumentMetaData.Builder().marketOrderEnabled(true).minimumAmount(instrumentInfo.getLotSizeFilter().getMinOrderQty()).maximumAmount(instrumentInfo.getLotSizeFilter().getMaxOrderQty()).counterMinimumAmount(instrumentInfo.getLotSizeFilter().getMinOrderAmt()).counterMaximumAmount(instrumentInfo.getLotSizeFilter().getMaxOrderAmt()).priceScale(Integer.valueOf(instrumentInfo.getPriceFilter().getTickSize().scale())).volumeScale(Integer.valueOf(instrumentInfo.getLotSizeFilter().getBasePrecision().scale())).amountStepSize(instrumentInfo.getLotSizeFilter().getBasePrecision()).priceStepSize(instrumentInfo.getPriceFilter().getTickSize()).build();
    }

    public static InstrumentMetaData symbolToCurrencyPairMetaData(BybitLinearInverseInstrumentInfo instrumentInfo) {
        return new InstrumentMetaData.Builder().marketOrderEnabled(true).minimumAmount(instrumentInfo.getLotSizeFilter().getMinOrderQty()).maximumAmount(instrumentInfo.getLotSizeFilter().getMaxOrderQty()).priceScale(Integer.valueOf(instrumentInfo.getPriceFilter().getTickSize().scale())).priceStepSize(instrumentInfo.getPriceFilter().getTickSize()).tradingFee(instrumentInfo.getDeliveryFeeRate()).volumeScale(Integer.valueOf(instrumentInfo.getLotSizeFilter().getQtyStep().scale())).amountStepSize(instrumentInfo.getLotSizeFilter().getQtyStep()).build();
    }

    public static InstrumentMetaData symbolToCurrencyPairMetaData(BybitOptionInstrumentInfo instrumentInfo) {
        return new InstrumentMetaData.Builder().marketOrderEnabled(true).minimumAmount(instrumentInfo.getLotSizeFilter().getMinOrderQty()).maximumAmount(instrumentInfo.getLotSizeFilter().getMaxOrderQty()).priceScale(Integer.valueOf(instrumentInfo.getPriceFilter().getTickSize().scale())).priceStepSize(instrumentInfo.getPriceFilter().getTickSize()).tradingFee(instrumentInfo.getDeliveryFeeRate()).build();
    }

    public static Order adaptBybitOrderDetails(BybitOrderDetail bybitOrderResult, BybitCategory category) {
        MarketOrder.Builder builder;
        switch (bybitOrderResult.getOrderType()) {
            case MARKET: {
                builder = new MarketOrder.Builder(BybitAdapters.adaptOrderType(bybitOrderResult), BybitAdapters.convertBybitSymbolToInstrument(bybitOrderResult.getSymbol(), category));
                break;
            }
            case LIMIT: {
                builder = new LimitOrder.Builder(BybitAdapters.adaptOrderType(bybitOrderResult), BybitAdapters.convertBybitSymbolToInstrument(bybitOrderResult.getSymbol(), category)).limitPrice(bybitOrderResult.getPrice());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)bybitOrderResult.getOrderType()));
            }
        }
        return builder.orderType(BybitAdapters.getOrderType(bybitOrderResult.getSide())).originalAmount(bybitOrderResult.getQty()).cumulativeAmount(bybitOrderResult.getCumExecQty()).id(bybitOrderResult.getOrderId()).timestamp(bybitOrderResult.getCreatedTime()).averagePrice(bybitOrderResult.getAvgPrice()).orderStatus(BybitAdapters.adaptBybitOrderStatus(bybitOrderResult.getOrderStatus())).build();
    }

    private static Order.OrderType adaptOrderType(BybitOrderDetail bybitOrderResult) {
        switch (bybitOrderResult.getSide()) {
            case BUY: {
                return Order.OrderType.BID;
            }
            case SELL: {
                return Order.OrderType.ASK;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)bybitOrderResult.getSide()));
    }

    public static Order.OrderStatus adaptBybitOrderStatus(BybitOrderStatus orderStatus) {
        switch (orderStatus) {
            case CREATED: {
                return Order.OrderStatus.OPEN;
            }
            case NEW: {
                return Order.OrderStatus.NEW;
            }
            case REJECTED: {
                return Order.OrderStatus.REJECTED;
            }
            case PARTIALLY_FILLED: 
            case ACTIVE: {
                return Order.OrderStatus.PARTIALLY_FILLED;
            }
            case PARTIALLY_FILLED_CANCELED: {
                return Order.OrderStatus.PARTIALLY_CANCELED;
            }
            case FILLED: {
                return Order.OrderStatus.FILLED;
            }
            case CANCELLED: {
                return Order.OrderStatus.CANCELED;
            }
            case UNTRIGGERED: 
            case TRIGGERED: {
                return Order.OrderStatus.UNKNOWN;
            }
            case DEACTIVATED: {
                return Order.OrderStatus.STOPPED;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)orderStatus));
    }

    public static <T> BybitException createBybitExceptionFromResult(BybitResult<T> bybitResult) {
        return new BybitException(bybitResult.getRetCode(), bybitResult.getRetMsg(), bybitResult.getRetExtInfo());
    }

    public static BybitCategory getCategory(Instrument instrument) {
        if (instrument instanceof CurrencyPair) {
            return BybitCategory.SPOT;
        }
        if (instrument instanceof FuturesContract) {
            return BybitAdapters.isInverse(instrument) != false ? BybitCategory.INVERSE : BybitCategory.LINEAR;
        }
        if (instrument instanceof OptionsContract) {
            return BybitCategory.OPTION;
        }
        throw new IllegalStateException("Unexpected instrument instance type: " + instrument.getClass().getSimpleName());
    }

    public static String getPrompt(BybitLinearInverseInstrumentInfo instrumentInfo) {
        switch (instrumentInfo.getContractType()) {
            case INVERSE_PERPETUAL: 
            case LINEAR_PERPETUAL: {
                return "PERP";
            }
            case LINEAR_FUTURES: {
                return instrumentInfo.getSymbol().split("-")[1];
            }
            case INVERSE_FUTURES: {
                return instrumentInfo.getSymbol().replace(instrumentInfo.getBaseCoin() + instrumentInfo.getQuoteCoin(), "");
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)instrumentInfo.getContractType()));
    }

    public static Boolean isInverse(Instrument pair) {
        return pair instanceof FuturesContract && pair.getCounter().equals((Object)Currency.USD);
    }

    public static Ticker adaptBybitLinearInverseTicker(Instrument instrument, Date time, BybitLinearInverseTicker bybitTicker) {
        return BybitAdapters.adaptBybitTickerBuilder(instrument, time, bybitTicker).open(bybitTicker.getPrevPrice24h()).percentageChange(bybitTicker.getPrice24hPcnt()).build();
    }

    public static Ticker adaptBybitSpotTicker(Instrument instrument, Date time, BybitSpotTicker bybitTicker) {
        return BybitAdapters.adaptBybitTickerBuilder(instrument, time, bybitTicker).open(bybitTicker.getPrevPrice24h()).percentageChange(bybitTicker.getPrice24hPcnt()).build();
    }

    public static Ticker adaptBybitOptionTicker(Instrument instrument, Date time, BybitOptionTicker bybitTicker) {
        return BybitAdapters.adaptBybitTickerBuilder(instrument, time, bybitTicker).build();
    }

    private static Ticker.Builder adaptBybitTickerBuilder(Instrument instrument, Date time, BybitTicker bybitTicker) {
        return new Ticker.Builder().timestamp(time).instrument(instrument).last(bybitTicker.getLastPrice()).bid(bybitTicker.getBid1Price()).bidSize(bybitTicker.getBid1Size()).ask(bybitTicker.getAsk1Price()).askSize(bybitTicker.getAsk1Size()).high(bybitTicker.getHighPrice24h()).low(bybitTicker.getLowPrice24h()).quoteVolume(bybitTicker.getTurnover24h()).volume(bybitTicker.getVolume24h());
    }

    public static Instrument convertBybitSymbolToInstrument(String symbol, BybitCategory category) {
        switch (category) {
            case SPOT: {
                return BybitAdapters.guessSymbol(symbol);
            }
            case LINEAR: {
                if (symbol.endsWith("USDT")) {
                    int splitIndex = symbol.lastIndexOf("USDT");
                    return new FuturesContract(new CurrencyPair(symbol.substring(0, splitIndex), "USDT"), "PERP");
                }
                if (symbol.endsWith("PERP")) {
                    int splitIndex = symbol.lastIndexOf("PERP");
                    return new FuturesContract(new CurrencyPair(symbol.substring(0, splitIndex), "USDC"), "PERP");
                }
                int splitIndex = symbol.lastIndexOf("-");
                return new FuturesContract(new CurrencyPair(symbol.substring(0, splitIndex), "USDC"), symbol.substring(splitIndex + 1));
            }
            case INVERSE: {
                int splitIndex = symbol.lastIndexOf("USD");
                String perp = symbol.length() > splitIndex + 3 ? symbol.substring(splitIndex + 3) : "";
                return new FuturesContract(new CurrencyPair(symbol.substring(0, splitIndex), "USD"), perp);
            }
            case OPTION: {
                DateTimeFormatter dateParser = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddLLLyy").toFormatter(Locale.US);
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyMMdd");
                String[] tokens = symbol.split("-");
                String base = tokens[0];
                String quote = "USDC";
                String date = dateFormat.format(LocalDate.parse(tokens[1], dateParser));
                BigDecimal strike = new BigDecimal(tokens[2]);
                return new OptionsContract(base + "/" + quote + "/" + date + "/" + strike + "/" + tokens[3]);
            }
        }
        return null;
    }
}

