/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.log;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.knopflerfish.bundle.log.ArrayEnumeration;
import org.knopflerfish.bundle.log.FileLog;
import org.knopflerfish.bundle.log.LogConfigImpl;
import org.knopflerfish.bundle.log.LogEntryImpl;
import org.knopflerfish.bundle.log.LogReaderServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;

public final class LogReaderServiceFactory
implements ServiceFactory {
    BundleContext bc;
    FileLog fileLog;
    Hashtable logReaderServicies = new Hashtable();
    LogConfigImpl configuration;
    LogEntry[] history;
    int historyInsertionPoint = 0;

    public LogReaderServiceFactory(BundleContext bc, LogConfigImpl lc) {
        this.bc = bc;
        this.configuration = lc;
        this.history = new LogEntry[this.configuration.getMemorySize()];
        this.historyInsertionPoint = 0;
        try {
            if (this.configuration.getFile()) {
                this.fileLog = new FileLog(bc, this.configuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.configuration.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.fileLog != null) {
            FileLog fileLog = this.fileLog;
            synchronized (fileLog) {
                this.fileLog.stop();
                this.fileLog = null;
            }
        }
        this.configuration.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetMemorySize(int size, int memorySize) {
        if (size <= 0) {
            size = 1;
        }
        LogEntry[] logEntryArray = this.history;
        synchronized (this.history) {
            LogEntry[] new_history = new LogEntry[size];
            int leftSize = this.historyInsertionPoint;
            if (leftSize > 0) {
                if (leftSize > size) {
                    System.arraycopy(this.history, leftSize - size + 1, new_history, 1, size - 1);
                } else {
                    System.arraycopy(this.history, 0, new_history, size - leftSize, leftSize);
                    int remaindingSize = size - leftSize;
                    int remaindingEntries = memorySize - leftSize;
                    if (remaindingSize > remaindingEntries) {
                        System.arraycopy(this.history, leftSize, new_history, remaindingSize - remaindingEntries, remaindingEntries);
                    } else {
                        System.arraycopy(this.history, memorySize - remaindingSize, new_history, 0, remaindingSize);
                    }
                }
            } else {
                int s = size > memorySize ? memorySize : size;
                int fromPos = size > memorySize ? 0 : memorySize - s;
                System.arraycopy(this.history, fromPos, new_history, size - s, s);
            }
            this.history = new_history;
            this.historyInsertionPoint = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFile(Boolean newValue, Boolean oldValue) {
        if (newValue.booleanValue() && this.fileLog == null) {
            this.fileLog = new FileLog(this.bc, this.configuration);
            if (oldValue == null) {
                FileLog fileLog = this.fileLog;
                synchronized (fileLog) {
                    LogEntry[] logEntryArray = this.history;
                    synchronized (this.history) {
                        this.fileLog.saveMemEntries(new ArrayEnumeration(this.history, this.historyInsertionPoint));
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                    }
                }
            }
        } else if (!newValue.booleanValue() && this.fileLog != null) {
            FileLog fileLog = this.fileLog;
            synchronized (fileLog) {
                this.fileLog.stop();
                this.fileLog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configChange(String propName, Object oldValue, Object newValue) {
        String name = propName;
        if (name.equals("memory.size")) {
            this.resetMemorySize((Integer)newValue, (Integer)oldValue);
        } else if (name.equals("file")) {
            this.resetFile((Boolean)newValue, (Boolean)oldValue);
        } else if (name.equals("file.generations") && this.fileLog != null) {
            FileLog fileLog = this.fileLog;
            synchronized (fileLog) {
                this.fileLog.resetGenerations((Integer)newValue, (Integer)oldValue);
            }
        }
    }

    public Object getService(Bundle bc, ServiceRegistration sd) {
        LogReaderServiceImpl lrsi = new LogReaderServiceImpl(this);
        this.logReaderServicies.put(lrsi, bc);
        return lrsi;
    }

    public void ungetService(Bundle bc, ServiceRegistration sd, Object s) {
        this.logReaderServicies.remove(s);
    }

    public Enumeration getLog() {
        return new ArrayEnumeration(this.history, this.historyInsertionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogLevel(final Bundle bundle) {
        LogConfigImpl logConfigImpl = this.configuration;
        synchronized (logConfigImpl) {
            Integer res = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Integer(LogReaderServiceFactory.this.getFilterLevel(bundle));
                }
            });
            return res;
        }
    }

    protected synchronized void log(final LogEntryImpl le) {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public Object run() {
                if (le.getLevel() <= LogReaderServiceFactory.this.getFilterLevel(le.getBundle())) {
                    LogEntry[] logEntryArray;
                    if (LogReaderServiceFactory.this.fileLog != null) {
                        logEntryArray = LogReaderServiceFactory.this.fileLog;
                        // MONITORENTER : LogReaderServiceFactory.this.fileLog
                        LogReaderServiceFactory.this.fileLog.logged(le);
                        // MONITOREXIT : logEntryArray
                    }
                    if (LogReaderServiceFactory.this.configuration.getOut()) {
                        System.out.println(le);
                    }
                    logEntryArray = LogReaderServiceFactory.this.history;
                    // MONITORENTER : LogReaderServiceFactory.this.history
                    LogReaderServiceFactory.this.history[LogReaderServiceFactory.this.historyInsertionPoint] = le;
                    ++LogReaderServiceFactory.this.historyInsertionPoint;
                    if (LogReaderServiceFactory.this.historyInsertionPoint == LogReaderServiceFactory.this.history.length) {
                        LogReaderServiceFactory.this.historyInsertionPoint = 0;
                    }
                    // MONITOREXIT : logEntryArray
                }
                Enumeration e = LogReaderServiceFactory.this.logReaderServicies.keys();
                while (e.hasMoreElements()) {
                    try {
                        ((LogReaderServiceImpl)e.nextElement()).callback(le);
                    }
                    catch (Exception exception) {}
                }
                return null;
            }
        });
    }

    int getFilterLevel(Bundle b) {
        return b != null ? this.configuration.getLevel(b) : this.configuration.getFilter();
    }
}

