/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.log;

import org.knopflerfish.bundle.log.LogEntryImpl;
import org.knopflerfish.bundle.log.LogReaderServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class LogFrameworkListener
implements FrameworkListener,
BundleListener,
ServiceListener {
    private final LogReaderServiceFactory lrsf;

    public LogFrameworkListener(LogReaderServiceFactory lrsf) {
        this.lrsf = lrsf;
    }

    public void frameworkEvent(FrameworkEvent fe) {
        int level = 3;
        String msg = null;
        Throwable thr = null;
        switch (fe.getType()) {
            case 2: {
                msg = "FrameworkEvent ERROR";
                level = 1;
                thr = fe.getThrowable();
                break;
            }
            case 1: {
                msg = "FrameworkEvent STARTED";
                level = 3;
                break;
            }
            case 8: {
                msg = "FrameworkEvent STARTLEVEL_CHANGED";
                level = 3;
                break;
            }
            case 4: {
                msg = "FrameworkEvent PACKAGES_REFRESHED";
                level = 3;
                break;
            }
            case 16: {
                msg = "FrameworkEvent WARNING";
                level = 3;
                break;
            }
            case 32: {
                msg = "FrameworkEvent INFO";
                level = 3;
                break;
            }
            default: {
                msg = "FrameworkEvent <" + fe.getType() + ">";
                level = 2;
            }
        }
        this.lrsf.log(new LogEntryImpl(fe.getBundle(), level, msg, thr));
    }

    public void bundleChanged(BundleEvent be) {
        String msg = null;
        switch (be.getType()) {
            case 1: {
                msg = "BundleEvent INSTALLED";
                break;
            }
            case 2: {
                msg = "BundleEvent STARTED";
                break;
            }
            case 4: {
                msg = "BundleEvent STOPPED";
                break;
            }
            case 16: {
                msg = "BundleEvent UNINSTALLED";
                break;
            }
            case 8: {
                msg = "BundleEvent UPDATED";
                break;
            }
            case 32: {
                msg = "BundleEvent RESOLVED";
                break;
            }
            case 64: {
                msg = "BundleEvent UNRESOLVED";
            }
        }
        this.lrsf.log(new LogEntryImpl(be.getBundle(), 3, msg));
    }

    public void serviceChanged(ServiceEvent se) {
        ServiceReference sr = se.getServiceReference();
        Bundle bundle = sr.getBundle();
        String msg = null;
        int level = 3;
        switch (se.getType()) {
            case 1: {
                msg = "ServiceEvent REGISTERED";
                break;
            }
            case 4: {
                msg = "ServiceEvent UNREGISTERING";
                break;
            }
            case 2: {
                msg = "ServiceEvent MODIFIED";
                level = 4;
            }
        }
        this.lrsf.log(new LogEntryImpl(bundle, sr, level, msg));
    }
}

