/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.log;

import java.text.SimpleDateFormat;
import org.knopflerfish.service.log.LogUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

public final class LogEntryImpl
implements LogEntry {
    private static SimpleDateFormat simpleDateFormat = null;
    private Bundle bundle;
    private ServiceReference sr;
    private int level;
    private String msg;
    private Throwable e;
    private long millis;

    public LogEntryImpl(Bundle bc, int l, String m) {
        this(bc, null, l, m, null);
    }

    public LogEntryImpl(Bundle bc, int l, String m, Throwable e) {
        this(bc, null, l, m, e);
    }

    public LogEntryImpl(Bundle bc, ServiceReference sd, int l, String m) {
        this(bc, sd, l, m, null);
    }

    public LogEntryImpl(Bundle bc, ServiceReference sd, int l, String m, Throwable e) {
        this.bundle = bc;
        this.sr = sd;
        this.level = l;
        this.msg = m;
        this.e = e;
        this.millis = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(LogUtil.fromLevel(this.level, 8));
        sb.append(" ");
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        }
        sb.append(simpleDateFormat.format(new Long(this.millis)));
        sb.append(" ");
        sb.append("bid#");
        if (this.bundle != null) {
            sb.append(this.bundle.getBundleId());
        }
        if (sb.length() < 40) {
            sb.append("          ");
            sb.setLength(40);
        }
        sb.append("- ");
        if (this.sr != null) {
            sb.append("[");
            sb.append(this.sr.getProperty("service.id").toString());
            sb.append(";");
            String[] clazzes = (String[])this.sr.getProperty("objectClass");
            for (int i = 0; i < clazzes.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(clazzes[i]);
            }
            sb.append("] ");
        }
        sb.append(this.msg);
        if (this.e != null) {
            sb.append(" (");
            sb.append(this.e.toString());
            sb.append(")");
        }
        return sb.toString();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ServiceReference getServiceReference() {
        return this.sr;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.msg;
    }

    public Throwable getException() {
        return this.e;
    }

    public long getTime() {
        return this.millis;
    }
}

