/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.log;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.knopflerfish.bundle.log.LogEntryImpl;
import org.knopflerfish.bundle.log.LogReaderServiceFactory;
import org.knopflerfish.service.log.LogConfig;
import org.knopflerfish.service.log.LogUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

class LogConfigImpl
implements ManagedService,
LogConfig {
    static BundleContext bc;
    boolean DEFAULT_CONFIG = true;
    boolean firstValid = false;
    static final String PROP_LOG_OUT = "org.knopflerfish.log.out";
    static final String PROP_LOG_GRABIO = "org.knopflerfish.log.grabio";
    static final String PROP_LOG_LEVEL = "org.knopflerfish.log.level";
    static final String PROP_LOG_FILE = "org.knopflerfish.log.file";
    static final String PROP_LOG_FILE_DIR = "org.knopflerfish.log.file.dir";
    private static final String OUT = "log.out";
    private static final String GRABIO = "log.grabio";
    private static final String L_FILTER = "default.level";
    private static final String BL_FILTERS = "bundle.log.level";
    private static final String DIR = "file.dir";
    private static final String FILE_S = "file.size";
    private static final String FLUSH = "file.flush";
    private static final String PID = "service.pid";
    private String pid;
    static final String MEM = "memory.size";
    static final String GEN = "file.generations";
    static final String FILE = "file";
    private static final int LOCATION_POS = 0;
    private static final int FILTER_POS = 1;
    private File dir;
    private Hashtable configCollection;
    private HashMap blFilters = new HashMap();
    private LogReaderServiceFactory logReaderCallback;
    boolean bGrabbed = false;
    PrintStream origOut = null;
    PrintStream origErr = null;
    LogReaderServiceFactory lsrf;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$knopflerfish$service$log$LogConfig;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    public LogConfigImpl(BundleContext bc) {
        LogConfigImpl.bc = bc;
        this.start();
    }

    synchronized void start() {
        this.pid = this.getClass().getName();
        this.configCollection = this.getDefault();
        this.initDir();
        String[] clazzes = new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = LogConfigImpl.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (class$org$knopflerfish$service$log$LogConfig == null ? (class$org$knopflerfish$service$log$LogConfig = LogConfigImpl.class$("org.knopflerfish.service.log.LogConfig")) : class$org$knopflerfish$service$log$LogConfig).getName()};
        bc.registerService(clazzes, (Object)this, (Dictionary)this.configCollection);
    }

    private void initDir() {
        this.dir = bc.getDataFile("");
        String d = (String)this.configCollection.get(DIR);
        if (d != null) {
            this.dir = new File(d);
        }
    }

    void init(LogReaderServiceFactory lr) {
        this.logReaderCallback = lr;
    }

    void stop() {
        this.logReaderCallback = null;
    }

    public synchronized void commit() {
        this.updateConfig();
    }

    public boolean isDefaultConfig() {
        return this.DEFAULT_CONFIG;
    }

    public synchronized void setMemorySize(int size) {
        int oldSize = this.getMemorySize();
        if (size != oldSize) {
            Integer newSize = new Integer(size);
            this.set(MEM, newSize);
            if (this.logReaderCallback != null) {
                this.logReaderCallback.configChange(MEM, new Integer(oldSize), newSize);
            }
            this.updateConfig();
        }
    }

    public int getMemorySize() {
        return (Integer)this.get(MEM);
    }

    public synchronized void setFilter(int filter) {
        int oldFilter = this.getFilter();
        if (filter == 0) {
            filter = 2;
        }
        if (filter != oldFilter) {
            this.set(L_FILTER, LogUtil.fromLevel(filter));
            this.updateConfig();
        }
    }

    public int getFilter() {
        return LogUtil.toLevel((String)this.get(L_FILTER), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFilter(String bundleLocation, int filter) {
        bundleLocation = bundleLocation.trim();
        HashMap hashMap = this.blFilters;
        synchronized (hashMap) {
            Integer f = (Integer)this.blFilters.get(this.getCommonLocation(bundleLocation));
            if (filter == 0 && f != null) {
                this.blFilters.remove(this.getCommonLocation(bundleLocation));
                this.setCollection(true, bundleLocation, filter);
            } else if (f != null && filter != f || f == null) {
                this.blFilters.put(this.getCommonLocation(bundleLocation), new Integer(filter));
                this.setCollection(false, bundleLocation, filter);
            }
        }
    }

    public synchronized HashMap getFilters() {
        return (HashMap)this.blFilters.clone();
    }

    public synchronized void setOut(boolean b) {
        boolean oldOut = this.getOut();
        if (b != oldOut) {
            this.set(OUT, new Boolean(b));
            this.updateConfig();
        }
    }

    public boolean getOut() {
        return (Boolean)this.get(OUT);
    }

    public synchronized void setFile(boolean f) {
        boolean oldFile;
        if (this.dir != null && f != (oldFile = this.getFile())) {
            Boolean newFile = new Boolean(f);
            this.set(FILE, newFile);
            if (this.logReaderCallback != null) {
                this.logReaderCallback.configChange(FILE, new Boolean(oldFile), newFile);
            }
        }
    }

    public boolean getFile() {
        return (Boolean)this.get(FILE) != false && this.getDir() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDir() {
        if (this.dir == null) {
            return this.dir;
        }
        File file = this.dir;
        synchronized (file) {
            return this.dir;
        }
    }

    public synchronized void setFileSize(int fS) {
        int oldSize = this.getFileSize();
        if (oldSize != fS) {
            this.set(FILE_S, new Integer(fS));
        }
    }

    public int getFileSize() {
        return (Integer)this.get(FILE_S);
    }

    public synchronized void setMaxGen(int maxGen) {
        int oldGen = this.getMaxGen();
        if (oldGen != maxGen) {
            this.set(GEN, new Integer(maxGen));
            if (this.logReaderCallback != null) {
                this.logReaderCallback.configChange(GEN, new Integer(oldGen), new Integer(maxGen));
            }
        }
    }

    public int getMaxGen() {
        int gen = (Integer)this.get(GEN);
        return gen < 1 ? 1 : gen;
    }

    public synchronized void setFlush(boolean f) {
        boolean oldFlush = this.getFlush();
        if (f != oldFlush) {
            this.set(FLUSH, new Boolean(f));
        }
    }

    public boolean getFlush() {
        return (Boolean)this.get(FLUSH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLevel(Bundle bundle) {
        Integer level;
        HashMap hashMap = this.blFilters;
        synchronized (hashMap) {
            level = (Integer)this.blFilters.get(bundle.getLocation());
            if (level == null) {
                Dictionary d = bundle.getHeaders("");
                String l = (String)d.get("Bundle-SymbolicName");
                if (l == null) {
                    l = (String)d.get("Bundle-Name");
                }
                if (l != null) {
                    level = (Integer)this.blFilters.get(this.getCommonLocation(l));
                }
            }
        }
        return level != null ? level.intValue() : this.getFilter();
    }

    static String[] getBL(Object obj) {
        String bundleStr = (String)obj;
        String[] bundle = new String[]{null, null};
        int ix = bundleStr.indexOf(";");
        try {
            bundle[0] = bundleStr.substring(0, ix).trim();
            bundle[1] = bundleStr.substring(ix + 1).trim();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bundle entries must be in the format location;level");
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCollection(boolean remove, String bundleLocation, int filter) {
        Hashtable hashtable = this.configCollection;
        synchronized (hashtable) {
            Vector v = (Vector)this.configCollection.get(BL_FILTERS);
            boolean notFound = true;
            if (v != null && v.size() > 0) {
                for (int i = v.size() - 1; i >= 0; --i) {
                    String[] bundF = LogConfigImpl.getBL(v.elementAt(i));
                    if (!this.getCommonLocation(bundF[0]).equals(this.getCommonLocation(bundleLocation))) continue;
                    if (remove) {
                        v.removeElementAt(i);
                    } else {
                        v.setElementAt(bundleLocation + ";" + LogUtil.fromLevel(filter), i);
                    }
                    notFound = false;
                    break;
                }
            }
            if (notFound && !remove) {
                v.addElement(bundleLocation + ";" + LogUtil.fromLevel(filter));
            }
        }
    }

    boolean getGrabIO() {
        return (Boolean)this.get(GRABIO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(String key) {
        Hashtable hashtable = this.configCollection;
        synchronized (hashtable) {
            return this.configCollection.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(String key, Object value) {
        Hashtable hashtable = this.configCollection;
        synchronized (hashtable) {
            this.configCollection.put(key, value);
        }
    }

    private void updateConfig() {
        try {
            ServiceReference sr = bc.getServiceReference((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = LogConfigImpl.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName());
            if (sr != null) {
                Configuration conf;
                ConfigurationAdmin ca = (ConfigurationAdmin)bc.getService(sr);
                if (ca != null && (conf = ca.getConfiguration(this.pid)) != null) {
                    conf.update((Dictionary)this.configCollection);
                }
                bc.ungetService(sr);
            }
        }
        catch (IOException io) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Hashtable getDefault() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Vector bundleLogFilters = new Vector();
        String o = LogConfigImpl.getProperty(PROP_LOG_OUT, "false");
        String levelStr = LogConfigImpl.getProperty(PROP_LOG_LEVEL, LogUtil.fromLevel(2));
        ht.put(L_FILTER, levelStr);
        ht.put(MEM, new Integer(250));
        ht.put(OUT, new Boolean("true".equalsIgnoreCase(o)));
        ht.put(GRABIO, new Boolean("true".equalsIgnoreCase(LogConfigImpl.getProperty(PROP_LOG_GRABIO, "false"))));
        ht.put(FILE, new Boolean("true".equalsIgnoreCase(LogConfigImpl.getProperty(PROP_LOG_FILE, "false"))));
        String dirStr = LogConfigImpl.getProperty(PROP_LOG_FILE_DIR, null);
        if (dirStr != null) {
            ht.put(DIR, dirStr);
        }
        ht.put(FILE_S, new Integer(20000));
        ht.put(GEN, new Integer(4));
        ht.put(FLUSH, new Boolean(true));
        ht.put(BL_FILTERS, bundleLogFilters);
        ht.put(PID, this.pid);
        return ht;
    }

    static String getProperty(String key, String def) {
        String result = def;
        try {
            result = bc.getProperty(key);
            if (result == null) {
                result = def;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to get property " + key + " : " + e);
            result = def;
        }
        return result;
    }

    public synchronized void updated(Dictionary cfg) throws ConfigurationException, IllegalArgumentException {
        if (cfg == null) {
            this.DEFAULT_CONFIG = true;
            this.checkChange(this.getDefault());
        } else {
            this.checkValidity(cfg);
        }
        this.updateGrabIO();
    }

    void setLogReaderServiceFactory(LogReaderServiceFactory lsrf) {
        this.lsrf = lsrf;
    }

    void updateGrabIO() {
        boolean bDebugClass = "true".equals(LogConfigImpl.getProperty("org.knopflerfish.framework.debug.classloader", "false"));
        if (!bDebugClass) {
            if (this.getGrabIO()) {
                this.grabIO();
            } else {
                this.ungrabIO();
            }
        }
    }

    void grabIO() {
        if (!this.getOut() && !this.bGrabbed) {
            this.origOut = System.out;
            this.origErr = System.err;
            System.setOut(new WrapStream("[stdout] ", System.out, 3));
            System.setErr(new WrapStream("[stderr] ", System.out, 1));
            this.bGrabbed = true;
        }
    }

    void ungrabIO() {
        if (this.bGrabbed) {
            System.setOut(this.origOut);
            System.setErr(this.origErr);
            this.bGrabbed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValidity(Dictionary cfg) throws ConfigurationException, IllegalArgumentException {
        block13: {
            boolean valid = false;
            Hashtable rollBack = (Hashtable)this.configCollection.clone();
            try {
                this.checkLogLevel(cfg);
                this.checkBundleLogLevel(cfg);
                valid = true;
                Object var5_4 = null;
                if (!valid) break block13;
                valid = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (valid) {
                    valid = false;
                    try {
                        this.acceptConfig(cfg);
                        valid = true;
                        if (!valid) {
                            this.configCollection = rollBack;
                        }
                    }
                    catch (Exception all) {
                        try {}
                        catch (Throwable throwable2) {
                            if (!valid) {
                                this.configCollection = rollBack;
                            }
                            throw throwable2;
                        }
                        throw new ConfigurationException(null, "Fault occurred when setting configuration. Check that all properties are valid.");
                    }
                }
                throw throwable;
            }
            try {
                this.acceptConfig(cfg);
                valid = true;
            }
            catch (Exception all) {
                throw new ConfigurationException(null, "Fault occurred when setting configuration. Check that all properties are valid.");
            }
            finally {
                if (!valid) {
                    this.configCollection = rollBack;
                }
            }
        }
    }

    private void checkLogLevel(Dictionary cfg) throws ConfigurationException, IllegalArgumentException {
        String filter = null;
        Object obj = cfg.get(L_FILTER);
        if (obj == null) {
            throw new IllegalArgumentException("No log level given. Please supply a valid log level.");
        }
        try {
            filter = ((String)obj).trim();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong type supplied when attempting to set log level. Correct type to use is String. " + obj + " " + obj.getClass().getName());
        }
        int filterVal = LogUtil.toLevel(filter, -1);
        if (filterVal == -1) {
            throw new ConfigurationException(L_FILTER, "Undefined log level <" + filter + ">.");
        }
        if (filterVal == 0) {
            cfg.put(L_FILTER, LogUtil.fromLevel(2));
        }
    }

    private void checkBundleLogLevel(Dictionary cfg) throws ConfigurationException, IllegalArgumentException {
        Vector v = null;
        try {
            v = (Vector)cfg.get(BL_FILTERS);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong type supplied when attempting to set log level for specific bundle. Correct type to use is Vector of String[].");
        }
        if (v != null) {
            String[] bundle = null;
            for (int i = 0; i < v.size(); ++i) {
                try {
                    bundle = LogConfigImpl.getBL(v.elementAt(i));
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("Wrong type supplied when attempting to set log level for specific bundle. Correct type to use is String.");
                }
                if (bundle == null) {
                    throw new IllegalArgumentException("Empty configuration supplied when attempting to set log level  for specific bundle.");
                }
                bundle[0] = bundle[0].trim();
                if (bundle[0] == null || bundle[0].length() <= 0) {
                    throw new IllegalArgumentException("No bundle location given when setting log level for specific bundle.");
                }
                if (bundle[1] == null) {
                    throw new IllegalArgumentException("No log level given for bundle: " + bundle[0] + ". " + "Please supply a valid log level.");
                }
                int testFilter = 0;
                testFilter = LogUtil.toLevel(bundle[1].trim(), -1);
                if (testFilter == -1) {
                    throw new ConfigurationException(BL_FILTERS, "Undefined log level <" + bundle[1] + "> specified for bundle <" + bundle[0] + ">.");
                }
                if (testFilter == 0) {
                    v.removeElementAt(i);
                    --i;
                    continue;
                }
                bundle[1] = LogUtil.fromLevel(testFilter);
                this.checkLocation(bundle[0]);
            }
        }
    }

    private void checkLocation(String location) {
        try {
            if (location.indexOf("/") != -1 || location.indexOf("\\") != -1) {
                URL u = new URL(this.getCommonLocation(location));
                InputStream is = u.openStream();
                is.close();
            }
        }
        catch (IOException ignore) {
            this.log("File <" + location + "> set at configuration of logcomponent " + "does not exist at the given location. ");
        }
    }

    private void acceptConfig(Dictionary cfg) {
        this.firstValid = this.DEFAULT_CONFIG;
        this.DEFAULT_CONFIG = false;
        this.checkChange(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChange(Dictionary cfg) {
        this.setFilterCfg((Vector)cfg.get(BL_FILTERS));
        Object newV = null;
        newV = this.diff(L_FILTER, cfg);
        if (newV != null) {
            this.set(L_FILTER, newV);
        }
        if ((newV = this.diff(MEM, cfg)) != null) {
            this.notify(MEM, newV);
            this.set(MEM, newV);
        }
        if ((newV = this.diff(OUT, cfg)) != null) {
            if (this.DEFAULT_CONFIG) {
                this.set(OUT, "true".equalsIgnoreCase(LogConfigImpl.getProperty(PROP_LOG_OUT, "false")) ? Boolean.TRUE : Boolean.FALSE);
            } else {
                this.set(OUT, newV);
            }
        }
        if ((newV = this.diff(DIR, cfg)) != null) {
            File currentDir = bc.getDataFile("/");
            newV = ((String)newV).trim();
            if (currentDir != null && !newV.equals("")) {
                currentDir = new File((String)newV);
            }
            if (this.dir != null) {
                File file = this.dir;
                synchronized (file) {
                    this.dir = currentDir;
                }
            } else {
                this.dir = currentDir;
            }
            this.set(DIR, newV);
        }
        if ((newV = this.diff(FILE_S, cfg)) != null) {
            this.set(FILE_S, newV);
        }
        if ((newV = this.diff(FLUSH, cfg)) != null) {
            this.set(FLUSH, newV);
        }
        if ((newV = this.diff(FILE, cfg)) != null) {
            if (this.dir != null) {
                if (this.firstValid) {
                    Hashtable hashtable = this.configCollection;
                    synchronized (hashtable) {
                        this.configCollection.remove(FILE);
                    }
                    this.firstValid = false;
                }
                this.notify(FILE, newV);
            }
            this.set(FILE, this.DEFAULT_CONFIG ? new Boolean(false) : newV);
        }
        if ((newV = this.diff(GEN, cfg)) != null) {
            this.notify(GEN, newV);
            this.set(GEN, newV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilterCfg(Vector newV) {
        if (newV != null) {
            String[] bundle = null;
            int newFilter = -1;
            HashMap<String, Integer> tmpFilters = new HashMap<String, Integer>();
            for (int i = 0; i < newV.size(); ++i) {
                bundle = LogConfigImpl.getBL(newV.elementAt(i));
                String common = this.getCommonLocation(bundle[0]);
                newFilter = LogUtil.toLevel(bundle[1].trim(), 2);
                tmpFilters.put(common, new Integer(newFilter));
            }
            HashMap hashMap = this.blFilters;
            synchronized (hashMap) {
                this.blFilters = tmpFilters;
            }
            this.set(BL_FILTERS, newV);
        }
    }

    String getCommonLocation(String location) {
        if (location.endsWith(".jar")) {
            return location;
        }
        return location + ".jar";
    }

    private Object diff(String key, Dictionary cfg) {
        Object newV = null;
        Object v = cfg.get(key);
        newV = v;
        return v != null && !newV.equals(this.configCollection.get(key)) ? newV : null;
    }

    private void notify(String key, Object newV) {
        if (this.logReaderCallback != null) {
            this.logReaderCallback.configChange(key, this.configCollection.get(key), newV);
        }
    }

    private void log(String msg) {
        if (this.logReaderCallback != null) {
            this.logReaderCallback.log(new LogEntryImpl(bc.getBundle(), 3, msg));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WrapStream
    extends PrintStream {
        String prefix;
        int level;

        WrapStream(String prefix, PrintStream out, int level) {
            super(out);
            this.prefix = prefix;
            this.level = level;
        }

        public void println(String s) {
            super.print(this.prefix);
            super.println(s);
            this.log(s);
        }

        public void print(String s) {
            super.print(s);
        }

        public void println(Object x) {
            super.print(this.prefix);
            super.println(x);
            this.log("" + x);
        }

        public void print(Object x) {
            super.print(x);
        }

        void log(String s) {
            if (s != null && -1 != s.indexOf(this.prefix)) {
                return;
            }
            if (LogConfigImpl.this.lsrf != null) {
                LogConfigImpl.this.lsrf.log(new LogEntryImpl(bc.getBundle(0L), this.level, this.prefix + s, null));
            }
        }
    }
}

