/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.knopflerfish.bundle.log.LogConfigImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public final class FileLog
implements LogListener {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private static final String LOGBASE = "gosglog";
    private int logSize;
    private File logdir = null;
    PrintWriter log;
    private LogConfigImpl configuration = null;

    public FileLog(BundleContext bc, LogConfigImpl lc) {
        this.configuration = lc;
        this.init();
    }

    private void init() {
        this.logdir = this.configuration.getDir();
        this.savePreviousLog();
        this.openLog();
    }

    void stop() {
        if (this.log != null) {
            this.log.flush();
            this.log.close();
            this.log = null;
        }
    }

    void resetGenerations(int gen, int oldGen) {
        if (gen < 1) {
            gen = 1;
        }
        if (gen != oldGen && oldGen > gen) {
            this.trimGenerations(gen);
        }
    }

    void openLog() {
        if (this.logdir == null) {
            return;
        }
        File logfile = new File(this.logdir, "gosglog0");
        try {
            FileOutputStream fos = new FileOutputStream(logfile);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            this.log = new PrintWriter(bw);
            String s = "Log started " + SDF.format(new Date());
            this.logSize = s.length();
            this.log.println(s);
            this.log.flush();
        }
        catch (IOException e) {
            System.err.println("Failed to open logfile " + logfile + " due to: " + e.getMessage());
            this.log = null;
        }
    }

    void saveOldGen() {
        if (this.logdir == null) {
            return;
        }
        for (int i = this.configuration.getMaxGen() - 1; i > 0; --i) {
            File dst = new File(this.logdir, LOGBASE + i);
            File src = new File(this.logdir, LOGBASE + (i - 1));
            if (dst.exists()) {
                dst.delete();
            }
            src.renameTo(dst);
        }
    }

    private void savePreviousLog() {
        File src;
        if (this.logdir == null) {
            return;
        }
        boolean done = false;
        int i = 0;
        while (!done) {
            src = new File(this.logdir, LOGBASE + i + ".old");
            if (src.exists()) {
                src.delete();
            } else {
                done = true;
            }
            ++i;
        }
        done = false;
        i = 0;
        while (!done) {
            src = new File(this.logdir, LOGBASE + i);
            if (src.exists()) {
                File dst = new File(this.logdir, LOGBASE + i + ".old");
                if (dst.exists()) {
                    dst.delete();
                }
                src.renameTo(dst);
            } else {
                done = true;
            }
            ++i;
        }
    }

    private void trimGenerations(int gen) {
        if (this.logdir == null) {
            return;
        }
        boolean done = false;
        int i = gen;
        while (!done) {
            File src = new File(this.logdir, LOGBASE + i);
            if (src.exists()) {
                src.delete();
            } else {
                done = true;
            }
            ++i;
        }
    }

    public void logged(LogEntry le) {
        if (this.log != null) {
            String s = le.toString();
            if (this.logSize + s.length() > this.configuration.getFileSize()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        FileLog.this.log.close();
                        FileLog.this.saveOldGen();
                        FileLog.this.openLog();
                        return null;
                    }
                });
            }
            this.logSize += s.length();
            this.log.println(s);
            if (this.configuration.getFlush()) {
                this.log.flush();
            }
        }
    }

    void saveMemEntries(Enumeration logEntries) {
        Vector v = new Vector();
        while (logEntries.hasMoreElements()) {
            v.insertElementAt(logEntries.nextElement(), 0);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.logged((LogEntry)e.nextElement());
        }
    }
}

