/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.bundlestorage.memory.BundleArchiveImpl;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStorageImpl
implements BundleStorage {
    private long nextFreeId = 1L;
    private final ArrayList<BundleArchive> archives = new ArrayList();
    final boolean checkSigned;

    public BundleStorageImpl(FrameworkContext framework) {
        this.checkSigned = framework.props.getBooleanProperty("org.knopflerfish.framework.bundlestorage.checksigned");
    }

    @Override
    public BundleArchive insertBundleJar(String location, InputStream is) throws Exception {
        long id = this.nextFreeId++;
        BundleArchiveImpl ba = new BundleArchiveImpl(this, is, location, id);
        this.archives.add(ba);
        return ba;
    }

    @Override
    public BundleArchive updateBundleArchive(BundleArchive old, InputStream is) throws Exception {
        return new BundleArchiveImpl((BundleArchiveImpl)old, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBundleArchive(BundleArchive oldBA, BundleArchive newBA) throws Exception {
        long id = oldBA.getBundleId();
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(id);
            if (pos >= this.archives.size() || this.archives.get(pos) != oldBA) {
                throw new Exception(((Object)new StringBuffer().append("replaceBundleJar: Old bundle archive not found, pos=").append(pos)).toString());
            }
            this.archives.set(pos, newBA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleArchive[] getAllBundleArchives() {
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            return this.archives.toArray(new BundleArchive[this.archives.size()]);
        }
    }

    @Override
    public List<String> getStartOnLaunchBundles() {
        ArrayList<String> res = new ArrayList<String>();
        for (BundleArchive ba : this.archives) {
            if (ba.getAutostartSetting() == -1) continue;
            res.add(ba.getBundleLocation());
        }
        return res;
    }

    @Override
    public void close() {
        Iterator<BundleArchive> i = this.archives.iterator();
        while (i.hasNext()) {
            BundleArchive ba = i.next();
            ba.close();
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeArchive(BundleArchive ba) {
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(ba.getBundleId());
            if (this.archives.get(pos) == ba) {
                this.archives.remove(pos);
                return true;
            }
            return false;
        }
    }

    private int find(long id) {
        int lb = 0;
        int ub = this.archives.size();
        int x = 0;
        while (lb != ub) {
            x = (lb + ub) / 2;
            long xid = this.archives.get(x).getBundleId();
            if (id <= xid) {
                ub = x;
                continue;
            }
            lb = x + 1;
        }
        return lb;
    }
}

