/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLStreamHandlerWrapper
extends URLStreamHandler
implements URLStreamHandlerSetter {
    ArrayList<FrameworkContext> framework = new ArrayList(2);
    final String protocol;
    final String filter;
    final ServiceListener serviceListener;
    private ServiceReference<URLStreamHandlerService> best;
    private URLStreamHandlerService bestService;
    private FrameworkContext currentFw;

    URLStreamHandlerWrapper(FrameworkContext fw, String proto) {
        this.protocol = proto;
        this.filter = "(&(objectClass=" + URLStreamHandlerService.class.getName() + ")" + "(" + "url.handler.protocol" + "=" + this.protocol + "))";
        this.serviceListener = new ServiceListener(){

            public synchronized void serviceChanged(ServiceEvent evt) {
                ServiceReference<?> ref = evt.getServiceReference();
                FrameworkContext fw = ((BundleImpl)ref.getBundle()).fwCtx;
                if (fw == URLStreamHandlerWrapper.this.currentFw) {
                    switch (evt.getType()) {
                        case 1: 
                        case 2: {
                            if (URLStreamHandlerWrapper.this.best == null || URLStreamHandlerWrapper.this.best.compareTo(ref) >= 0) break;
                            URLStreamHandlerWrapper.this.best = ref;
                            URLStreamHandlerWrapper.this.bestService = null;
                            break;
                        }
                        case 4: 
                        case 8: {
                            if (URLStreamHandlerWrapper.this.best == null || !URLStreamHandlerWrapper.this.best.equals(ref)) break;
                            URLStreamHandlerWrapper.this.best = null;
                            URLStreamHandlerWrapper.this.bestService = null;
                        }
                    }
                }
            }
        };
        this.framework.add(fw);
        try {
            fw.systemBundle.bundleContext.addServiceListener(this.serviceListener, this.filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Protocol name contains illegal characters: " + proto);
        }
        if (fw.debug.url) {
            fw.debug.println("created wrapper for " + this.protocol + ", filter=" + this.filter + ", " + this.toString());
        }
    }

    void addFramework(FrameworkContext fw) {
        try {
            fw.systemBundle.bundleContext.addServiceListener(this.serviceListener, this.filter);
            this.framework.add(fw);
            if (fw.debug.url) {
                fw.debug.println("created wrapper for " + this.protocol + ", filter=" + this.filter + ", " + this.toString());
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    boolean removeFramework(FrameworkContext fw) {
        this.framework.remove(fw);
        return this.framework.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLStreamHandlerService getService() {
        if (this.framework.size() != 1) {
            throw new RuntimeException("NYI - walk stack to get framework");
        }
        FrameworkContext fw = this.framework.get(0);
        ServiceListener serviceListener = this.serviceListener;
        synchronized (serviceListener) {
            if (this.best == null) {
                try {
                    ServiceReference<?>[] refs = fw.systemBundle.bundleContext.getServiceReferences(URLStreamHandlerService.class.getName(), this.filter);
                    if (refs != null) {
                        this.best = refs[0];
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            if (this.best == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.protocol);
            }
            if (this.bestService == null) {
                this.bestService = fw.systemBundle.bundleContext.getService(this.best);
            }
            if (this.bestService == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.protocol);
            }
            this.currentFw = fw;
            return this.bestService;
        }
    }

    public boolean equals(URL u1, URL u2) {
        return this.getService().equals(u1, u2);
    }

    protected int getDefaultPort() {
        return this.getService().getDefaultPort();
    }

    protected InetAddress getHostAddress(URL u) {
        return this.getService().getHostAddress(u);
    }

    protected int hashCode(URL u) {
        return this.getService().hashCode(u);
    }

    protected boolean hostsEqual(URL u1, URL u2) {
        return this.getService().hostsEqual(u1, u2);
    }

    protected URLConnection openConnection(URL u) throws IOException {
        try {
            return this.getService().openConnection(u);
        }
        catch (IllegalStateException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        this.getService().parseURL(this, u, spec, start, limit);
    }

    protected boolean sameFile(URL u1, URL u2) {
        return this.getService().sameFile(u1, u2);
    }

    public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        String authority = null;
        String userInfo = null;
        if (host != null && host.length() != 0) {
            authority = port == -1 ? host : host + ":" + port;
            int ix = host.lastIndexOf(64);
            if (ix != -1) {
                userInfo = host.substring(0, ix);
                host = host.substring(ix + 1);
            }
        }
        String path = null;
        String query = null;
        if (file != null) {
            int ix = file.lastIndexOf(63);
            if (ix != -1) {
                query = file.substring(ix + 1);
                path = file.substring(0, ix);
            } else {
                path = file;
            }
        }
        this.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    protected String toExternalForm(URL u) {
        return this.getService().toExternalForm(u);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("URLStreamHandlerWrapper[");
        ServiceReference<URLStreamHandlerService> ref = this.best;
        sb.append("protocol=" + this.protocol);
        if (ref != null) {
            sb.append(", id=" + ref.getProperty("service.id"));
            sb.append(", rank=" + ref.getProperty("service.ranking"));
        } else {
            sb.append(" no service tracked");
        }
        sb.append("]");
        return ((Object)sb).toString();
    }
}

