/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.StartLevelController;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.permissions.ConditionalPermissionAdminImpl;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurePermissionOps
extends PermissionOps {
    private static final int AP_CLASS = 0;
    private static final int AP_EXECUTE = 1;
    private static final int AP_EXTENSIONLIFECYCLE = 2;
    private static final int AP_LIFECYCLE = 3;
    private static final int AP_LISTENER = 4;
    private static final int AP_METADATA = 5;
    private static final int AP_RESOURCE = 6;
    private static final int AP_CONTEXT = 7;
    private static final int AP_WEAVE = 8;
    private static final int AP_MAX = 9;
    private static String[] AP_TO_STRING = new String[]{"class", "execute", "extensionLifecycle", "lifecycle", "listener", "metadata", "resource", "context", "weave"};
    private final FrameworkContext framework;
    private PermissionsHandle ph;
    private AdminPermission ap_resolve = null;
    private AdminPermission ap_startlevel = null;
    private RuntimePermission rp_getprotectiondomain = null;
    Hashtable<Bundle, AdminPermission[]> adminPerms = new Hashtable();
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;

    public SecurePermissionOps(FrameworkContext fw) {
        this.framework = fw;
    }

    @Override
    void init() {
        this.ph = new PermissionsHandle(this.framework);
    }

    @Override
    void registerService() {
        ConditionalPermissionAdminImpl cpa;
        if (this.framework.props.getBooleanProperty("org.knopflerfish.framework.service.permissionadmin")) {
            String[] classes = new String[]{(class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SecurePermissionOps.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName()};
            this.framework.services.register(this.framework.systemBundle, classes, this.ph.getPermissionAdminService(), null);
        }
        if (this.framework.props.getBooleanProperty("org.knopflerfish.framework.service.conditionalpermissionadmin") && (cpa = this.ph.getConditionalPermissionAdminService()) != null) {
            String[] classes = new String[]{(class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin = SecurePermissionOps.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin")) : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName()};
            this.framework.services.register(this.framework.systemBundle, classes, cpa, null);
        }
    }

    @Override
    boolean checkPermissions() {
        return true;
    }

    @Override
    boolean okClassAdminPerm(Bundle b) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (null != sm) {
                sm.checkPermission(this.getAdminPermission(b, 0));
            }
            return true;
        }
        catch (SecurityException _ignore) {
            return false;
        }
    }

    @Override
    void checkExecuteAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 1));
        }
    }

    @Override
    void checkExtensionLifecycleAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 2));
        }
    }

    @Override
    void checkExtensionLifecycleAdminPerm(Bundle b, Object checkContext) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm && checkContext != null) {
            sm.checkPermission(this.getAdminPermission(b, 2), checkContext);
        }
    }

    @Override
    void checkLifecycleAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 3));
        }
    }

    @Override
    void checkLifecycleAdminPerm(Bundle b, Object checkContext) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm && checkContext != null) {
            sm.checkPermission(this.getAdminPermission(b, 3), checkContext);
        }
    }

    @Override
    void checkListenerAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 4));
        }
    }

    @Override
    void checkMetadataAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 5));
        }
    }

    @Override
    void checkResolveAdminPerm() {
        SecurityManager sm;
        if (this.ap_resolve == null) {
            this.ap_resolve = new AdminPermission(this.framework.systemBundle, "resolve");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.ap_resolve);
        }
    }

    @Override
    void checkResourceAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 6));
        }
    }

    @Override
    boolean okResourceAdminPerm(Bundle b) {
        try {
            this.checkResourceAdminPerm(b);
            return true;
        }
        catch (SecurityException ignore) {
            if (this.framework.debug.bundle_resource) {
                this.framework.debug.printStackTrace(((Object)new StringBuffer().append("No permission to access resources in bundle #").append(b.getBundleId())).toString(), ignore);
            }
            return false;
        }
    }

    @Override
    void checkContextAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 7));
        }
    }

    @Override
    void checkStartLevelAdminPerm() {
        SecurityManager sm;
        if (this.ap_startlevel == null) {
            this.ap_startlevel = new AdminPermission(this.framework.systemBundle, "startlevel");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.ap_startlevel);
        }
    }

    @Override
    void checkGetProtectionDomain() {
        SecurityManager sm;
        if (this.rp_getprotectiondomain == null) {
            this.rp_getprotectiondomain = new RuntimePermission("getProtectionDomain");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.rp_getprotectiondomain);
        }
    }

    @Override
    void checkWeaveAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 8));
        }
    }

    @Override
    boolean okFragmentBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.getSymbolicName(), "fragment"));
    }

    @Override
    boolean okHostBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.getSymbolicName(), "host"));
    }

    @Override
    boolean okProvideBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.getSymbolicName(), "provide"));
    }

    @Override
    boolean okRequireBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.getSymbolicName(), "require"));
    }

    @Override
    boolean okAllPerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new AllPermission());
    }

    @Override
    boolean hasExportPackagePermission(ExportPkg ep) {
        BundleImpl b = ep.bpkgs.bg.bundle;
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new PackagePermission(ep.name, "exportonly"));
        }
        return true;
    }

    @Override
    boolean hasImportPackagePermission(BundleImpl b, ExportPkg ep) {
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new PackagePermission(ep.name, ep.bpkgs.bg.bundle, "import"));
        }
        return true;
    }

    @Override
    void checkRegisterServicePerm(String clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new ServicePermission(clazz, "register"));
        }
    }

    @Override
    void checkGetServicePerms(ServiceReference<?> sr) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new ServicePermission(sr, "get"));
        }
    }

    @Override
    boolean okGetServicePerms(ServiceReference<?> sr) {
        try {
            this.checkGetServicePerms(sr);
            return true;
        }
        catch (SecurityException ignore) {
            if (this.framework.debug.service_reference) {
                this.framework.debug.printStackTrace(((Object)new StringBuffer().append("No permission to get service ref: ").append(sr.getProperty("objectClass"))).toString(), ignore);
            }
            return false;
        }
    }

    @Override
    void filterGetServicePermission(Set<ServiceRegistrationImpl<?>> srs) {
        Iterator<ServiceRegistrationImpl<?>> i = srs.iterator();
        while (i.hasNext()) {
            ServiceRegistrationImpl<?> sr = i.next();
            if (this.okGetServicePerms(sr.getReference())) continue;
            i.remove();
        }
    }

    @Override
    boolean hasProvidePermission(BundleCapabilityImpl bc) {
        BundleImpl b = bc.getBundleGeneration().bundle;
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new CapabilityPermission(bc.getNamespace(), "provide"));
        }
        return true;
    }

    @Override
    boolean hasRequirePermission(BundleRequirementImpl br) {
        BundleImpl b = br.getBundleGeneration().bundle;
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new CapabilityPermission(br.getNamespace(), "require"));
        }
        return true;
    }

    @Override
    boolean hasRequirePermission(BundleRequirementImpl br, BundleCapabilityImpl bc) {
        BundleImpl bbr = br.getBundleGeneration().bundle;
        if (bbr.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(bbr.id));
            return pc.implies(new CapabilityPermission(bc.getNamespace(), bc.getAttributes(), bc.getBundleGeneration().bundle, "require"));
        }
        return true;
    }

    @Override
    <A> void checkAdaptPerm(BundleImpl b, Class<A> type) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new AdaptPermission(type.getName(), b, "adapt"));
        }
    }

    @Override
    BundleResourceStream callGetBundleResourceStream(final BundleArchive archive, final String name, final int ix) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleResourceStream>(){

            @Override
            public BundleResourceStream run() {
                return archive.getBundleResourceStream(name, ix);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    Enumeration<String> callFindResourcesPath(final BundleArchive archive, final String path) {
        return AccessController.doPrivileged(new PrivilegedAction<Enumeration<String>>(){

            @Override
            public Enumeration<String> run() {
                return archive.findResourcesPath(path);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    Object callSearchFor(final BundleClassLoader cl, final String name, final String pkg, final String path, final BundleClassLoader.SearchAction action, final int options, final BundleClassLoader requestor, final HashSet<BundleClassLoader> visited) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return cl.searchFor(name, pkg, path, action, options, requestor, visited);
            }
        });
    }

    @Override
    String callFindLibrary0(final BundleClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return cl.findLibrary0(name);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    void callFinalizeActivation(final BundleImpl b) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws BundleException {
                    b.finalizeActivation();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    @Override
    BundleThread createBundleThread(final FrameworkContext fc) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleThread>(){

            @Override
            public BundleThread run() {
                return new BundleThread(fc);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    void callUpdate0(final BundleImpl b, final InputStream in, final boolean wasActive) throws BundleException {
        try {
            final AccessControlContext acc = AccessController.getContext();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws BundleException {
                    b.update0(in, wasActive, acc);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    @Override
    void callUninstall0(final BundleImpl b) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                b.uninstall0();
                return null;
            }
        });
    }

    @Override
    void callSetAutostartSetting(final BundleImpl b, final int settings) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                b.setAutostartSetting0(settings);
                return null;
            }
        });
    }

    @Override
    HeaderDictionary callGetHeaders0(final BundleGeneration bg, final String locale) {
        return AccessController.doPrivileged(new PrivilegedAction<HeaderDictionary>(){

            @Override
            public HeaderDictionary run() {
                return bg.getHeaders0(locale);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    Vector<URL> callFindEntries(final BundleGeneration bg, final String path, final String filePattern, final boolean recurse) {
        return AccessController.doPrivileged(new PrivilegedAction<Vector<URL>>(){

            @Override
            public Vector<URL> run() {
                return bg.findEntries(path, filePattern, recurse);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    BundleClassLoader newBundleClassLoader(final BundleGeneration bg) throws BundleException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<BundleClassLoader>(){

                @Override
                public BundleClassLoader run() throws Exception {
                    return new BundleClassLoader(bg);
                }

                @Override
                public /* synthetic */ Object run() throws Exception {
                    return this.run();
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (BundleException)pe.getException();
        }
    }

    Vector<URL> getBundleClassPathEntry(final BundleGeneration bg, final String name, final boolean onlyFirst) {
        return AccessController.doPrivileged(new PrivilegedAction<Vector<URL>>(){

            @Override
            public Vector<URL> run() {
                return bg.getBundleClassPathEntries(name, onlyFirst);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    AccessControlContext getAccessControlContext(BundleImpl bundle) {
        ProtectionDomain pd = bundle.current().getProtectionDomain();
        return pd != null ? new AccessControlContext(new ProtectionDomain[]{pd}) : null;
    }

    @Override
    BundleImpl callInstall0(final Bundles bs, final String location, final InputStream in, final Bundle caller) throws BundleException {
        try {
            final AccessControlContext acc = AccessController.getContext();
            return AccessController.doPrivileged(new PrivilegedExceptionAction<BundleImpl>(){

                @Override
                public BundleImpl run() throws BundleException {
                    return bs.install0(location, in, acc, caller);
                }

                @Override
                public /* synthetic */ Object run() throws Exception {
                    return this.run();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    @Override
    void callBundleChanged(final FrameworkContext fwCtx, final BundleEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                fwCtx.listeners.bundleChanged(evt);
                return null;
            }
        });
    }

    @Override
    void callServiceChanged(final FrameworkContext fwCtx, final Collection<ServiceListenerEntry> receivers, final ServiceEvent evt, final Set<ServiceListenerEntry> matchBefore) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                fwCtx.listeners.serviceChanged(receivers, evt, matchBefore);
                return null;
            }
        });
    }

    @Override
    void callRefreshPackages0(final PackageAdminImpl pa, final Bundle[] bundles, final FrameworkListener[] fl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                pa.refreshPackages0(bundles, fl);
                return null;
            }
        });
    }

    @Override
    <S> S callGetService(final ServiceRegistrationImpl<S> sr, final Bundle b) {
        return (S)AccessController.doPrivileged(new PrivilegedAction<S>(){

            @Override
            public S run() {
                ServiceFactory srf = (ServiceFactory)sr.service;
                return srf.getService(b, sr);
            }
        });
    }

    @Override
    <S> void callUngetService(final ServiceRegistrationImpl<S> sr, final Bundle b, final S instance) {
        final ServiceFactory srf = (ServiceFactory)sr.service;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                srf.ungetService(b, sr, instance);
                return null;
            }
        });
    }

    @Override
    void callSetStartLevel(final BundleImpl b, final int startlevel) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                b.setStartLevel(startlevel);
                return null;
            }
        });
    }

    @Override
    void callSetInitialBundleStartLevel0(final StartLevelController slc, final int startlevel) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                slc.setInitialBundleStartLevel0(startlevel, true);
                return null;
            }
        });
    }

    @Override
    void callShutdown(final SystemBundle sb, final boolean restart) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sb.shutdown(restart);
                return null;
            }
        });
    }

    @Override
    ProtectionDomain getProtectionDomain(BundleGeneration bg) {
        try {
            Certificate[] cca;
            String h = Long.toString(bg.bundle.id);
            if (bg.generation != 0) {
                h = ((Object)new StringBuffer().append(h).append(".").append(Long.toString(bg.generation))).toString();
            }
            URLStreamHandler ush = bg.bundle.fwCtx.urlStreamHandlerFactory.createURLStreamHandler("bundle");
            URL bundleUrl = new URL("bundle", h, -1, "", ush);
            BundleResourceStream pis = bg.archive.getBundleResourceStream("OSGI-INF/permissions.perm", 0);
            PermissionCollection pc = this.ph.createPermissionCollection(bg.bundle.location, bg.bundle, pis);
            ArrayList<List<X509Certificate>> cc = bg.archive.getCertificateChains(false);
            if (cc != null) {
                ArrayList<X509Certificate> tmp = new ArrayList<X509Certificate>();
                for (List<X509Certificate> list : cc) {
                    tmp.addAll(list);
                }
                cca = tmp.toArray(new Certificate[tmp.size()]);
            } else {
                cca = null;
            }
            return new ProtectionDomain(new CodeSource(bundleUrl, cca), pc);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    URL getBundleURL(final FrameworkContext fwCtx, final String s) throws MalformedURLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(null, s, fwCtx.urlStreamHandlerFactory.createURLStreamHandler("bundle"));
                }

                @Override
                public /* synthetic */ Object run() throws Exception {
                    return this.run();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getException();
        }
    }

    @Override
    ClassLoader getClassLoaderOf(final Class<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    @Override
    void purge(BundleImpl b, ProtectionDomain pd) {
        if (this.ph.purgePermissionCollection(new Long(b.id), pd.getPermissions())) {
            this.adminPerms.remove(b);
        }
    }

    AdminPermission getAdminPermission(Bundle b, int ti) {
        AdminPermission[] res = this.adminPerms.get(b);
        if (res != null) {
            if (res[ti] != null) {
                return res[ti];
            }
        } else {
            res = new AdminPermission[9];
            this.adminPerms.put(b, res);
        }
        res[ti] = new AdminPermission(b, AP_TO_STRING[ti]);
        return res[ti];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

