/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleNameVersionCapability;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.Capabilities;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequireBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Resolver {
    static final String RESOLVER_HOOK_VETO = "ResolverHook Veto";
    final FrameworkContext framework;
    private final Hashtable<String, Pkg> packages = new Hashtable();
    private final Capabilities capabilities = new Capabilities();
    private volatile HashSet<BundleGeneration> tempResolved = null;
    private HashMap<String, ExportPkg> tempProvider = null;
    private HashMap<RequireBundle, BundlePackages> tempRequired = null;
    private HashSet<ExportPkg> tempBlackList = null;
    private HashSet<BundlePackages> tempBackTracked = null;
    private ArrayList<BundleWireImpl> tempWires = null;
    private ExportPkg tempCollision;
    private Object resolveThread;
    int tempBlackListChecks = 0;
    int tempBlackListHits = 0;

    Resolver(FrameworkContext fw) {
        this.framework = fw;
    }

    void clear() {
        this.packages.clear();
        if (null != this.tempResolved) {
            this.tempResolved.clear();
        }
        if (null != this.tempProvider) {
            this.tempProvider.clear();
        }
        if (null != this.tempRequired) {
            this.tempRequired.clear();
        }
        if (null != this.tempBlackList) {
            this.tempBlackList.clear();
        }
        if (null != this.tempBackTracked) {
            this.tempBackTracked.clear();
        }
        if (null != this.tempWires) {
            this.tempWires.clear();
        }
    }

    synchronized void registerCapabilities(Map<String, List<BundleCapabilityImpl>> capabilities, Iterator<ExportPkg> exports, Iterator<ImportPkg> imports) {
        Pkg p;
        Comparable<ExportPkg> pe;
        this.capabilities.addCapabilities(capabilities);
        while (exports.hasNext()) {
            pe = exports.next();
            p = this.packages.get(pe.name);
            if (p == null) {
                p = new Pkg(pe.name);
                this.packages.put(pe.name, p);
            }
            p.addExporter((ExportPkg)pe);
            if (!this.framework.debug.resolver) continue;
            this.framework.debug.println(((Object)new StringBuffer().append("registerPackages: export, ").append(pe)).toString());
        }
        while (imports.hasNext()) {
            pe = imports.next();
            p = this.packages.get(((ImportPkg)pe).name);
            if (p == null) {
                p = new Pkg(((ImportPkg)pe).name);
                this.packages.put(((ImportPkg)pe).name, p);
            }
            p.addImporter((ImportPkg)pe);
            if (!this.framework.debug.resolver) continue;
            this.framework.debug.println(((Object)new StringBuffer().append("registerPackages: import, ").append(pe)).toString());
        }
    }

    synchronized ExportPkg registerDynamicImport(ImportPkg ip) throws BundleException {
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("registerDynamicImport: try ").append(ip)).toString());
        }
        ExportPkg res = null;
        Pkg p = this.packages.get(ip.name);
        if (p != null) {
            while (this.tempResolved != null) {
                this.checkThread();
                try {
                    this.wait();
                }
                catch (InterruptedException _ignore) {}
            }
            this.resolveThread = Thread.currentThread();
            this.tempResolved = new HashSet();
            this.tempProvider = new HashMap();
            this.tempRequired = new HashMap();
            this.tempBlackList = new HashSet();
            this.tempBackTracked = new HashSet();
            this.backTrackUses(ip);
            this.tempBackTracked = null;
            List<ImportPkg> pkgs = Collections.singletonList(ip);
            p.addImporter(ip);
            try {
                if (this.resolvePackages(pkgs.iterator(), null)) {
                    this.registerNewProviders(ip.bpkgs.bg.bundle);
                    ip.provider = res = this.tempProvider.get(ip.name);
                } else {
                    p.removeImporter(ip);
                }
            }
            catch (BundleException be) {
                p.removeImporter(ip);
                throw be;
            }
            finally {
                this.tempBlackList = null;
                this.tempProvider = null;
                this.tempRequired = null;
                this.tempResolved = null;
                this.resolveThread = null;
                this.notifyAll();
            }
        }
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("registerDynamicImport: Done for ").append(ip.name).append(", res = ").append(res)).toString());
        }
        return res;
    }

    synchronized boolean unregisterCapabilities(Map<String, List<BundleCapabilityImpl>> capabilities, Iterator<ExportPkg> exports, Iterator<ImportPkg> imports, boolean force) {
        Pkg p;
        if (!force) {
            ArrayList<ExportPkg> saved = new ArrayList<ExportPkg>();
            Iterator<ExportPkg> i = exports;
            while (i.hasNext()) {
                ExportPkg ep = i.next();
                saved.add(ep);
                if (ep.bpkgs.isRequired()) {
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("unregisterPackages: Failed to unregister, ").append(ep).append(" is still in use via Require-Bundle.")).toString());
                    }
                    this.markAsZombies(saved, exports);
                    return false;
                }
                Pkg p2 = ep.pkg;
                if (!p2.providers.contains(ep)) continue;
                Iterator<ImportPkg> i$ = p2.importers.iterator();
                while (i$.hasNext()) {
                    ImportPkg element;
                    ImportPkg ip = element = i$.next();
                    if (ep != ip.provider || ep.bpkgs == ip.bpkgs) continue;
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("unregisterPackages: Failed to unregister, ").append(ep).append(" is still in use via import-package.")).toString());
                    }
                    this.markAsZombies(saved, exports);
                    return false;
                }
            }
            exports = saved.iterator();
            for (List<BundleCapabilityImpl> lbc : capabilities.values()) {
                for (BundleCapabilityImpl bc : lbc) {
                    if (!bc.isWired()) continue;
                    return false;
                }
            }
        }
        while (exports.hasNext()) {
            ExportPkg ep = exports.next();
            p = ep.pkg;
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("unregisterPackages: unregister export - ").append(ep)).toString());
            }
            p.removeExporter(ep);
            if (!p.isEmpty()) continue;
            this.packages.remove(ep.name);
        }
        while (imports.hasNext()) {
            ImportPkg ip = imports.next();
            p = ip.pkg;
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("unregisterPackages: unregister import - ").append(ip.pkgString())).toString());
            }
            p.removeImporter(ip);
            if (!p.isEmpty()) continue;
            this.packages.remove(ip.name);
        }
        this.capabilities.removeCapabilities(capabilities);
        for (List<BundleCapabilityImpl> lbc : capabilities.values()) {
            for (BundleCapabilityImpl bc : lbc) {
                bc.removeWires();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String resolve(BundleGeneration bg, BundlePackages importBpkgs, BundleImpl[] triggers) throws BundleException {
        BundleGeneration sbg;
        String res = null;
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("resolve: ").append(bg)).toString());
        }
        if (this.tempResolved != null) {
            if (this.tempResolved.remove(bg)) {
                return null;
            }
            this.checkThread();
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException _ignore) {
                    // empty catch block
                }
            } while (this.tempResolved != null);
        }
        this.resolveThread = Thread.currentThread();
        this.tempResolved = new HashSet();
        try {
            if (!this.addTempResolved(bg)) {
                res = RESOLVER_HOOK_VETO;
            }
        }
        catch (BundleException be) {
            this.tempResolved = null;
            this.resolveThread = null;
            this.notifyAll();
            throw be;
        }
        if (res == null && (sbg = this.checkBundleSingleton(bg)) != null) {
            res = ((Object)new StringBuffer().append("Singleton bundle failed to resolve because ").append(sbg.bundle).append(" is already resolved")).toString();
        }
        if (res != null) {
            this.tempResolved = null;
            this.resolveThread = null;
            this.notifyAll();
            return res;
        }
        HashSet<ExportPkg> baseTempBlackList = new HashSet<ExportPkg>();
        this.tempBlackList = new HashSet();
        this.tempProvider = new HashMap();
        this.tempRequired = new HashMap();
        this.tempWires = new ArrayList();
        try {
            while (true) {
                this.tempCollision = null;
                res = this.checkBundleRequirements(bg);
                if (res == null && (res = this.checkRequireBundle(bg)) == null) {
                    StringBuffer failReason = new StringBuffer("Missing package(s) or can not resolve all of the them:");
                    if (this.resolvePackages(importBpkgs.getImports(), failReason)) {
                        if (triggers != null && triggers.length == 1) {
                            this.framework.resolverHooks.endResolve(triggers);
                        }
                        this.registerNewWires();
                        this.registerNewProviders(bg.bundle);
                        res = null;
                    } else {
                        res = ((Object)failReason).toString();
                    }
                }
                if (res != null && this.tempCollision != null) {
                    baseTempBlackList.add(this.tempCollision);
                    this.tempResolved.clear();
                    this.tempResolved.add(bg);
                    this.tempBlackList.clear();
                    this.tempBlackList.addAll(baseTempBlackList);
                    this.tempProvider.clear();
                    this.tempRequired.clear();
                    this.tempWires.clear();
                    continue;
                }
                break;
            }
        }
        finally {
            this.tempResolved = null;
            this.tempProvider = null;
            this.tempRequired = null;
            this.tempBlackList = null;
            this.tempWires = null;
            this.resolveThread = null;
            this.notifyAll();
        }
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("resolve: Done for ").append(bg)).toString());
        }
        return res;
    }

    private boolean addTempResolved(BundleGeneration bg) throws BundleException {
        if (this.framework.resolverHooks.filterResolvable(bg)) {
            this.tempResolved.add(bg);
            return true;
        }
        return false;
    }

    Pkg getPkg(String pkg) {
        return this.packages.get(pkg);
    }

    synchronized TreeSet<Bundle> getZombieAffected(Bundle[] bundles) {
        TreeSet<Bundle> affected = new TreeSet<Bundle>(new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                int dif = ((BundleImpl)b1).getStartLevel() - ((BundleImpl)b2).getStartLevel();
                if (dif == 0) {
                    dif = (int)(b1.getBundleId() - b2.getBundleId());
                }
                return dif;
            }

            @Override
            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass());
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Bundle)x0, (Bundle)x1);
            }
        });
        if (bundles == null) {
            if (this.framework.debug.resolver) {
                this.framework.debug.println("getZombieAffected: check - null");
            }
            this.framework.bundles.getRemovalPendingBundles(affected);
            this.framework.bundles.getUnattachedBundles(affected);
        } else {
            for (Bundle bundle : bundles) {
                BundleImpl tmp = (BundleImpl)bundle;
                if (tmp == null) continue;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("getZombieAffected: check - ").append(bundle)).toString());
                }
                affected.add(tmp);
            }
        }
        this.closure(affected);
        return affected;
    }

    synchronized void closure(Set<Bundle> bundles) {
        ArrayList<Bundle> moreBundles = new ArrayList<Bundle>(bundles);
        for (int i = 0; i < moreBundles.size(); ++i) {
            BundleImpl b = (BundleImpl)moreBundles.get(i);
            Iterator<ExportPkg> j = b.getExports();
            while (j.hasNext()) {
                ExportPkg ep = j.next();
                if (ep.pkg != null && ep.pkg.providers.contains(ep)) {
                    for (ImportPkg ip : ep.getPackageImporters()) {
                        BundleImpl ib = ip.bpkgs.bg.bundle;
                        if (bundles.contains(ib)) continue;
                        moreBundles.add(ib);
                        if (this.framework.debug.resolver) {
                            this.framework.debug.println(((Object)new StringBuffer().append("closure: added importing bundle - ").append(ib)).toString());
                        }
                        bundles.add(ib);
                    }
                }
                Iterator<Object> i$ = ep.bpkgs.getRequiredBy().iterator();
                while (i$.hasNext()) {
                    BundlePackages element;
                    BundlePackages rbpkgs = element = i$.next();
                    BundleImpl rb = rbpkgs.bg.bundle;
                    if (bundles.contains(rb)) continue;
                    moreBundles.add(rb);
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("closure: added requiring bundle - ").append(rb)).toString());
                    }
                    bundles.add(rb);
                }
            }
            for (BundleGeneration bbg : b.generations) {
                List<BundleWireImpl> bwl = bbg.getCapabilityWires();
                if (bwl != null) {
                    for (BundleWireImpl bcw : bwl) {
                        BundleImpl bbr = bcw.getRequirerGeneration().bundle;
                        if (bundles.contains(bbr)) continue;
                        moreBundles.add(bbr);
                        if (this.framework.debug.resolver) {
                            this.framework.debug.println(((Object)new StringBuffer().append("closure: added wired bundle - ").append(bbr)).toString());
                        }
                        bundles.add(bbr);
                    }
                }
                if (bbg.isFragmentHost()) {
                    Vector fix = (Vector)bbg.fragments.clone();
                    for (BundleGeneration fbg : fix) {
                        if (bundles.contains(fbg.bundle)) continue;
                        moreBundles.add(fbg.bundle);
                        if (this.framework.debug.resolver) {
                            this.framework.debug.println(((Object)new StringBuffer().append("closure: added fragment bundle - ").append(fbg.bundle)).toString());
                        }
                        bundles.add(fbg.bundle);
                    }
                }
                if (!bbg.isFragment()) continue;
                Set<BundleImpl> hosts = bbg.getResolvedHosts();
                for (BundleImpl hb : hosts) {
                    if (bundles.contains(hb)) continue;
                    moreBundles.add(hb);
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("closure: added fragment host bundle - ").append(hb)).toString());
                    }
                    bundles.add(hb);
                }
            }
        }
    }

    private boolean backTrackUses(ImportPkg ip) {
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("backTrackUses: check - ").append(ip.pkgString())).toString());
        }
        if (this.tempBackTracked.contains(ip.bpkgs)) {
            return false;
        }
        this.tempBackTracked.add(ip.bpkgs);
        Iterator<ExportPkg> i = this.getPackagesProvidedBy(ip.bpkgs).iterator();
        if (i.hasNext()) {
            do {
                ExportPkg ep = i.next();
                boolean foundUses = false;
                Iterator<ImportPkg> i$ = ep.pkg.importers.iterator();
                while (i$.hasNext()) {
                    ImportPkg element;
                    ImportPkg iip = element = i$.next();
                    if (iip.provider != ep || !this.backTrackUses(iip)) continue;
                    foundUses = true;
                }
                if (foundUses) continue;
                this.checkUses(ep.uses, ep, ep.bpkgs);
            } while (i.hasNext());
            return true;
        }
        return false;
    }

    private void markAsZombies(List<ExportPkg> e1, Iterator<ExportPkg> e2) {
        for (ExportPkg exportPkg : e1) {
            exportPkg.zombie = true;
        }
        while (e2.hasNext()) {
            e2.next().zombie = true;
        }
    }

    private Collection<ExportPkg> getPackagesProvidedBy(BundlePackages bpkgs) {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>();
        Iterator<ExportPkg> i = bpkgs.getExports();
        while (i.hasNext()) {
            ExportPkg ep = i.next();
            if (!ep.pkg.providers.contains(ep)) continue;
            res.add(ep);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean resolvePackages(Iterator<ImportPkg> pkgs, StringBuffer failReason) throws BundleException {
        StringBuffer pkgFail = failReason != null ? new StringBuffer() : null;
        boolean res = true;
        this.tempCollision = null;
        while (pkgs.hasNext()) {
            ExportPkg provider = null;
            ImportPkg ip = pkgs.next();
            if (ip.provider != null) {
                this.framework.frameworkError(ip.bpkgs.bg.bundle, (Throwable)new Exception("resolvePackages: InternalError1!"), new FrameworkListener[0]);
            }
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("resolvePackages: check - ").append(ip.pkgString())).toString());
            }
            LinkedList<ExportPkg> possibleProvider = new LinkedList<ExportPkg>();
            for (ExportPkg ep : ip.pkg.exporters) {
                if (ip.checkAttributes(ep)) {
                    if (ip.bpkgs == ep.bpkgs || ip.checkPermission(ep)) {
                        possibleProvider.add(ep);
                        continue;
                    }
                    if (pkgFail == null) continue;
                    this.newFailReason(pkgFail, "No import permission", ep);
                    continue;
                }
                if (pkgFail == null) continue;
                this.newFailReason(pkgFail, "Attributes don't match", ep);
            }
            if (pkgFail != null && possibleProvider.isEmpty() && pkgFail.length() == 0) {
                pkgFail.append("No providers found.");
            }
            this.framework.resolverHooks.filterMatches((BundleRequirement)ip, possibleProvider);
            if (pkgFail != null && pkgFail.length() == 0 && possibleProvider.isEmpty()) {
                pkgFail.append("Resolver hooks filtered all possible providers");
            }
            if ((provider = this.tempProvider.get(ip.name)) != null) {
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("resolvePackages: ").append(ip.name).append(" - has temporary provider - ").append(provider)).toString());
                }
                if (!possibleProvider.contains(provider)) {
                    String r = ((Object)new StringBuffer().append("provider not used, rejected by constraints or resolver hooks - ").append(provider)).toString();
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("resolvePackages: ").append(ip.name).append(" - ").append(r)).toString());
                    }
                    if (!possibleProvider.isEmpty()) {
                        this.tempCollision = provider;
                        return false;
                    }
                    provider = null;
                }
            } else {
                for (ExportPkg ep : ip.pkg.providers) {
                    if (!possibleProvider.contains(ep)) continue;
                    if (this.tempBlackList.contains(ep)) {
                        possibleProvider.remove(ep);
                        ++this.tempBlackListHits;
                        if (pkgFail == null) continue;
                        this.newFailReason(pkgFail, "Collied with previous selection", ep);
                        continue;
                    }
                    if (ep.zombie) continue;
                    HashMap<String, ExportPkg> oldTempProvider = this.tempProviderClone();
                    if (this.checkUses(ep.uses, ep, ep.bpkgs)) {
                        provider = ep;
                        break;
                    }
                    this.tempProvider = oldTempProvider;
                    this.tempBlackList.add(ep);
                    possibleProvider.remove(ep);
                    if (pkgFail == null) continue;
                    this.newFailReason(pkgFail, "Provider rejected because of uses directive ", ep);
                }
                if (provider == null) {
                    provider = this.pickProvider(ip, possibleProvider, pkgFail);
                }
                if (provider != null) {
                    this.tempProvider.put(ip.pkg.pkg, provider);
                }
            }
            if (provider == null) {
                if (ip.mustBeResolved()) {
                    res = false;
                    if (failReason != null) {
                        failReason.append(FWProps.NL);
                        failReason.append(ip.pkgString());
                        failReason.append(" -- ");
                        failReason.append(pkgFail);
                    }
                } else if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("resolvePackages: Ok, no provider for optional ").append(ip.name)).toString());
                }
            }
            if (pkgFail == null) continue;
            pkgFail.setLength(0);
        }
        return res;
    }

    private HashMap<String, ExportPkg> tempProviderClone() {
        return (HashMap)this.tempProvider.clone();
    }

    private ExportPkg pickProvider(ImportPkg ip, List<ExportPkg> possibleProvider, StringBuffer failReason) throws BundleException {
        HashMap<String, ExportPkg> oldTempProvider;
        ExportPkg ep;
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: for - ").append(ip)).toString());
        }
        boolean zombieExists = false;
        Iterator<ExportPkg> i = possibleProvider.iterator();
        while (i.hasNext()) {
            ep = i.next();
            ++this.tempBlackListChecks;
            if (this.tempBlackList.contains(ep)) {
                ++this.tempBlackListHits;
                i.remove();
                if (failReason == null) continue;
                this.newFailReason(failReason, "Collied with previous selection", ep);
                continue;
            }
            if (ip.bpkgs == ep.bpkgs) {
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: internal wire ok for - ").append(ep)).toString());
                }
                ip.internalOk = ep;
            } else if (!ep.checkPermission()) {
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: no export permission for - ").append(ep)).toString());
                }
                i.remove();
                if (failReason == null) continue;
                this.newFailReason(failReason, "No export permission for", ep);
                continue;
            }
            if (ep.bpkgs.bg.bundle.state != 2) {
                oldTempProvider = this.tempProviderClone();
                if (this.checkUses(ep.uses, ep, ep.bpkgs)) {
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: ").append(ip).append(" - got resolved provider - ").append(ep)).toString());
                    }
                    return ep;
                }
                this.tempProvider = oldTempProvider;
                this.tempBlackList.add(ep);
                i.remove();
                if (failReason == null) continue;
                this.newFailReason(failReason, "Uses directive block", ep);
                continue;
            }
            if (!ep.zombie) continue;
            zombieExists = true;
        }
        if (zombieExists) {
            Iterator<ExportPkg> iep = possibleProvider.iterator();
            while (iep.hasNext()) {
                ep = iep.next();
                if (this.tempResolved.contains(ep.bpkgs.bg)) {
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: ").append(ip).append(" - got temp provider - ").append(ep)).toString());
                    }
                    return ep;
                }
                if (!ep.zombie) continue;
                oldTempProvider = this.tempProviderClone();
                if (this.checkUses(ep.uses, ep, ep.bpkgs)) {
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: ").append(ip).append(" - got zombie provider - ").append(ep)).toString());
                    }
                    return ep;
                }
                this.tempProvider = oldTempProvider;
                this.tempBlackList.add(ep);
                if (failReason != null) {
                    this.newFailReason(failReason, "Uses directive block", ep);
                }
                iep.remove();
            }
        }
        ExportPkg savedCollision = null;
        for (ExportPkg ep2 : possibleProvider) {
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: check possible provider - ").append(ep2)).toString());
            }
            if (this.checkResolve(ep2.bpkgs.bg, ep2)) {
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: ").append(ip).append(" - got provider - ").append(ep2)).toString());
                }
                return ep2;
            }
            if (this.tempCollision != null && savedCollision == null) {
                savedCollision = this.tempCollision;
            }
            if (failReason == null) continue;
            this.newFailReason(failReason, "Could not resolve exporting bundle", ep2);
        }
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("pickProvider: ").append(ip).append(" - found no provider")).toString());
        }
        if (savedCollision != null) {
            this.tempCollision = savedCollision;
        }
        return null;
    }

    private void newFailReason(StringBuffer failReason, String string, ExportPkg ep) {
        if (failReason.length() > 0) {
            failReason.append(" || ");
        }
        failReason.append(string);
        if (ep != null) {
            failReason.append(" - ");
            failReason.append(ep);
        }
        failReason.append(".");
    }

    private boolean checkResolve(BundleGeneration bg, ExportPkg ep) throws BundleException {
        if (this.tempResolved.contains(bg)) {
            return true;
        }
        if (this.checkBundleSingleton(bg) == null) {
            boolean retry;
            HashSet<ExportPkg> collisions = new HashSet<ExportPkg>();
            do {
                String breq;
                retry = false;
                HashSet oldTempResolved = (HashSet)this.tempResolved.clone();
                if (!this.addTempResolved(bg)) {
                    return false;
                }
                HashMap<String, ExportPkg> oldTempProvider = this.tempProviderClone();
                HashMap oldTempRequired = (HashMap)this.tempRequired.clone();
                HashSet oldTempBlackList = (HashSet)this.tempBlackList.clone();
                this.tempBlackList.addAll(collisions);
                int oldTempWiresSize = this.tempWires.size();
                if (ep != null) {
                    this.tempProvider.put(ep.pkg.pkg, ep);
                }
                if ((breq = this.checkBundleRequirements(bg)) == null && this.checkRequireBundle(bg) == null) {
                    if (this.resolvePackages(bg.bpkgs.getImports(), null)) {
                        return true;
                    }
                    if (this.tempCollision != null && !oldTempProvider.containsValue(this.tempCollision)) {
                        collisions.add(this.tempCollision);
                        retry = true;
                        this.tempCollision = null;
                    }
                }
                this.tempResolved = oldTempResolved;
                this.tempProvider = oldTempProvider;
                this.tempRequired = oldTempRequired;
                this.tempBlackList = oldTempBlackList;
                this.tempWires.subList(oldTempWiresSize, this.tempWires.size()).clear();
            } while (retry);
        }
        return false;
    }

    private boolean checkUses(Set<String> uses, BundleCapability bc, BundlePackages bpkgs) {
        Iterator<ImportPkg> i;
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("checkUses: check if packages used by ").append(bc).append(" is okay.")).toString());
        }
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("checkUses: provider with bpkgs=").append(bpkgs)).toString());
        }
        if ((i = bpkgs.getActiveImports()) != null) {
            ArrayList<ExportPkg> checkList = new ArrayList<ExportPkg>();
            while (i.hasNext()) {
                ImportPkg ip = i.next();
                if (uses != null && !uses.contains(ip.pkg.pkg)) continue;
                ExportPkg ep = this.tempProvider.get(ip.pkg.pkg);
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkUses: check import, ").append(ip).append(" with provider, ").append(ip.provider)).toString());
                }
                if (ep == null) {
                    this.tempProvider.put(ip.pkg.pkg, ip.provider);
                    checkList.add(ip.provider);
                    continue;
                }
                if (ep == ip.provider) continue;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkUses: mismatch in providers for, ").append(ip.pkg.pkg)).toString());
                }
                return false;
            }
            for (ExportPkg exportPkg : checkList) {
                if (this.checkUses(exportPkg.uses, exportPkg, exportPkg.bpkgs)) continue;
                return false;
            }
        }
        if (this.framework.debug.resolver) {
            this.framework.debug.println(((Object)new StringBuffer().append("checkUses: ").append(bc).append(" is okay.")).toString());
        }
        return true;
    }

    private BundleGeneration checkBundleSingleton(BundleGeneration bg) throws BundleException {
        block10: {
            List<BundleGeneration> bl;
            block11: {
                if (bg.symbolicName == null || !bg.singleton) break block10;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkBundleSingleton: check singleton bundle ").append(bg)).toString());
                }
                if ((bl = this.framework.bundles.getBundleGenerations(bg.symbolicName)).size() <= 1) break block10;
                if (!this.framework.resolverHooks.hasHooks()) break block11;
                BundleNameVersionCapability bc = bg.getBundleCapability();
                LinkedList<BundleCapability> candidates = new LinkedList<BundleCapability>();
                ArrayList<BundleNameVersionCapability> active = new ArrayList<BundleNameVersionCapability>(bl.size());
                for (BundleGeneration bg2 : bl) {
                    BundleNameVersionCapability bc2;
                    if (!bg2.singleton || bg2 == bg || (bc2 = bg2.getBundleCapability()) == null) continue;
                    if (bg2.bpkgs.isActive()) {
                        active.add(bc2);
                        continue;
                    }
                    candidates.add(bc2);
                }
                if (!active.isEmpty()) {
                    for (BundleNameVersionCapability abc : active) {
                        LinkedList<BundleCapability> c = new LinkedList<BundleCapability>(candidates);
                        c.add(bc);
                        this.framework.resolverHooks.filterSingletonCollisions(abc, c);
                        if (c.contains(bc)) {
                            return abc.gen;
                        }
                        candidates.removeAll(c);
                    }
                }
                if (candidates.isEmpty()) break block10;
                this.framework.resolverHooks.filterSingletonCollisions(bc, candidates);
                for (BundleCapability bc2 : candidates) {
                    BundleGeneration bg2 = ((BundleRevisionImpl)bc2.getRevision()).gen;
                    if (!this.tempResolved.contains(bg2)) continue;
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("checkBundleSingleton: Reject because of bundle: ").append(bg2.bundle)).toString());
                    }
                    return bg2;
                }
                break block10;
            }
            for (BundleGeneration bg2 : bl) {
                if (bg == bg2 || !bg2.singleton || !bg2.bpkgs.isActive() && !this.tempResolved.contains(bg2)) continue;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkBundleSingleton: Reject because of bundle: ").append(bg2.bundle)).toString());
                }
                return bg2;
            }
        }
        return null;
    }

    private String checkBundleRequirements(BundleGeneration bg) throws BundleException {
        for (Map.Entry<String, List<BundleRequirementImpl>> e : bg.getOtherRequirements().entrySet()) {
            String namespace = e.getKey();
            for (BundleRequirementImpl br : e.getValue()) {
                if (!br.shouldResolve()) continue;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkBundleRequirements: Check requirement: ").append(br)).toString());
                }
                boolean reqPerm = this.framework.perm.hasRequirePermission(br);
                List<BundleCapabilityImpl> bcs = this.capabilities.getCapabilities(namespace);
                BundleWireImpl found = null;
                if (bcs != null) {
                    BundleGeneration bcbg;
                    LinkedList<BundleCapabilityImpl> mbcs = new LinkedList<BundleCapabilityImpl>();
                    for (BundleCapabilityImpl bc : bcs) {
                        if (!br.matches(bc) || !bc.checkPermission() || !reqPerm && !this.framework.perm.hasRequirePermission(br, bc)) continue;
                        mbcs.add(bc);
                    }
                    if (this.framework.resolverHooks.hasHooks()) {
                        this.framework.resolverHooks.filterMatches((BundleRequirement)br, mbcs);
                    }
                    ArrayList<BundleCapabilityImpl> matches = new ArrayList<BundleCapabilityImpl>();
                    int n_active = 0;
                    for (BundleCapabilityImpl bc : mbcs) {
                        bcbg = bc.getBundleGeneration();
                        if (bcbg.isCurrent()) {
                            if (bcbg.bpkgs.isActive() || this.tempResolved.contains(bcbg)) {
                                matches.add(0, bc);
                                ++n_active;
                                if (!this.framework.debug.resolver) continue;
                                this.framework.debug.println(((Object)new StringBuffer().append("checkBundleRequirements: Found active capability: ").append(bc)).toString());
                                continue;
                            }
                            matches.add(n_active, bc);
                            if (!this.framework.debug.resolver) continue;
                            this.framework.debug.println(((Object)new StringBuffer().append("checkBundleRequirements: Found unresolved capability: ").append(bc)).toString());
                            continue;
                        }
                        matches.add(bc);
                        if (!this.framework.debug.resolver) continue;
                        this.framework.debug.println(((Object)new StringBuffer().append("checkBundleRequirements: Found zombie capability: ").append(bc)).toString());
                    }
                    for (BundleCapabilityImpl bc : matches) {
                        Set<String> uses;
                        bcbg = bc.getBundleGeneration();
                        if (!this.tempResolved.contains(bcbg) && (bcbg.bundle.state == 2 ? !this.checkResolve(bcbg, null) : (uses = bc.getUses()) != null && !this.checkUses(uses, bc, bc.getBundleGeneration().bpkgs))) continue;
                        found = new BundleWireImpl(bc, bcbg, br, bg);
                        break;
                    }
                }
                if (found != null) {
                    this.tempWires.add(found);
                    continue;
                }
                if (br.isOptional()) continue;
                return ((Object)new StringBuffer().append("Failed to satisfy: ").append(br)).toString();
            }
        }
        return null;
    }

    private String checkRequireBundle(BundleGeneration bg) throws BundleException {
        Iterator<RequireBundle> i = bg.bpkgs.getRequire();
        if (i.hasNext()) {
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("checkRequireBundle: check requiring bundle ").append(bg)).toString());
            }
            if (!this.framework.perm.okRequireBundlePerm(bg.bundle)) {
                return ((Object)new StringBuffer().append("No permission to require bundle: ").append(bg.symbolicName)).toString();
            }
            HashMap<RequireBundle, BundlePackages> res = new HashMap<RequireBundle, BundlePackages>();
            do {
                RequireBundle br = i.next();
                BundleGeneration ok = null;
                LinkedList<BundleNameVersionCapability> possibleProvider = new LinkedList<BundleNameVersionCapability>();
                for (BundleGeneration bg2 : this.framework.bundles.getBundles(br.name, br.bundleRange)) {
                    possibleProvider.add(new BundleNameVersionCapability(bg2, "osgi.wiring.bundle"));
                }
                this.framework.resolverHooks.filterMatches((BundleRequirement)br, possibleProvider);
                for (BundleNameVersionCapability bc : possibleProvider) {
                    BundleGeneration bg2 = bc.gen;
                    if (!bg2.bsnAttrMatch(br.attributes)) continue;
                    if (this.tempResolved.contains(bg2)) {
                        ok = bg2;
                        break;
                    }
                    if (bg2.bpkgs.isActive()) {
                        HashMap<String, ExportPkg> oldTempProvider = this.tempProviderClone();
                        ok = bg2;
                        Iterator<ExportPkg> epi = bg2.bpkgs.getExports();
                        while (epi.hasNext()) {
                            ExportPkg ep = epi.next();
                            if (this.checkUses(ep.uses, ep, ep.bpkgs)) continue;
                            this.tempProvider = oldTempProvider;
                            this.tempBlackList.add(ep);
                            ok = null;
                            break;
                        }
                        if (ok == null) continue;
                        break;
                    }
                    if (bg2.bundle.state != 2 || !this.framework.perm.okProvideBundlePerm(bg2.bundle) || !this.checkResolve(bg2, null)) continue;
                    ok = bg2;
                    break;
                }
                if (ok != null) {
                    if (this.framework.debug.resolver) {
                        this.framework.debug.println(((Object)new StringBuffer().append("checkRequireBundle: added required bundle ").append(ok)).toString());
                    }
                    res.put(br, ok.bpkgs);
                    continue;
                }
                if (br.resolution != "mandatory") continue;
                if (this.framework.debug.resolver) {
                    this.framework.debug.println(((Object)new StringBuffer().append("checkRequireBundle: failed to satisfy: ").append(br.name)).toString());
                }
                return ((Object)new StringBuffer().append("Failed to resolve required bundle: ").append(br.name)).toString();
            } while (i.hasNext());
            this.tempRequired.putAll(res);
        }
        return null;
    }

    private void registerNewProviders(BundleImpl bundle) {
        ExportPkg ep;
        for (ExportPkg exportPkg : this.tempProvider.values()) {
            exportPkg.pkg.addProvider(exportPkg);
        }
        for (Map.Entry entry : this.tempRequired.entrySet()) {
            BundlePackages bpkgs = (BundlePackages)entry.getValue();
            RequireBundle br = (RequireBundle)entry.getKey();
            br.bpkgs = bpkgs;
            bpkgs.addRequiredBy(br.requestor);
            if (this.framework.debug.resolver) {
                this.framework.debug.println(((Object)new StringBuffer().append("registerNewProviders: 'Require-Bundle: ").append(br.name).append("' for ").append(br.requestor.bg.bundle.getBundleId()).append(" bound to (id=").append(bpkgs.bg.bundle.getBundleId()).append(",gen=").append(bpkgs.bg.generation).append(")")).toString());
            }
            if (br.visibility != "reexport") continue;
            Iterator<ExportPkg> be = bpkgs.getExports();
            while (be.hasNext()) {
                ep = be.next();
                br.requestor.checkReExport(ep);
                if (!this.framework.debug.resolver) continue;
                this.framework.debug.println(((Object)new StringBuffer().append("registerNewProviders: ").append(br.requestor.bg.bundle.getBundleId()).append(" reexports package ").append(ep.name)).toString());
            }
        }
        ArrayList<BundleImpl> resolve = new ArrayList<BundleImpl>(this.tempResolved.size());
        for (BundleGeneration bg : this.tempResolved) {
            if (bg.bpkgs.isActive()) continue;
            Iterator<ImportPkg> bi = bg.bpkgs.getImports();
            while (bi.hasNext()) {
                ImportPkg ip = bi.next();
                ep = this.tempProvider.get(ip.name);
                if (ep == null) {
                    if (ip.internalOk == null) continue;
                    if (ip.internalOk.pkg.providers.isEmpty() && ip.internalOk.checkPermission()) {
                        ip.internalOk.pkg.addProvider(ip.internalOk);
                        if (!this.framework.debug.resolver) continue;
                        this.framework.debug.println(((Object)new StringBuffer().append("registerNewProviders: exported internal wire, ").append(ip).append(" -> ").append(ip.internalOk)).toString());
                        continue;
                    }
                    if (!this.framework.debug.resolver) continue;
                    this.framework.debug.println(((Object)new StringBuffer().append("registerNewProviders: internal wire, ").append(ip).append(" -> ").append(ip.internalOk)).toString());
                    continue;
                }
                if (ip.checkAttributes(ep) && ip.checkPermission(ep)) {
                    ip.provider = ep;
                    continue;
                }
                if (ip.internalOk == null) continue;
                if (ip.internalOk == ep) {
                    if (!this.framework.debug.resolver) continue;
                    this.framework.debug.println(((Object)new StringBuffer().append("registerNewProviders: internal wire, ").append(ip).append(", ").append(ep)).toString());
                    continue;
                }
                this.framework.frameworkError(bg.bundle, (Throwable)new Exception(((Object)new StringBuffer().append("registerNewProviders: Warning! Internal wire for, ").append(ip).append(", does not match exported. ").append(ep)).toString()), new FrameworkListener[0]);
            }
            if (bg.bundle == bundle) continue;
            resolve.add(bg.bundle);
        }
        for (BundleImpl b : resolve) {
            if (b.getUpdatedState(null) != 2) continue;
            this.framework.frameworkError(b, (Throwable)new Exception("registerNewProviders: InternalError!"), new FrameworkListener[0]);
        }
    }

    private void registerNewWires() {
        for (BundleWireImpl bw : this.tempWires) {
            ((BundleRequirementImpl)bw.getRequirement()).setWire(bw);
        }
    }

    private void checkThread() throws BundleException {
        Thread t = Thread.currentThread();
        if (t.equals(this.resolveThread)) {
            throw new BundleException("Can not currently start new resolve during a resolve.");
        }
        for (BundleGeneration bg : this.tempResolved) {
            if (!bg.bundle.isBundleThread(t)) continue;
            throw new BundleException(((Object)new StringBuffer().append("Can not resolve a bundle inside current BundleListener.Will cause a dead-lock. BID=").append(bg.bundle.id)).toString());
        }
    }
}

