/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Enumeration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesDictionary
extends Dictionary<String, Object> {
    private final String[] keys;
    private final Object[] values;
    private int size;
    private int ocIndex = -1;
    private int sidIndex = -1;
    private static long nextServiceID = 1L;

    PropertiesDictionary(Dictionary in) {
        int max_size = in != null ? in.size() + 2 : 2;
        this.keys = new String[max_size];
        this.values = new Object[max_size];
        this.size = 0;
        if (in != null) {
            try {
                Enumeration e = in.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (this.ocIndex == -1 && key.equalsIgnoreCase("objectClass")) {
                        this.ocIndex = this.size;
                    } else if (this.sidIndex == -1 && key.equalsIgnoreCase("service.id")) {
                        this.sidIndex = this.size;
                    } else {
                        for (int i = this.size - 1; i >= 0; --i) {
                            if (!key.equalsIgnoreCase(this.keys[i])) continue;
                            throw new IllegalArgumentException(((Object)new StringBuffer().append("Several entries for property: ").append(key)).toString());
                        }
                    }
                    this.keys[this.size] = key;
                    this.values[this.size++] = in.get(key);
                }
            }
            catch (ClassCastException ignore) {
                throw new IllegalArgumentException("Properties contains key that is not of type java.lang.String");
            }
        }
    }

    PropertiesDictionary(Dictionary in, String[] classes, Long sid) {
        this(in);
        Long l;
        if (this.ocIndex == -1) {
            this.keys[this.size] = "objectClass";
            this.ocIndex = this.size++;
        }
        this.values[this.ocIndex] = classes;
        if (this.sidIndex == -1) {
            this.keys[this.size] = "service.id";
            this.sidIndex = this.size++;
        }
        if (sid != null) {
            l = sid;
        } else {
            long l2 = nextServiceID++;
            l = new Long(l2);
        }
        this.values[this.sidIndex] = l;
    }

    @Override
    public Object get(Object key) {
        if (key == "objectClass") {
            return this.ocIndex >= 0 ? this.values[this.ocIndex] : null;
        }
        if (key == "service.id") {
            return this.sidIndex >= 0 ? this.values[this.sidIndex] : null;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!((String)key).equalsIgnoreCase(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public String[] keyArray() {
        String[] nkeys = new String[this.size];
        System.arraycopy(this.keys, 0, nkeys, 0, this.size);
        return nkeys;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Enumeration<Object> elements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Enumeration<String> keys() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object put(String k, Object v) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object remove(Object k) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public /* synthetic */ Object put(Object x0, Object x1) {
        return this.put((String)x0, x1);
    }
}

