/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ExportedPackageImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequiredBundleImpl;
import org.knopflerfish.framework.Resolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.VersionRange;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAdminImpl
implements PackageAdmin {
    static final String SPEC_VERSION = "1.2";
    private final FrameworkContext fwCtx;
    private volatile Vector<Thread> refreshSync = new Vector(1);

    PackageAdminImpl(FrameworkContext fw) {
        this.fwCtx = fw;
    }

    @Override
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        int size;
        ArrayList<ExportedPackageImpl> pkgs = new ArrayList<ExportedPackageImpl>();
        if (bundle != null) {
            Iterator<ExportPkg> i = ((BundleImpl)bundle).getExports();
            while (i.hasNext()) {
                ExportPkg ep = i.next();
                if (!ep.isExported()) continue;
                pkgs.add(new ExportedPackageImpl(ep));
            }
        } else {
            for (BundleImpl b : this.fwCtx.bundles.getBundles()) {
                Iterator<ExportPkg> i = b.getExports();
                while (i.hasNext()) {
                    ExportPkg ep = i.next();
                    if (!ep.isExported()) continue;
                    pkgs.add(new ExportedPackageImpl(ep));
                }
            }
        }
        if ((size = pkgs.size()) > 0) {
            return pkgs.toArray(new ExportedPackage[size]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportedPackage[] getExportedPackages(String name) {
        Pkg pkg = this.fwCtx.resolver.getPkg(name);
        ExportedPackage[] res = null;
        if (pkg != null) {
            Pkg pkg2 = pkg;
            synchronized (pkg2) {
                int size = pkg.exporters.size();
                if (size > 0) {
                    res = new ExportedPackage[size];
                    Iterator<ExportPkg> i = pkg.exporters.iterator();
                    int pos = 0;
                    while (pos < size) {
                        res[pos++] = new ExportedPackageImpl(i.next());
                    }
                }
            }
        }
        return res;
    }

    @Override
    public ExportedPackage getExportedPackage(String name) {
        ExportPkg ep;
        Pkg p = this.fwCtx.resolver.getPkg(name);
        if (p != null && (ep = p.getBestProvider()) != null) {
            return new ExportedPackageImpl(ep);
        }
        return null;
    }

    @Override
    public void refreshPackages(Bundle[] bundles) {
        this.refreshPackages(bundles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages(final Bundle[] bundles, final FrameworkListener[] fl) {
        this.fwCtx.perm.checkResolveAdminPerm();
        boolean restart = false;
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                this.fwCtx.checkOurBundle(bundles[i]);
                if (!((BundleImpl)bundles[i]).extensionNeedsRestart()) continue;
                restart = true;
                break;
            }
        } else {
            restart = this.fwCtx.bundles.checkExtensionBundleRestart();
        }
        if (restart) {
            try {
                this.fwCtx.systemBundle.update();
            }
            catch (BundleException ignored) {
                // empty catch block
            }
            return;
        }
        final PackageAdminImpl thisClass = this;
        Vector<Thread> vector = this.refreshSync;
        synchronized (vector) {
            Thread t = new Thread(this.fwCtx.threadGroup, "RefreshPackages"){

                public void run() {
                    ((PackageAdminImpl)PackageAdminImpl.this).fwCtx.perm.callRefreshPackages0(thisClass, bundles, fl);
                }
            };
            t.setDaemon(false);
            this.refreshSync.add(t);
            t.start();
            try {
                this.refreshSync.wait(500L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages0(Bundle[] bundles, FrameworkListener[] fl) {
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() starting");
        }
        ArrayList<BundleImpl> startList = new ArrayList<BundleImpl>();
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            TreeSet<Bundle> zombies = this.fwCtx.resolver.getZombieAffected(bundles);
            BundleImpl[] bi = zombies.toArray(new BundleImpl[zombies.size()]);
            Vector<Thread> vector = this.refreshSync;
            synchronized (vector) {
                this.refreshSync.notifyAll();
            }
            int bx = bi.length;
            while (bx-- > 0) {
                if (bi[bx].state != 32 && bi[bx].state != 8) continue;
                startList.add(0, bi[bx]);
                try {
                    bi[bx].waitOnOperation(this.fwCtx.resolver, "PackageAdmin.refreshPackages", false);
                    Exception be = bi[bx].stop0();
                    if (be == null) continue;
                    this.fwCtx.frameworkError(bi[bx], (Throwable)be, new FrameworkListener[0]);
                }
                catch (BundleException ignore) {}
            }
            int startPos = startList.size() - 1;
            BundleImpl nextStart = startPos >= 0 ? (BundleImpl)startList.get(startPos) : null;
            int bx2 = bi.length;
            while (bx2-- > 0) {
                Exception be = null;
                switch (bi[bx2].state) {
                    case 8: 
                    case 32: {
                        while (true) {
                            try {
                                bi[bx2].waitOnOperation(this.fwCtx.resolver, "PackageAdmin.refreshPackages", true);
                            }
                            catch (BundleException we) {
                                if (this.fwCtx.debug.resolver) {
                                    this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() timeout on bundle stop, retry...");
                                }
                                this.fwCtx.frameworkWarning(bi[bx2], (Throwable)we, new FrameworkListener[0]);
                                continue;
                            }
                            break;
                        }
                        be = bi[bx2].stop0();
                        if (be != null) {
                            this.fwCtx.frameworkError(bi[bx2], (Throwable)be, new FrameworkListener[0]);
                        }
                        if (nextStart != bi[bx2]) {
                            startList.add(startPos + 1, bi[bx2]);
                        }
                    }
                    case 4: 
                    case 16: {
                        bi[bx2].setStateInstalled(true);
                        if (bi[bx2] != nextStart) break;
                        nextStart = --startPos >= 0 ? startList.get(startPos) : null;
                    }
                }
                bi[bx2].purge();
            }
        }
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() all affected bundles now in state INSTALLED");
        }
        this.startBundles(startList);
        FrameworkEvent fe = new FrameworkEvent(4, this.fwCtx.systemBundle, null);
        this.fwCtx.listeners.frameworkEvent(fe, fl);
        this.refreshSync.remove(Thread.currentThread());
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() done.");
        }
    }

    private void startBundles(List<BundleImpl> slist) {
        BundleImpl[] triggers = slist.toArray(new BundleImpl[slist.size()]);
        for (BundleImpl rb : slist) {
            rb.getUpdatedState(triggers);
        }
        try {
            this.fwCtx.resolverHooks.endResolve(triggers);
        }
        catch (BundleException be) {
            this.fwCtx.frameworkError(this.fwCtx.systemBundle, (Throwable)be, new FrameworkListener[0]);
        }
        for (BundleImpl rb : slist) {
            if (rb.getState() != 4) continue;
            try {
                rb.start();
            }
            catch (BundleException be) {
                this.fwCtx.frameworkError(rb, (Throwable)be, new FrameworkListener[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resolveBundles(Bundle[] bundles) {
        this.fwCtx.perm.checkResolveAdminPerm();
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            this.fwCtx.resolverHooks.checkResolveBlocked();
            ArrayList<BundleImpl> bl = new ArrayList<BundleImpl>();
            boolean res = true;
            if (bundles != null) {
                for (Bundle bundle : bundles) {
                    if (bundle.getState() == 2) {
                        bl.add((BundleImpl)bundle);
                        continue;
                    }
                    if (bundle.getState() != 1) continue;
                    res = false;
                }
            } else {
                for (BundleImpl bundle : this.fwCtx.bundles.getBundles()) {
                    if (bundle.getState() != 2) continue;
                    bl.add(bundle);
                }
            }
            if (!bl.isEmpty()) {
                BundleImpl[] triggers = bl.toArray(new BundleImpl[bl.size()]);
                for (BundleImpl bundle : bl) {
                    BundleImpl b = bundle;
                    if (b.getUpdatedState(triggers) != 2) continue;
                    res = false;
                }
                try {
                    this.fwCtx.resolverHooks.endResolve(triggers);
                }
                catch (BundleException be) {
                    this.fwCtx.frameworkError(this.fwCtx.systemBundle, (Throwable)be, new FrameworkListener[0]);
                }
            }
            return res;
        }
    }

    @Override
    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        List<BundleGeneration> bgs = this.fwCtx.bundles.getBundleGenerations(symbolicName);
        ArrayList<RequiredBundleImpl> res = new ArrayList<RequiredBundleImpl>();
        for (BundleGeneration bg : bgs) {
            if (!bg.bundle.isResolved() && bg.bundle.getRequiredBy().size() <= 0 || bg.isFragment()) continue;
            res.add(new RequiredBundleImpl(bg.bpkgs));
        }
        int s = res.size();
        if (s > 0) {
            return res.toArray(new RequiredBundle[s]);
        }
        return null;
    }

    @Override
    public Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange vr = versionRange != null ? new VersionRange(versionRange.trim()) : null;
        List<BundleGeneration> bgs = this.fwCtx.bundles.getBundles(symbolicName, vr);
        int size = bgs.size();
        if (size > 0) {
            Bundle[] res = new Bundle[size];
            Iterator<BundleGeneration> i = bgs.iterator();
            int pos = 0;
            while (pos < size) {
                res[pos++] = i.next().bundle;
            }
            return res;
        }
        return null;
    }

    @Override
    public Bundle[] getFragments(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleGeneration bg = ((BundleImpl)bundle).current();
        if (bg.isFragment()) {
            return null;
        }
        if (bg.isFragmentHost()) {
            Vector fix = (Vector)bg.fragments.clone();
            Bundle[] r = new Bundle[fix.size()];
            for (int i = fix.size() - 1; i >= 0; --i) {
                r[i] = ((BundleGeneration)fix.get((int)i)).bundle;
            }
            return r;
        }
        return null;
    }

    @Override
    public Bundle[] getHosts(Bundle bundle) {
        Vector<BundleGeneration> h;
        BundleImpl b = (BundleImpl)bundle;
        if (b != null && (h = b.getHosts(false)) != null) {
            Bundle[] r = new Bundle[h.size()];
            int pos = 0;
            for (BundleGeneration bg : h) {
                r[pos++] = bg.bundle;
            }
            return r;
        }
        return null;
    }

    @Override
    public Bundle getBundle(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleClassLoader)cl).getBundle();
        }
        return null;
    }

    @Override
    public int getBundleType(Bundle bundle) {
        BundleGeneration bg = ((BundleImpl)bundle).current();
        return bg.isFragment() && !bg.isExtension() ? 1 : 0;
    }
}

