/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPkg
implements BundleRequirement,
Comparable<ImportPkg> {
    static final String RESOLUTION_DYNAMIC = "dynamic";
    private static final String PACKAGE_SPECIFICATION_VERSION = "specification-version";
    private static int importPkgCount = 0;
    final int orderal = ++importPkgCount;
    final String name;
    final BundlePackages bpkgs;
    final String resolution;
    final String bundleSymbolicName;
    final VersionRange packageRange;
    final VersionRange bundleRange;
    final Map<String, Object> attributes;
    final Map<String, String> directives;
    final ImportPkg parent;
    Pkg pkg = null;
    ExportPkg provider = null;
    ExportPkg internalOk = null;
    int dynId = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ImportPkg(String name, Util.HeaderEntry he, BundlePackages b, boolean dynamic) {
        String rangeStr;
        this.bpkgs = b;
        this.name = name;
        if (name.startsWith("java.")) {
            throw new IllegalArgumentException("You can not import a java.* package");
        }
        Map<String, String> dirs = he.getDirectives();
        String res = dirs.get("resolution");
        if (dynamic) {
            if (res != null) {
                throw new IllegalArgumentException(((Object)new StringBuffer().append("Directives not supported for Dynamic-Import, found resolution:=").append(res)).toString());
            }
            this.resolution = RESOLUTION_DYNAMIC;
        } else if (res != null) {
            if ("optional".equals(res)) {
                this.resolution = "optional";
            } else {
                if (!"mandatory".equals(res)) throw new IllegalArgumentException(((Object)new StringBuffer().append("Directive resolution, unexpected value: ").append(res)).toString());
                this.resolution = "mandatory";
            }
        } else {
            this.resolution = "mandatory";
        }
        this.bundleSymbolicName = (String)he.getAttributes().remove("bundle-symbolic-name");
        String versionStr = (String)he.getAttributes().remove("version");
        String specVersionStr = (String)he.getAttributes().remove(PACKAGE_SPECIFICATION_VERSION);
        if (specVersionStr != null) {
            this.packageRange = new VersionRange(specVersionStr);
            if (versionStr != null && !this.packageRange.equals(new VersionRange(versionStr))) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but differs");
            }
        } else {
            this.packageRange = versionStr != null ? new VersionRange(versionStr) : null;
        }
        this.bundleRange = (rangeStr = (String)he.getAttributes().remove("bundle-version")) != null ? new VersionRange(rangeStr) : null;
        this.attributes = Collections.unmodifiableMap(he.getAttributes());
        Filter filter = this.toFilter();
        if (null != filter) {
            dirs.put("filter", ((Object)filter).toString());
        }
        this.directives = Collections.unmodifiableMap(dirs);
        this.parent = null;
    }

    ImportPkg(ImportPkg ip, String name) {
        this.name = name;
        this.bpkgs = ip.bpkgs;
        this.resolution = ip.resolution;
        this.bundleSymbolicName = ip.bundleSymbolicName;
        this.packageRange = ip.packageRange;
        this.bundleRange = ip.bundleRange;
        this.attributes = ip.attributes;
        this.directives = ip.directives;
        this.parent = ip;
    }

    ImportPkg(ImportPkg ip, BundlePackages bpkgs) {
        this.name = ip.name;
        this.bpkgs = bpkgs;
        this.resolution = ip.resolution;
        this.bundleSymbolicName = ip.bundleSymbolicName;
        this.packageRange = ip.packageRange;
        this.bundleRange = ip.bundleRange;
        this.attributes = ip.attributes;
        this.directives = ip.directives;
        this.parent = ip.parent;
    }

    ImportPkg(ExportPkg p) {
        this.name = p.name;
        this.bpkgs = p.bpkgs;
        this.resolution = "mandatory";
        this.bundleSymbolicName = null;
        this.packageRange = p.version == Version.emptyVersion ? null : new VersionRange(p.version.toString());
        this.bundleRange = null;
        this.attributes = p.attributes;
        HashMap<String, String> dirs = new HashMap<String, String>();
        Filter filter = this.toFilter();
        if (null != filter) {
            dirs.put("filter", ((Object)filter).toString());
        }
        this.directives = Collections.unmodifiableMap(dirs);
        this.parent = null;
    }

    void attachPkg(Pkg p) {
        this.pkg = p;
    }

    void detachPkg() {
        this.pkg = null;
        this.provider = null;
    }

    public boolean okPackageVersion(Version ver) {
        return this.packageRange == null || this.packageRange.includes(ver);
    }

    boolean checkAttributes(ExportPkg ep) {
        if (!this.checkMandatory(ep.mandatory)) {
            return false;
        }
        if (!this.okPackageVersion(ep.version) || this.bundleSymbolicName != null && !this.bundleSymbolicName.equals(ep.bpkgs.bg.symbolicName) || this.bundleRange != null && !this.bundleRange.includes(ep.bpkgs.bg.version)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            String a = (String)ep.attributes.get(entry.getKey());
            if (a != null && a.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    boolean checkPermission(ExportPkg ep) {
        return this.bpkgs.bg.bundle.fwCtx.perm.hasImportPackagePermission(this.bpkgs.bg.bundle, ep);
    }

    boolean mustBeResolved() {
        return this.resolution == "mandatory" && this.internalOk == null;
    }

    boolean intersect(ImportPkg ip) {
        if (ip.bundleSymbolicName != null && this.bundleSymbolicName != null && !ip.bundleSymbolicName.equals(this.bundleSymbolicName)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            String a = (String)ip.attributes.get(entry.getKey());
            if (a == null || a.equals(entry.getValue())) continue;
            return false;
        }
        if (this.packageRange != null && this.packageRange.intersection(new VersionRange[]{ip.packageRange}).isEmpty()) {
            return false;
        }
        return this.bundleRange == null || !this.bundleRange.intersection(new VersionRange[]{ip.bundleRange}).isEmpty();
    }

    public String pkgString() {
        if (this.packageRange != null) {
            return ((Object)new StringBuffer().append(this.name).append(";").append("version").append("=").append(this.packageRange)).toString();
        }
        return this.name;
    }

    public String toString() {
        return ((Object)new StringBuffer().append(this.pkgString()).append("(").append(this.bpkgs.bg.bundle).append(")")).toString();
    }

    boolean isDynamic() {
        return this.resolution == RESOLUTION_DYNAMIC;
    }

    private boolean checkMandatory(Collection<String> mandatory) {
        if (mandatory != null) {
            for (String a : mandatory) {
                if (!("version".equals(a) ? this.packageRange == null : ("bundle-symbolic-name".equals(a) ? this.bundleSymbolicName == null : ("bundle-version".equals(a) ? this.bundleRange == null : !this.attributes.containsKey(a))))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "osgi.wiring.package";
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    private Filter toFilter() {
        StringBuffer sb = new StringBuffer(80);
        boolean multipleConditions = false;
        sb.append('(');
        sb.append("osgi.wiring.package");
        sb.append('=');
        sb.append(this.name);
        if (this.name.length() == 0 || this.name.endsWith(".")) {
            sb.append('*');
        }
        sb.append(')');
        if (this.packageRange != null) {
            sb.append(this.packageRange.toFilterString("version"));
            multipleConditions = true;
        }
        if (this.bundleSymbolicName != null) {
            sb.append('(');
            sb.append("bundle-symbolic-name");
            sb.append('=');
            sb.append(this.bundleSymbolicName);
            sb.append(')');
            multipleConditions |= true;
        }
        if (this.bundleRange != null) {
            sb.append(this.bundleRange.toFilterString("bundle-version"));
            multipleConditions = true;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            sb.append('(');
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().toString());
            sb.append(')');
            multipleConditions |= true;
        }
        if (multipleConditions) {
            sb.insert(0, "(&");
            sb.append(')');
        }
        try {
            return FrameworkUtil.createFilter(((Object)sb).toString());
        }
        catch (InvalidSyntaxException _ise) {
            System.err.println(((Object)new StringBuffer().append("createFilter: '").append(((Object)sb).toString()).append("': ").append(_ise.getMessage())).toString());
            return null;
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map res = Collections.EMPTY_MAP;
        return res;
    }

    @Override
    public BundleRevision getRevision() {
        return this.bpkgs.bg.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.bpkgs.bg.bundleRevision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if ("osgi.wiring.package".equals(capability.getNamespace())) {
            return this.toFilter().matches(capability.getAttributes());
        }
        return false;
    }

    @Override
    public int compareTo(ImportPkg o) {
        return this.orderal - o.orderal;
    }

    @Override
    public /* synthetic */ Resource getResource() {
        return this.getResource();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((ImportPkg)x0);
    }
}

