/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassPath;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.WeavingHooks;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleClassLoader
extends ClassLoader
implements BundleReference {
    static final int ONLY_FIRST = 1;
    static final int LIST = 2;
    static final int ONLY_RECURSE = 4;
    static final int RECURSE = 256;
    static final int LOCAL = 512;
    final FrameworkContext fwCtx;
    final PermissionOps secure;
    final ProtectionDomain protectionDomain;
    BundleArchive archive;
    BundlePackages bpkgs;
    private final BundleClassPath classPath;
    private static ThreadLocal<ArrayList<BundleImpl>> tlBundlesToActivate = new ThreadLocal();
    private static Method dexFileClassLoadDexMethod;
    private static Method dexFileClassLoadClassMethod;
    static boolean bDalvik;
    private ArrayList<Object> dexFile = null;
    Debug debug;
    protected static SecurityManagerExposer smex;
    static final SearchAction classSearch;
    static final SearchAction resourceSearch;
    static final SearchAction listSearch;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$org$knopflerfish$framework$BundleClassLoader;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;

    BundleClassLoader(BundleGeneration gen) throws BundleException {
        super(gen.bundle.fwCtx.parentClassLoader);
        this.fwCtx = gen.bundle.fwCtx;
        this.debug = this.fwCtx.debug;
        this.secure = this.fwCtx.perm;
        this.protectionDomain = gen.getProtectionDomain();
        this.bpkgs = gen.bpkgs;
        this.archive = gen.archive;
        this.classPath = new BundleClassPath(this.archive, gen.fragments, this.fwCtx);
        this.fwCtx.bundleClassLoaderCreated(this);
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" Created new classloader")).toString());
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String pkg;
        String path;
        int pos;
        if (name.startsWith("java.")) {
            return this.fwCtx.parentClassLoader.loadClass(name);
        }
        if (this.fwCtx.isBootDelegated(name)) {
            try {
                Class<?> bootDelegationCls = this.fwCtx.parentClassLoader.loadClass(name);
                if (this.debug.classLoader && bootDelegationCls != null) {
                    this.debug.println(((Object)new StringBuffer().append(this).append(" findClass: ").append(name).append(" boot delegation: ").append(bootDelegationCls)).toString());
                }
                return bootDelegationCls;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((pos = name.lastIndexOf(46)) != -1) {
            path = name.replace('.', '/');
            pkg = name.substring(0, pos);
        } else {
            path = name;
            pkg = null;
        }
        Class<?> res = (Class<?>)this.secure.callSearchFor(this, name, pkg, ((Object)new StringBuffer().append(path).append(".class")).toString(), classSearch, 1, this, null);
        if (res != null) {
            return res;
        }
        if (!this.fwCtx.props.STRICTBOOTCLASSLOADING && this.isBootClassContext(name)) {
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" trying parent loader for class=").append(name).append(", since it was loaded on the system loader itself")).toString());
            }
            if ((res = this.fwCtx.parentClassLoader.loadClass(name)) != null && this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" loaded ").append(name).append(" from ").append(this.fwCtx.parentClassLoader)).toString());
            }
            return res;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected String findLibrary(String name) {
        String res = this.secure.callFindLibrary0(this, name);
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" Find library: ").append(name).append(res != null ? " OK" : " FAIL")).toString());
        }
        return res;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.getBundleResources(name, false);
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<URL> res = this.getBundleResources(name, true);
        if (res != null) {
            return res.nextElement();
        }
        return null;
    }

    private boolean isNonBundleClass(Class<?> cls) {
        return this.getClass().getClassLoader() != cls.getClassLoader() && !(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).isAssignableFrom(cls) && !(class$java$lang$Class == null ? (class$java$lang$Class = BundleClassLoader.class$("java.lang.Class")) : class$java$lang$Class).equals(cls) && !(class$java$lang$reflect$Proxy == null ? (class$java$lang$reflect$Proxy = BundleClassLoader.class$("java.lang.reflect.Proxy")) : class$java$lang$reflect$Proxy).equals(cls);
    }

    public boolean isBootClassContext(String name) {
        Class<?>[] classStack = smex.getClassContext();
        if (classStack == null) {
            try {
                StackTraceElement[] classNames = new Throwable().getStackTrace();
                classStack = new Class[classNames.length];
                for (int i = 1; i < classNames.length; ++i) {
                    classStack[i] = Class.forName(classNames[i].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        for (int i = 1; i < classStack.length; ++i) {
            ClassLoader currentCL;
            Class<?> currentCls = classStack[i];
            if (!this.isNonBundleClass(currentCls)) continue;
            ClassLoader cl = currentCL = currentCls.getClassLoader();
            while (cl != null && cl != cl.getClass().getClassLoader()) {
                if ((class$org$knopflerfish$framework$BundleClassLoader == null ? BundleClassLoader.class$("org.knopflerfish.framework.BundleClassLoader") : class$org$knopflerfish$framework$BundleClassLoader).isInstance(cl)) {
                    return false;
                }
                cl = cl.getClass().getClassLoader();
            }
            return !(class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleClassLoader.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).isInstance(classStack[i - 1]);
        }
        return false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        BundleImpl b;
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        } else if (this.secure.getClassLoaderOf(c) == this && (b = (BundleImpl)this.getBundle()).triggersActivationCls(name)) {
            ArrayList<BundleImpl> bundlesToActivate;
            if (this.debug.lazy_activation) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" lazy activation of #").append(b.id).append(" triggered by loadClass(").append(name).append(")")).toString());
            }
            if (null == (bundlesToActivate = tlBundlesToActivate.get())) {
                if (this.debug.lazy_activation) {
                    this.debug.println(((Object)new StringBuffer().append(this).append(" requesting lazy activation of #").append(b.id)).toString());
                }
                try {
                    this.secure.callFinalizeActivation(b);
                }
                catch (BundleException e) {
                    this.fwCtx.frameworkError(b, (Throwable)e, new FrameworkListener[0]);
                }
            } else {
                boolean bundlePresent = false;
                int size = bundlesToActivate.size();
                for (int i = 0; i < size; ++i) {
                    BundleImpl tmp = bundlesToActivate.get(i);
                    if (tmp.id != b.id) continue;
                    bundlePresent = true;
                    break;
                }
                if (!bundlePresent) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(((Object)new StringBuffer().append(this).append(" added #").append(b.id).append(" to list of bundles to be activated.")).toString());
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" getResource: ").append(name)).toString());
        }
        URL res = null;
        if (name.startsWith("java/")) {
            res = this.fwCtx.parentClassLoader.getResource(name);
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" getResource: ").append(name).append(" file in java pkg: ").append(res)).toString());
            }
            return res;
        }
        if (this.fwCtx.isBootDelegatedResource(name) && (res = this.fwCtx.parentClassLoader.getResource(name)) != null) {
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" getResource: ").append(name).append(" boot delegation: ").append(res)).toString());
            }
            return res;
        }
        res = this.findResource(name);
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" getResource: ").append(name).append(" bundle space: ").append(res)).toString());
        }
        return res;
    }

    public Enumeration<URL> getResourcesOSGi(String name) throws IOException {
        int start;
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" getResources: ").append(name)).toString());
        }
        int n = start = name.startsWith("/") ? 1 : 0;
        if (name.substring(start).startsWith("java/")) {
            return this.fwCtx.parentClassLoader.getResources(name);
        }
        Enumeration<URL> res = null;
        if (this.fwCtx.isBootDelegatedResource(name)) {
            res = this.fwCtx.parentClassLoader.getResources(name);
        }
        if (res == null || !res.hasMoreElements()) {
            res = this.findResources(name);
        }
        return res;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return ((Object)new StringBuffer().append("BundleClassLoader(id=").append(this.bpkgs.bg.bundle.id).append(",gen=").append(this.bpkgs.bg.generation).append(")")).toString();
    }

    @Override
    public Bundle getBundle() {
        return this.bpkgs.bg.bundle;
    }

    void close() {
        this.archive = null;
        this.fwCtx.bundleClassLoaderClosed(this);
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" Cleared archives")).toString());
        }
    }

    Enumeration<URL> getBundleResources(String name, boolean onlyFirst) {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" Find bundle resource").append(onlyFirst ? "" : "s").append(": ").append(name)).toString());
        }
        String pkg = null;
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            int start = name.startsWith("/") ? 1 : 0;
            pkg = name.substring(start, pos).replace('/', '.');
        } else {
            pkg = null;
        }
        Enumeration res = (Enumeration)this.secure.callSearchFor(this, null, pkg, name, resourceSearch, onlyFirst ? 1 : 0, this, null);
        return res;
    }

    BundlePackages getBpkgs() {
        return this.bpkgs;
    }

    void attachFragment(BundleGeneration gen) throws BundleException {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" fragment attached update classpath")).toString());
        }
        this.classPath.attachFragment(gen);
    }

    Collection<String> listResources(String path, String filePattern, int options) {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" List bundle resources: ").append(path).append(", pattern=").append(filePattern)).toString());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String pkg = path.replace('/', '.');
        Set res = (Set)this.secure.callSearchFor(this, filePattern, pkg, path, listSearch, options << 8 | 2, this, null);
        return res;
    }

    Object searchFor(String name, String pkg, String path, SearchAction action, int options, BundleClassLoader requestor, HashSet<BundleClassLoader> visited) {
        try {
            BundleImpl b = (BundleImpl)this.getBundle();
            boolean initiator = false;
            ArrayList<BundleImpl> bundlesToActivate = null;
            if (action == classSearch) {
                boolean bundlePresent = false;
                bundlesToActivate = tlBundlesToActivate.get();
                boolean bl = initiator = bundlesToActivate == null;
                if (initiator) {
                    bundlesToActivate = new ArrayList();
                    tlBundlesToActivate.set(bundlesToActivate);
                } else {
                    bundlePresent = bundlesToActivate.contains(b);
                }
                if (!bundlePresent && b.triggersActivationPkg(pkg)) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(((Object)new StringBuffer().append(this).append(" lazy activation of #").append(b.id).append(" triggered by searchFor(").append(name).append(")")).toString());
                    }
                }
            }
            Object res = this.searchFor0(name, pkg, path, action, options, requestor, visited);
            if (initiator) {
                tlBundlesToActivate.set(null);
                for (int i = bundlesToActivate.size() - 1; i >= 0; --i) {
                    BundleImpl tmp = bundlesToActivate.get(i);
                    if (this.debug.lazy_activation) {
                        this.debug.println(((Object)new StringBuffer().append(this).append(" requesting lazy activation of #").append(tmp.id)).toString());
                    }
                    try {
                        tmp.finalizeActivation();
                        continue;
                    }
                    catch (BundleException e) {
                        this.fwCtx.frameworkError(tmp, (Throwable)e, new FrameworkListener[0]);
                    }
                }
            }
            return res;
        }
        catch (Error te) {
            tlBundlesToActivate.set(null);
            throw te;
        }
    }

    Object searchFor0(String name, String pkg, String path, SearchAction action, int options, BundleClassLoader requestor, HashSet<BundleClassLoader> visited) {
        Vector<FileArchive> av;
        Iterator<ExportPkg> ep;
        BundlePackages pbp;
        Class<?> c;
        if (action == classSearch && requestor != this && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        boolean list = (options & 2) != 0;
        boolean local = (options & 0x200) != 0;
        boolean recurse = (options & 0x100) != 0;
        Object answer = null;
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append(" Search for: ").append(path)).toString());
        }
        if (pkg != null) {
            ArrayList<BundleGeneration> pl;
            pbp = this.bpkgs.getProviderBundlePackages(pkg);
            if (pbp != null) {
                ClassLoader cl = pbp.getClassLoader();
                if (!local || cl == this) {
                    if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                        answer = this.frameworkSearchFor(cl, name, path, action);
                        if (!recurse) {
                            return answer;
                        }
                    } else {
                        BundleClassLoader bcl = (BundleClassLoader)cl;
                        if (bcl != this && (visited == null || bcl != null && !visited.contains(bcl))) {
                            if (bcl != null) {
                                if (this.debug.classLoader) {
                                    this.debug.println(((Object)new StringBuffer().append(this).append(" Import search: ").append(path).append(" from #").append(pbp.bg.bundle.id)).toString());
                                }
                                answer = this.secure.callSearchFor(bcl, name, pkg, path, action, options & 0xFFFFFEFF, requestor, visited);
                            } else if (this.debug.classLoader) {
                                this.debug.println(((Object)new StringBuffer().append(this).append(" No import found: ").append(path)).toString());
                            }
                            if (!recurse) {
                                return answer;
                            }
                        }
                    }
                }
                if (cl != this) {
                    options |= 4;
                }
            } else if (!local && (pl = this.bpkgs.getRequiredBundleGenerations(pkg)) != null) {
                if (visited == null) {
                    visited = new HashSet();
                }
                visited.add(this);
                for (BundleGeneration pbg : pl) {
                    ClassLoader cl = pbg.getClassLoader();
                    if (cl instanceof BundleClassLoader) {
                        BundleClassLoader bcl = (BundleClassLoader)cl;
                        if (bcl != null && !visited.contains(bcl)) {
                            if (this.debug.classLoader) {
                                this.debug.println(((Object)new StringBuffer().append(this).append(" Required bundle search: ").append(path).append(" from #").append(pbg.bundle.id)).toString());
                            }
                            answer = this.secure.callSearchFor(bcl, name, pkg, path, action, options, requestor, visited);
                        }
                    } else {
                        answer = this.frameworkSearchFor(cl, name, path, action);
                    }
                    if (answer == null) continue;
                    if (list || recurse) break;
                    return answer;
                }
                if (this.debug.classLoader && answer == null) {
                    this.debug.println(((Object)new StringBuffer().append(this).append(" Required bundle search: ").append("Not found, continuing with local search.")).toString());
                }
            }
            ep = this.bpkgs.getExports(pkg);
        } else {
            ep = null;
        }
        if (this != requestor && ep != null && action == classSearch) {
            boolean blocked = true;
            while (ep.hasNext()) {
                if (!ep.next().checkFilter(name)) continue;
                blocked = false;
                break;
            }
            if (blocked) {
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append(this).append(" Filter check blocked search for: ").append(name)).toString());
                }
                return null;
            }
        }
        if ((av = this.classPath.componentExists(path, (options & 1) != 0, (options & 2) != 0)) != null || recurse) {
            try {
                Object res = action.get(av, path, name, pkg, options, requestor, this);
                if (answer != null) {
                    if (res != null) {
                        Collection ca = (Collection)answer;
                        Collection cr = (Collection)res;
                        ca.addAll(cr);
                    }
                } else {
                    answer = res;
                }
                return answer;
            }
            catch (ClassFormatError cfe) {
                throw cfe;
            }
            catch (IOException ioe) {
                this.fwCtx.frameworkError(this.bpkgs.bg.bundle, (Throwable)ioe, new FrameworkListener[0]);
                return null;
            }
        }
        if (ep != null || (options & 2) != 0) {
            return null;
        }
        if (pkg != null) {
            pbp = this.bpkgs.getDynamicProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                    try {
                        return this.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != null) {
                        if (this.debug.classLoader) {
                            this.debug.println(((Object)new StringBuffer().append(this).append(" Dynamic import search: ").append(path).append(" from #").append(pbp.bg.bundle.id)).toString());
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, options, requestor, visited);
                    }
                }
            }
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append(" No dynamic import: ").append(path)).toString());
            }
        }
        return null;
    }

    private Object frameworkSearchFor(ClassLoader cl, String name, String path, SearchAction action) {
        if (action == classSearch) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        } else if (action == resourceSearch) {
            try {
                return cl.getResources(path);
            }
            catch (IOException e) {
            }
        } else if (action == listSearch) {
            throw new UnsupportedOperationException("listResources not available on system bundle");
        }
        return null;
    }

    private static boolean isSystemBundle(BundleImpl bundle) {
        return bundle == bundle.fwCtx.systemBundle;
    }

    private void walkAndAddJars(List<Object> dexlist, String path) throws Exception {
        File[] list;
        File root = new File(path);
        for (File f : list = root.listFiles()) {
            if (f.isDirectory()) {
                this.walkAndAddJars(dexlist, f.getAbsolutePath());
                continue;
            }
            if (!f.getAbsolutePath().endsWith(".jar")) continue;
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append("creating DexFile from ").append(f.getAbsolutePath())).toString());
            }
            Object dex = dexFileClassLoadDexMethod.invoke(null, f.getAbsolutePath(), ((Object)new StringBuffer().append(f.getAbsolutePath()).append(".dexopt")).toString(), new Integer(0));
            dexlist.add(dex);
        }
    }

    private Class<?> getDexFileClass(String name) throws Exception {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append("loading dex class ").append(name)).toString());
        }
        if (this.dexFile == null) {
            Object dex;
            this.dexFile = new ArrayList();
            File f = new File(this.archive.getJarLocation());
            if (!f.isDirectory()) {
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append("creating DexFile from ").append(f)).toString());
                }
                dex = dexFileClassLoadDexMethod.invoke(null, f.getAbsolutePath(), ((Object)new StringBuffer().append(f.getAbsolutePath()).append(".dexopt")).toString(), new Integer(0));
                this.dexFile.add(dex);
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append("created DexFile from ").append(f)).toString());
                }
            } else {
                if (this.debug.classLoader) {
                    System.err.println(((Object)new StringBuffer().append("creating DexFile from ").append(f).append("/classes.dex")).toString());
                }
                dex = dexFileClassLoadDexMethod.invoke(null, ((Object)new StringBuffer().append(f.getAbsolutePath()).append("/classes.dex")).toString(), ((Object)new StringBuffer().append(f.getAbsolutePath()).append(".dexopt")).toString(), new Integer(0));
                this.dexFile.add(dex);
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append("created DexFile from ").append(f).append(File.pathSeparatorChar).append("classes.dex")).toString());
                }
                this.walkAndAddJars(this.dexFile, f.getAbsolutePath());
            }
        }
        String path = name.replace('.', '/');
        for (Object dex : this.dexFile) {
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append("trying to load ").append(path).append(" from ").append(dex)).toString());
            }
            try {
                Class clz = (Class)dexFileClassLoadClassMethod.invoke(dex, path, this);
                if (clz != null) {
                    if (this.debug.classLoader) {
                        this.debug.println(((Object)new StringBuffer().append("loaded ").append(path).append(" from ").append(dex)).toString());
                    }
                    return clz;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.debug.classLoader) continue;
            this.debug.println(((Object)new StringBuffer().append("failed to load ").append(path).append(" from ").append(dex)).toString());
        }
        throw new ClassNotFoundException(((Object)new StringBuffer().append("could not find dex class ").append(path)).toString());
    }

    String findLibrary0(String name) {
        return this.classPath.getNativeLibrary(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        bDalvik = false;
        try {
            Class<?> dexFileClass = null;
            try {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            dexFileClassLoadDexMethod = dexFileClass.getMethod("loadDex", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            dexFileClassLoadClassMethod = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            bDalvik = true;
        }
        catch (Exception e) {
            dexFileClassLoadDexMethod = null;
            dexFileClassLoadClassMethod = null;
        }
        smex = new SecurityManagerExposer();
        classSearch = new SearchAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
                byte[] bytes = items.get(0).getClassBytes(path);
                if (bytes != null) {
                    if (cl.debug.classLoader) {
                        cl.debug.println(((Object)new StringBuffer().append("classLoader(#").append(cl.bpkgs.bg.bundle.id).append(") - load class: ").append(name)).toString());
                    }
                    BundleClassLoader bundleClassLoader = cl;
                    synchronized (bundleClassLoader) {
                        Class c = cl.findLoadedClass(name);
                        if (c == null) {
                            if (pkg != null && cl.getPackage(pkg) == null) {
                                cl.definePackage(pkg, null, null, null, null, null, null, null);
                            }
                            if (bDalvik) {
                                try {
                                    c = cl.getDexFileClass(name);
                                }
                                catch (Exception e) {
                                    throw new IOException(((Object)new StringBuffer().append("Failed to load dex class '").append(name).append("', ").append(e)).toString());
                                }
                            }
                            if (c == null) {
                                WeavingHooks.WovenClassImpl wc = null;
                                if (cl != null && cl.bpkgs != null && cl.bpkgs.bg != null && cl.bpkgs.bg.bundle != null) {
                                    wc = new WeavingHooks.WovenClassImpl(cl.bpkgs.bg.bundle, name, bytes);
                                    try {
                                        cl.fwCtx.weavingHooks.callHooks(wc);
                                        if (wc.hasAdditionalDynamicImports()) {
                                            cl.bpkgs.parseDynamicImports(wc.getDynamicImportsAsString());
                                        }
                                        bytes = wc.getBytes();
                                    }
                                    catch (ClassFormatError cfe) {
                                        throw cfe;
                                    }
                                    catch (Throwable t) {
                                        ClassFormatError cfe = new ClassFormatError(((Object)new StringBuffer().append("Failed to call WeavingHooks for ").append(name)).toString());
                                        cfe.initCause(t);
                                        throw cfe;
                                    }
                                }
                                c = cl.protectionDomain == null ? cl.defineClass(name, bytes, 0, bytes.length) : cl.defineClass(name, bytes, 0, bytes.length, cl.protectionDomain);
                                if (wc != null) {
                                    wc.setDefinedClass(c);
                                }
                            }
                        }
                        return c;
                    }
                }
                return null;
            }
        };
        resourceSearch = new SearchAction(){

            @Override
            public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
                Vector<URL> answer = new Vector<URL>();
                for (int i = 0; i < items.size(); ++i) {
                    FileArchive fa = items.elementAt(i);
                    URL url = fa.getBundleGeneration().getURL(fa.getSubId(), path);
                    if (url != null) {
                        if (cl.debug.classLoader) {
                            cl.debug.println(((Object)new StringBuffer().append("classLoader(#").append(cl.bpkgs.bg.bundle.id).append(") - found: ").append(path).append(" -> ").append(url)).toString());
                        }
                    } else {
                        return null;
                    }
                    answer.addElement(url);
                }
                return answer.elements();
            }
        };
        listSearch = new SearchAction(){

            @Override
            public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
                HashSet<String> answer = new HashSet<String>();
                boolean onlyRecurse = (options & 4) != 0;
                HashSet<String> scanned = new HashSet<String>();
                for (String subPkg : cl.bpkgs.getSubProvider(pkg)) {
                    String next;
                    Set subAnswer;
                    if ((options & 0x100) != 0 && (subAnswer = (Set)cl.searchFor(name, (next = path.length() > 0 ? ((Object)new StringBuffer().append(path).append("/").append(subPkg)).toString() : subPkg).replace('/', '.'), next, listSearch, options & 0xFFFFFFFB, requestor, null)) != null) {
                        answer.addAll(subAnswer);
                    }
                    if (!onlyRecurse && (name == null || Util.filterMatch(name, subPkg))) {
                        answer.add(((Object)new StringBuffer().append(path).append("/").append(subPkg)).toString());
                    }
                    scanned.add(((Object)new StringBuffer().append(subPkg).append("/")).toString());
                }
                if (items != null) {
                    for (FileArchive fa : items) {
                        for (String e : fa.listDir(path)) {
                            if (scanned.contains(e)) {
                                if (!cl.debug.classLoader) continue;
                                cl.debug.println(((Object)new StringBuffer().append("classLoader(#").append(cl.bpkgs.bg.bundle.id).append(") - list search skip: ").append(e)).toString());
                                continue;
                            }
                            if (cl.debug.classLoader) {
                                cl.debug.println(((Object)new StringBuffer().append("classLoader(#").append(cl.bpkgs.bg.bundle.id).append(") - list search check: ").append(e).append(onlyRecurse ? " (scan)" : "")).toString());
                            }
                            if (e.endsWith("/")) {
                                String next;
                                Set subAnswer;
                                e = e.substring(0, e.length() - 1);
                                if ((options & 0x100) != 0 && (subAnswer = (Set)cl.searchFor(name, (next = path.length() > 0 ? ((Object)new StringBuffer().append(path).append("/").append(e)).toString() : e).replace('/', '.'), next, listSearch, options & 0xFFFFFFFB, requestor, null)) != null) {
                                    answer.addAll(subAnswer);
                                }
                            }
                            if (onlyRecurse || name != null && !Util.filterMatch(name, e)) continue;
                            answer.add(((Object)new StringBuffer().append(path).append("/").append(e)).toString());
                            if (!cl.debug.classLoader) continue;
                            cl.debug.println(((Object)new StringBuffer().append("classLoader(#").append(cl.bpkgs.bg.bundle.id).append(") - list search match: ").append(e)).toString());
                        }
                    }
                }
                return answer;
            }
        };
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface SearchAction {
        public Object get(Vector<FileArchive> var1, String var2, String var3, String var4, int var5, BundleClassLoader var6, BundleClassLoader var7) throws IOException;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecurityManagerExposer
    extends SecurityManager {
        SecurityManagerExposer() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

