/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class SignerProperty {
    private final Bundle bundle;
    private final String pattern;

    public SignerProperty(String pattern) {
        this.pattern = pattern;
        this.bundle = null;
    }

    SignerProperty(Bundle bundle) {
        this.bundle = bundle;
        this.pattern = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SignerProperty)) {
            return false;
        }
        SignerProperty other = (SignerProperty)o;
        Bundle matchBundle = this.bundle != null ? this.bundle : other.bundle;
        String matchPattern = this.bundle != null ? other.pattern : this.pattern;
        Map signers = matchBundle.getSignerCertificates(2);
        Iterator iSigners = signers.values().iterator();
        while (iSigners.hasNext()) {
            List signerCerts = (List)iSigners.next();
            ArrayList<String> dnChain = new ArrayList<String>(signerCerts.size());
            Iterator iCerts = signerCerts.iterator();
            while (iCerts.hasNext()) {
                dnChain.add(((X509Certificate)iCerts.next()).getSubjectDN().getName());
            }
            if (!FrameworkUtil.matchDistinguishedNameChain(matchPattern, dnChain)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    boolean isBundleSigned() {
        if (this.bundle == null) {
            return false;
        }
        Map signers = this.bundle.getSignerCertificates(2);
        return !signers.isEmpty();
    }
}

