/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.bundlestorage.memory.BundleArchiveImpl;

public class BundleStorageImpl
implements BundleStorage {
    private long nextFreeId = 1L;
    private ArrayList archives = new ArrayList();
    final boolean checkSigned;

    public BundleStorageImpl(FrameworkContext framework) {
        this.checkSigned = framework.props.getBooleanProperty("org.knopflerfish.framework.bundlestorage.checksigned");
    }

    public BundleArchive insertBundleJar(String location, InputStream is) throws Exception {
        long id = this.nextFreeId++;
        BundleArchiveImpl ba = new BundleArchiveImpl(this, is, location, id);
        this.archives.add(ba);
        return ba;
    }

    public BundleArchive updateBundleArchive(BundleArchive old, InputStream is) throws Exception {
        return new BundleArchiveImpl((BundleArchiveImpl)old, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBundleArchive(BundleArchive oldBA, BundleArchive newBA) throws Exception {
        long id = oldBA.getBundleId();
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(id);
            if (pos >= this.archives.size() || this.archives.get(pos) != oldBA) {
                throw new Exception("replaceBundleJar: Old bundle archive not found, pos=" + pos);
            }
            this.archives.set(pos, newBA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleArchive[] getAllBundleArchives() {
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            return this.archives.toArray(new BundleArchive[this.archives.size()]);
        }
    }

    public List getStartOnLaunchBundles() {
        ArrayList<String> res = new ArrayList<String>();
        Iterator i = ((AbstractList)this.archives).iterator();
        while (i.hasNext()) {
            BundleArchive ba = (BundleArchive)i.next();
            if (ba.getAutostartSetting() == -1) continue;
            res.add(ba.getBundleLocation());
        }
        return res;
    }

    public void close() {
        Iterator i = ((AbstractList)this.archives).iterator();
        while (i.hasNext()) {
            BundleArchive ba = (BundleArchive)i.next();
            ba.close();
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeArchive(BundleArchive ba) {
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(ba.getBundleId());
            if (this.archives.get(pos) == ba) {
                this.archives.remove(pos);
                return true;
            }
            return false;
        }
    }

    private int find(long id) {
        int lb = 0;
        int ub = this.archives.size();
        int x = 0;
        while (lb != ub) {
            x = (lb + ub) / 2;
            long xid = ((BundleArchive)this.archives.get(x)).getBundleId();
            if (id <= xid) {
                ub = x;
                continue;
            }
            lb = x + 1;
        }
        return lb;
    }
}

