/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.bundlestorage.file.BundleArchiveImpl;

public class BundleStorageImpl
implements BundleStorage {
    public static final String ALWAYS_UNPACK_PROP = "org.knopflerfish.framework.bundlestorage.file.always_unpack";
    public static final String REFERENCE_PROP = "org.knopflerfish.framework.bundlestorage.file.reference";
    public static final String TRUSTED_PROP = "org.knopflerfish.framework.bundlestorage.file.trusted";
    public static final String UNPACK_PROP = "org.knopflerfish.framework.bundlestorage.file.unpack";
    boolean alwaysUnpack;
    boolean fileReference;
    boolean trustedStorage;
    boolean unpack;
    String execPermCmd;
    boolean isWindows;
    private FileTree bundlesDir;
    private long nextFreeId = 1L;
    private ArrayList archives = new ArrayList();
    FrameworkContext framework;
    boolean checkSigned;

    public BundleStorageImpl(FrameworkContext framework) {
        this.framework = framework;
        this.initProps(framework.props);
        this.bundlesDir = Util.getFileStorage(framework, "bs");
        if (this.bundlesDir == null) {
            throw new RuntimeException("No bundle storage area available!");
        }
        String[] list = this.bundlesDir.list();
        int i = 0;
        while (list != null & i < list.length) {
            block12: {
                int pos;
                long id;
                try {
                    id = Long.parseLong(list[i]);
                }
                catch (NumberFormatException e) {
                    break block12;
                }
                if (id == 0L) {
                    System.err.println("Saved bundle with illegal id 0 is ignored.");
                }
                if ((pos = this.find(id)) < this.archives.size() && ((BundleArchive)this.archives.get(pos)).getBundleId() == id) {
                    System.err.println("There are two bundle directories with id: " + id);
                    break;
                }
                FileTree dir = new FileTree(this.bundlesDir, list[i]);
                if (dir.isDirectory()) {
                    try {
                        boolean bUninstalled = BundleArchiveImpl.isUninstalled(dir);
                        if (bUninstalled) {
                            dir.delete();
                        } else {
                            BundleArchiveImpl ba = new BundleArchiveImpl(this, dir, id);
                            this.archives.add(pos, ba);
                        }
                        if (id >= this.nextFreeId) {
                            this.nextFreeId = id + 1L;
                        }
                    }
                    catch (Exception e) {
                        dir.delete();
                        System.err.println("Removed corrupt bundle dir (" + e.getMessage() + "): " + dir);
                    }
                }
            }
            ++i;
        }
    }

    public BundleArchive insertBundleJar(String location, InputStream is) throws Exception {
        long id;
        FileTree dir;
        if ((dir = new FileTree(this.bundlesDir, String.valueOf(id = this.nextFreeId++))).exists()) {
            dir.delete();
        }
        dir.mkdir();
        try {
            BundleArchiveImpl ba = new BundleArchiveImpl(this, dir, is, location, id);
            this.archives.add(ba);
            return ba;
        }
        catch (Exception e) {
            dir.delete();
            throw e;
        }
    }

    public BundleArchive updateBundleArchive(BundleArchive old, InputStream is) throws Exception {
        return new BundleArchiveImpl((BundleArchiveImpl)old, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBundleArchive(BundleArchive oldBA, BundleArchive newBA) throws Exception {
        long id = oldBA.getBundleId();
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(id);
            if (pos >= this.archives.size() || this.archives.get(pos) != oldBA) {
                throw new Exception("replaceBundleJar: Old bundle archive not found, pos=" + pos);
            }
            this.archives.set(pos, newBA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleArchive[] getAllBundleArchives() {
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            return this.archives.toArray(new BundleArchive[this.archives.size()]);
        }
    }

    public List getStartOnLaunchBundles() {
        ArrayList<String> res = new ArrayList<String>();
        Iterator i = ((AbstractList)this.archives).iterator();
        while (i.hasNext()) {
            BundleArchive ba = (BundleArchive)i.next();
            if (ba.getAutostartSetting() == -1) continue;
            res.add(ba.getBundleLocation());
        }
        return res;
    }

    public void close() {
        Iterator i = ((AbstractList)this.archives).iterator();
        while (i.hasNext()) {
            BundleArchive ba = (BundleArchive)i.next();
            ba.close();
            i.remove();
        }
        this.framework = null;
        this.bundlesDir = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeArchive(BundleArchive ba) {
        ArrayList arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(ba.getBundleId());
            if (pos < this.archives.size() && this.archives.get(pos) == ba) {
                this.archives.remove(pos);
                return true;
            }
            return false;
        }
    }

    private void initProps(FWProps props) {
        props.setPropertyDefault(ALWAYS_UNPACK_PROP, "false");
        props.setPropertyDefault(REFERENCE_PROP, "false");
        props.setPropertyDefault(TRUSTED_PROP, "true");
        props.setPropertyDefault(UNPACK_PROP, "true");
        this.alwaysUnpack = props.getBooleanProperty(ALWAYS_UNPACK_PROP);
        this.fileReference = props.getBooleanProperty(REFERENCE_PROP);
        this.trustedStorage = props.getBooleanProperty(TRUSTED_PROP);
        this.unpack = props.getBooleanProperty(UNPACK_PROP);
        this.execPermCmd = props.getProperty("org.osgi.framework.command.execpermission").trim();
        this.checkSigned = props.getBooleanProperty("org.knopflerfish.framework.bundlestorage.checksigned");
        this.isWindows = props.getProperty("org.osgi.framework.os.name").startsWith("Windows");
    }

    private int find(long id) {
        int lb = 0;
        int ub = this.archives.size() - 1;
        int x = 0;
        while (lb < ub) {
            x = (lb + ub) / 2;
            long xid = ((BundleArchive)this.archives.get(x)).getBundleId();
            if (id == xid) {
                return x;
            }
            if (id < xid) {
                ub = x;
                continue;
            }
            lb = x + 1;
        }
        if (lb < this.archives.size() && ((BundleArchive)this.archives.get(lb)).getBundleId() < id) {
            return lb + 1;
        }
        return lb;
    }
}

