/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;

public class SystemBundle
extends BundleImpl
implements Framework {
    private static final String BOOT_CLASSPATH_FILE = "boot_cp";
    private String exportPackageString;
    private volatile FrameworkEvent stopEvent = null;
    private Thread shutdownThread = null;
    private Object lock = new Object();
    boolean bootClassPathHasChanged;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$osgi$util$tracker$ServiceTracker;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$org$knopflerfish$framework$SystemBundle;
    static /* synthetic */ Class class$java$net$URL;

    SystemBundle(FrameworkContext fw) {
        super(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        Object object = this.lock;
        synchronized (object) {
            this.waitOnOperation(this.lock, "Framework.init", true);
            switch (this.state) {
                case 2: 
                case 4: {
                    break;
                }
                case 8: 
                case 32: {
                    return;
                }
                default: {
                    throw new IllegalStateException("INTERNAL ERROR, Illegal state, " + this.state);
                }
            }
            this.doInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int options) throws BundleException {
        List bundlesToStart = null;
        Object object = this.lock;
        synchronized (object) {
            this.waitOnOperation(this.lock, "Framework.start", true);
            switch (this.state) {
                case 2: 
                case 4: {
                    this.doInit();
                }
                case 8: {
                    this.operation = 1;
                    break;
                }
                case 32: {
                    return;
                }
                default: {
                    throw new IllegalStateException("INTERNAL ERROR, Illegal state, " + this.state);
                }
            }
            if (this.fwCtx.startLevelController == null) {
                bundlesToStart = this.fwCtx.storage.getStartOnLaunchBundles();
            }
        }
        if (this.fwCtx.startLevelController != null) {
            this.fwCtx.startLevelController.open();
        } else {
            Iterator i = bundlesToStart.iterator();
            while (i.hasNext()) {
                BundleImpl b = (BundleImpl)this.fwCtx.bundles.getBundle((String)i.next());
                try {
                    int autostartSetting = b.gen.archive.getAutostartSetting();
                    int option = 1;
                    if (2 == autostartSetting) {
                        option |= 2;
                    }
                    b.start(option);
                }
                catch (BundleException be) {
                    this.fwCtx.listeners.frameworkError(b, (Throwable)be);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.state = 32;
            this.operation = 0;
            this.lock.notifyAll();
            this.fwCtx.listeners.frameworkEvent(new FrameworkEvent(1, this, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if ((6 & this.state) == 0) {
                long st;
                this.stopEvent = null;
                do {
                    st = System.currentTimeMillis();
                    try {
                        this.lock.wait(timeout);
                        if (this.stopEvent == null) continue;
                        break;
                    }
                    catch (InterruptedException _) {
                        // empty catch block
                    }
                } while (timeout <= 0L || (timeout -= System.currentTimeMillis() - st) > 0L);
                if (this.stopEvent == null) {
                    return new FrameworkEvent(512, this, null);
                }
            } else if (this.stopEvent == null) {
                this.stopEvent = new FrameworkEvent(64, this, null);
            }
            return this.stopEvent;
        }
    }

    public void stop(int options) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        this.secure.callShutdown(this, false);
    }

    public void update(InputStream in) throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.secure.callShutdown(this, true);
    }

    public void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        throw new BundleException("uninstall of System bundle is not allowed", 2);
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Bundle-SymbolicName", this.getSymbolicName());
        headers.put("Bundle-Name", this.location);
        headers.put("Export-Package", this.exportPackageString);
        headers.put("Bundle-Version", this.getVersion().toString());
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-RequiredExecutionEnvironment", this.fwCtx.props.getProperty("org.osgi.framework.executionenvironment"));
        headers.put("Bundle-Icon", "icon.png;size=32,icon64.png;size=64");
        headers.put("Bundle-Vendor", "Knopflerfish");
        headers.put("Bundle-Description", "Knopflerfish System Bundle");
        return headers;
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            return this.getClass().getResource(name);
        }
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        return null;
    }

    ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    void systemShuttingdown(boolean restart) throws BundleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemShuttingdownDone(FrameworkEvent fe) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 2) {
                this.state = 4;
                this.operation = 0;
                this.lock.notifyAll();
            }
            this.stopEvent = fe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void attachExtension(BundleGeneration extension) {
        if (extension.isBootClassPathExtension()) {
            if (this.getClassLoader() != null) throw new UnsupportedOperationException("Bootclasspath extension can not be dynamicly activated");
            this.gen.attachFragment(extension);
            return;
        }
        try {
            this.addClassPathURL(new URL("file:" + extension.archive.getJarLocation()));
            this.gen.attachFragment(extension);
            this.handleExtensionActivator(extension);
            return;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Framework extension could not be dynamicly activated, " + e);
        }
    }

    void readLocalization(String locale, Hashtable localization_entries, String baseName) {
        if (this.gen.fragments == null) {
            return;
        }
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if (!locale.equals("")) {
            locale = "_" + locale;
        }
        while (true) {
            String l = baseName + locale + ".properties";
            for (int i = this.gen.fragments.size() - 1; i >= 0; --i) {
                BundleGeneration bg = (BundleGeneration)this.gen.fragments.get(i);
                Hashtable tmp = bg.archive.getLocalizationEntries(l);
                if (tmp == null) continue;
                localization_entries.putAll(tmp);
                return;
            }
            int pos = locale.lastIndexOf(95);
            if (pos == -1) break;
            locale = locale.substring(0, pos);
        }
    }

    void initSystemBundle() {
        String extraPkgs;
        this.bundleContext = new BundleContextImpl(this);
        StringBuffer sp = new StringBuffer(this.fwCtx.props.getProperty("org.osgi.framework.system.packages"));
        if (sp.length() == 0) {
            this.addSysPackagesFromFile(sp, this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.file"));
            if (sp.length() == 0) {
                sp.append(this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.base"));
                if (sp.length() == 0) {
                    String jver = this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.version");
                    if (jver == null) {
                        jver = Integer.toString(FWProps.javaVersionMajor) + "." + FWProps.javaVersionMinor;
                    }
                    try {
                        this.addSysPackagesFromFile(sp, "packages" + jver + ".txt");
                    }
                    catch (IllegalArgumentException iae) {
                        if (this.fwCtx.debug.framework) {
                            this.fwCtx.debug.println("No built in list of Java packages to be exported by the system bundle for JRE with version '" + jver + "', using the list for 1.6.");
                        }
                        this.addSysPackagesFromFile(sp, "packages1.6.txt");
                    }
                }
                this.addSystemPackages(sp);
            }
        }
        if ((extraPkgs = this.fwCtx.props.getProperty("org.osgi.framework.system.packages.extra")).length() > 0) {
            sp.append(",").append(extraPkgs);
        }
        this.exportPackageString = sp.toString();
        this.gen = new BundleGeneration(this, this.exportPackageString);
        this.gen.bpkgs.registerPackages();
        this.gen.bpkgs.resolvePackages();
    }

    void uninitSystemBundle() {
        this.bundleContext.invalidate();
        this.bundleContext = null;
        if (!this.bootClassPathHasChanged) {
            Iterator i = this.fwCtx.bundles.getFragmentBundles(this).iterator();
            while (i.hasNext()) {
                BundleGeneration bg = (BundleGeneration)i.next();
                if (!bg.isBootClassPathExtension() || !bg.bundle.extensionNeedsRestart()) continue;
                this.bootClassPathHasChanged = true;
                break;
            }
        }
    }

    private void doInit() throws BundleException {
        this.state = 8;
        this.bootClassPathHasChanged = false;
        this.fwCtx.init();
    }

    private void addSystemPackages(StringBuffer sp) {
        if (sp.length() > 0 && ',' != sp.charAt(sp.length() - 1)) {
            sp.append(",");
        }
        String name = (class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = SystemBundle.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append(name + ";" + "version" + "=" + "1.5");
        sp.append(",org.osgi.framework.launch;version=1.0");
        sp.append(",org.osgi.framework.hooks.service;version=1.0");
        name = (class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = SystemBundle.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.2");
        name = (class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SystemBundle.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.2");
        name = (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin = SystemBundle.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin")) : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.1.0");
        name = (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = SystemBundle.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.1");
        name = (class$org$osgi$util$tracker$ServiceTracker == null ? (class$org$osgi$util$tracker$ServiceTracker = SystemBundle.class$("org.osgi.util.tracker.ServiceTracker")) : class$org$osgi$util$tracker$ServiceTracker).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.4");
        name = (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = SystemBundle.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.0");
    }

    private void addSysPackagesFromFile(StringBuffer sp, String sysPkgFile) {
        if (null == sysPkgFile || 0 == sysPkgFile.length()) {
            return;
        }
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("Will add system packages from file " + sysPkgFile);
        }
        URL url = null;
        File f = new File(new File(sysPkgFile).getAbsolutePath());
        if (!f.exists() || !f.isFile()) {
            url = (class$org$knopflerfish$framework$SystemBundle == null ? (class$org$knopflerfish$framework$SystemBundle = SystemBundle.class$("org.knopflerfish.framework.SystemBundle")) : class$org$knopflerfish$framework$SystemBundle).getResource(sysPkgFile);
            if (null == url) {
                url = (class$org$knopflerfish$framework$SystemBundle == null ? (class$org$knopflerfish$framework$SystemBundle = SystemBundle.class$("org.knopflerfish.framework.SystemBundle")) : class$org$knopflerfish$framework$SystemBundle).getResource("/" + sysPkgFile);
            }
            if (null == url && this.fwCtx.debug.packages) {
                this.fwCtx.debug.println("Could not add system bundle package exports from '" + sysPkgFile + "', file not found.");
            }
        }
        BufferedReader in = null;
        try {
            InputStreamReader reader = null;
            String source = null;
            if (null == url) {
                reader = new FileReader(f);
                source = f.getAbsolutePath().toString();
            } else {
                reader = new InputStreamReader(url.openStream());
                source = url.toString();
            }
            in = new BufferedReader(reader);
            if (this.fwCtx.debug.packages) {
                this.fwCtx.debug.println("\treading from " + source);
            }
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    sp.append(line);
                    sp.append(",");
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read " + sysPkgFile + ": " + e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(final boolean restart) {
        Object object = this.lock;
        synchronized (object) {
            boolean wasActive = false;
            switch (this.state) {
                case 2: 
                case 4: {
                    this.shutdownDone(false);
                    break;
                }
                case 32: {
                    wasActive = true;
                }
                case 8: {
                    if (this.shutdownThread != null) break;
                    try {
                        final boolean wa = wasActive;
                        this.shutdownThread = new Thread(this.fwCtx.threadGroup, "Framework shutdown"){

                            public void run() {
                                SystemBundle.this.shutdown0(restart, wa);
                            }
                        };
                        this.shutdownThread.setDaemon(false);
                        this.shutdownThread.start();
                    }
                    catch (Exception e) {
                        this.systemShuttingdownDone(new FrameworkEvent(2, this, e));
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown0(boolean restart, boolean wasActive) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.waitOnOperation(this.lock, "Framework." + (restart ? "update" : "stop"), true);
                this.operation = 2;
                this.state = 16;
            }
            this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
            if (wasActive) {
                this.stopAllBundles();
                this.saveClasspaths();
            }
            object = this.lock;
            synchronized (object) {
                this.fwCtx.uninit();
                this.shutdownThread = null;
                this.shutdownDone(restart);
            }
            if (restart) {
                if (wasActive) {
                    this.start();
                } else {
                    this.init();
                }
            }
        }
        catch (Exception e) {
            this.shutdownThread = null;
            this.systemShuttingdownDone(new FrameworkEvent(2, this, e));
        }
    }

    private void shutdownDone(boolean restart) {
        int t = this.bootClassPathHasChanged ? 256 : (restart ? 128 : 64);
        this.systemShuttingdownDone(new FrameworkEvent(t, this, null));
    }

    private void stopAllBundles() {
        if (this.fwCtx.startLevelController != null) {
            this.fwCtx.startLevelController.shutdown();
        }
        List activeBundles = this.fwCtx.bundles.getActiveBundles();
        for (int i = activeBundles.size() - 1; i >= 0; --i) {
            BundleImpl b = (BundleImpl)activeBundles.get(i);
            try {
                if ((0x28 & b.getState()) == 0) continue;
                b.stop(1);
                continue;
            }
            catch (BundleException be) {
                this.fwCtx.listeners.frameworkError(b, (Throwable)be);
            }
        }
        List allBundles = this.fwCtx.bundles.getBundles();
        Iterator i = allBundles.iterator();
        while (i.hasNext()) {
            BundleImpl b = (BundleImpl)i.next();
            if (b.getBundleId() == 0L) continue;
            b.setStateInstalled(false);
            b.purge();
        }
    }

    private void saveClasspaths() {
        block6: {
            StringBuffer bootClasspath = new StringBuffer();
            Iterator i = this.fwCtx.bundles.getFragmentBundles(this).iterator();
            while (i.hasNext()) {
                BundleGeneration ebg = (BundleGeneration)i.next();
                String path = ebg.archive.getJarLocation();
                if (!ebg.isBootClassPathExtension()) continue;
                if (bootClasspath.length() > 0) {
                    bootClasspath.append(File.pathSeparator);
                }
                bootClasspath.append(path);
            }
            try {
                File bcpf = new File(Util.getFrameworkDir(this.fwCtx), BOOT_CLASSPATH_FILE);
                if (bootClasspath.length() > 0) {
                    this.saveStringBuffer(bcpf, bootClasspath);
                } else {
                    bcpf.delete();
                }
            }
            catch (IOException e) {
                if (!this.fwCtx.debug.errors) break block6;
                this.fwCtx.debug.println("Could not save classpath " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStringBuffer(File f, StringBuffer content) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(f));
            out.println(content.toString());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void addClassPathURL(URL url) throws Exception {
        ClassLoader cl = this.getClassLoader();
        Method m = null;
        Class<?> c = cl.getClass();
        while (true) {
            try {
                m = c.getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = SystemBundle.class$("java.net.URL")) : class$java$net$URL);
            }
            catch (NoSuchMethodException e) {
                if ((c = c.getSuperclass()) != null) continue;
                throw e;
            }
            break;
        }
        ((AccessibleObject)m).setAccessible(true);
        m.invoke((Object)cl, url);
    }

    private void handleExtensionActivator(BundleGeneration extension) {
        String extActivatorName = extension.archive.getAttribute("Extension-Activator");
        String string = extActivatorName = null != extActivatorName ? extActivatorName.trim() : null;
        if (null != extActivatorName && extActivatorName.length() > 0) {
            this.fwCtx.log("Activating extension: " + extension.symbolicName + ":" + extension.version + " using: " + extActivatorName);
            this.fwCtx.activateExtension(extension);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

