/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class Services {
    HashMap services = new HashMap();
    private HashMap classServices = new HashMap();
    private PermissionOps secure;
    FrameworkContext framework;
    static final Util.Comparator sComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) {
            ServiceRegistrationImpl a = (ServiceRegistrationImpl)oa;
            ServiceRegistrationImpl b = (ServiceRegistrationImpl)ob;
            return a.reference.compareTo(b.reference);
        }
    };
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;

    Services(FrameworkContext fwCtx, PermissionOps perm) {
        this.framework = fwCtx;
        this.secure = perm;
    }

    void clear() {
        this.services.clear();
        this.classServices.clear();
        this.secure = null;
        this.framework = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration register(BundleImpl bundle, String[] classes, Object service, Dictionary properties) {
        Object cls;
        if (service == null) {
            throw new IllegalArgumentException("Can't register null as a service");
        }
        for (int i = 0; i < classes.length; ++i) {
            cls = classes[i];
            if (cls == null) {
                throw new IllegalArgumentException("Can't register as null class");
            }
            this.secure.checkRegisterServicePerm((String)cls);
            if (bundle.id != 0L) {
                if (((String)cls).equals((class$org$osgi$service$packageadmin$PackageAdmin == null ? Services.class$("org.osgi.service.packageadmin.PackageAdmin") : class$org$osgi$service$packageadmin$PackageAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a PackageAdmin service is not allowed");
                }
                if (((String)cls).equals((class$org$osgi$service$permissionadmin$PermissionAdmin == null ? Services.class$("org.osgi.service.permissionadmin.PermissionAdmin") : class$org$osgi$service$permissionadmin$PermissionAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a PermissionAdmin service is not allowed");
                }
                if (((String)cls).equals((class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? Services.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin") : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a ConditionalPermissionAdmin service is not allowed");
                }
            }
            if (service instanceof ServiceFactory || this.checkServiceClass(service, (String)cls)) continue;
            throw new IllegalArgumentException("Service object is not an instance of " + (String)cls);
        }
        ServiceRegistrationImpl res = new ServiceRegistrationImpl(bundle, service, new PropertiesDictionary(properties, classes, null));
        cls = this;
        synchronized (cls) {
            this.services.put(res, classes);
            for (int i = 0; i < classes.length; ++i) {
                ArrayList<ServiceRegistrationImpl> s = (ArrayList<ServiceRegistrationImpl>)this.classServices.get(classes[i]);
                if (s == null) {
                    s = new ArrayList<ServiceRegistrationImpl>(1);
                    this.classServices.put(classes[i], s);
                }
                int ip = Math.abs(Util.binarySearch(s, sComp, res) + 1);
                s.add(ip, res);
            }
        }
        ServiceReference r = res.getReference();
        bundle.fwCtx.perm.callServiceChanged(bundle.fwCtx, bundle.fwCtx.listeners.getMatchingServiceListeners(r), new ServiceEvent(1, r), null);
        return res;
    }

    synchronized void updateServiceRegistrationOrder(ServiceRegistrationImpl sr, String[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            ArrayList s = (ArrayList)this.classServices.get(classes[i]);
            ((AbstractCollection)s).remove(sr);
            s.add(Math.abs(Util.binarySearch(s, sComp, sr) + 1), sr);
        }
    }

    boolean checkServiceClass(Object service, String cls) {
        Class<?> sc = service.getClass();
        ClassLoader scl = this.secure.getClassLoaderOf(sc);
        Class<?> c = null;
        boolean ok = false;
        try {
            c = scl != null ? scl.loadClass(cls) : Class.forName(cls);
            ok = c.isInstance(service);
        }
        catch (ClassNotFoundException e) {
            block2: for (Class<?> csc = sc; csc != null; csc = csc.getSuperclass()) {
                if (cls.equals(csc.getName())) {
                    ok = true;
                    break;
                }
                Class<?>[] ic = csc.getInterfaces();
                for (int iic = ic.length - 1; iic >= 0; --iic) {
                    if (!cls.equals(ic[iic].getName())) continue;
                    ok = true;
                    continue block2;
                }
            }
        }
        return ok;
    }

    synchronized ArrayList get(String clazz) {
        ArrayList v = (ArrayList)this.classServices.get(clazz);
        if (v != null) {
            return (ArrayList)v.clone();
        }
        return null;
    }

    synchronized ServiceReference get(BundleImpl bundle, String clazz) {
        try {
            ServiceReference[] srs = this.get(clazz, null, bundle);
            if (this.framework.debug.service_reference) {
                this.framework.debug.println("get service ref " + clazz + " for bundle " + bundle.location + " = " + (srs != null ? srs[0] : null));
            }
            if (srs != null) {
                return srs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized ServiceReference[] get(String clazz, String filter, BundleImpl bundle) throws InvalidSyntaxException {
        void var4_17;
        LDAPExpr ldap = null;
        if (clazz == null) {
            if (filter != null) {
                ldap = new LDAPExpr(filter);
                Set matched = ldap.getMatchedObjectClasses();
                if (matched != null) {
                    ArrayList v = null;
                    boolean vReadOnly = true;
                    Iterator i = matched.iterator();
                    while (i.hasNext()) {
                        ArrayList cl = (ArrayList)this.classServices.get(i.next());
                        if (cl == null) continue;
                        if (v == null) {
                            v = cl;
                            continue;
                        }
                        if (vReadOnly) {
                            v = new ArrayList(v);
                            vReadOnly = false;
                        }
                        v.addAll(cl);
                    }
                    if (v == null) return null;
                    Iterator iterator = ((AbstractList)v).iterator();
                } else {
                    Iterator iterator = this.services.keySet().iterator();
                }
            } else {
                Iterator iterator = this.services.keySet().iterator();
            }
        } else {
            ArrayList v = (ArrayList)this.classServices.get(clazz);
            if (v == null) {
                return null;
            }
            Iterator iterator = ((AbstractList)v).iterator();
            if (filter != null) {
                ldap = new LDAPExpr(filter);
            }
        }
        ArrayList<ServiceReference> res = new ArrayList<ServiceReference>();
        while (var4_17.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)var4_17.next();
            ServiceReference sri = sr.getReference();
            if (!this.secure.okGetServicePerms(sri) || filter != null && !ldap.evaluate(sr.getProperties(), false)) continue;
            if (bundle != null) {
                String[] classes = (String[])this.services.get(sr);
                for (int i = 0; i < classes.length; ++i) {
                    if (sri.isAssignableTo(bundle, classes[i])) continue;
                    sri = null;
                    break;
                }
            }
            if (sri == null) continue;
            res.add(sri);
        }
        if (res.isEmpty()) {
            return null;
        }
        if (bundle != null) {
            this.framework.hooks.filterServiceReferences(bundle.bundleContext, clazz, filter, false, res);
        } else {
            this.framework.hooks.filterServiceReferences(null, clazz, filter, true, res);
        }
        if (!res.isEmpty()) return res.toArray(new ServiceReference[res.size()]);
        return null;
    }

    synchronized void removeServiceRegistration(ServiceRegistrationImpl sr) {
        String[] classes = (String[])sr.getProperty("objectClass");
        this.services.remove(sr);
        for (int i = 0; i < classes.length; ++i) {
            ArrayList s = (ArrayList)this.classServices.get(classes[i]);
            if (s.size() > 1) {
                ((AbstractCollection)s).remove(sr);
                continue;
            }
            this.classServices.remove(classes[i]);
        }
    }

    synchronized Set getRegisteredByBundle(Bundle b) {
        HashSet<ServiceRegistrationImpl> res = new HashSet<ServiceRegistrationImpl>();
        Iterator e = this.services.keySet().iterator();
        while (e.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)e.next();
            if (sr.bundle != b) continue;
            res.add(sr);
        }
        return res;
    }

    synchronized Set getUsedByBundle(Bundle b) {
        HashSet<ServiceRegistrationImpl> res = new HashSet<ServiceRegistrationImpl>();
        Iterator e = this.services.keySet().iterator();
        while (e.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)e.next();
            if (!sr.isUsedByBundle(b)) continue;
            res.add(sr);
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

