/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    BundleImpl bundle;
    Object service;
    ServiceReferenceImpl reference;
    private PropertiesDictionary properties;
    private Hashtable dependents = new Hashtable();
    private HashMap serviceInstances = new HashMap();
    private HashSet ungetInProgress = new HashSet();
    private volatile boolean available;
    private Object eventLock = new Object();
    private volatile boolean unregistering = false;
    private Thread factoryThread = null;

    ServiceRegistrationImpl(BundleImpl b, Object s, PropertiesDictionary props) {
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
    }

    public ServiceReference getReference() {
        ServiceReferenceImpl res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.available) {
                Set before;
                Services services = this.bundle.fwCtx.services;
                synchronized (services) {
                    PropertiesDictionary propertiesDictionary = this.properties;
                    synchronized (propertiesDictionary) {
                        Object old_rank = this.properties.get("service.ranking");
                        before = this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference);
                        String[] classes = (String[])this.properties.get("objectClass");
                        Long sid = (Long)this.properties.get("service.id");
                        this.properties = new PropertiesDictionary(props, classes, sid);
                        Object new_rank = this.properties.get("service.ranking");
                        if (old_rank != new_rank && new_rank instanceof Integer && !((Integer)new_rank).equals(old_rank)) {
                            this.bundle.fwCtx.services.updateServiceRegistrationOrder(this, classes);
                        }
                    }
                }
                this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(2, this.reference), before);
                if (!before.isEmpty()) {
                    this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, before, new ServiceEvent(8, this.reference), null);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        if (this.unregistering) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.unregistering) {
                return;
            }
            this.unregistering = true;
            if (this.available) {
                if (null != this.bundle) {
                    this.bundle.fwCtx.services.removeServiceRegistration(this);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
        if (null != this.bundle) {
            this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(4, this.reference), null);
        }
        object = this.eventLock;
        synchronized (object) {
            this.available = false;
            Bundle[] using = this.getUsingBundles();
            if (using != null) {
                for (int i = 0; i < using.length; ++i) {
                    this.ungetService(using[i], false);
                }
            }
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                this.bundle = null;
                this.dependents = null;
                this.reference = null;
                this.service = null;
                this.serviceInstances = null;
                this.unregistering = false;
            }
        }
    }

    PropertiesDictionary getProperties() {
        return this.properties;
    }

    Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getService(Bundle b) {
        boolean bl;
        Integer ref;
        BundleImpl sBundle = null;
        PropertiesDictionary propertiesDictionary = this.properties;
        synchronized (propertiesDictionary) {
            if (!this.available) return null;
            ref = (Integer)this.dependents.get(b);
            if (this.service instanceof ServiceFactory) {
                if (ref == null) {
                    this.dependents.put(b, new Integer(0));
                    this.factoryThread = Thread.currentThread();
                } else if (this.factoryThread != null && this.factoryThread.equals(Thread.currentThread())) {
                    throw new IllegalStateException("Recursive call of getService");
                }
            } else {
                this.dependents.put(b, new Integer(ref != null ? ref + 1 : 1));
                return this.service;
            }
            sBundle = this.bundle;
        }
        Object s = null;
        if (ref == null) {
            try {
                s = sBundle.fwCtx.perm.callGetService(this, b);
                if (s == null) {
                    sBundle.fwCtx.listeners.frameworkWarning(sBundle, new ServiceException("ServiceFactory produced null", 2));
                }
            }
            catch (Throwable throwable) {
                sBundle.fwCtx.listeners.frameworkError(sBundle, (Throwable)new ServiceException("ServiceFactory throw an exception", 3, throwable));
            }
            if (s != null) {
                String[] stringArray = (String[])this.getProperty("objectClass");
                for (int i = 0; i < stringArray.length; ++i) {
                    String cls = stringArray[i];
                    if (sBundle.fwCtx.services.checkServiceClass(s, cls)) continue;
                    sBundle.fwCtx.listeners.frameworkError(sBundle, (Throwable)new ServiceException("ServiceFactory produced an object that did not implement: " + cls, 2));
                    s = null;
                    break;
                }
            }
            if (s == null) {
                PropertiesDictionary propertiesDictionary2 = this.properties;
                synchronized (propertiesDictionary2) {
                    if (this.dependents != null) {
                        this.dependents.remove(b);
                    }
                    this.factoryThread = null;
                    return null;
                }
            }
        }
        boolean bl2 = false;
        PropertiesDictionary i = this.properties;
        synchronized (i) {
            if (s == null) {
                while ((s = this.serviceInstances.get(b)) == null) {
                    try {
                        this.properties.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.dependents != null && this.dependents.containsKey(b)) continue;
                    break;
                }
            } else {
                this.factoryThread = null;
                this.serviceInstances.put(b, s);
                this.properties.notifyAll();
            }
            if (s != null) {
                Integer n = ref = this.dependents != null ? (Integer)this.dependents.get(b) : null;
                if (ref != null) {
                    this.dependents.put(b, new Integer(ref + 1));
                } else {
                    bl = true;
                }
            }
        }
        if (!bl) return s;
        try {
            sBundle.fwCtx.perm.callUngetService(this, b, s);
            return null;
        }
        catch (Throwable e) {
            sBundle.fwCtx.listeners.frameworkError(sBundle, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Hashtable d = this.dependents;
        if (d != null) {
            Hashtable hashtable = d;
            synchronized (hashtable) {
                int size = d.size() + this.ungetInProgress.size();
                if (size > 0) {
                    Bundle[] res = new Bundle[size];
                    Enumeration e = d.keys();
                    while (e.hasMoreElements()) {
                        res[--size] = (Bundle)e.nextElement();
                    }
                    Iterator i = this.ungetInProgress.iterator();
                    while (i.hasNext()) {
                        res[--size] = (Bundle)i.next();
                    }
                    return res;
                }
            }
        }
        return null;
    }

    boolean isUsedByBundle(Bundle b) {
        Hashtable deps = this.dependents;
        if (deps != null) {
            return deps.containsKey(b);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle b, boolean checkRefCounter) {
        BundleImpl sBundle;
        Hashtable deps;
        Object serviceToRemove = null;
        Dictionary dictionary = this.properties;
        synchronized (dictionary) {
            if (this.dependents == null) {
                return false;
            }
            Object countInteger = this.dependents.get(b);
            if (countInteger == null) {
                return false;
            }
            int count = (Integer)countInteger;
            if (checkRefCounter && count > 1) {
                this.dependents.put(b, new Integer(count - 1));
            } else {
                Hashtable hashtable = this.dependents;
                synchronized (hashtable) {
                    this.ungetInProgress.add(b);
                    this.dependents.remove(b);
                }
                serviceToRemove = this.serviceInstances.remove(b);
            }
            deps = this.dependents;
            sBundle = this.bundle;
        }
        if (serviceToRemove != null && this.service instanceof ServiceFactory) {
            try {
                sBundle.fwCtx.perm.callUngetService(this, b, serviceToRemove);
            }
            catch (Throwable e) {
                sBundle.fwCtx.listeners.frameworkError(sBundle, e);
            }
        }
        dictionary = deps;
        synchronized (dictionary) {
            this.ungetInProgress.remove(b);
        }
        return true;
    }
}

