/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.ContentHandlerWrapper;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceContentHandlerFactory
implements ContentHandlerFactory {
    FrameworkContext framework;
    String[] jvmPkgs = null;
    Map wrapMap = new HashMap();
    static /* synthetic */ Class class$java$net$ContentHandler;

    ServiceContentHandlerFactory(FrameworkContext fw) {
        this.framework = fw;
        String s = this.framework.props.getProperty("java.content.handler.pkgs");
        if (s != null && s.length() > 0) {
            this.jvmPkgs = Util.splitwords(s, "|");
            for (int i = 0; i < this.jvmPkgs.length; ++i) {
                this.jvmPkgs[i] = this.jvmPkgs[i].trim();
                if (!this.framework.debug.url) continue;
                this.framework.debug.println("JVMClassPathCH - jvmPkgs[" + i + "]=" + this.jvmPkgs[i]);
            }
        }
    }

    public ContentHandler createContentHandler(String mimetype) {
        ContentHandler handler;
        if (this.framework.debug.url) {
            this.framework.debug.println("createContentHandler protocol=" + mimetype);
        }
        if ((handler = this.getJVMClassPathHandler(mimetype)) != null) {
            if (this.framework.debug.url) {
                this.framework.debug.println("using JVMClassPath handler for " + mimetype);
            }
            return handler;
        }
        handler = this.getServiceHandler(mimetype);
        if (handler != null) {
            if (this.framework.debug.url) {
                this.framework.debug.println("Using service ContentHandler for " + mimetype + ", handler=" + handler);
            }
            return handler;
        }
        if (this.framework.debug.url) {
            this.framework.debug.println("Using default ContentHandler for " + mimetype);
        }
        return null;
    }

    ContentHandler getServiceHandler(String mimetype) {
        try {
            String filter = "(url.content.mimetype=" + mimetype + ")";
            ServiceReference[] srl = this.framework.services.get((class$java$net$ContentHandler == null ? (class$java$net$ContentHandler = ServiceContentHandlerFactory.class$("java.net.ContentHandler")) : class$java$net$ContentHandler).getName(), filter, null);
            if (srl != null && srl.length > 0) {
                ContentHandlerWrapper wrapper = (ContentHandlerWrapper)this.wrapMap.get(mimetype);
                if (wrapper == null) {
                    wrapper = new ContentHandlerWrapper(this.framework, mimetype);
                    this.wrapMap.put(mimetype, wrapper);
                }
                return wrapper;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Failed to get service: " + e);
        }
        return null;
    }

    ContentHandler getJVMClassPathHandler(String mimetype) {
        if (this.jvmPkgs != null) {
            for (int i = 0; i < this.jvmPkgs.length; ++i) {
                String converted = ServiceContentHandlerFactory.convertMimetype(mimetype);
                String className = this.jvmPkgs[i] + "." + converted + ".Handler";
                try {
                    if (this.framework.debug.url) {
                        this.framework.debug.println("JVMClassPathCH - trying ContentHandler class=" + className);
                    }
                    Class<?> clazz = Class.forName(className);
                    ContentHandler handler = (ContentHandler)clazz.newInstance();
                    if (this.framework.debug.url) {
                        this.framework.debug.println("JVMClassPathCH - created ContentHandler class=" + className);
                    }
                    return handler;
                }
                catch (Throwable t) {
                    if (!this.framework.debug.url) continue;
                    this.framework.debug.println("JVMClassPathCH - no ContentHandler class " + className);
                    continue;
                }
            }
        }
        if (this.framework.debug.url) {
            this.framework.debug.println("JVMClassPath - no ContentHandler for " + mimetype);
        }
        return null;
    }

    static String convertMimetype(String s) {
        String bad = ".,:;*-";
        for (int i = 0; i < bad.length(); ++i) {
            s = s.replace(bad.charAt(i), '_');
        }
        s = s.replace('/', '.');
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

