/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.VersionRange;

class RequireBundle {
    final BundlePackages requestor;
    final String name;
    final String visibility;
    final String resolution;
    final VersionRange bundleRange;
    BundlePackages bpkgs = null;

    RequireBundle(RequireBundle parent, BundlePackages requestor) {
        this.requestor = requestor;
        this.name = parent.name;
        this.visibility = parent.visibility;
        this.resolution = parent.resolution;
        this.bundleRange = parent.bundleRange;
    }

    RequireBundle(BundlePackages requestor, String name, String visibility, String resolution, String range) {
        this.requestor = requestor;
        this.name = name;
        if (visibility != null) {
            this.visibility = visibility.intern();
            if (this.visibility != "private" && this.visibility != "reexport") {
                throw new IllegalArgumentException("Invalid directive : 'visibility:=" + this.visibility + "' in manifest header '" + "Require-Bundle" + ": " + this.name + "' of bundle with id " + this.requestor.bg.bundle.getBundleId() + " (" + this.requestor.bg.symbolicName + ")" + ". The value must be either '" + "private" + "' or '" + "reexport" + "'.");
            }
        } else {
            this.visibility = "private";
        }
        if (resolution != null) {
            this.resolution = resolution.intern();
            if (this.resolution != "mandatory" && this.resolution != "optional") {
                throw new IllegalArgumentException("Invalid directive : 'resolution:=" + this.resolution + "' in manifest header '" + "Require-Bundle" + ": " + this.name + "' of bundle with id " + this.requestor.bg.bundle.getBundleId() + " (" + this.requestor.bg.symbolicName + ")" + ". The value must be either '" + "mandatory" + "' or '" + "optional" + "'.");
            }
        } else {
            this.resolution = "mandatory";
        }
        this.bundleRange = range != null ? new VersionRange(range) : VersionRange.defaultVersionRange;
    }

    boolean overlap(RequireBundle rb) {
        if (this.visibility.equals("reexport") && !rb.visibility.equals("reexport")) {
            return false;
        }
        if (this.resolution.equals("mandatory") && !rb.resolution.equals("mandatory")) {
            return false;
        }
        return this.bundleRange.withinRange(rb.bundleRange);
    }
}

