/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import org.knopflerfish.framework.ClassAdapterPatcher;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.MethodInfo;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

class ReplaceMethodAdapter
extends MethodAdapter
implements Opcodes {
    ClassAdapterPatcher ca;
    FrameworkContext framework;

    public ReplaceMethodAdapter(MethodVisitor mv, ClassAdapterPatcher ca) {
        super(mv);
        this.ca = ca;
        this.framework = ca.framework;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        MethodInfo from0 = new MethodInfo(owner, name, desc, false);
        MethodInfo mi = this.ca.cp.findMethodInfo(from0);
        if (mi != null) {
            MethodInfo from = mi.key;
            if (from.filter != null) {
                this.ca.cp.matchProps.put("methodname", this.ca.currentMethodName);
                this.ca.cp.matchProps.put("methoddesc", this.ca.currentMethodDesc);
                this.ca.cp.matchProps.put("methodaccess", new Integer(this.ca.currentMethodAccess));
                if (!from.filter.evaluate(this.ca.cp.matchProps, false)) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
            }
            if (this.framework.debug.patch) {
                this.framework.debug.println("patch " + this.ca.className + "/" + this.ca.currentSuperName + "." + this.ca.currentMethodName + "\n " + from0.owner + "." + from.name + "\n " + mi.owner + "." + mi.name);
            }
            this.wrapMethod(mi);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    void wrapMethod(MethodInfo mi) {
        this.ca.bNeedBIDField = true;
        super.visitFieldInsn(178, this.ca.className, ClassAdapterPatcher.FIELD_BID, "J");
        if ((this.ca.currentMethodAccess & 8) != 0) {
            super.visitInsn(1);
        } else {
            super.visitVarInsn(25, 0);
        }
        super.visitMethodInsn(184, mi.owner, mi.name, mi.desc);
        mi.className = this.ca.className;
        ++mi.nPatches;
    }
}

