/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequireBundle;
import org.osgi.framework.Bundle;

class Packages {
    final FrameworkContext framework;
    private Hashtable packages = new Hashtable();
    private volatile HashSet tempResolved = null;
    private HashMap tempProvider = null;
    private HashMap tempRequired = null;
    private HashSet tempBlackList = null;
    private HashSet tempBackTracked = null;
    int tempBlackListChecks = 0;
    int tempBlackListHits = 0;

    Packages(FrameworkContext fw) {
        this.framework = fw;
    }

    void clear() {
        this.packages.clear();
        if (null != this.tempResolved) {
            this.tempResolved.clear();
        }
        if (null != this.tempProvider) {
            this.tempProvider.clear();
        }
        if (null != this.tempRequired) {
            this.tempRequired.clear();
        }
        if (null != this.tempBlackList) {
            this.tempBlackList.clear();
        }
        if (null != this.tempBackTracked) {
            this.tempBackTracked.clear();
        }
    }

    synchronized void registerPackages(Iterator exports, Iterator imports) {
        Pkg p;
        Object pe;
        while (exports.hasNext()) {
            pe = (ExportPkg)exports.next();
            p = (Pkg)this.packages.get(((ExportPkg)pe).name);
            if (p == null) {
                p = new Pkg(((ExportPkg)pe).name);
                this.packages.put(((ExportPkg)pe).name, p);
            }
            p.addExporter((ExportPkg)pe);
            if (!this.framework.debug.packages) continue;
            this.framework.debug.println("registerPackages: export, " + pe);
        }
        while (imports.hasNext()) {
            pe = (ImportPkg)imports.next();
            p = (Pkg)this.packages.get(((ImportPkg)pe).name);
            if (p == null) {
                p = new Pkg(((ImportPkg)pe).name);
                this.packages.put(((ImportPkg)pe).name, p);
            }
            p.addImporter((ImportPkg)pe);
            if (!this.framework.debug.packages) continue;
            this.framework.debug.println("registerPackages: import, " + pe);
        }
    }

    synchronized ExportPkg registerDynamicImport(ImportPkg ip) {
        if (this.framework.debug.packages) {
            this.framework.debug.println("registerDynamicImport: try " + ip);
        }
        ExportPkg res = null;
        Pkg p = (Pkg)this.packages.get(ip.name);
        if (p != null) {
            while (this.tempResolved != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException _ignore) {}
            }
            this.tempResolved = new HashSet();
            this.tempProvider = new HashMap();
            this.tempRequired = new HashMap();
            this.tempBlackList = new HashSet();
            this.tempBackTracked = new HashSet();
            this.backTrackUses(ip);
            this.tempBackTracked = null;
            ArrayList<ImportPkg> pkgs = new ArrayList<ImportPkg>(1);
            pkgs.add(ip);
            p.addImporter(ip);
            List r = this.resolvePackages(((AbstractList)pkgs).iterator());
            this.tempBlackList = null;
            if (r.size() == 0) {
                this.registerNewProviders(ip.bpkgs.bg.bundle);
                ip.provider = res = (ExportPkg)this.tempProvider.get(ip.name);
            } else {
                p.removeImporter(ip);
            }
            this.tempProvider = null;
            this.tempRequired = null;
            this.tempResolved = null;
            this.notifyAll();
        }
        if (this.framework.debug.packages) {
            this.framework.debug.println("registerDynamicImport: Done for " + ip.name + ", res = " + res);
        }
        return res;
    }

    synchronized boolean unregisterPackages(Iterator exports, Iterator imports, boolean force) {
        Pkg p;
        if (!force) {
            ArrayList<ExportPkg> saved = new ArrayList<ExportPkg>();
            Iterator i = exports;
            while (i.hasNext()) {
                ExportPkg ep = (ExportPkg)i.next();
                saved.add(ep);
                if (ep.bpkgs.isRequired()) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("unregisterPackages: Failed to unregister, " + ep + " is still in use via Require-Bundle.");
                    }
                    this.markAsZombies(saved, exports);
                    return false;
                }
                Pkg p2 = ep.pkg;
                if (!p2.providers.contains(ep)) continue;
                Iterator ii = ((AbstractList)p2.importers).iterator();
                while (ii.hasNext()) {
                    ImportPkg ip = (ImportPkg)ii.next();
                    if (ep != ip.provider || ep.bpkgs == ip.bpkgs) continue;
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("unregisterPackages: Failed to unregister, " + ep + " is still in use via import-package.");
                    }
                    this.markAsZombies(saved, exports);
                    return false;
                }
            }
            exports = ((AbstractList)saved).iterator();
        }
        while (exports.hasNext()) {
            ExportPkg ep = (ExportPkg)exports.next();
            p = ep.pkg;
            if (this.framework.debug.packages) {
                this.framework.debug.println("unregisterPackages: unregister export - " + ep);
            }
            p.removeExporter(ep);
            if (!p.isEmpty()) continue;
            this.packages.remove(ep.name);
        }
        while (imports.hasNext()) {
            ImportPkg ip = (ImportPkg)imports.next();
            p = ip.pkg;
            if (this.framework.debug.packages) {
                this.framework.debug.println("unregisterPackages: unregister import - " + ip.pkgString());
            }
            p.removeImporter(ip);
            if (!p.isEmpty()) continue;
            this.packages.remove(ip.name);
        }
        return true;
    }

    synchronized String resolve(BundleImpl bundle, Iterator pkgs) {
        String res;
        if (this.framework.debug.packages) {
            this.framework.debug.println("resolve: " + bundle);
        }
        while (this.tempResolved != null) {
            if (this.tempResolved.contains(bundle)) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException _ignore) {}
        }
        this.tempResolved = new HashSet();
        BundleImpl sb = this.checkBundleSingleton(bundle);
        if (sb != null) {
            this.tempResolved = null;
            return "Singleton bundle failed to resolve because " + sb + " is already resolved";
        }
        this.tempProvider = new HashMap();
        this.tempRequired = new HashMap();
        this.tempBlackList = new HashSet();
        this.tempResolved.add(bundle);
        String br = this.checkRequireBundle(bundle);
        if (br == null) {
            List failed = this.resolvePackages(pkgs);
            if (failed.size() == 0) {
                this.registerNewProviders(bundle);
                res = null;
            } else {
                StringBuffer r = new StringBuffer("missing package(s) or can not resolve all of the them: ");
                Iterator mi = failed.iterator();
                r.append(((ImportPkg)mi.next()).pkgString());
                while (mi.hasNext()) {
                    r.append(", ");
                    r.append(((ImportPkg)mi.next()).pkgString());
                }
                res = r.toString();
            }
        } else {
            res = "Failed to resolve required bundle or host: " + br;
        }
        this.tempResolved = null;
        this.tempProvider = null;
        this.tempRequired = null;
        this.tempBlackList = null;
        this.notifyAll();
        if (this.framework.debug.packages) {
            this.framework.debug.println("resolve: Done for " + bundle);
        }
        return res;
    }

    Pkg getPkg(String pkg) {
        return (Pkg)this.packages.get(pkg);
    }

    synchronized TreeSet getZombieAffected(Bundle[] bundles) {
        TreeSet<Bundle> affected = new TreeSet<Bundle>(new Comparator(){

            public int compare(Object o1, Object o2) {
                BundleImpl b1 = (BundleImpl)o1;
                BundleImpl b2 = (BundleImpl)o2;
                int dif = b1.getStartLevel() - b2.getStartLevel();
                if (dif == 0) {
                    dif = (int)(b1.getBundleId() - b2.getBundleId());
                }
                return dif;
            }

            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass());
            }
        });
        if (bundles == null) {
            if (this.framework.debug.packages) {
                this.framework.debug.println("getZombieAffected: check - null");
            }
            Iterator i = this.packages.values().iterator();
            while (i.hasNext()) {
                Pkg p = (Pkg)i.next();
                Iterator ps = ((AbstractList)p.exporters).iterator();
                while (ps.hasNext()) {
                    ExportPkg ep = (ExportPkg)ps.next();
                    if (!ep.zombie) continue;
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("getZombieAffected: found zombie - " + ep);
                    }
                    affected.add(ep.bpkgs.bg.bundle);
                }
            }
        } else {
            for (int i = 0; i < bundles.length; ++i) {
                BundleImpl tmp = (BundleImpl)bundles[i];
                if (tmp == null) continue;
                if (this.framework.debug.packages) {
                    this.framework.debug.println("getZombieAffected: check - " + bundles[i]);
                }
                affected.add(tmp);
                Vector h = tmp.getHosts(true);
                if (h == null) continue;
                Iterator hi = ((AbstractList)h).iterator();
                while (hi.hasNext()) {
                    affected.add(((BundleGeneration)hi.next()).bundle);
                }
            }
        }
        ArrayList<Bundle> moreBundles = new ArrayList<Bundle>(affected);
        for (int i = 0; i < moreBundles.size(); ++i) {
            BundleImpl b = (BundleImpl)moreBundles.get(i);
            Iterator j = b.getExports();
            while (j.hasNext()) {
                ExportPkg ep = (ExportPkg)j.next();
                if (ep.pkg != null && ep.pkg.providers.contains(ep)) {
                    Iterator k = ep.getPackageImporters().iterator();
                    while (k.hasNext()) {
                        Bundle ib = (Bundle)k.next();
                        if (affected.contains(ib)) continue;
                        moreBundles.add(ib);
                        if (this.framework.debug.packages) {
                            this.framework.debug.println("getZombieAffected: added importing bundle - " + ib);
                        }
                        affected.add(ib);
                    }
                }
                Iterator rbi = ep.bpkgs.getRequiredBy().iterator();
                while (rbi.hasNext()) {
                    BundlePackages rbpkgs = (BundlePackages)rbi.next();
                    BundleImpl rb = rbpkgs.bg.bundle;
                    if (affected.contains(rb)) continue;
                    moreBundles.add(rb);
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("getZombieAffected: added requiring bundle - " + rb);
                    }
                    affected.add(rb);
                }
            }
        }
        return affected;
    }

    private boolean backTrackUses(ImportPkg ip) {
        if (this.framework.debug.packages) {
            this.framework.debug.println("backTrackUses: check - " + ip.pkgString());
        }
        if (this.tempBackTracked.contains(ip.bpkgs)) {
            return false;
        }
        this.tempBackTracked.add(ip.bpkgs);
        Iterator i = this.getPackagesProvidedBy(ip.bpkgs).iterator();
        if (i.hasNext()) {
            do {
                ExportPkg ep = (ExportPkg)i.next();
                boolean foundUses = false;
                Iterator ii = ((AbstractList)ep.pkg.importers).iterator();
                while (ii.hasNext()) {
                    ImportPkg iip = (ImportPkg)ii.next();
                    if (iip.provider != ep || !this.backTrackUses(iip)) continue;
                    foundUses = true;
                }
                if (foundUses) continue;
                this.checkUses(ep);
            } while (i.hasNext());
            return true;
        }
        return false;
    }

    private void markAsZombies(List e1, Iterator e2) {
        Iterator i = e1.iterator();
        while (i.hasNext()) {
            ((ExportPkg)i.next()).zombie = true;
        }
        while (e2.hasNext()) {
            ((ExportPkg)e2.next()).zombie = true;
        }
    }

    private Collection getPackagesProvidedBy(BundlePackages bpkgs) {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>();
        Iterator i = bpkgs.getExports();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            if (!ep.pkg.providers.contains(ep)) continue;
            res.add(ep);
        }
        return res;
    }

    private List resolvePackages(Iterator pkgs) {
        ArrayList<ImportPkg> res = new ArrayList<ImportPkg>();
        while (pkgs.hasNext()) {
            ExportPkg provider = null;
            ImportPkg ip = (ImportPkg)pkgs.next();
            if (ip.provider != null) {
                this.framework.listeners.frameworkError(ip.bpkgs.bg.bundle, (Throwable)new Exception("resolvePackages: InternalError1!"));
            }
            if (this.framework.debug.packages) {
                this.framework.debug.println("resolvePackages: check - " + ip.pkgString());
            }
            if ((provider = (ExportPkg)this.tempProvider.get(ip.name)) != null) {
                if (this.framework.debug.packages) {
                    this.framework.debug.println("resolvePackages: " + ip.name + " - has temporary provider - " + provider);
                }
                if (provider.zombie && provider.bpkgs.bg.bundle.state == 1) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("resolvePackages: " + ip.name + " - provider not used since it is an uninstalled zombie - " + provider);
                    }
                    provider = null;
                } else if (!ip.checkAttributes(provider)) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("resolvePackages: " + ip.name + " - provider has wrong attributes - " + provider);
                    }
                    provider = null;
                } else if (ip.bpkgs != provider.bpkgs && !ip.checkPermission(provider)) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("resolvePackages: " + ip.name + " -  has no permission to use - " + provider);
                    }
                    provider = null;
                }
            } else {
                Iterator i = ((AbstractList)ip.pkg.providers).iterator();
                while (i.hasNext()) {
                    ExportPkg ep = (ExportPkg)i.next();
                    ++this.tempBlackListChecks;
                    if (this.tempBlackList.contains(ep)) {
                        ++this.tempBlackListHits;
                        continue;
                    }
                    if (ep.zombie || !ip.checkAttributes(ep)) continue;
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("resolvePackages: " + ip.name + " - has provider - " + ep);
                    }
                    if (ip.checkPermission(ep)) {
                        HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                        if (!this.checkUses(ep)) {
                            this.tempProvider = oldTempProvider;
                            this.tempBlackList.add(ep);
                            continue;
                        }
                        provider = ep;
                        break;
                    }
                    if (!this.framework.debug.packages) continue;
                    this.framework.debug.println("resolvePackages: no permission for - " + ep);
                }
                if (provider == null) {
                    provider = this.pickProvider(ip);
                }
                if (provider != null) {
                    this.tempProvider.put(ip.pkg.pkg, provider);
                }
            }
            if (provider != null) continue;
            if (ip.mustBeResolved()) {
                res.add(ip);
                continue;
            }
            if (!this.framework.debug.packages) continue;
            this.framework.debug.println("resolvePackages: Ok, no provider for optional " + ip.name);
        }
        return res;
    }

    private ExportPkg pickProvider(ImportPkg ip) {
        ExportPkg ep;
        if (this.framework.debug.packages) {
            this.framework.debug.println("pickProvider: for - " + ip);
        }
        ArrayList<ExportPkg> possibleProvider = new ArrayList<ExportPkg>(ip.pkg.exporters.size());
        Iterator i = ((AbstractList)ip.pkg.exporters).iterator();
        while (i.hasNext()) {
            ep = (ExportPkg)i.next();
            ++this.tempBlackListChecks;
            if (this.tempBlackList.contains(ep)) {
                ++this.tempBlackListHits;
                continue;
            }
            if (!ip.checkAttributes(ep)) {
                if (!this.framework.debug.packages) continue;
                this.framework.debug.println("pickProvider: attribute match failed for - " + ep);
                continue;
            }
            if (!ip.checkPermission(ep)) {
                if (ip.bpkgs == ep.bpkgs) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("pickProvider: internal wire ok for - " + ep);
                    }
                    ip.internalOk = ep;
                }
                if (!this.framework.debug.packages) continue;
                this.framework.debug.println("pickProvider: no import permission for - " + ep);
                continue;
            }
            if (!ep.checkPermission()) {
                if (!this.framework.debug.packages) continue;
                this.framework.debug.println("pickProvider: no export permission for - " + ep);
                continue;
            }
            if ((ep.bpkgs.bg.bundle.state & 0x3C) != 0) {
                HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                if (this.checkUses(ep)) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("pickProvider: " + ip + " - got resolved provider - " + ep);
                    }
                    return ep;
                }
                this.tempProvider = oldTempProvider;
                this.tempBlackList.add(ep);
                continue;
            }
            if (ep.bpkgs.bg.bundle.state != 2) continue;
            possibleProvider.add(ep);
        }
        i = ((AbstractList)possibleProvider).iterator();
        while (i.hasNext()) {
            ep = (ExportPkg)i.next();
            if (this.framework.debug.packages) {
                this.framework.debug.println("pickProvider: check possible provider - " + ep);
            }
            if (!this.tempResolved.contains(ep.bpkgs.bg.bundle) && !this.checkResolve(ep.bpkgs.bg.bundle, ep)) continue;
            if (this.framework.debug.packages) {
                this.framework.debug.println("pickProvider: " + ip + " - got provider - " + ep);
            }
            return ep;
        }
        if (this.framework.debug.packages) {
            this.framework.debug.println("pickProvider: " + ip + " - found no provider");
        }
        return null;
    }

    private boolean checkResolve(BundleImpl b, ExportPkg ep) {
        if (this.checkBundleSingleton(b) == null) {
            List r;
            HashSet oldTempResolved = (HashSet)this.tempResolved.clone();
            HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
            HashMap oldTempRequired = (HashMap)this.tempRequired.clone();
            HashSet oldTempBlackList = (HashSet)this.tempBlackList.clone();
            if (ep != null) {
                this.tempProvider.put(ep.pkg.pkg, ep);
            }
            this.tempResolved.add(b);
            if (this.checkRequireBundle(b) == null && (r = this.resolvePackages(b.gen.bpkgs.getImports())).size() == 0) {
                return true;
            }
            this.tempResolved = oldTempResolved;
            this.tempProvider = oldTempProvider;
            this.tempRequired = oldTempRequired;
            this.tempBlackList = oldTempBlackList;
        }
        return false;
    }

    private boolean checkUses(ExportPkg pkg) {
        Iterator ui = null;
        String next_uses = null;
        if (this.framework.debug.packages) {
            this.framework.debug.println("checkUses: check if packages used by " + pkg + " is okay.");
        }
        if (pkg.uses != null && (ui = pkg.uses.iterator()).hasNext()) {
            next_uses = (String)ui.next();
        }
        if (this.framework.debug.packages) {
            this.framework.debug.println("checkUses: provider with bpkgs=" + pkg.bpkgs);
        }
        ArrayList<ExportPkg> checkList = new ArrayList<ExportPkg>();
        Iterator i = pkg.bpkgs.getActiveImports();
        while (i.hasNext()) {
            ImportPkg ip = (ImportPkg)i.next();
            if (ui != null) {
                if (next_uses == null || !ip.pkg.pkg.equals(next_uses)) continue;
                next_uses = ui.hasNext() ? (String)ui.next() : null;
            }
            ExportPkg ep = (ExportPkg)this.tempProvider.get(ip.pkg.pkg);
            if (this.framework.debug.packages) {
                this.framework.debug.println("checkUses: check import, " + ip + " with provider, " + ip.provider);
            }
            if (ep == null) {
                this.tempProvider.put(ip.pkg.pkg, ip.provider);
                checkList.add(ip.provider);
                continue;
            }
            if (ep == ip.provider) continue;
            if (this.framework.debug.packages) {
                this.framework.debug.println("checkUses: mismatch in providers for, " + ip.pkg.pkg);
            }
            return false;
        }
        i = ((AbstractList)checkList).iterator();
        while (i.hasNext()) {
            if (this.checkUses((ExportPkg)i.next())) continue;
            return false;
        }
        if (this.framework.debug.packages) {
            this.framework.debug.println("checkUses: package " + pkg + " is okay.");
        }
        return true;
    }

    private BundleImpl checkBundleSingleton(BundleImpl b) {
        if (b.gen.symbolicName != null && b.gen.singleton) {
            List bl;
            if (this.framework.debug.packages) {
                this.framework.debug.println("checkBundleSingleton: check singleton bundle " + b);
            }
            if ((bl = this.framework.bundles.getBundles(b.gen.symbolicName)).size() > 1) {
                Iterator i = bl.iterator();
                while (i.hasNext()) {
                    BundleImpl b2 = (BundleImpl)i.next();
                    if (!b2.gen.singleton || (b2.state & 0x3C) == 0 && !this.tempResolved.contains(b2)) continue;
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("checkBundleSingleton: Reject because of bundle: " + b2);
                    }
                    return b2;
                }
            }
        }
        return null;
    }

    private String checkRequireBundle(BundleImpl b) {
        Iterator i = b.gen.bpkgs.getRequire();
        if (i != null) {
            if (this.framework.debug.packages) {
                this.framework.debug.println("checkRequireBundle: check requiring bundle " + b);
            }
            if (!this.framework.perm.okRequireBundlePerm(b)) {
                return b.gen.symbolicName;
            }
            HashMap<RequireBundle, BundlePackages> res = new HashMap<RequireBundle, BundlePackages>();
            do {
                RequireBundle br = (RequireBundle)i.next();
                List bl = this.framework.bundles.getBundles(br.name, br.bundleRange);
                BundleImpl ok = null;
                Iterator bci = bl.iterator();
                while (bci.hasNext() && ok == null) {
                    BundleImpl b2 = (BundleImpl)bci.next();
                    if (this.tempResolved.contains(b2)) {
                        ok = b2;
                        continue;
                    }
                    if ((b2.state & 0x3C) != 0) {
                        HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                        ok = b2;
                        Iterator epi = b2.gen.bpkgs.getExports();
                        while (epi.hasNext()) {
                            ExportPkg ep = (ExportPkg)epi.next();
                            if (this.checkUses(ep)) continue;
                            this.tempProvider = oldTempProvider;
                            this.tempBlackList.add(ep);
                            ok = null;
                        }
                        continue;
                    }
                    if (b2.state != 2 || !this.framework.perm.okProvideBundlePerm(b2) || !this.checkResolve(b2, null)) continue;
                    ok = b2;
                }
                if (ok != null) {
                    if (this.framework.debug.packages) {
                        this.framework.debug.println("checkRequireBundle: added required bundle " + ok);
                    }
                    res.put(br, ok.gen.bpkgs);
                    continue;
                }
                if (br.resolution != "mandatory") continue;
                if (this.framework.debug.packages) {
                    this.framework.debug.println("checkRequireBundle: failed to satisfy: " + br.name);
                }
                return br.name;
            } while (i.hasNext());
            this.tempRequired.putAll(res);
        }
        return null;
    }

    private void registerNewProviders(BundleImpl bundle) {
        Iterator<Object> i = this.tempProvider.values().iterator();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            ep.pkg.addProvider(ep);
        }
        i = this.tempRequired.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            BundlePackages bpkgs = (BundlePackages)e.getValue();
            RequireBundle br = (RequireBundle)e.getKey();
            br.bpkgs = bpkgs;
            bpkgs.addRequiredBy(br.requestor);
            if (this.framework.debug.packages) {
                this.framework.debug.println("registerNewProviders: 'Require-Bundle: " + br.name + "' for " + br.requestor.bg.bundle.getBundleId() + " bound to (id=" + bpkgs.bg.bundle.getBundleId() + ",gen=" + bpkgs.bg.generation + ")");
            }
            if (br.visibility != "reexport") continue;
            Iterator be = bpkgs.getExports();
            while (be.hasNext()) {
                ExportPkg ep = (ExportPkg)be.next();
                br.requestor.checkReExport(ep);
                if (!this.framework.debug.packages) continue;
                this.framework.debug.println("registerNewProviders: " + br.requestor.bg.bundle.getBundleId() + " reexports package " + ep.name);
            }
        }
        i = this.tempResolved.iterator();
        while (i.hasNext()) {
            BundleImpl bs = (BundleImpl)i.next();
            if (bs.getState() != 2) continue;
            Iterator bi = bs.gen.bpkgs.getImports();
            while (bi.hasNext()) {
                ImportPkg ip = (ImportPkg)bi.next();
                ExportPkg ep = (ExportPkg)this.tempProvider.get(ip.name);
                if (ep == null) {
                    if (ip.internalOk == null) continue;
                    if (ip.internalOk.pkg.providers.isEmpty() && ip.internalOk.checkPermission()) {
                        ip.internalOk.pkg.addProvider(ip.internalOk);
                        if (!this.framework.debug.packages) continue;
                        this.framework.debug.println("registerNewProviders: exported internal wire, " + ip + " -> " + ip.internalOk);
                        continue;
                    }
                    if (!this.framework.debug.packages) continue;
                    this.framework.debug.println("registerNewProviders: internal wire, " + ip + " -> " + ip.internalOk);
                    continue;
                }
                if (ip.checkAttributes(ep) && ip.checkPermission(ep)) {
                    ip.provider = ep;
                    continue;
                }
                if (ip.internalOk == null) continue;
                if (ip.internalOk == ep) {
                    if (!this.framework.debug.packages) continue;
                    this.framework.debug.println("registerNewProviders: internal wire, " + ip + ", " + ep);
                    continue;
                }
                this.framework.listeners.frameworkError(bs, (Throwable)new Exception("registerNewProviders: Warning! Internal wire for, " + ip + ", does not match exported. " + ep));
            }
            if (bs == bundle || bs.getUpdatedState() != 2) continue;
            this.framework.listeners.frameworkError(bs, (Throwable)new Exception("registerNewProviders: InternalError!"));
        }
    }
}

