/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ListenerEntry;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceListenerState;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

class Listeners {
    private HashSet bundleListeners = new HashSet();
    private HashSet syncBundleListeners = new HashSet();
    private HashSet frameworkListeners = new HashSet();
    ServiceListenerState serviceListeners;
    private LinkedList asyncEventQueue = null;
    private AsyncEventThread[] threads = null;
    private HashMap activeListeners = null;
    private PermissionOps secure;
    FrameworkContext framework;
    boolean nocacheldap;
    volatile boolean quit = false;

    Listeners(FrameworkContext framework, PermissionOps perm) {
        this.framework = framework;
        this.secure = perm;
        this.nocacheldap = framework.props.getBooleanProperty("org.knopflerfish.framework.ldap.nocache");
        this.serviceListeners = new ServiceListenerState(this);
        String ets = framework.props.getProperty("org.knopflerfish.framework.listener.n_threads");
        int n_threads = 1;
        if (ets != null) {
            try {
                n_threads = Integer.parseInt(ets);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (n_threads > 0) {
            this.asyncEventQueue = new LinkedList();
            this.threads = new AsyncEventThread[n_threads];
            for (int i = 0; i < n_threads; ++i) {
                this.threads[i] = new AsyncEventThread(i);
                this.threads[i].start();
            }
            if (n_threads > 1) {
                this.activeListeners = new HashMap();
            }
        }
    }

    void clear() {
        this.bundleListeners.clear();
        this.syncBundleListeners.clear();
        this.frameworkListeners.clear();
        this.serviceListeners.clear();
        this.secure = null;
        this.framework = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(BundleContextImpl bc, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        if (listener instanceof SynchronousBundleListener) {
            this.secure.checkListenerAdminPerm(bc.bundle);
            HashSet hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.syncBundleListeners.add(le);
            }
        }
        HashSet hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(BundleContextImpl bc, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        if (listener instanceof SynchronousBundleListener) {
            HashSet hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.secure.checkListenerAdminPerm(bc.bundle);
                this.syncBundleListeners.remove(le);
            }
        }
        HashSet hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.remove(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(BundleContextImpl bc, FrameworkListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(BundleContextImpl bc, FrameworkListener listener) {
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.remove(new ListenerEntry(bc, listener));
        }
    }

    void addServiceListener(BundleContextImpl bc, ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.serviceListeners.add(bc, listener, filter);
    }

    void removeServiceListener(BundleContextImpl bc, ServiceListener listener) {
        this.serviceListeners.remove(bc, listener);
    }

    void removeAllListeners(BundleContextImpl bc) {
        this.removeAllListeners(this.syncBundleListeners, bc);
        this.removeAllListeners(this.bundleListeners, bc);
        this.removeAllListeners(this.frameworkListeners, bc);
        this.serviceListeners.removeAll(bc);
    }

    void frameworkError(Bundle b, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(2, b, t));
    }

    void frameworkError(BundleContextImpl bc, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(2, bc.bundle, t));
    }

    void frameworkInfo(Bundle b, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(32, b, t));
    }

    void frameworkWarning(Bundle b, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(16, b, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bundleChanged(BundleEvent evt) {
        int i2;
        ListenerEntry[] sbl;
        ListenerEntry[] bl = null;
        int type = evt.getType();
        HashSet hashSet = this.syncBundleListeners;
        synchronized (hashSet) {
            sbl = new ListenerEntry[this.syncBundleListeners.size()];
            ((AbstractCollection)this.syncBundleListeners).toArray(sbl);
        }
        if (type != 512 && type != 128 && type != 256) {
            hashSet = this.bundleListeners;
            synchronized (hashSet) {
                bl = new ListenerEntry[this.bundleListeners.size()];
                ((AbstractCollection)this.bundleListeners).toArray(bl);
            }
        }
        for (i2 = 0; i2 < sbl.length; ++i2) {
            this.bundleChanged(sbl[i2], evt);
        }
        if (bl != null) {
            if (this.asyncEventQueue != null) {
                LinkedList i2 = this.asyncEventQueue;
                synchronized (i2) {
                    for (int i3 = 0; i3 < bl.length; ++i3) {
                        this.asyncEventQueue.addLast(new AsyncEvent(bl[i3], evt));
                    }
                    this.asyncEventQueue.notify();
                }
            } else {
                for (i2 = 0; i2 < bl.length; ++i2) {
                    this.bundleChanged(bl[i2], evt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void frameworkEvent(FrameworkEvent evt) {
        ListenerEntry[] fl;
        if (this.framework.debug.errors && evt.getType() == 2) {
            this.framework.debug.println("errors - FrameworkErrorEvent bundle #" + evt.getBundle().getBundleId());
            this.framework.debug.printStackTrace("errors - FrameworkErrorEvent throwable: ", evt.getThrowable());
        }
        if (this.framework.debug.warnings && evt.getType() == 16) {
            this.framework.debug.println("warnings - FrameworkErrorEvent bundle #" + evt.getBundle().getBundleId());
            this.framework.debug.printStackTrace("warnings - FrameworkErrorEvent throwable: ", evt.getThrowable());
        }
        if (this.asyncEventQueue != null) {
            LinkedList linkedList = this.asyncEventQueue;
            synchronized (linkedList) {
                HashSet hashSet = this.frameworkListeners;
                synchronized (hashSet) {
                    Iterator i = this.frameworkListeners.iterator();
                    while (i.hasNext()) {
                        this.asyncEventQueue.addLast(new AsyncEvent((ListenerEntry)i.next(), evt));
                    }
                    this.asyncEventQueue.notify();
                }
            }
        }
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            fl = new ListenerEntry[this.frameworkListeners.size()];
            ((AbstractCollection)this.frameworkListeners).toArray(fl);
        }
        for (int i = 0; i < fl.length; ++i) {
            this.frameworkEvent(fl[i], evt);
        }
    }

    void serviceChanged(Collection receivers, ServiceEvent evt, Set matchBefore) {
        ServiceReferenceImpl sr = (ServiceReferenceImpl)evt.getServiceReference();
        String[] classes = (String[])sr.getProperty("objectClass");
        int n = 0;
        this.framework.hooks.filterServiceEventReceivers(evt, receivers);
        Iterator it = receivers.iterator();
        while (it.hasNext()) {
            block8: {
                ServiceListenerEntry l = (ServiceListenerEntry)it.next();
                if (matchBefore != null) {
                    matchBefore.remove(l);
                }
                try {
                    if (l.isRemoved() || this.secure.checkPermissions() && !l.bc.bundle.hasPermission(new ServicePermission(sr, "get"))) break block8;
                    boolean testAssignable = !(l.listener instanceof AllServiceListener);
                    for (int i = 0; i < classes.length; ++i) {
                        if (testAssignable && !sr.isAssignableTo(l.bc.bundle, classes[i])) continue;
                        try {
                            ((ServiceListener)l.listener).serviceChanged(evt);
                        }
                        catch (Throwable pe) {
                            this.frameworkError(l.bc, pe);
                        }
                        break;
                    }
                }
                catch (IllegalStateException ignore) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (this.framework.debug.ldap) {
            this.framework.debug.println("Notified " + n + " listeners");
        }
    }

    Set getMatchingServiceListeners(ServiceReference sr) {
        return this.serviceListeners.getMatchingListeners((ServiceReferenceImpl)sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllListeners(Set s, BundleContext bc) {
        Set set = s;
        synchronized (set) {
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (((ListenerEntry)i.next()).bc != bc) continue;
                i.remove();
            }
        }
    }

    private void bundleChanged(ListenerEntry le, BundleEvent evt) {
        try {
            ((BundleListener)le.listener).bundleChanged(evt);
        }
        catch (Throwable pe) {
            this.frameworkError(le.bc, pe);
        }
    }

    private void frameworkEvent(ListenerEntry le, FrameworkEvent evt) {
        block2: {
            try {
                ((FrameworkListener)le.listener).frameworkEvent(evt);
            }
            catch (Exception pe) {
                if (evt.getType() == 2) break block2;
                this.frameworkError(le.bc, (Throwable)pe);
            }
        }
    }

    private class AsyncEventThread
    extends Thread {
        AsyncEventThread(int i) {
            super(Listeners.this.framework.threadGroup, "AsyncEventThread#" + i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                AsyncEvent ae;
                Cloneable cloneable = Listeners.this.asyncEventQueue;
                synchronized (cloneable) {
                    while (!Listeners.this.quit && Listeners.this.asyncEventQueue.isEmpty()) {
                        try {
                            Listeners.this.asyncEventQueue.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    if (Listeners.this.quit) {
                        break;
                    }
                    ae = (AsyncEvent)Listeners.this.asyncEventQueue.removeFirst();
                }
                if (Listeners.this.activeListeners != null) {
                    cloneable = Listeners.this.activeListeners;
                    synchronized (cloneable) {
                        while (Listeners.this.activeListeners.containsKey(ae.le)) {
                            try {
                                Listeners.this.activeListeners.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        Listeners.this.activeListeners.put(ae.le, Thread.currentThread());
                    }
                }
                if (ae.le.bc.isValid()) {
                    if (ae.evt instanceof BundleEvent) {
                        Listeners.this.bundleChanged(ae.le, (BundleEvent)ae.evt);
                    } else {
                        Listeners.this.frameworkEvent(ae.le, (FrameworkEvent)ae.evt);
                    }
                }
                if (Listeners.this.activeListeners == null) continue;
                cloneable = Listeners.this.activeListeners;
                synchronized (cloneable) {
                    Listeners.this.activeListeners.remove(ae.le);
                    Listeners.this.activeListeners.notifyAll();
                }
            }
        }
    }

    static class AsyncEvent {
        final ListenerEntry le;
        final EventObject evt;

        AsyncEvent(ListenerEntry le, EventObject evt) {
            this.le = le;
            this.evt = evt;
        }
    }
}

