/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.knopflerfish.framework.Util;

public class IteratorIteratorSorted
implements Iterator {
    private final Iterator[] iter;
    private final Object[] top;
    private final Util.Comparator comp;
    int size;

    public IteratorIteratorSorted(List ilist, Util.Comparator comp) {
        this.comp = comp;
        this.size = ilist.size();
        this.iter = new Iterator[this.size + 1];
        this.top = new Object[this.size + 1];
        int pos = 1;
        Iterator i = ilist.iterator();
        while (i.hasNext()) {
            Iterator si = (Iterator)i.next();
            if (si.hasNext()) {
                this.top[pos] = si.next();
                this.iter[pos++] = si;
                continue;
            }
            --this.size;
        }
        for (pos = this.size / 2; pos > 0; --pos) {
            this.balance(pos);
        }
    }

    public boolean hasNext() {
        return this.size > 0;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        if (this.hasNext()) {
            Object res = this.top[1];
            if (this.iter[1].hasNext()) {
                this.top[1] = this.iter[1].next();
            } else {
                this.top[1] = this.top[this.size];
                this.iter[1] = this.iter[this.size--];
            }
            this.balance(1);
            return res;
        }
        throw new NoSuchElementException();
    }

    private void balance(int current) {
        Object tmp = this.top[current];
        Iterator itmp = this.iter[current];
        while (current * 2 <= this.size) {
            int child = current * 2;
            if (child != this.size && this.comp.compare(this.top[child + 1], this.top[child]) > 0) {
                ++child;
            }
            if (this.comp.compare(this.top[child], tmp) <= 0) break;
            this.top[current] = this.top[child];
            this.iter[current] = this.iter[child];
            current = child;
        }
        this.top[current] = tmp;
        this.iter[current] = itmp;
    }
}

