/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Policy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ExtensionContext;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Hooks;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.SecurePermissionOps;
import org.knopflerfish.framework.ServiceContentHandlerFactory;
import org.knopflerfish.framework.ServiceURLStreamHandlerFactory;
import org.knopflerfish.framework.Services;
import org.knopflerfish.framework.StartLevelController;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.KFSecurityManager;
import org.osgi.framework.Bundle;

public class FrameworkContext {
    static final String SPEC_VERSION = "1.5";
    static final String LAUNCH_VERSION = "1.0";
    static final String HOOKS_VERSION = "1.0";
    public Debug debug;
    Bundles bundles;
    Listeners listeners;
    Hooks hooks;
    Packages packages;
    Services services;
    PermissionOps perm;
    SystemBundle systemBundle;
    BundleStorage storage;
    List validator = null;
    FileTree dataStorage;
    StartLevelController startLevelController;
    ServiceURLStreamHandlerFactory urlStreamHandlerFactory;
    ServiceContentHandlerFactory contentHandlerFactory;
    ArrayList bootDelegationPatterns;
    boolean bootDelegationUsed;
    ClassLoader parentClassLoader;
    boolean firstInit = true;
    private Set eeCacheSet = new HashSet();
    private String eeCache = null;
    final int id;
    public FWProps props;
    public ThreadGroup threadGroup;
    LinkedList bundleThreads;
    static volatile ServiceURLStreamHandlerFactory systemUrlStreamHandlerFactory;
    static volatile ServiceContentHandlerFactory systemContentHandlerFactory;
    static Object globalFwLock;
    static int globalId;
    static int smUse;
    private final List extCtxs = new ArrayList();
    static /* synthetic */ Class class$org$knopflerfish$framework$FrameworkContext;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrameworkContext(Map initProps) {
        Object object = globalFwLock;
        synchronized (object) {
            this.id = globalId++;
        }
        this.threadGroup = new ThreadGroup("FW#" + this.id);
        this.props = new FWProps(initProps, this);
        this.perm = new SecurePermissionOps(this);
        this.systemBundle = new SystemBundle(this);
        this.log("created");
    }

    public ClassLoader getClassLoader(String clazz) {
        ExportPkg ep;
        Pkg p;
        int pos;
        if (clazz != null && (pos = clazz.lastIndexOf(46)) != -1 && (p = this.packages.getPkg(clazz.substring(0, pos))) != null && (ep = p.getBestProvider()) != null) {
            return ep.bpkgs.bg.getClassLoader();
        }
        return this.systemBundle.getClassLoader();
    }

    void init() {
        this.log("initializing");
        if (this.firstInit && "onFirstInit".equals(this.props.getProperty("org.osgi.framework.storage.clean"))) {
            this.deleteFWDir();
            this.firstInit = false;
        }
        this.buildBootDelegationPatterns();
        this.selectBootDelegationParentClassLoader();
        if (this.setSecurityManager()) {
            this.systemBundle.secure = this.perm;
        } else {
            this.perm = new PermissionOps();
        }
        this.perm.init();
        String v = this.props.getProperty("org.knopflerfish.framework.validator");
        if (!v.equalsIgnoreCase("none") && !v.equalsIgnoreCase("null")) {
            this.validator = new ArrayList();
            int start = 0;
            while (start < v.length()) {
                int end = v.indexOf(44, start);
                if (end == -1) {
                    end = v.length();
                }
                String vs = "org.knopflerfish.framework.validator." + v.substring(start, end).trim();
                try {
                    Class<?> vi = Class.forName(vs);
                    Constructor<?> vc = vi.getConstructor(class$org$knopflerfish$framework$FrameworkContext == null ? FrameworkContext.class$("org.knopflerfish.framework.FrameworkContext") : class$org$knopflerfish$framework$FrameworkContext);
                    this.validator.add((Validator)vc.newInstance(this));
                }
                catch (InvocationTargetException ite) {
                    System.err.println("Construct of " + vs + " failed: " + ite.getTargetException());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(vs + ", found no such Validator", e);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new RuntimeException(vs + ", Validator not supported by JVM", ncdfe);
                }
                catch (Exception e) {
                    throw new RuntimeException(vs + ", failed to construct Validator", e);
                }
                start = end + 1;
            }
        }
        if (null == this.urlStreamHandlerFactory) {
            if (this.props.REGISTERSERVICEURLHANDLER) {
                if (systemUrlStreamHandlerFactory != null) {
                    this.urlStreamHandlerFactory = systemUrlStreamHandlerFactory;
                    this.contentHandlerFactory = systemContentHandlerFactory;
                    this.urlStreamHandlerFactory.addFramework(this);
                } else {
                    this.urlStreamHandlerFactory = new ServiceURLStreamHandlerFactory(this);
                    this.contentHandlerFactory = new ServiceContentHandlerFactory(this);
                    try {
                        URL.setURLStreamHandlerFactory(this.urlStreamHandlerFactory);
                        URLConnection.setContentHandlerFactory(this.contentHandlerFactory);
                        systemContentHandlerFactory = this.contentHandlerFactory;
                        systemUrlStreamHandlerFactory = this.urlStreamHandlerFactory;
                    }
                    catch (Throwable e) {
                        this.debug.printStackTrace("Cannot set global URL handlers, continuing without OSGi service URL handler (" + e + ")", e);
                    }
                }
            } else {
                this.urlStreamHandlerFactory = new ServiceURLStreamHandlerFactory(this);
                this.contentHandlerFactory = new ServiceContentHandlerFactory(this);
            }
        }
        String storageClass = "org.knopflerfish.framework.bundlestorage." + this.props.getProperty("org.knopflerfish.framework.bundlestorage") + ".BundleStorageImpl";
        try {
            Class<?> storageImpl = Class.forName(storageClass);
            Constructor<?> cons = storageImpl.getConstructor(class$org$knopflerfish$framework$FrameworkContext == null ? (class$org$knopflerfish$framework$FrameworkContext = FrameworkContext.class$("org.knopflerfish.framework.FrameworkContext")) : class$org$knopflerfish$framework$FrameworkContext);
            this.storage = (BundleStorage)cons.newInstance(this);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)e).getTargetException();
            }
            throw new RuntimeException("Failed to initialize storage " + storageClass, cause);
        }
        this.dataStorage = Util.getFileStorage(this, "data");
        this.bundleThreads = new LinkedList();
        this.packages = new Packages(this);
        this.listeners = new Listeners(this, this.perm);
        this.services = new Services(this, this.perm);
        this.urlStreamHandlerFactory.addFramework(this);
        this.systemBundle.initSystemBundle();
        this.bundles = new Bundles(this);
        this.hooks = new Hooks(this);
        this.hooks.open();
        this.perm.registerService();
        String[] classes = new String[]{(class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = FrameworkContext.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName()};
        this.services.register(this.systemBundle, classes, new PackageAdminImpl(this), null);
        this.registerStartLevel();
        this.bundles.load();
        this.log("inited");
        this.log("Installed bundles:");
        BundleArchive[] allBAs = this.storage.getAllBundleArchives();
        for (int i = 0; i < allBAs.length; ++i) {
            BundleArchive ba = allBAs[i];
            Bundle b = this.bundles.getBundle(ba.getBundleLocation());
            this.log(" #" + b.getBundleId() + " " + b.getSymbolicName() + ":" + b.getVersion() + " location:" + b.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninit() {
        this.log("uninit");
        this.startLevelController = null;
        this.systemBundle.uninitSystemBundle();
        this.bundles.clear();
        this.bundles = null;
        this.services.clear();
        this.services = null;
        this.listeners.clear();
        this.listeners = null;
        this.packages.clear();
        this.packages = null;
        Object object = this.bundleThreads;
        synchronized (object) {
            while (!this.bundleThreads.isEmpty()) {
                ((BundleThread)this.bundleThreads.remove(0)).quit();
            }
        }
        this.bundleThreads = null;
        this.dataStorage = null;
        this.storage.close();
        this.storage = null;
        if (!this.props.REGISTERSERVICEURLHANDLER) {
            this.urlStreamHandlerFactory = null;
            this.contentHandlerFactory = null;
        }
        this.perm = new SecurePermissionOps(this);
        object = globalFwLock;
        synchronized (object) {
            if (--smUse == 0) {
                System.setSecurityManager(null);
            }
        }
        this.parentClassLoader = null;
        this.bootDelegationPatterns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSecurityManager() {
        Object object = globalFwLock;
        synchronized (object) {
            SecurityManager current = System.getSecurityManager();
            String osgiSecurity = this.props.getProperty("org.osgi.framework.security");
            if (osgiSecurity.length() > 0) {
                if (!"osgi".equals(osgiSecurity)) {
                    throw new SecurityException("Unknown OSGi security, " + osgiSecurity);
                }
                if (current == null) {
                    String POLICY_PROPERTY = "java.security.policy";
                    String defaultPolicy = this.getClass().getResource("/framework.policy").toString();
                    String policy = System.getProperty("java.security.policy", defaultPolicy);
                    if (this.debug.framework) {
                        this.debug.println("Installing OSGi security manager, policy=" + policy);
                    }
                    System.setProperty("java.security.policy", policy);
                    Policy.getPolicy().refresh();
                    current = new KFSecurityManager(this.debug);
                    System.setSecurityManager(current);
                    smUse = 1;
                } else if (current instanceof ConditionalPermissionSecurityManager) {
                    smUse = smUse == 0 ? 2 : ++smUse;
                } else if (!(current instanceof ConditionalPermissionSecurityManager)) {
                    throw new SecurityException("Incompatible security manager installed");
                }
            }
            return current != null;
        }
    }

    private void deleteFWDir() {
        FileTree dir;
        String d = Util.getFrameworkDir(this);
        FileTree fileTree = dir = d != null ? new FileTree(d) : null;
        if (dir != null && dir.exists()) {
            this.log("deleting old framework directory.");
            boolean bOK = dir.delete();
            if (!bOK) {
                this.debug.println("Failed to remove existing fwdir " + dir.getAbsolutePath());
            }
        }
    }

    private void registerStartLevel() {
        if (this.props.getBooleanProperty("org.knopflerfish.startlevel.use")) {
            if (this.debug.startlevel) {
                this.debug.println("[using startlevel service]");
            }
            this.startLevelController = new StartLevelController(this);
            this.startLevelController.restoreState();
            this.services.register(this.systemBundle, new String[]{(class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = FrameworkContext.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName()}, this.startLevelController, null);
        }
    }

    public FileTree getDataStorage(long id) {
        if (this.dataStorage != null) {
            return new FileTree(this.dataStorage, Long.toString(id));
        }
        return null;
    }

    void checkOurBundle(Bundle b) {
        if (this != ((BundleImpl)b).fwCtx) {
            throw new IllegalArgumentException("Bundle does not belong to this framework: " + b);
        }
    }

    boolean isValidEE(String ee) {
        int i;
        if ((ee = ee.trim()) == null || "".equals(ee)) {
            return true;
        }
        String fwEE = this.props.getProperty("org.osgi.framework.executionenvironment");
        if (fwEE == null) {
            return true;
        }
        if (!fwEE.equals(this.eeCache)) {
            this.eeCacheSet.clear();
            String[] l = Util.splitwords(fwEE, ",");
            for (i = 0; i < l.length; ++i) {
                this.eeCacheSet.add(l[i]);
            }
            this.eeCache = fwEE;
        }
        String[] eel = Util.splitwords(ee, ",");
        for (i = 0; i < eel.length; ++i) {
            if (!this.eeCacheSet.contains(eel[i])) continue;
            return true;
        }
        return false;
    }

    void buildBootDelegationPatterns() {
        String bootDelegationString = this.props.getProperty("org.osgi.framework.bootdelegation");
        this.bootDelegationUsed = bootDelegationString.length() > 0;
        this.bootDelegationPatterns = new ArrayList(1);
        if (this.bootDelegationUsed) {
            try {
                Iterator i = Util.parseEntries("org.osgi.framework.bootdelegation", bootDelegationString, true, true, false);
                while (i.hasNext()) {
                    Map e = (Map)i.next();
                    String key = (String)e.get("$key");
                    if (key.equals("*")) {
                        this.bootDelegationPatterns = null;
                        break;
                    }
                    if (key.endsWith(".*")) {
                        this.bootDelegationPatterns.add(key.substring(0, key.length() - 1));
                        continue;
                    }
                    if (key.endsWith(".")) {
                        this.listeners.frameworkError(this.systemBundle, (Throwable)new IllegalArgumentException("org.osgi.framework.bootdelegation entry ends with '.': " + key));
                        continue;
                    }
                    if (key.indexOf("*") != -1) {
                        this.listeners.frameworkError(this.systemBundle, (Throwable)new IllegalArgumentException("org.osgi.framework.bootdelegation entry contains a '*': " + key));
                        continue;
                    }
                    this.bootDelegationPatterns.add(key);
                }
            }
            catch (IllegalArgumentException e) {
                this.debug.printStackTrace("Failed to parse org.osgi.framework.bootdelegation", e);
            }
        }
    }

    boolean isBootDelegatedResource(String name) {
        int pos = name.lastIndexOf(47);
        return pos != -1 ? this.isBootDelegated(name.substring(0, pos).replace('/', '.') + ".X") : false;
    }

    boolean isBootDelegated(String className) {
        if (!this.bootDelegationUsed) {
            return false;
        }
        if (this.bootDelegationPatterns == null) {
            return true;
        }
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            String classPackage = className.substring(0, pos);
            Iterator i = ((AbstractList)this.bootDelegationPatterns).iterator();
            while (i.hasNext()) {
                String ps = (String)i.next();
                if ((!ps.endsWith(".") || !classPackage.regionMatches(0, ps, 0, ps.length() - 1)) && !classPackage.equals(ps)) continue;
                return true;
            }
        }
        return false;
    }

    private void selectBootDelegationParentClassLoader() {
        String s = this.props.getProperty("org.osgi.framework.bundle.parent");
        if ("ext".equals(s)) {
            this.parentClassLoader = ClassLoader.getSystemClassLoader();
            if (this.parentClassLoader != null) {
                this.parentClassLoader = this.parentClassLoader.getParent();
            }
        } else {
            this.parentClassLoader = "app".equals(s) ? ClassLoader.getSystemClassLoader() : ("framework".equals(s) ? this.getClass().getClassLoader() : (class$java$lang$Object == null ? (class$java$lang$Object = FrameworkContext.class$("java.lang.Object")) : class$java$lang$Object).getClassLoader());
        }
        if (this.parentClassLoader == null) {
            this.parentClassLoader = new BCLoader();
        }
    }

    void activateExtension(BundleGeneration extension) {
        this.extCtxs.add(new ExtensionContext(this, extension));
    }

    void bundleClassLoaderCreated(BundleClassLoader bcl) {
        Iterator it = this.extCtxs.iterator();
        while (it.hasNext()) {
            ExtensionContext extCtx = (ExtensionContext)it.next();
            extCtx.bundleClassLoaderCreated(bcl);
        }
    }

    void bundleClassLoaderClosed(BundleClassLoader bcl) {
        Iterator it = this.extCtxs.iterator();
        while (it.hasNext()) {
            ExtensionContext extCtx = (ExtensionContext)it.next();
            extCtx.bundleClassLoaderClosed(bcl);
        }
    }

    void log(String msg) {
        if (this.debug.framework) {
            this.debug.println("Framework instance " + this.hashCode() + ": " + msg);
        }
    }

    void log(String msg, Throwable t) {
        if (this.debug.framework) {
            this.debug.printStackTrace("Framework instance " + this.hashCode() + ": " + msg, t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        globalFwLock = new Object();
        globalId = 0;
        smUse = 0;
    }

    private static class BCLoader
    extends ClassLoader {
        protected BCLoader() {
            super(null);
        }
    }
}

