/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.VersionRange;

class Fragment {
    final String hostName;
    final String extension;
    final VersionRange versionRange;
    private Vector hosts = new Vector(2);

    Fragment(String hostName, String extension, String range) {
        this.hostName = hostName;
        this.extension = extension;
        this.versionRange = range == null ? VersionRange.defaultVersionRange : new VersionRange(range);
    }

    void addHost(BundleGeneration host) {
        this.hosts.add(host);
    }

    void removeHost(BundleGeneration host) {
        if (host == null) {
            this.hosts.clear();
        } else {
            this.hosts.remove(host);
        }
    }

    boolean isHost(BundleGeneration host) {
        return this.hosts.contains(host);
    }

    Vector getHosts() {
        return this.hosts.isEmpty() ? null : (Vector)this.hosts.clone();
    }

    boolean hasHosts() {
        return !this.hosts.isEmpty();
    }

    boolean isTarget(BundleImpl b) {
        return this.hostName.equals(b.gen.symbolicName) && this.versionRange.withinRange(b.gen.version);
    }

    List targets(FrameworkContext fwCtx) {
        List bundles = fwCtx.bundles.getBundles(this.hostName, this.versionRange);
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            BundleImpl t = (BundleImpl)iter.next();
            if (!t.gen.attachPolicy.equals("never")) continue;
            iter.remove();
        }
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles;
    }
}

