/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Version;

class ExportPkg {
    final String name;
    final BundlePackages bpkgs;
    final HashSet uses;
    final HashSet mandatory;
    final HashSet include;
    final HashSet exclude;
    final Version version;
    final Map attributes;
    boolean zombie = false;
    boolean hasPermission = true;
    Pkg pkg = null;

    ExportPkg(String name, Map tokens, BundlePackages b) {
        this.bpkgs = b;
        this.name = name;
        if (name.startsWith("java.")) {
            throw new IllegalArgumentException("You can not export a java.* package");
        }
        this.uses = Util.parseEnumeration("uses", (String)tokens.remove("uses"));
        this.mandatory = Util.parseEnumeration("mandatory", (String)tokens.remove("mandatory"));
        this.include = Util.parseEnumeration("include", (String)tokens.remove("include"));
        this.exclude = Util.parseEnumeration("exclude", (String)tokens.remove("exclude"));
        String versionStr = (String)tokens.remove("version");
        String specVersionStr = (String)tokens.remove("specification-version");
        if (specVersionStr != null) {
            this.version = new Version(specVersionStr);
            if (versionStr != null && !this.version.equals(new Version(versionStr))) {
                throw new IllegalArgumentException("Both version and specification-version are specified, and differs");
            }
        } else {
            this.version = versionStr != null ? new Version(versionStr) : Version.emptyVersion;
        }
        if (tokens.containsKey("bundle-version")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-version");
        }
        if (tokens.containsKey("bundle-symbolic-name")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-symbolic-name");
        }
        Set directiveNames = (Set)tokens.remove("$directives");
        if (null != directiveNames) {
            Iterator dit = directiveNames.iterator();
            while (dit.hasNext()) {
                tokens.remove((String)dit.next());
            }
        }
        tokens.remove("$key");
        tokens.remove("$keys");
        this.attributes = tokens;
    }

    ExportPkg(ExportPkg ep, String name) {
        this.name = name;
        this.bpkgs = ep.bpkgs;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    ExportPkg(ExportPkg ep, BundlePackages b) {
        this.name = ep.name;
        this.bpkgs = b;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    synchronized void attachPkg(Pkg p) {
        this.pkg = p;
    }

    synchronized void detachPkg() {
        this.pkg = null;
        this.zombie = false;
    }

    boolean checkFilter(String fullClassName) {
        String clazz = null;
        boolean ok = true;
        if (fullClassName != null) {
            Iterator i;
            if (this.include != null) {
                clazz = fullClassName.substring(this.name.length() + 1);
                i = this.include.iterator();
                while (i.hasNext() && !Util.filterMatch((String)i.next(), clazz)) {
                    if (i.hasNext()) continue;
                    ok = false;
                }
            }
            if (ok && this.exclude != null) {
                if (clazz == null) {
                    clazz = fullClassName.substring(this.name.length() + 1);
                }
                i = this.exclude.iterator();
                while (i.hasNext()) {
                    if (!Util.filterMatch((String)i.next(), clazz)) continue;
                    ok = false;
                    break;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean isProvider() {
        if (this.pkg != null) {
            Pkg pkg = this.pkg;
            synchronized (pkg) {
                return this.pkg.providers.contains(this) || this.bpkgs.isRequired();
            }
        }
        return false;
    }

    synchronized boolean isExported() {
        if (this.checkPermission() && this.pkg != null && ((this.bpkgs.bg.bundle.state & 0x3C) != 0 || this.zombie)) {
            BundlePackages bp = this.bpkgs.getProviderBundlePackages(this.name);
            return bp == null || bp.bg.bundle == this.bpkgs.bg.bundle;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Collection getPackageImporters() {
        if (this.pkg != null) {
            HashSet<BundleImpl> res = new HashSet<BundleImpl>();
            Pkg pkg = this.pkg;
            synchronized (pkg) {
                Iterator i = ((AbstractList)this.pkg.importers).iterator();
                while (i.hasNext()) {
                    ImportPkg ip = (ImportPkg)i.next();
                    if (ip.provider != this || ip.bpkgs == this.bpkgs) continue;
                    res.add(ip.bpkgs.bg.bundle);
                }
            }
            return res;
        }
        return null;
    }

    boolean checkPermission() {
        if (this.bpkgs.bg.bundle.state == 2) {
            this.hasPermission = this.bpkgs.bg.bundle.fwCtx.perm.hasExportPackagePermission(this);
        }
        return this.hasPermission;
    }

    boolean pkgEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        ExportPkg ep = (ExportPkg)o;
        return this.name.equals(ep.name) && this.version.equals(ep.version) && (this.uses == null ? ep.uses == null : this.uses.equals(ep.uses)) && (this.mandatory == null ? ep.mandatory == null : this.mandatory.equals(ep.mandatory)) && (this.include == null ? ep.include == null : this.include.equals(ep.include)) && (this.exclude == null ? ep.exclude == null : this.exclude.equals(ep.exclude)) && ((Object)this.attributes).equals(ep.attributes);
    }

    public String pkgString() {
        if (this.version != Version.emptyVersion) {
            return this.name + ";" + "specification-version" + "=" + this.version;
        }
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.pkgString());
        sb.append('(');
        if (this.zombie) {
            sb.append("zombie, ");
        }
        sb.append(this.bpkgs.toString());
        sb.append(')');
        return sb.toString();
    }
}

