/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ContentHandlerWrapper
extends ContentHandler {
    FrameworkContext framework;
    String mimetype;
    String filter;
    ServiceReference best;
    static /* synthetic */ Class class$java$net$ContentHandler;

    ContentHandlerWrapper(FrameworkContext framework, String mimetype) {
        this.framework = framework;
        this.mimetype = mimetype;
        this.filter = "(&(objectClass=" + (class$java$net$ContentHandler == null ? (class$java$net$ContentHandler = ContentHandlerWrapper.class$("java.net.ContentHandler")) : class$java$net$ContentHandler).getName() + ")" + "(" + "url.content.mimetype" + "=" + mimetype + ")" + ")";
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent evt) {
                ServiceReference ref = evt.getServiceReference();
                switch (evt.getType()) {
                    case 1: 
                    case 2: {
                        if (ContentHandlerWrapper.this.best == null) {
                            ContentHandlerWrapper.this.updateBest();
                            return;
                        }
                        if (ContentHandlerWrapper.this.compare(ContentHandlerWrapper.this.best, ref) <= 0) break;
                        ContentHandlerWrapper.this.best = ref;
                        break;
                    }
                    case 4: 
                    case 8: {
                        if (!ContentHandlerWrapper.this.best.equals(ref)) break;
                        ContentHandlerWrapper.this.best = null;
                    }
                }
            }
        };
        try {
            framework.systemBundle.bundleContext.addServiceListener(serviceListener, this.filter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not register service listener for content handler: " + e);
        }
        if (framework.debug.url) {
            framework.debug.println("created wrapper for " + mimetype + ", filter=" + this.filter);
        }
    }

    private int compare(ServiceReference ref1, ServiceReference ref2) {
        int r2;
        Object tmp1 = ref1.getProperty("service.ranking");
        Object tmp2 = ref2.getProperty("service.ranking");
        int r1 = tmp1 instanceof Integer ? (Integer)tmp1 : 0;
        int n = r2 = tmp2 instanceof Integer ? (Integer)tmp2 : 0;
        if (r2 == r1) {
            Long i1 = (Long)ref1.getProperty("service.id");
            Long i2 = (Long)ref2.getProperty("service.id");
            return i1.compareTo(i2);
        }
        return r2 - r1;
    }

    private void updateBest() {
        try {
            ServiceReference[] refs = this.framework.systemBundle.bundleContext.getServiceReferences((class$java$net$ContentHandler == null ? (class$java$net$ContentHandler = ContentHandlerWrapper.class$("java.net.ContentHandler")) : class$java$net$ContentHandler).getName(), this.filter);
            if (refs != null) {
                this.best = refs[0];
                for (int i = 1; i < refs.length; ++i) {
                    if (this.compare(this.best, refs[i]) <= 0) continue;
                    this.best = refs[i];
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not register url handler: " + e);
        }
    }

    private ContentHandler getService() {
        ContentHandler obj;
        try {
            if (this.best == null) {
                this.updateBest();
            }
            if (this.best == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.mimetype);
            }
            obj = (ContentHandler)this.framework.systemBundle.bundleContext.getService(this.best);
            if (obj == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.mimetype);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("null: Lost service for protocol=" + this.mimetype);
        }
        return obj;
    }

    public Object getContent(URLConnection urlc) throws IOException {
        return this.getService().getContent(urlc);
    }

    public Object getContent(URLConnection urlc, Class[] classes) throws IOException {
        return this.getService().getContent(urlc, classes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ContentHandlerWrapper[");
        ServiceReference ref = this.best;
        sb.append("mimetype=" + this.mimetype);
        if (ref != null) {
            sb.append(", id=" + ref.getProperty("service.id"));
            sb.append(", rank=" + ref.getProperty("service.ranking"));
        } else {
            sb.append(" no service tracked");
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

