/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.LinkedList;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;

class BundleThread
extends Thread {
    private static final int OP_IDLE = 0;
    private static final int OP_BUNDLE_EVENT = 1;
    private static final int OP_START = 2;
    private static final int OP_STOP = 3;
    private static final int KEEP_ALIVE = 1000;
    static final String ABORT_ACTION_STOP = "stop";
    static final String ABORT_ACTION_MINPRIO = "minprio";
    static final String ABORT_ACTION_IGNORE = "ignore";
    private final FrameworkContext fwCtx;
    private final Object lock = new Object();
    private volatile BundleEvent be;
    private volatile BundleImpl bundle;
    private volatile int operation = 0;
    private volatile Object res;
    private volatile boolean doRun;

    BundleThread(FrameworkContext fc) {
        super(fc.threadGroup, "BundleThread waiting");
        this.setDaemon(true);
        this.fwCtx = fc;
        this.doRun = true;
        this.start();
    }

    void quit() {
        this.doRun = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.doRun) {
            Object object = this.lock;
            synchronized (object) {
                while (this.doRun && this.operation == 0) {
                    try {
                        this.lock.wait(1000L);
                        if (this.operation == 0) {
                            LinkedList linkedList = this.fwCtx.bundleThreads;
                            synchronized (linkedList) {
                                if (this.fwCtx.bundleThreads.remove(this)) {
                                    return;
                                }
                                continue;
                            }
                        }
                        break;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                if (!this.doRun) {
                    break;
                }
                Exception tmpres = null;
                try {
                    switch (this.operation) {
                        case 1: {
                            this.setName("BundleChanged #" + this.be.getBundle().getBundleId());
                            this.fwCtx.listeners.bundleChanged(this.be);
                            break;
                        }
                        case 2: {
                            this.setName("BundleStart #" + this.bundle.getBundleId());
                            tmpres = this.bundle.start0();
                            break;
                        }
                        case 3: {
                            this.setName("BundleStop #" + this.bundle.getBundleId());
                            tmpres = this.bundle.stop1();
                        }
                    }
                }
                catch (Throwable t) {
                    this.fwCtx.listeners.frameworkError(this.bundle, t);
                }
                this.operation = 0;
                this.res = tmpres;
            }
            object = this.fwCtx.packages;
            synchronized (object) {
                this.fwCtx.packages.notifyAll();
            }
        }
    }

    void bundleChanged(BundleEvent be) {
        this.be = be;
        this.startAndWait((BundleImpl)be.getBundle(), 1);
    }

    BundleException callStart0(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 2);
    }

    BundleException callStop1(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object startAndWait(BundleImpl b, int op) {
        Object object = this.lock;
        synchronized (object) {
            this.res = Boolean.FALSE;
            this.bundle = b;
            this.operation = op;
            this.lock.notifyAll();
        }
        boolean abort = false;
        do {
            try {
                this.fwCtx.packages.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (op != 2 && op != 3 || b.getState() != 1) continue;
            abort = true;
            break;
        } while (this.res == Boolean.FALSE);
        if (abort) {
            String s = this.fwCtx.props.getProperty("org.knopflerfish.framework.bundlethread.abort");
            if (s == null) {
                s = ABORT_ACTION_IGNORE;
            }
            this.fwCtx.debug.println("bundle thread aborted during " + (op == 2 ? "start" : ABORT_ACTION_STOP) + " of bundle #" + b.getBundleId() + ", abort action set to '" + s + "'");
            this.quit();
            if (ABORT_ACTION_STOP.equalsIgnoreCase(s)) {
                this.stop();
            } else if (ABORT_ACTION_MINPRIO.equalsIgnoreCase(s)) {
                this.setPriority(1);
            }
            switch (op) {
                case 2: {
                    this.res = new BundleException("Bundle start failed", 7, new Exception("Bundle uninstalled during start()"));
                    break;
                }
                case 3: {
                    this.res = new BundleException("Bundle stop failed", 7, new Exception("Bundle uninstalled during stop()"));
                }
            }
            return this.res;
        }
        LinkedList linkedList = this.fwCtx.bundleThreads;
        synchronized (linkedList) {
            this.fwCtx.bundleThreads.addFirst(this);
            if (op != this.operation) {
                // empty if block
            }
            return this.res;
        }
    }
}

