/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.IteratorIterator;
import org.knopflerfish.framework.IteratorIteratorSorted;
import org.knopflerfish.framework.RequireBundle;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;

class BundlePackages {
    final BundleGeneration bg;
    private ArrayList exports = new ArrayList(1);
    private ArrayList imports = new ArrayList(1);
    private ArrayList dImportPatterns = new ArrayList(1);
    private TreeMap fragments = null;
    private ArrayList require;
    private ArrayList requiredBy = null;
    private ArrayList okImports = null;
    private boolean registered = false;
    private String failReason = null;
    static final String EMPTY_STRING = "";
    static final Util.Comparator epComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ExportPkg a = (ExportPkg)oa;
            ExportPkg b = (ExportPkg)ob;
            return a.name.compareTo(b.name);
        }
    };
    static final Util.Comparator epFind = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ExportPkg a = (ExportPkg)oa;
            String b = (String)ob;
            return a.name.compareTo(b);
        }
    };
    static final Util.Comparator ipComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ImportPkg a = (ImportPkg)oa;
            ImportPkg b = (ImportPkg)ob;
            return a.name.compareTo(b.name);
        }
    };
    static final Util.Comparator ipFind = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ImportPkg a = (ImportPkg)oa;
            String b = (String)ob;
            return a.name.compareTo(b);
        }
    };

    BundlePackages(BundleGeneration bg) {
        Iterator pi;
        Map e;
        this.bg = bg;
        BundleArchive ba = bg.archive;
        Iterator i = Util.parseEntries("Import-Package", ba.getAttribute("Import-Package"), false, true, false);
        block0: while (i.hasNext()) {
            e = (Map)i.next();
            pi = ((List)e.remove("$keys")).iterator();
            ImportPkg ip = new ImportPkg((String)pi.next(), e, this);
            while (true) {
                int ii;
                if ((ii = Util.binarySearch(this.imports, ipComp, ip)) >= 0) {
                    throw new IllegalArgumentException("Duplicate import definitions for - " + ip.name);
                }
                this.imports.add(-ii - 1, ip);
                if (!pi.hasNext()) continue block0;
                ip = new ImportPkg(ip, (String)pi.next());
            }
        }
        i = Util.parseEntries("Export-Package", ba.getAttribute("Export-Package"), false, true, false);
        block2: while (i.hasNext()) {
            e = (Map)i.next();
            pi = ((List)e.remove("$keys")).iterator();
            ExportPkg ep = new ExportPkg((String)pi.next(), e, this);
            while (true) {
                ImportPkg ip;
                int ii;
                int ei = Math.abs(Util.binarySearch(this.exports, epComp, ep) + 1);
                this.exports.add(ei, ep);
                if (!bg.v2Manifest && (ii = Util.binarySearch(this.imports, ipComp, ip = new ImportPkg(ep))) < 0) {
                    this.imports.add(-ii - 1, ip);
                }
                if (!pi.hasNext()) continue block2;
                ep = new ExportPkg(ep, (String)pi.next());
            }
        }
        i = Util.parseEntries("DynamicImport-Package", ba.getAttribute("DynamicImport-Package"), false, true, false);
        while (i.hasNext()) {
            e = (Map)i.next();
            if (e.containsKey("resolution")) {
                throw new IllegalArgumentException("DynamicImport-Package entry illegal contains a resolution directive.");
            }
            ImportPkg tmpl = null;
            Iterator pi2 = ((List)e.remove("$keys")).iterator();
            while (pi2.hasNext()) {
                String key = (String)pi2.next();
                if (key.equals("*")) {
                    key = EMPTY_STRING;
                } else if (key.endsWith(".*")) {
                    key = key.substring(0, key.length() - 1);
                } else {
                    if (key.endsWith(".")) {
                        throw new IllegalArgumentException("DynamicImport-Package entry ends with '.': " + key);
                    }
                    if (key.indexOf("*") != -1) {
                        throw new IllegalArgumentException("DynamicImport-Package entry contains a '*': " + key);
                    }
                }
                if (tmpl != null) {
                    this.dImportPatterns.add(new ImportPkg(tmpl, key));
                    continue;
                }
                tmpl = new ImportPkg(key, e, this);
                this.dImportPatterns.add(tmpl);
            }
        }
        i = Util.parseEntries("Require-Bundle", ba.getAttribute("Require-Bundle"), true, true, false);
        if (i.hasNext()) {
            this.require = new ArrayList();
            do {
                e = (Map)i.next();
                this.require.add(new RequireBundle(this, (String)e.get("$key"), (String)e.get("visibility"), (String)e.get("resolution"), (String)e.get("bundle-version")));
            } while (i.hasNext());
        } else {
            this.require = null;
        }
    }

    BundlePackages(BundleGeneration bg, String exportString) {
        this.bg = bg;
        Iterator i = Util.parseEntries("Export-Package", exportString, false, true, false);
        block0: while (i.hasNext()) {
            Map e = (Map)i.next();
            Iterator pi = ((List)e.remove("$keys")).iterator();
            ExportPkg ep = new ExportPkg((String)pi.next(), e, this);
            while (true) {
                int ei = Math.abs(Util.binarySearch(this.exports, epComp, ep) + 1);
                this.exports.add(ei, ep);
                if (!pi.hasNext()) continue block0;
                ep = new ExportPkg(ep, (String)pi.next());
            }
        }
        this.require = null;
    }

    BundlePackages(BundlePackages host, BundlePackages frag) {
        this.bg = host.bg;
        Iterator iiter = frag.getImports();
        while (iiter.hasNext()) {
            ImportPkg fip = (ImportPkg)iiter.next();
            ImportPkg ip = host.getImport(fip.name);
            if (ip != null && !fip.intersect(ip)) {
                throw new IllegalStateException("Host bundle import package and fragment bundle import package doesn't intersect so a resolve isn't possible.");
            }
            this.imports.add(new ImportPkg(fip, this));
        }
        if (frag.require != null) {
            this.require = new ArrayList();
            Iterator iter = ((AbstractList)frag.require).iterator();
            while (iter.hasNext()) {
                RequireBundle fragReq = (RequireBundle)iter.next();
                boolean match = false;
                if (this.require != null) {
                    Iterator iter2 = ((AbstractList)host.require).iterator();
                    while (iter2.hasNext()) {
                        RequireBundle req = (RequireBundle)iter2.next();
                        if (!fragReq.name.equals(req.name)) continue;
                        if (fragReq.overlap(req)) {
                            match = true;
                            continue;
                        }
                        throw new IllegalStateException("Fragment bundle required bundle doesn't completely overlap required bundle in host bundle.");
                    }
                }
                if (match) continue;
                if (this.bg.bundle.state != 2) {
                    throw new IllegalStateException("Can not attach a fragment with new required bundles to a resolved host");
                }
                this.require.add(new RequireBundle(fragReq, this));
            }
        } else {
            this.require = null;
        }
        Iterator eiter = frag.getExports();
        while (eiter.hasNext()) {
            ExportPkg hep;
            ExportPkg fep = (ExportPkg)eiter.next();
            if (fep.pkgEquals(hep = this.getExport(fep.name))) continue;
            this.exports.add(new ExportPkg(fep, this));
        }
    }

    void registerPackages() {
        this.bg.bundle.fwCtx.packages.registerPackages(((AbstractList)this.exports).iterator(), ((AbstractList)this.imports).iterator());
        this.registered = true;
    }

    synchronized boolean unregisterPackages(boolean force) {
        if (this.registered) {
            if (this.bg.bundle.fwCtx.packages.unregisterPackages(this.getExports(), this.getImports(), force)) {
                this.okImports = null;
                this.registered = false;
                this.unRequireBundles();
                this.detachFragments();
            } else {
                return false;
            }
        }
        return true;
    }

    boolean resolvePackages() {
        this.failReason = this.bg.bundle.fwCtx.packages.resolve(this.bg.bundle, this.getImports());
        if (this.failReason == null) {
            this.okImports = new ArrayList(this.imports.size());
            Iterator i = this.getImports();
            while (i.hasNext()) {
                ImportPkg ip = (ImportPkg)i.next();
                if (ip.provider == null) continue;
                this.okImports.add(ip);
            }
            return true;
        }
        return false;
    }

    String getResolveFailReason() {
        return this.failReason;
    }

    synchronized BundlePackages getProviderBundlePackages(String pkg) {
        if (this.bg.bundle instanceof SystemBundle) {
            return this.isExported(pkg) ? this : null;
        }
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return ((ImportPkg)this.okImports.get((int)ii)).provider.bpkgs;
        }
        return null;
    }

    synchronized BundlePackages getDynamicProviderBundlePackages(String pkg) {
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return ((ImportPkg)this.okImports.get((int)ii)).provider.bpkgs;
        }
        Iterator i = ((AbstractList)this.dImportPatterns).iterator();
        while (i.hasNext()) {
            ImportPkg nip;
            ExportPkg ep;
            ImportPkg ip = (ImportPkg)i.next();
            if (ip.name != EMPTY_STRING && (!ip.name.endsWith(".") || !pkg.startsWith(ip.name)) && !pkg.equals(ip.name) || (ep = this.bg.bundle.fwCtx.packages.registerDynamicImport(nip = new ImportPkg(ip, pkg))) == null) continue;
            nip.provider = ep;
            this.okImports.add(-ii - 1, nip);
            return ep.bpkgs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getRequire() {
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList<Iterator> iters = new ArrayList<Iterator>(this.fragments.size() + 1);
                if (this.require != null) {
                    iters.add(((AbstractList)this.require).iterator());
                }
                Iterator i = this.fragments.values().iterator();
                while (i.hasNext()) {
                    Iterator fi = ((BundlePackages)i.next()).getRequire();
                    if (fi == null) continue;
                    iters.add(fi);
                }
                return iters.isEmpty() ? null : new IteratorIterator(iters);
            }
        }
        if (this.require != null) {
            return ((AbstractList)this.require).iterator();
        }
        return null;
    }

    ArrayList getRequiredBundleGenerations(String pkg) {
        Iterator i = this.getRequire();
        if (i != null) {
            ArrayList<BundleGeneration> res = new ArrayList<BundleGeneration>(2);
            do {
                RequireBundle rb = (RequireBundle)i.next();
                if (rb.bpkgs == null || !rb.bpkgs.isExported(pkg)) continue;
                res.add(rb.bpkgs.bg);
            } while (i.hasNext());
            return res.isEmpty() ? null : res;
        }
        return null;
    }

    void addRequiredBy(BundlePackages r) {
        if (this.requiredBy == null) {
            this.requiredBy = new ArrayList();
        }
        this.requiredBy.add(r);
    }

    boolean isRequired() {
        return this.requiredBy != null && !this.requiredBy.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getRequiredBy() {
        if (this.requiredBy != null) {
            if (this.fragments != null) {
                ArrayList res = new ArrayList();
                Cloneable cloneable = this.requiredBy;
                synchronized (cloneable) {
                    res.addAll(this.requiredBy);
                }
                cloneable = this.fragments;
                synchronized (cloneable) {
                    Iterator i = this.fragments.values().iterator();
                    while (i.hasNext()) {
                        List fl = ((BundlePackages)i.next()).getRequiredBy();
                        if (fl == null) continue;
                        res.addAll(fl);
                    }
                }
                return res;
            }
            ArrayList arrayList = this.requiredBy;
            synchronized (arrayList) {
                return (List)this.requiredBy.clone();
            }
        }
        return Collections.EMPTY_LIST;
    }

    void checkReExport(ExportPkg ep) {
        int i = Util.binarySearch(this.exports, epFind, ep.name);
        if (i < 0) {
            ExportPkg nep = new ExportPkg(ep, this);
            this.exports.add(-i - 1, nep);
            ep.pkg.addExporter(nep);
        }
    }

    private ExportPkg getExport(String pkg) {
        int i = Util.binarySearch(this.exports, epFind, pkg);
        if (i >= 0) {
            return (ExportPkg)this.exports.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getExports() {
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList<Iterator> iters = new ArrayList<Iterator>(this.fragments.size() + 1);
                iters.add(((AbstractList)this.exports).iterator());
                Iterator i = this.fragments.values().iterator();
                while (i.hasNext()) {
                    iters.add(((BundlePackages)i.next()).getExports());
                }
                return new IteratorIteratorSorted(iters, epComp);
            }
        }
        return ((AbstractList)this.exports).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getExports(String pkg) {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>(2);
        ExportPkg ep = this.getExport(pkg);
        if (ep != null) {
            res.add(ep);
        }
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                Iterator i = this.fragments.values().iterator();
                while (i.hasNext()) {
                    ep = ((BundlePackages)i.next()).getExport(pkg);
                    if (ep == null) continue;
                    res.add(ep);
                }
            }
        }
        return res.isEmpty() ? null : ((AbstractList)res).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isExported(String pkg) {
        if (this.getExport(pkg) != null) {
            return true;
        }
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                Iterator i = this.fragments.values().iterator();
                while (i.hasNext()) {
                    if (((BundlePackages)i.next()).getExport(pkg) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getImports() {
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList<Iterator> iters = new ArrayList<Iterator>(this.fragments.size() + 1);
                iters.add(((AbstractList)this.imports).iterator());
                Iterator i = this.fragments.values().iterator();
                while (i.hasNext()) {
                    iters.add(((BundlePackages)i.next()).getImports());
                }
                return new IteratorIteratorSorted(iters, ipComp);
            }
        }
        return ((AbstractList)this.imports).iterator();
    }

    Iterator getActiveImports() {
        if (this.okImports != null) {
            return ((AbstractList)this.okImports).iterator();
        }
        return this.bg.bpkgs.getActiveImports();
    }

    ClassLoader getClassLoader() {
        return this.bg.getClassLoader();
    }

    boolean isRegistered() {
        return this.registered;
    }

    String attachFragment(BundlePackages fbpkgs) {
        BundlePackages nfbpkgs = new BundlePackages(this, fbpkgs);
        nfbpkgs.registerPackages();
        if (this.okImports != null) {
            this.failReason = this.bg.bundle.fwCtx.packages.resolve(this.bg.bundle, nfbpkgs.getImports());
            if (this.failReason == null) {
                Iterator i = nfbpkgs.getImports();
                while (i.hasNext()) {
                    int ii;
                    ImportPkg ip = (ImportPkg)i.next();
                    if (ip.provider == null || (ii = Util.binarySearch(this.okImports, ipComp, ip)) >= 0) continue;
                    this.okImports.add(-ii - 1, ip);
                }
            } else {
                nfbpkgs.unregisterPackages(true);
                return this.failReason;
            }
        }
        if (this.fragments == null) {
            this.fragments = new TreeMap();
        }
        this.fragments.put(fbpkgs.bg, nfbpkgs);
        return null;
    }

    void fragmentIsZombie(BundleImpl fb) {
        if (null != this.exports) {
            if (this.bg.bundle.fwCtx.debug.packages) {
                this.bg.bundle.fwCtx.debug.println("Marking all packages exported by host bundle(id=" + this.bg.bundle.id + ",gen=" + this.bg.generation + ") as zombies since the attached fragment (id=" + fb.getBundleId() + ") was updated/uninstalled.");
            }
            Iterator eiter = ((AbstractList)this.exports).iterator();
            while (eiter.hasNext()) {
                ((ExportPkg)eiter.next()).zombie = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachFragment(BundleGeneration fbg) {
        TreeMap treeMap = this.fragments;
        synchronized (treeMap) {
            this.detachFragment(fbg, true);
        }
    }

    void unregister() {
        this.registered = false;
        this.unRequireBundles();
    }

    public String toString() {
        return "BundlePackages(id=" + this.bg.bundle.id + ",gen=" + this.bg.generation + ")";
    }

    private ImportPkg getImport(String pkg) {
        int i = Util.binarySearch(this.imports, ipFind, pkg);
        if (i >= 0) {
            return (ImportPkg)this.imports.get(i);
        }
        return null;
    }

    private void unRequireBundles() {
        if (this.require != null) {
            Iterator iter = ((AbstractList)this.require).iterator();
            while (iter.hasNext()) {
                RequireBundle req = (RequireBundle)iter.next();
                if (null == req.bpkgs || null == req.bpkgs.requiredBy) continue;
                ((AbstractCollection)req.bpkgs.requiredBy).remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachFragments() {
        if (this.fragments != null) {
            TreeMap treeMap = this.fragments;
            synchronized (treeMap) {
                while (!this.fragments.isEmpty()) {
                    this.detachFragment((BundleGeneration)this.fragments.lastKey(), false);
                }
            }
        }
    }

    private void detachFragment(BundleGeneration fbg, boolean unregisterPkg) {
        BundlePackages fbpkgs;
        if (null == this.okImports && (fbpkgs = (BundlePackages)this.fragments.remove(fbg)) != null) {
            if (unregisterPkg) {
                fbpkgs.unregisterPackages(true);
            } else {
                fbpkgs.unregister();
            }
        }
    }
}

