/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Fragment;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.MainClassBundleActivator;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class BundleImpl
implements Bundle {
    static final int RESOLVED_FLAGS = 60;
    final FrameworkContext fwCtx;
    final long id;
    final String location;
    PermissionOps secure;
    volatile int state;
    volatile BundleGeneration gen;
    private volatile Vector oldGenerations = null;
    protected FileTree bundleDir = null;
    protected BundleContextImpl bundleContext = null;
    protected BundleActivator bactivator = null;
    private volatile HeaderDictionary cachedHeaders = null;
    protected volatile int operation;
    static final int IDLE = 0;
    static final int ACTIVATING = 1;
    static final int DEACTIVATING = 2;
    static final int RESOLVING = 3;
    static final int UNINSTALLING = 4;
    static final int UNRESOLVING = 5;
    static final int UPDATING = 6;
    private BundleException resolveFailException;
    private boolean wasStarted;

    BundleImpl(FrameworkContext fw) {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = 0L;
        this.location = "System Bundle";
        this.state = 2;
    }

    BundleImpl(FrameworkContext fw, BundleArchive ba, Object checkContext) {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = ba.getBundleId();
        this.location = ba.getBundleLocation();
        this.state = 2;
        this.gen = new BundleGeneration(this, ba, null);
        this.gen.checkPermissions(checkContext);
        this.doExportImport();
        this.bundleDir = this.fwCtx.getDataStorage(this.id);
        if (this.gen.isExtension() && this.attachToFragmentHost(this.fwCtx.systemBundle.gen)) {
            this.state = 4;
        }
    }

    public int getState() {
        return this.state;
    }

    public void start() throws BundleException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int options) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.gen.isFragment()) {
                throw new BundleException("Cannot start a fragment bundle", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            options &= 0xFF;
            if (this.fwCtx.startLevelController != null && this.getStartLevel() > this.fwCtx.startLevelController.getStartLevel()) {
                if ((options & 1) != 0) {
                    throw new BundleException("Can not transiently activate bundle with start level " + this.getStartLevel() + " when running on start level " + this.fwCtx.startLevelController.getStartLevel(), 10);
                }
                this.setAutostartSetting(options);
                return;
            }
            this.waitOnOperation(this.fwCtx.packages, "Bundle.start", false);
            if (this.state == 32) {
                return;
            }
            if ((options & 1) == 0) {
                this.setAutostartSetting(options);
            }
            if ((options & 2) != 0 && this.gen.lazyActivation) {
                if (2 == this.getUpdatedState()) {
                    throw this.resolveFailException;
                }
                if (8 == this.state) {
                    return;
                }
            } else {
                this.secure.callFinalizeActivation(this);
                return;
            }
            this.state = 8;
            this.bundleContext = new BundleContextImpl(this);
            this.operation = 1;
        }
        this.secure.callBundleChanged(this.fwCtx, new BundleEvent(512, this));
        packages = this.fwCtx.packages;
        synchronized (packages) {
            this.operation = 0;
            this.fwCtx.packages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeActivation() throws BundleException {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            switch (this.getUpdatedState()) {
                case 2: {
                    throw this.resolveFailException;
                }
                case 8: {
                    if (this.operation == 1) {
                        return;
                    }
                }
                case 4: {
                    this.state = 8;
                    this.operation = 1;
                    if (this.fwCtx.debug.lazy_activation) {
                        this.fwCtx.debug.println("activating #" + this.getBundleId());
                    }
                    if (null == this.bundleContext) {
                        this.bundleContext = new BundleContextImpl(this);
                    }
                    BundleException e = this.bundleThread().callStart0(this);
                    this.operation = 0;
                    this.fwCtx.packages.notifyAll();
                    if (e == null) break;
                    throw e;
                }
                case 32: {
                    break;
                }
                case 16: {
                    throw new BundleException("start called from BundleActivator.stop", 5);
                }
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
            }
        }
    }

    BundleException start0() {
        String ba = this.gen.archive.getAttribute("Bundle-Activator");
        boolean bStarted = false;
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(128, this));
        ClassLoader oldLoader = null;
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
        }
        int error_type = 3;
        try {
            if (ba != null) {
                Class<?> c = this.getClassLoader().loadClass(ba.trim());
                error_type = 5;
                this.bactivator = (BundleActivator)c.newInstance();
                this.bactivator.start(this.bundleContext);
                bStarted = true;
            } else {
                String mc;
                String locations = this.fwCtx.props.getProperty("org.knopflerfish.framework.main.class.activation");
                if (locations.length() > 0 && (mc = this.gen.archive.getAttribute("Main-Class")) != null) {
                    String[] locs = Util.splitwords(locations, ",");
                    for (int i = 0; i < locs.length; ++i) {
                        if (!locs[i].equals(this.location)) continue;
                        if (this.fwCtx.debug.packages) {
                            this.fwCtx.debug.println("starting main class " + mc);
                        }
                        error_type = 5;
                        Class<?> mainClass = this.getClassLoader().loadClass(mc.trim());
                        this.bactivator = new MainClassBundleActivator(mainClass);
                        this.bactivator.start(this.bundleContext);
                        bStarted = true;
                        break;
                    }
                }
            }
            if (!bStarted) {
                // empty if block
            }
            if (8 != this.state) {
                error_type = 7;
                if (1 == this.state) {
                    throw new Exception("Bundle uninstalled during start()");
                }
                throw new Exception("Bundle changed state because of refresh during start()");
            }
            this.state = 32;
        }
        catch (Throwable t) {
            res = new BundleException("Bundle start failed", error_type, t);
        }
        if (this.fwCtx.debug.lazy_activation) {
            this.fwCtx.debug.println("activating #" + this.getBundleId() + " completed.");
        }
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        if (res == null) {
            this.fwCtx.listeners.bundleChanged(new BundleEvent(2, this));
        } else if (this.operation == 1) {
            this.state = 16;
            this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
            this.removeBundleResources();
            this.bundleContext.invalidate();
            this.bundleContext = null;
            this.state = 4;
            this.fwCtx.listeners.bundleChanged(new BundleEvent(4, this));
        }
        return res;
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int options) throws BundleException {
        Exception savedException = null;
        this.secure.checkExecuteAdminPerm(this);
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.gen.isFragment()) {
                throw new BundleException("Cannot stop a fragment bundle", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            this.waitOnOperation(this.fwCtx.packages, "Bundle.stop", false);
            if ((options & 1) == 0) {
                this.setAutostartSetting(-1);
            }
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 16: {
                    return;
                }
                case 8: 
                case 32: {
                    savedException = this.stop0();
                }
            }
        }
        if (savedException != null) {
            if (savedException instanceof BundleException) {
                throw (BundleException)savedException;
            }
            throw (RuntimeException)savedException;
        }
    }

    Exception stop0() {
        this.wasStarted = this.state == 32;
        this.state = 16;
        this.operation = 2;
        BundleException savedException = this.bundleThread().callStop1(this);
        if (this.state != 1) {
            this.state = 4;
            this.bundleThread().bundleChanged(new BundleEvent(4, this));
            this.fwCtx.packages.notifyAll();
            this.operation = 0;
        }
        return savedException;
    }

    Exception stop1() {
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
        if (this.wasStarted && this.bactivator != null) {
            try {
                this.bactivator.stop(this.bundleContext);
                if (this.state != 16) {
                    if (this.state == 1) {
                        return new IllegalStateException("Bundle is uninstalled");
                    }
                    return new IllegalStateException("Bundle changed state because of refresh during stop");
                }
            }
            catch (Throwable e) {
                res = new BundleException("Bundle.stop: BundleActivator stop failed", 5, e);
            }
            this.bactivator = null;
        }
        if (this.operation == 2 && null != this.bundleContext) {
            this.fwCtx.listeners.serviceListeners.hooksBundleStopped(this.bundleContext);
            this.removeBundleResources();
            this.bundleContext.invalidate();
            this.bundleContext = null;
        }
        return res;
    }

    void waitOnOperation(Object lock, String src, boolean longWait) throws BundleException {
        if (this.operation != 0) {
            String op;
            long left = longWait ? 20000L : 500L;
            long waitUntil = System.currentTimeMillis() + left;
            do {
                try {
                    lock.wait(left);
                    if (this.operation == 0) {
                        return;
                    }
                }
                catch (InterruptedException _ie) {
                    // empty catch block
                }
            } while ((left = waitUntil - System.currentTimeMillis()) > 0L);
            switch (this.operation) {
                case 0: {
                    return;
                }
                case 1: {
                    op = "start";
                    break;
                }
                case 2: {
                    op = "stop";
                    break;
                }
                case 3: {
                    op = "resolve";
                    break;
                }
                case 4: {
                    op = "uninstall";
                    break;
                }
                case 5: {
                    op = "unresolve";
                    break;
                }
                case 6: {
                    op = "update";
                    break;
                }
                default: {
                    op = "unknown operation";
                }
            }
            throw new BundleException(src + " called during " + op + " of Bundle", 7);
        }
    }

    public void update() throws BundleException {
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(InputStream in) throws BundleException {
        try {
            this.secure.checkLifecycleAdminPerm(this);
            if (this.gen.isExtension()) {
                this.secure.checkExtensionLifecycleAdminPerm(this);
            }
            Packages packages = this.fwCtx.packages;
            synchronized (packages) {
                boolean wasActive = this.state == 32;
                switch (this.getState()) {
                    case 32: {
                        this.stop(1);
                    }
                    case 2: 
                    case 4: {
                        this.secure.callUpdate0(this, in, wasActive);
                        break;
                    }
                    case 8: {
                        throw new IllegalStateException("Bundle is in STARTING state");
                    }
                    case 16: {
                        throw new IllegalStateException("Bundle is in STOPPING state");
                    }
                    case 1: {
                        throw new IllegalStateException("Bundle is in UNINSTALLED state");
                    }
                }
            }
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ignore) {}
    }

    void update0(InputStream in, boolean wasActive, Object checkContext) throws BundleException {
        boolean purgeOld;
        boolean wasResolved = this.state == 4;
        Fragment oldFragment = this.gen.fragment;
        int oldStartLevel = this.getStartLevel();
        BundleArchive newArchive = null;
        BundleGeneration newGeneration = null;
        this.operation = 6;
        try {
            InputStream bin;
            if (in == null) {
                File file;
                URL url;
                String fname;
                String update;
                String string = update = this.gen.archive != null ? this.gen.archive.getAttribute("Bundle-UpdateLocation") : null;
                if (update == null) {
                    update = this.location;
                }
                if ((fname = (url = new URL(update)).getFile()).startsWith("file:")) {
                    fname = fname.substring(5);
                }
                bin = (file = new File(fname)).isDirectory() ? null : url.openStream();
            } else {
                bin = in;
            }
            newArchive = this.fwCtx.storage.updateBundleArchive(this.gen.archive, bin);
            newGeneration = new BundleGeneration(this, newArchive, this.gen);
            newGeneration.checkPermissions(checkContext);
            newArchive.setStartLevel(oldStartLevel);
            this.fwCtx.storage.replaceBundleArchive(this.gen.archive, newGeneration.archive);
        }
        catch (Exception e) {
            if (newArchive != null) {
                newArchive.purge();
            }
            this.operation = 0;
            if (wasActive) {
                try {
                    this.start();
                }
                catch (BundleException be) {
                    this.fwCtx.listeners.frameworkError(this, (Throwable)be);
                }
            }
            if (e instanceof BundleException) {
                throw (BundleException)e;
            }
            throw new BundleException("Failed to get update bundle", 0, e);
        }
        if (oldFragment != null) {
            if (oldFragment.hasHosts()) {
                if (oldFragment.extension != null) {
                    if (oldFragment.extension.equals("bootclasspath")) {
                        this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                    }
                } else {
                    Iterator i = ((AbstractList)oldFragment.getHosts()).iterator();
                    while (i.hasNext()) {
                        ((BundleGeneration)i.next()).bpkgs.fragmentIsZombie(this);
                    }
                }
                oldFragment.removeHost(null);
                purgeOld = false;
            } else {
                purgeOld = true;
            }
        } else {
            purgeOld = this.gen.unregisterPackages(false);
            if (purgeOld) {
                this.gen.closeClassLoader();
            } else {
                this.saveZombieGeneration();
            }
        }
        BundleGeneration oldGen = this.gen;
        this.state = 2;
        this.gen = newGeneration;
        this.doExportImport();
        if (purgeOld) {
            oldGen.purge(false);
        }
        if (wasResolved) {
            this.bundleThread().bundleChanged(new BundleEvent(64, this));
        }
        this.bundleThread().bundleChanged(new BundleEvent(8, this));
        this.operation = 0;
        if (wasActive) {
            try {
                this.start();
            }
            catch (BundleException be) {
                this.fwCtx.listeners.frameworkError(this, (Throwable)be);
            }
        }
    }

    public void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (this.gen.isExtension()) {
            this.secure.checkExtensionLifecycleAdminPerm(this);
        }
        this.secure.callUninstall0(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstall0() {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (null != this.gen) {
                try {
                    this.gen.archive.setStartLevel(-2);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            boolean doPurge = false;
            switch (this.state) {
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
                case 8: 
                case 16: 
                case 32: {
                    Exception exception;
                    try {
                        this.waitOnOperation(this.fwCtx.packages, "Bundle.uninstall", true);
                        exception = (this.state & 0x28) != 0 ? this.stop0() : null;
                    }
                    catch (Exception se) {
                        this.setStateInstalled(false);
                        this.fwCtx.packages.notifyAll();
                        exception = se;
                    }
                    this.operation = 4;
                    if (exception != null) {
                        this.fwCtx.listeners.frameworkError(this, (Throwable)exception);
                    }
                }
                case 2: 
                case 4: {
                    this.fwCtx.bundles.remove(this.location);
                    if (this.operation != 4) {
                        try {
                            this.waitOnOperation(this.fwCtx.packages, "Bundle.uninstall", true);
                            this.operation = 4;
                        }
                        catch (BundleException be) {
                            if (this.bundleContext != null) {
                                this.bundleContext.invalidate();
                                this.bundleContext = null;
                            }
                            this.operation = 4;
                            this.fwCtx.listeners.frameworkError(this, (Throwable)be);
                        }
                    }
                    if (this.state == 1) {
                        this.operation = 0;
                        throw new IllegalStateException("Bundle is in UNINSTALLED state");
                    }
                    if (this.gen.isFragment()) {
                        if (this.isAttached()) {
                            if (this.gen.isExtension()) {
                                if (this.gen.isBootClassPathExtension()) {
                                    this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                                }
                            } else {
                                Iterator i = ((AbstractList)this.gen.getHosts()).iterator();
                                while (i.hasNext()) {
                                    BundleGeneration hbg = (BundleGeneration)i.next();
                                    if (hbg.bpkgs == null) continue;
                                    hbg.bpkgs.fragmentIsZombie(this);
                                }
                            }
                            this.saveZombieGeneration();
                        } else {
                            doPurge = true;
                        }
                    } else {
                        boolean pkgsUnregistered = this.gen.unregisterPackages(false);
                        if (pkgsUnregistered) {
                            this.gen.closeClassLoader();
                            doPurge = true;
                        } else {
                            this.saveZombieGeneration();
                        }
                    }
                    this.state = 2;
                    this.bundleThread().bundleChanged(new BundleEvent(64, this));
                    this.cachedHeaders = this.gen.getHeaders0(null);
                    this.bactivator = null;
                    this.state = 1;
                    BundleGeneration oldGen = this.gen;
                    this.gen = new BundleGeneration(oldGen);
                    if (doPurge) {
                        oldGen.purge(false);
                    }
                    this.operation = 0;
                    if (this.bundleDir != null) {
                        if (this.bundleDir.exists() && !this.bundleDir.delete()) {
                            this.fwCtx.listeners.frameworkError(this, (Throwable)new IOException("Failed to delete bundle data"));
                        }
                        this.bundleDir = null;
                    }
                    this.fwCtx.packages.notifyAll();
                }
            }
        }
        this.fwCtx.listeners.bundleChanged(new BundleEvent(16, this));
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public long getBundleId() {
        return this.id;
    }

    public String getLocation() {
        this.secure.checkMetadataAdminPerm(this);
        return this.location;
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkUninstalled();
        Set sr = this.fwCtx.services.getRegisteredByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            Iterator i = sr.iterator();
            while (i.hasNext()) {
                res[pos++] = ((ServiceRegistration)i.next()).getReference();
            }
            return res;
        }
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkUninstalled();
        Set sr = this.fwCtx.services.getUsedByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            Iterator i = sr.iterator();
            while (i.hasNext()) {
                res[pos++] = ((ServiceRegistration)i.next()).getReference();
            }
            return res;
        }
        return null;
    }

    public boolean hasPermission(Object permission) {
        BundleGeneration fix = this.gen;
        this.checkUninstalled();
        if (permission instanceof Permission) {
            if (this.secure.checkPermissions()) {
                PermissionCollection pc = fix.getProtectionDomain().getPermissions();
                return pc != null ? pc.implies((Permission)permission) : false;
            }
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        this.secure.checkContextAdminPerm(this);
        return this.bundleContext;
    }

    public URL getResource(String name) {
        ClassLoader cl0;
        this.checkUninstalled();
        if (this.secure.okResourceAdminPerm(this) && !this.gen.isFragment() && this.getUpdatedState() != 2 && (cl0 = this.getClassLoader()) != null) {
            return cl0.getResource(name);
        }
        return null;
    }

    public String getSymbolicName() {
        return this.gen.symbolicName;
    }

    public long getLastModified() {
        return this.gen.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    public Map getSignerCertificates(int signersType) {
        void var2_2;
        ArrayList cs;
        boolean onlyTrusted;
        if (signersType == 1) {
            onlyTrusted = false;
        } else if (signersType == 2) {
            onlyTrusted = true;
        } else {
            throw new IllegalArgumentException("signersType not SIGNER_ALL or SIGNERS_TRUSTED");
        }
        BundleArchive fix = this.gen.archive;
        if (fix != null && (cs = fix.getCertificateChains((boolean)var2_2)) != null) {
            HashMap res = new HashMap();
            Iterator i = cs.iterator();
            while (i.hasNext()) {
                ArrayList chain = (ArrayList)i.next();
                res.put(chain.get(0), chain.clone());
            }
            return res;
        }
        return Collections.EMPTY_MAP;
    }

    public Version getVersion() {
        return this.gen.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUpdatedState() {
        if (this.state == 2) {
            try {
                Packages packages = this.fwCtx.packages;
                synchronized (packages) {
                    this.waitOnOperation(this.fwCtx.packages, "Bundle.resolve", true);
                    if (this.state == 2) {
                        String ee = this.gen.archive.getAttribute("Bundle-RequiredExecutionEnvironment");
                        if (ee != null) {
                            if (this.fwCtx.debug.packages) {
                                this.fwCtx.debug.println("bundle #" + this.gen.archive.getBundleId() + " has EE=" + ee);
                            }
                            if (!this.fwCtx.isValidEE(ee)) {
                                throw new BundleException("Unable to resolve bundle: Execution environment '" + ee + "' is not supported", 4);
                            }
                        }
                        if (this.gen.isFragment()) {
                            List hosts = this.gen.fragment.targets(this.fwCtx);
                            if (hosts != null) {
                                Iterator i = hosts.iterator();
                                while (i.hasNext()) {
                                    BundleImpl host = (BundleImpl)i.next();
                                    if (host.state == 2) {
                                        host.getUpdatedState();
                                        continue;
                                    }
                                    if (this.gen.fragment.isHost(host.gen)) continue;
                                    this.attachToFragmentHost(host.gen);
                                }
                                if (this.state == 2 && this.gen.fragment.hasHosts()) {
                                    this.state = 4;
                                    this.operation = 3;
                                    this.bundleThread().bundleChanged(new BundleEvent(32, this));
                                    this.operation = 0;
                                }
                            }
                        } else if (this.gen.resolvePackages()) {
                            this.state = 4;
                            this.operation = 3;
                            this.gen.updateStateFragments();
                            this.bundleThread().bundleChanged(new BundleEvent(32, this));
                            this.operation = 0;
                        } else {
                            throw new BundleException("Unable to resolve bundle: " + this.gen.bpkgs.getResolveFailReason(), 4);
                        }
                    }
                }
            }
            catch (BundleException be) {
                this.resolveFailException = be;
                this.fwCtx.listeners.frameworkError(this, (Throwable)be);
            }
        }
        return this.state;
    }

    boolean attachToFragmentHost(BundleGeneration host) {
        BundleGeneration fix = this.gen;
        if (fix.isFragment() && this.secure.okFragmentBundlePerm(this)) {
            try {
                if (fix.isExtension()) {
                    this.fwCtx.systemBundle.attachExtension(fix);
                } else {
                    host.attachFragment(fix);
                }
                fix.fragment.addHost(host);
                return true;
            }
            catch (Exception e) {
                this.fwCtx.listeners.frameworkWarning(this, e);
            }
        }
        return false;
    }

    File getDataRoot() {
        return this.bundleDir;
    }

    ClassLoader getClassLoader() {
        return this.gen.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateInstalled(boolean sendEvent) {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.bundleContext != null) {
                this.bundleContext.invalidate();
                this.bundleContext = null;
            }
            if (this.gen.isFragment()) {
                this.gen.fragment.removeHost(null);
            } else {
                this.gen.closeClassLoader();
                this.gen.unregisterPackages(true);
                this.gen.bpkgs.registerPackages();
            }
            this.state = 2;
            if (sendEvent) {
                this.operation = 5;
                this.bundleThread().bundleChanged(new BundleEvent(64, this));
            }
            this.operation = 0;
        }
    }

    void purge() {
        Vector fix;
        if (this.state == 1) {
            this.fwCtx.bundles.remove(this.location);
        }
        if ((fix = this.oldGenerations) != null) {
            this.oldGenerations = null;
            Iterator i = ((AbstractList)fix).iterator();
            while (i.hasNext()) {
                ((BundleGeneration)i.next()).purge(true);
            }
        }
    }

    BundleArchive getBundleArchive(long generation) {
        BundleGeneration bg = this.gen;
        if ((long)bg.generation == generation) {
            return bg.archive;
        }
        Vector fix = this.oldGenerations;
        if (fix != null) {
            for (int i = fix.size() - 1; i >= 0; --i) {
                bg = (BundleGeneration)fix.get(i);
                if ((long)bg.generation != generation) continue;
                return bg.archive;
            }
        }
        return null;
    }

    Iterator getExports() {
        BundlePackages bp = this.gen.bpkgs;
        Vector fix = this.oldGenerations;
        if (fix != null) {
            HashSet res = new HashSet();
            for (int i = fix.size() - 1; i >= 0; --i) {
                BundleGeneration bg = (BundleGeneration)fix.get(i);
                Iterator j = bg.bpkgs.getExports();
                while (j.hasNext()) {
                    res.add(j.next());
                }
            }
            if (bp != null) {
                Iterator i = bp.getExports();
                while (i.hasNext()) {
                    res.add(i.next());
                }
            }
            return res.iterator();
        }
        if (bp != null) {
            return bp.getExports();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    Vector getHosts(boolean zombieHosts) {
        Vector fix;
        Vector res = this.gen.getHosts();
        if (zombieHosts && (fix = this.oldGenerations) != null) {
            Iterator i = ((AbstractList)fix).iterator();
            while (i.hasNext()) {
                Vector h = ((BundleGeneration)i.next()).getHosts();
                if (h == null) continue;
                if (res != null) {
                    res.addAll(h);
                    continue;
                }
                res = h;
            }
        }
        return res;
    }

    List getRequiredBy() {
        BundlePackages bp = this.gen.bpkgs;
        Vector fix = this.oldGenerations;
        if (fix != null) {
            ArrayList res = new ArrayList();
            for (int i = fix.size() - 1; i >= 0; --i) {
                BundleGeneration bg = (BundleGeneration)fix.get(i);
                res.addAll(bg.bpkgs.getRequiredBy());
            }
            if (bp != null) {
                res.addAll(bp.getRequiredBy());
            }
            return res;
        }
        if (bp != null) {
            return bp.getRequiredBy();
        }
        return Collections.EMPTY_LIST;
    }

    void setAutostartSetting(int setting) {
        this.secure.callSetAutostartSetting(this, setting);
    }

    void setAutostartSetting0(int setting) {
        try {
            BundleArchive ba = this.gen.archive;
            if (null != ba) {
                ba.setAutostartSetting(setting);
            }
        }
        catch (IOException e) {
            this.fwCtx.listeners.frameworkError(this, (Throwable)e);
        }
    }

    int getAutostartSetting() {
        BundleArchive ba = this.gen.archive;
        return ba != null ? ba.getAutostartSetting() : -1;
    }

    int getStartLevel() {
        BundleArchive ba = this.gen.archive;
        if (ba != null) {
            return ba.getStartLevel();
        }
        return 0;
    }

    void setStartLevel(int n) {
        BundleArchive ba = this.gen.archive;
        if (ba != null) {
            try {
                ba.setStartLevel(n);
            }
            catch (Exception e) {
                this.fwCtx.listeners.frameworkError(this, (Throwable)new BundleException("Failed to set start level on #" + this.id, e));
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int detail) {
        StringBuffer sb = new StringBuffer();
        sb.append("BundleImpl[");
        sb.append("id=" + this.getBundleId());
        if (detail > 0) {
            sb.append(", state=" + this.getState());
        }
        if (detail > 1) {
            sb.append(", startlevel=" + this.getStartLevel());
        }
        if (detail > 3) {
            try {
                sb.append(", autostart setting=");
                sb.append(this.getAutostartSetting());
            }
            catch (Exception e) {
                sb.append(e.toString());
            }
        }
        if (detail > 4) {
            sb.append(", loc=" + this.location);
        }
        if (detail > 4) {
            sb.append(", symName=" + this.gen.symbolicName);
        }
        sb.append("]");
        return sb.toString();
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        if (this.secure.okResourceAdminPerm(this)) {
            if (this.state == 2 && !this.fwCtx.bundles.getFragmentBundles(this).isEmpty()) {
                this.getUpdatedState();
            }
            return this.secure.callFindEntries(this.gen, path, filePattern, recurse);
        }
        return null;
    }

    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            try {
                if ("/".equals(name)) {
                    return this.gen.getURL(0, "/");
                }
                BundleGeneration fix = this.gen;
                BundleResourceStream is = this.secure.callGetBundleResourceStream(fix.archive, name, 0);
                if (is != null) {
                    ((InputStream)is).close();
                    return fix.getURL(0, name);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            return this.secure.callFindResourcesPath(this.gen.archive, path);
        }
        return null;
    }

    public Dictionary getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        Dictionary res = this.secure.callGetHeaders0(this.gen, locale);
        if (res == null && this.cachedHeaders != null) {
            res = (Dictionary)this.cachedHeaders.clone();
            if (this.cachedHeaders == null) {
                return this.getHeaders(locale);
            }
        }
        return res;
    }

    public Enumeration getResources(String name) throws IOException {
        this.checkUninstalled();
        if (this.secure.okResourceAdminPerm(this) && !this.gen.isFragment()) {
            Enumeration e = null;
            if (this.getUpdatedState() != 2) {
                if (this instanceof SystemBundle) {
                    e = this.getClassLoader().getResources(name);
                } else {
                    BundleClassLoader cl0 = (BundleClassLoader)this.gen.getClassLoader();
                    if (cl0 != null) {
                        e = cl0.getResourcesOSGi(name);
                    }
                }
            }
            if (e != null && e.hasMoreElements()) {
                return e;
            }
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.secure.okClassAdminPerm(this)) {
            ClassLoader cl;
            this.checkUninstalled();
            if (this.gen.isFragment()) {
                throw new ClassNotFoundException("Can not load classes from fragment/extension bundles");
            }
            if (this.getUpdatedState() == 2) {
                throw new ClassNotFoundException(this.resolveFailException.getMessage());
            }
            if (this instanceof SystemBundle) {
                cl = ((SystemBundle)this).getClassLoader();
            } else {
                cl = this.gen.getClassLoader();
                if (cl == null) {
                    throw new IllegalStateException("state is uninstalled?");
                }
            }
            return cl.loadClass(name);
        }
        throw new ClassNotFoundException("No AdminPermission to get class: " + name);
    }

    boolean extensionNeedsRestart() {
        return this.gen.isExtension() && (this.state & 3) != 0;
    }

    boolean isAttached() {
        BundleGeneration fix = this.gen;
        return fix.fragment != null && fix.fragment.hasHosts();
    }

    String getFragmentHostName() {
        BundleGeneration fix = this.gen;
        if (fix.isFragment()) {
            return fix.fragment.hostName;
        }
        return null;
    }

    boolean triggersActivationPkg(String pkg) {
        return 16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1 && this.gen.isPkgActivationTrigger(pkg);
    }

    boolean triggersActivationCls(String name) {
        if (16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1) {
            String pkg = "";
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                pkg = name.substring(0, pos);
            }
            return this.gen.isPkgActivationTrigger(pkg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleThread bundleThread() {
        LinkedList linkedList = this.fwCtx.bundleThreads;
        synchronized (linkedList) {
            if (this.fwCtx.bundleThreads.isEmpty()) {
                return this.secure.createBundleThread(this.fwCtx);
            }
            return (BundleThread)this.fwCtx.bundleThreads.removeFirst();
        }
    }

    private void doExportImport() {
        if (!this.gen.isFragment()) {
            this.gen.bpkgs.registerPackages();
        }
    }

    private void removeBundleResources() {
        this.fwCtx.listeners.removeAllListeners(this.bundleContext);
        Set srs = this.fwCtx.services.getRegisteredByBundle(this);
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            try {
                ((ServiceRegistration)i.next()).unregister();
            }
            catch (IllegalStateException ignore) {}
        }
        Set s = this.fwCtx.services.getUsedByBundle(this);
        Iterator i2 = s.iterator();
        while (i2.hasNext()) {
            ServiceRegistrationImpl sri = (ServiceRegistrationImpl)i2.next();
            sri.ungetService(this, false);
        }
    }

    private void saveZombieGeneration() {
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("Save old BundleGeneration, " + this.gen);
        }
        if (this.oldGenerations == null) {
            this.oldGenerations = new Vector(1);
        }
        this.oldGenerations.add(this.gen);
    }

    private void checkUninstalled() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
    }
}

