/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Fragment;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleGeneration
implements Comparable {
    static final String KNOPFLERFISH_SYMBOLICNAME = "org.knopflerfish.framework";
    final BundleImpl bundle;
    final BundlePackages bpkgs;
    final BundleArchive archive;
    final int generation;
    final boolean v2Manifest;
    final String symbolicName;
    final boolean singleton;
    final Version version;
    final String attachPolicy;
    final Fragment fragment;
    final boolean lazyActivation;
    private final HashSet lazyIncludes;
    private final HashSet lazyExcludes;
    final long timeStamp;
    Vector fragments;
    private volatile HeaderDictionary cachedRawHeaders;
    private volatile ClassLoader classLoader;
    private ProtectionDomain protectionDomain;

    BundleGeneration(BundleImpl b, String exportStr) {
        this.fragments = null;
        this.cachedRawHeaders = null;
        this.bundle = b;
        this.archive = null;
        this.generation = 0;
        this.v2Manifest = true;
        this.symbolicName = KNOPFLERFISH_SYMBOLICNAME;
        this.singleton = false;
        this.version = new Version(Util.readFrameworkVersion());
        this.attachPolicy = "always";
        this.fragment = null;
        this.protectionDomain = null;
        this.lazyActivation = false;
        this.lazyIncludes = null;
        this.lazyExcludes = null;
        this.timeStamp = System.currentTimeMillis();
        this.bpkgs = new BundlePackages(this, exportStr);
        this.classLoader = b.getClassLoader();
    }

    BundleGeneration(BundleImpl b, BundleArchive ba, BundleGeneration prev) {
        long lastModified;
        Version newVer;
        Map e;
        Iterator i;
        block33: {
            this.fragments = null;
            this.cachedRawHeaders = null;
            this.bundle = b;
            this.generation = (prev != null ? prev.generation : -1) + 1;
            this.archive = ba;
            this.checkCertificates();
            String mv = this.archive.getAttribute("Bundle-ManifestVersion");
            this.v2Manifest = mv != null && mv.trim().equals("2");
            i = Util.parseEntries("Bundle-SymbolicName", this.archive.getAttribute("Bundle-SymbolicName"), true, true, true);
            e = null;
            if (i.hasNext()) {
                e = (Map)i.next();
                this.symbolicName = (String)e.get("$key");
            } else {
                if (this.v2Manifest) {
                    throw new IllegalArgumentException("Bundle has no symbolic name, location=" + this.bundle.location);
                }
                this.symbolicName = null;
            }
            String mbv = this.archive.getAttribute("Bundle-Version");
            newVer = Version.emptyVersion;
            if (mbv != null) {
                try {
                    newVer = new Version(mbv);
                }
                catch (Throwable ee) {
                    if (!this.v2Manifest) break block33;
                    throw new IllegalArgumentException("Bundle does not specify a valid Bundle-Version header. Got exception: " + ee.getMessage());
                }
            }
        }
        this.version = newVer;
        if (e != null) {
            this.singleton = "true".equals((String)e.get("singleton"));
            BundleImpl snb = b.fwCtx.bundles.getBundle(this.symbolicName, this.version);
            String tmp = (String)e.get("fragment-attachment");
            String string = this.attachPolicy = tmp == null ? "always" : tmp;
            if (snb != null && snb != this.bundle) {
                throw new IllegalArgumentException("Bundle with same symbolic name and version is already installed (" + this.symbolicName + ", " + this.version);
            }
        } else {
            this.attachPolicy = "always";
            this.singleton = false;
        }
        if ((i = Util.parseEntries("Fragment-Host", this.archive.getAttribute("Fragment-Host"), true, true, true)).hasNext()) {
            if (this.archive.getAttribute("Bundle-Activator") != null) {
                throw new IllegalArgumentException("A fragment bundle can not have a Bundle-Activator.");
            }
            e = (Map)i.next();
            String extension = (String)e.get("extension");
            String key = (String)e.get("$key");
            if ("framework".equals(extension) || "bootclasspath".equals(extension)) {
                if (!"system.bundle".equals(key) && !KNOPFLERFISH_SYMBOLICNAME.equals(key)) {
                    throw new IllegalArgumentException("An extension bundle must target the system bundle(system.bundle or org.knopflerfish.framework)");
                }
                if (this.archive.getAttribute("Import-Package") != null || this.archive.getAttribute("Require-Bundle") != null || this.archive.getAttribute("Bundle-NativeCode") != null || this.archive.getAttribute("DynamicImport-Package") != null || this.archive.getAttribute("Bundle-Activator") != null) {
                    throw new IllegalArgumentException("An extension bundle cannot specify: Import-Package, Require-Bundle, Bundle-NativeCode, DynamicImport-Package or Bundle-Activator");
                }
                if (!this.bundle.fwCtx.props.getBooleanProperty("org.osgi.supports.framework.extension") && "framework".equals(extension)) {
                    throw new UnsupportedOperationException("Framework extension bundles are not supported by this framework. Consult the documentation");
                }
                if (!this.bundle.fwCtx.props.getBooleanProperty("org.osgi.supports.bootclasspath.extension") && "bootclasspath".equals(extension)) {
                    throw new UnsupportedOperationException("Bootclasspath extension bundles are not supported by this framework. Consult the documentation");
                }
            } else if (extension != null) {
                throw new IllegalArgumentException("Did not recognize directive extension:=" + extension + ".");
            }
            this.fragment = new Fragment(key, extension, (String)e.get("bundle-version"));
        } else {
            this.fragment = null;
        }
        i = Util.parseEntries("Bundle-ActivationPolicy", this.archive.getAttribute("Bundle-ActivationPolicy"), true, true, true);
        if (i.hasNext()) {
            e = (Map)i.next();
            this.lazyActivation = "lazy".equals(e.get("$key"));
            if (this.lazyActivation) {
                this.lazyIncludes = e.containsKey("include") ? Util.parseEnumeration("include", (String)e.get("include")) : null;
                if (e.containsKey("exclude")) {
                    this.lazyExcludes = Util.parseEnumeration("exclude", (String)e.get("exclude"));
                    if (this.lazyIncludes != null) {
                        Iterator excsIter = this.lazyExcludes.iterator();
                        while (excsIter.hasNext()) {
                            String entry = (String)excsIter.next();
                            if (!this.lazyIncludes.contains(entry)) continue;
                            throw new IllegalArgumentException("Conflicting include/exclude entries in Bundle-ActivationPolicy: '" + entry + "' both included and excluded");
                        }
                    }
                } else {
                    this.lazyExcludes = null;
                }
            } else {
                this.lazyIncludes = null;
                this.lazyExcludes = null;
            }
        } else {
            this.lazyActivation = false;
            this.lazyIncludes = null;
            this.lazyExcludes = null;
        }
        this.bpkgs = new BundlePackages(this);
        try {
            if (b.fwCtx.startLevelController == null) {
                this.archive.setStartLevel(0);
            } else if (this.archive.getStartLevel() == -1) {
                this.archive.setStartLevel(b.fwCtx.startLevelController.getInitialBundleStartLevel());
            }
        }
        catch (Exception exc) {
            b.fwCtx.listeners.frameworkError(b, (Throwable)exc);
        }
        this.archive.setBundleGeneration(this);
        long l = lastModified = prev != null ? 0L : this.archive.getLastModified();
        if (lastModified == 0L) {
            lastModified = System.currentTimeMillis();
        }
        this.timeStamp = lastModified;
    }

    BundleGeneration(BundleGeneration prev) {
        this.fragments = null;
        this.cachedRawHeaders = null;
        this.bundle = prev.bundle;
        this.archive = null;
        this.generation = prev.generation + 1;
        this.v2Manifest = prev.v2Manifest;
        this.symbolicName = prev.symbolicName;
        this.singleton = prev.singleton;
        this.version = prev.version;
        this.attachPolicy = "never";
        this.fragment = null;
        this.protectionDomain = null;
        this.lazyActivation = false;
        this.lazyIncludes = null;
        this.lazyExcludes = null;
        this.timeStamp = System.currentTimeMillis();
        this.bpkgs = null;
        this.cachedRawHeaders = prev.cachedRawHeaders;
        this.classLoader = null;
    }

    public int compareTo(Object obj) {
        long diff = this.bundle.id - ((BundleGeneration)obj).bundle.id;
        if (diff < 0L) {
            return -1;
        }
        if (diff == 0L) {
            return 0;
        }
        return 1;
    }

    void checkPermissions(Object checkContext) {
        this.protectionDomain = this.bundle.secure.getProtectionDomain(this);
        try {
            this.bundle.secure.checkExtensionLifecycleAdminPerm(this.bundle, checkContext);
            if (this.isExtension() && !this.bundle.secure.okAllPerm(this.bundle)) {
                throw new IllegalArgumentException("An extension bundle must have AllPermission");
            }
        }
        catch (RuntimeException re) {
            this.purgeProtectionDomain();
            throw re;
        }
        if (this.archive.getLastModified() != this.timeStamp) {
            try {
                this.archive.setLastModified(this.timeStamp);
            }
            catch (IOException ioe) {
                this.bundle.fwCtx.listeners.frameworkError(this.bundle, (Throwable)ioe);
            }
        }
    }

    boolean resolvePackages() throws BundleException {
        ArrayList<BundleGeneration> detached = null;
        this.attachFragments();
        while (true) {
            if (this.bpkgs.resolvePackages()) {
                if (detached != null) {
                    for (int i = detached.size() - 2; i >= 0; --i) {
                        BundleGeneration bg = (BundleGeneration)detached.get(i);
                        if (!bg.bundle.attachToFragmentHost(this)) continue;
                        this.fragments.add(bg);
                    }
                }
                this.classLoader = this.bundle.secure.newBundleClassLoader(this);
                return true;
            }
            if (this.fragments == null) break;
            if (this.bundle.fwCtx.debug.packages) {
                this.bundle.fwCtx.debug.println("Resolve failed, remove last fragment and retry");
            }
            if (detached == null) {
                detached = new ArrayList<BundleGeneration>();
            }
            detached.add(this.detachLastFragment());
            if (!this.fragments.isEmpty()) continue;
            this.fragments = null;
        }
        return false;
    }

    boolean isPkgActivationTrigger(String packageName) {
        return this.lazyActivation && (this.lazyIncludes == null && this.lazyExcludes == null || this.lazyIncludes != null && this.lazyIncludes.contains(packageName) || this.lazyExcludes != null && !this.lazyExcludes.contains(packageName));
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    private void attachFragments() {
        Collection hosting;
        if (!this.attachPolicy.equals("never") && (hosting = this.bundle.fwCtx.bundles.getFragmentBundles(this.bundle)).size() > 0 && this.bundle.secure.okHostBundlePerm(this.bundle)) {
            Iterator iter = hosting.iterator();
            while (iter.hasNext()) {
                BundleGeneration fbg = (BundleGeneration)iter.next();
                fbg.bundle.attachToFragmentHost(this);
            }
        }
    }

    void attachFragment(BundleGeneration fragmentBundle) {
        int i;
        if (this.attachPolicy.equals("never")) {
            throw new IllegalStateException("Bundle does not allow fragments to attach");
        }
        if (this.attachPolicy.equals("resolve-time") && (this.bundle.state & 0x3C) != 0) {
            throw new IllegalStateException("Bundle does not allow fragments to attach dynamicly");
        }
        String failReason = this.bpkgs.attachFragment(fragmentBundle.bpkgs);
        if (failReason != null) {
            throw new IllegalStateException("Failed to attach: " + failReason);
        }
        if (this.classLoader != null && this.classLoader instanceof BundleClassLoader) {
            try {
                ((BundleClassLoader)this.classLoader).attachFragment(fragmentBundle);
            }
            catch (BundleException be) {
                throw new IllegalStateException(be.getMessage());
            }
        }
        if (this.bundle.fwCtx.debug.packages) {
            this.bundle.fwCtx.debug.println("Fragment(" + fragmentBundle.bundle + ") attached to host(id=" + this.bundle.id + ",gen=" + this.generation + ")");
        }
        if (this.fragments == null) {
            this.fragments = new Vector();
        }
        for (i = 0; i < this.fragments.size(); ++i) {
            BundleGeneration b = (BundleGeneration)this.fragments.get(i);
            if (b.bundle.id > fragmentBundle.bundle.id) break;
        }
        this.fragments.add(i, fragmentBundle);
    }

    private BundleGeneration detachLastFragment() {
        int last = this.fragments.size() - 1;
        if (last >= 0) {
            BundleGeneration fbg = (BundleGeneration)this.fragments.remove(last);
            this.bpkgs.detachFragment(fbg);
            if (this.bundle.fwCtx.debug.packages) {
                this.bundle.fwCtx.debug.println("Fragment(id=" + fbg.bundle.id + ") detached from host(id=" + this.bundle.id + ",gen=" + this.generation + ")");
            }
            if (fbg.bundle.state != 1) {
                fbg.fragment.removeHost(this);
                if (!fbg.fragment.hasHosts() && fbg == fbg.bundle.gen) {
                    fbg.bundle.setStateInstalled(true);
                }
            }
            return fbg;
        }
        return null;
    }

    void updateStateFragments() {
        if (this.fragments != null) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                BundleImpl fb = ((BundleGeneration)i.next()).bundle;
                fb.getUpdatedState();
            }
        }
    }

    Vector getHosts() {
        return this.fragment != null ? this.fragment.getHosts() : null;
    }

    boolean isFragment() {
        return this.fragment != null;
    }

    boolean isFragmentHost() {
        return this.fragments != null && this.fragments.size() > 0;
    }

    boolean isBootClassPathExtension() {
        return this.fragment != null && this.fragment.extension != null && this.fragment.extension.equals("bootclasspath");
    }

    boolean isExtension() {
        return this.fragment != null && this.fragment.extension != null;
    }

    private Dictionary getLocaleDictionary(String locale, String baseName) {
        Vector h;
        String defaultLocale = Locale.getDefault().toString();
        if (locale == null) {
            locale = defaultLocale;
        } else if (locale.equals("")) {
            return null;
        }
        Hashtable localization_entries = new Hashtable();
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((h = this.getHosts()) != null) {
            BundleGeneration best;
            while (true) {
                try {
                    best = null;
                    Iterator i = ((AbstractList)h).iterator();
                    while (i.hasNext()) {
                        BundleGeneration bg = (BundleGeneration)i.next();
                        if (best != null && bg.version.compareTo(best.version) <= 0) continue;
                        best = bg;
                    }
                }
                catch (ConcurrentModificationException ignore) {
                    continue;
                }
                break;
            }
            if (best == this.bundle.fwCtx.systemBundle.gen) {
                this.bundle.fwCtx.systemBundle.readLocalization("", localization_entries, baseName);
                this.bundle.fwCtx.systemBundle.readLocalization(defaultLocale, localization_entries, baseName);
                if (!locale.equals(defaultLocale)) {
                    this.bundle.fwCtx.systemBundle.readLocalization(locale, localization_entries, baseName);
                }
                return localization_entries;
            }
            if (best != null) {
                return best.getLocaleDictionary(locale, baseName);
            }
        }
        this.readLocalization("", localization_entries, baseName);
        this.readLocalization(defaultLocale, localization_entries, baseName);
        if (!locale.equals(defaultLocale)) {
            this.readLocalization(locale, localization_entries, baseName);
        }
        return localization_entries;
    }

    HeaderDictionary getHeaders0(String locale) {
        if (this.cachedRawHeaders == null) {
            this.cachedRawHeaders = this.archive.getUnlocalizedAttributes();
        }
        if ("".equals(locale)) {
            return (HeaderDictionary)this.cachedRawHeaders.clone();
        }
        if (this.bundle.state != 1) {
            String base = (String)this.cachedRawHeaders.get("Bundle-Localization");
            return this.localize(this.getLocaleDictionary(locale, base));
        }
        return null;
    }

    void addResourceEntries(Vector res, String path, String pattern, boolean recurse) {
        if (this.archive == null) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
        Enumeration e = this.archive.findResourcesPath(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url;
                String fp = (String)e.nextElement();
                boolean isDirectory = fp.endsWith("/");
                int searchBackwardFrom = fp.length() - 1;
                if (isDirectory) {
                    --searchBackwardFrom;
                }
                int l = fp.lastIndexOf(47, searchBackwardFrom);
                String lastComponentOfPath = fp.substring(l + 1, searchBackwardFrom + 1);
                if ((pattern == null || Util.filterMatch(pattern, lastComponentOfPath)) && (url = this.getURL(0, fp)) != null) {
                    res.add(url);
                }
                if (!isDirectory || !recurse) continue;
                this.addResourceEntries(res, fp, pattern, recurse);
            }
        }
    }

    Enumeration findEntries(String path, String filePattern, boolean recurse) {
        Vector res = new Vector();
        this.addResourceEntries(res, path, filePattern, recurse);
        if (this.isFragmentHost()) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                BundleGeneration fbg = (BundleGeneration)i.next();
                fbg.addResourceEntries(res, path, filePattern, recurse);
            }
        }
        return res.size() != 0 ? res.elements() : null;
    }

    URL getURL(int subId, String path) {
        try {
            StringBuffer u = new StringBuffer("bundle");
            u.append("://");
            u.append(this.bundle.id);
            if (this.generation > 0) {
                u.append('.').append(this.generation);
            }
            if (this.bundle.fwCtx.id > 0) {
                u.append('!').append(this.bundle.fwCtx.id);
            }
            if (subId > 0) {
                u.append(':').append(subId);
            }
            if (!path.startsWith("/")) {
                u.append('/');
            }
            u.append(path);
            return this.bundle.secure.getBundleURL(this.bundle.fwCtx, u.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    void closeClassLoader() {
        BundleClassLoader tmp;
        if (this.bundle.fwCtx.debug.classLoader) {
            this.bundle.fwCtx.debug.println("closeClassLoader: " + this.bundle + " gen = " + this.generation);
        }
        if ((tmp = (BundleClassLoader)this.classLoader) != null) {
            this.classLoader = null;
            tmp.close();
        }
    }

    void purge(boolean unregister) {
        if (this.bundle.fwCtx.debug.classLoader) {
            this.bundle.fwCtx.debug.println("BundleGeneration.purge: " + this.bundle + " gen = " + this.generation);
        }
        if (unregister) {
            this.unregisterPackages(true);
        }
        this.closeClassLoader();
        this.purgeProtectionDomain();
        if (this.archive != null) {
            this.archive.purge();
        }
    }

    boolean unregisterPackages(boolean force) {
        boolean res = this.bpkgs.unregisterPackages(force);
        if (res && this.isFragmentHost()) {
            while (this.detachLastFragment() != null) {
            }
            this.fragments = null;
        }
        return res;
    }

    void purgeProtectionDomain() {
        this.bundle.secure.purge(this.bundle, this.protectionDomain);
    }

    private void checkCertificates() {
        ArrayList cs = this.archive.getCertificateChains(false);
        if (cs != null && this.bundle.fwCtx.validator != null) {
            if (this.bundle.fwCtx.debug.certificates) {
                this.bundle.fwCtx.debug.println("Validate certs for bundle #" + this.archive.getBundleId());
            }
            cs = (ArrayList)cs.clone();
            Iterator vi = this.bundle.fwCtx.validator.iterator();
            while (!cs.isEmpty() && vi.hasNext()) {
                Validator v = (Validator)vi.next();
                Iterator ci = ((AbstractList)cs).iterator();
                while (ci.hasNext()) {
                    List c = (List)ci.next();
                    if (v.validateCertificateChain(c)) {
                        this.archive.trustCertificateChain(c);
                        ci.remove();
                        if (!this.bundle.fwCtx.debug.certificates) continue;
                        this.bundle.fwCtx.debug.println("Validated cert: " + c.get(0));
                        continue;
                    }
                    if (!this.bundle.fwCtx.debug.certificates) continue;
                    this.bundle.fwCtx.debug.println("Failed to validate cert: " + c.get(0));
                }
            }
            if (cs.isEmpty()) {
                return;
            }
        }
        if (this.bundle.fwCtx.props.getBooleanProperty("org.knopflerfish.framework.all_signed")) {
            throw new IllegalArgumentException("All installed bundles must be signed!");
        }
    }

    private HeaderDictionary localize(Dictionary localization_entries) {
        HeaderDictionary localized = (HeaderDictionary)this.cachedRawHeaders.clone();
        if (localization_entries != null) {
            Enumeration e = localized.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String unlocalizedEntry = (String)localized.get(key);
                if (!unlocalizedEntry.startsWith("%")) continue;
                String k = unlocalizedEntry.substring(1);
                String val = (String)localization_entries.get(k);
                if (val == null) {
                    localized.put(key, k);
                    continue;
                }
                localized.put(key, val);
            }
        }
        return localized;
    }

    private void readLocalization(String locale, Hashtable localization_entries, String baseName) {
        if (!locale.equals("")) {
            locale = "_" + locale;
        }
        while (true) {
            String l;
            Hashtable res;
            if ((res = this.getLocalizationEntries(l = baseName + locale + ".properties")) != null) {
                localization_entries.putAll(res);
                break;
            }
            int pos = locale.lastIndexOf(95);
            if (pos == -1) break;
            locale = locale.substring(0, pos);
        }
    }

    private Hashtable getLocalizationEntries(String name) {
        Hashtable res = this.archive.getLocalizationEntries(name);
        if (res == null && this.fragments != null) {
            Vector fix = (Vector)this.fragments.clone();
            Iterator i = ((AbstractList)fix).iterator();
            while (i.hasNext()) {
                BundleGeneration bg = (BundleGeneration)i.next();
                if (bg.archive == null || (res = bg.archive.getLocalizationEntries(name)) == null) continue;
                break;
            }
        }
        return res;
    }
}

