/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassPath;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ClassPatcher;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.PermissionOps;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

public final class BundleClassLoader
extends ClassLoader
implements BundleReference {
    final FrameworkContext fwCtx;
    final PermissionOps secure;
    final ProtectionDomain protectionDomain;
    BundleArchive archive;
    BundlePackages bpkgs;
    private final BundleClassPath classPath;
    private static ThreadLocal tlBundlesToActivate = new ThreadLocal();
    private static Method dexFileClassLoadDexMethod;
    private static Method dexFileClassLoadClassMethod;
    static boolean bDalvik;
    private ArrayList dexFile = null;
    Debug debug;
    static boolean bHasASM;
    static boolean bHasCheckedASM;
    protected static SecurityManagerExposer smex;
    static final SearchAction classSearch;
    static final SearchAction resourceSearch;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$org$knopflerfish$framework$BundleClassLoader;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;

    BundleClassLoader(BundleGeneration gen) throws BundleException {
        super(gen.bundle.fwCtx.parentClassLoader);
        this.fwCtx = gen.bundle.fwCtx;
        this.debug = this.fwCtx.debug;
        this.secure = this.fwCtx.perm;
        this.protectionDomain = gen.getProtectionDomain();
        this.bpkgs = gen.bpkgs;
        this.archive = gen.archive;
        this.classPath = new BundleClassPath(this.archive, gen.fragments, this.fwCtx);
        this.fwCtx.bundleClassLoaderCreated(this);
        if (this.debug.classLoader) {
            this.debug.println(this + " Created new classloader");
        }
    }

    boolean isBundlePatch() {
        if (!bHasCheckedASM) {
            try {
                Class.forName("org.objectweb.asm.ClassReader");
                bHasASM = true;
            }
            catch (Exception no_asm_class) {
                bHasASM = false;
            }
            bHasCheckedASM = true;
            if (this.debug.patch) {
                this.debug.println("ASM library: " + bHasASM);
            }
        }
        return bHasASM && this.fwCtx.props.getBooleanProperty("org.knopflerfish.framework.patch");
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String pkg;
        String path;
        int pos;
        if (name.startsWith("java.")) {
            return this.fwCtx.parentClassLoader.loadClass(name);
        }
        if (this.fwCtx.isBootDelegated(name)) {
            try {
                Class<?> bootDelegationCls = this.fwCtx.parentClassLoader.loadClass(name);
                if (this.debug.classLoader && bootDelegationCls != null) {
                    this.debug.println(this + " findClass: " + name + " boot delegation: " + bootDelegationCls);
                }
                return bootDelegationCls;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((pos = name.lastIndexOf(46)) != -1) {
            path = name.replace('.', '/');
            pkg = name.substring(0, pos);
        } else {
            path = name;
            pkg = null;
        }
        Class<?> res = (Class<?>)this.secure.callSearchFor(this, name, pkg, path + ".class", classSearch, true, this, null);
        if (res != null) {
            return res;
        }
        if (!this.fwCtx.props.STRICTBOOTCLASSLOADING && this.isBootClassContext(name)) {
            if (this.debug.classLoader) {
                this.debug.println(this + " trying parent loader for class=" + name + ", since it was loaded on the system loader itself");
            }
            if ((res = this.fwCtx.parentClassLoader.loadClass(name)) != null && this.debug.classLoader) {
                this.debug.println(this + " loaded " + name + " from " + this.fwCtx.parentClassLoader);
            }
            return res;
        }
        throw new ClassNotFoundException(name);
    }

    protected String findLibrary(String name) {
        String res = this.secure.callFindLibrary0(this, name);
        if (this.debug.classLoader) {
            this.debug.println(this + " Find library: " + name + (res != null ? " OK" : " FAIL"));
        }
        return res;
    }

    protected Enumeration findResources(String name) {
        return this.getBundleResources(name, false);
    }

    protected URL findResource(String name) {
        Enumeration res = this.getBundleResources(name, true);
        if (res != null) {
            return (URL)res.nextElement();
        }
        return null;
    }

    private boolean isNonBundleClass(Class cls) {
        return this.getClass().getClassLoader() != cls.getClassLoader() && !(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).isAssignableFrom(cls) && !(class$java$lang$Class == null ? (class$java$lang$Class = BundleClassLoader.class$("java.lang.Class")) : class$java$lang$Class).equals(cls) && !(class$java$lang$reflect$Proxy == null ? (class$java$lang$reflect$Proxy = BundleClassLoader.class$("java.lang.reflect.Proxy")) : class$java$lang$reflect$Proxy).equals(cls);
    }

    public boolean isBootClassContext(String name) {
        Class[] classStack = smex.getClassContext();
        if (classStack == null) {
            try {
                StackTraceElement[] classNames = new Throwable().getStackTrace();
                classStack = new Class[classNames.length];
                for (int i = 1; i < classNames.length; ++i) {
                    classStack[i] = Class.forName(classNames[i].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        for (int i = 1; i < classStack.length; ++i) {
            ClassLoader currentCL;
            Class currentCls = classStack[i];
            if (!this.isNonBundleClass(currentCls)) continue;
            ClassLoader cl = currentCL = currentCls.getClassLoader();
            while (cl != null && cl != cl.getClass().getClassLoader()) {
                if ((class$org$knopflerfish$framework$BundleClassLoader == null ? BundleClassLoader.class$("org.knopflerfish.framework.BundleClassLoader") : class$org$knopflerfish$framework$BundleClassLoader).isInstance(cl)) {
                    return false;
                }
                cl = cl.getClass().getClassLoader();
            }
            return !(class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleClassLoader.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).isInstance(classStack[i - 1]);
        }
        return false;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        BundleImpl b;
        Class c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        } else if (this.secure.getClassLoaderOf(c) == this && (b = (BundleImpl)this.getBundle()).triggersActivationCls(name)) {
            ArrayList bundlesToActivate;
            if (this.debug.lazy_activation) {
                this.debug.println(this + " lazy activation of #" + b.id + " triggered by loadClass(" + name + ")");
            }
            if (null == (bundlesToActivate = (ArrayList)tlBundlesToActivate.get())) {
                if (this.debug.lazy_activation) {
                    this.debug.println(this + " requesting lazy activation of #" + b.id);
                }
                try {
                    this.secure.callFinalizeActivation(b);
                }
                catch (BundleException e) {
                    this.fwCtx.listeners.frameworkError(b, (Throwable)e);
                }
            } else {
                boolean bundlePresent = false;
                int size = bundlesToActivate.size();
                for (int i = 0; i < size; ++i) {
                    BundleImpl tmp = (BundleImpl)bundlesToActivate.get(i);
                    if (tmp.id != b.id) continue;
                    bundlePresent = true;
                    break;
                }
                if (!bundlePresent) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " added #" + b.id + " to list of bundles to be activated.");
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name);
        }
        URL res = null;
        if (name.startsWith("java/")) {
            res = this.fwCtx.parentClassLoader.getResource(name);
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " file in java pkg: " + res);
            }
            return res;
        }
        if (this.fwCtx.isBootDelegatedResource(name) && (res = this.fwCtx.parentClassLoader.getResource(name)) != null) {
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " boot delegation: " + res);
            }
            return res;
        }
        res = this.findResource(name);
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name + " bundle space: " + res);
        }
        return res;
    }

    public Enumeration getResourcesOSGi(String name) throws IOException {
        int start;
        if (this.debug.classLoader) {
            this.debug.println(this + " getResources: " + name);
        }
        int n = start = name.startsWith("/") ? 1 : 0;
        if (name.substring(start).startsWith("java/")) {
            return this.fwCtx.parentClassLoader.getResources(name);
        }
        Enumeration res = null;
        if (this.fwCtx.isBootDelegatedResource(name)) {
            res = this.fwCtx.parentClassLoader.getResources(name);
        }
        if (res == null || !res.hasMoreElements()) {
            res = this.findResources(name);
        }
        return res;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "BundleClassLoader(id=" + this.bpkgs.bg.bundle.id + ",gen=" + this.bpkgs.bg.generation + ")";
    }

    public Bundle getBundle() {
        return this.bpkgs.bg.bundle;
    }

    void close() {
        this.archive = null;
        this.fwCtx.bundleClassLoaderClosed(this);
        if (this.debug.classLoader) {
            this.debug.println(this + " Cleared archives");
        }
    }

    Enumeration getBundleResources(String name, boolean onlyFirst) {
        if (this.debug.classLoader) {
            this.debug.println(this + " Find bundle resource" + (onlyFirst ? "" : "s") + ": " + name);
        }
        String pkg = null;
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            int start = name.startsWith("/") ? 1 : 0;
            pkg = name.substring(start, pos).replace('/', '.');
        } else {
            pkg = null;
        }
        return (Enumeration)this.secure.callSearchFor(this, null, pkg, name, resourceSearch, onlyFirst, this, null);
    }

    BundlePackages getBpkgs() {
        return this.bpkgs;
    }

    void attachFragment(BundleGeneration gen) throws BundleException {
        if (this.debug.classLoader) {
            this.debug.println(this + " fragment attached update classpath");
        }
        this.classPath.attachFragment(gen);
    }

    Object searchFor(String name, String pkg, String path, SearchAction action, boolean onlyFirst, BundleClassLoader requestor, HashSet visited) {
        try {
            BundleImpl b = (BundleImpl)this.getBundle();
            boolean initiator = false;
            ArrayList<BundleImpl> bundlesToActivate = null;
            if (action == classSearch) {
                boolean bundlePresent = false;
                bundlesToActivate = (ArrayList<BundleImpl>)tlBundlesToActivate.get();
                boolean bl = initiator = bundlesToActivate == null;
                if (initiator) {
                    bundlesToActivate = new ArrayList<BundleImpl>();
                    tlBundlesToActivate.set(bundlesToActivate);
                } else {
                    bundlePresent = bundlesToActivate.contains(b);
                }
                if (!bundlePresent && b.triggersActivationPkg(pkg)) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " lazy activation of #" + b.id + " triggered by searchFor(" + name + ")");
                    }
                }
            }
            Object res = this.searchFor0(name, pkg, path, action, onlyFirst, requestor, visited);
            if (initiator) {
                tlBundlesToActivate.set(null);
                for (int i = bundlesToActivate.size() - 1; i >= 0; --i) {
                    BundleImpl tmp = (BundleImpl)bundlesToActivate.get(i);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " requesting lazy activation of #" + tmp.id);
                    }
                    try {
                        tmp.finalizeActivation();
                        continue;
                    }
                    catch (BundleException e) {
                        this.fwCtx.listeners.frameworkError(tmp, (Throwable)e);
                    }
                }
            }
            return res;
        }
        catch (Error te) {
            tlBundlesToActivate.set(null);
            throw te;
        }
    }

    Object searchFor0(String name, String pkg, String path, SearchAction action, boolean onlyFirst, BundleClassLoader requestor, HashSet visited) {
        Vector av;
        Iterator ep;
        BundlePackages pbp;
        Class<?> c;
        if (action == classSearch && requestor != this && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        if (this.debug.classLoader) {
            this.debug.println(this + " Search for: " + path);
        }
        if (pkg != null) {
            pbp = this.bpkgs.getProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                    try {
                        return this.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
                BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                if (cl != this && (visited == null || cl != null && !visited.contains(cl))) {
                    if (cl != null) {
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Import search: " + path + " from #" + pbp.bg.bundle.id);
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(this + " No import found: " + path);
                    }
                    return null;
                }
            } else {
                ArrayList pl = this.bpkgs.getRequiredBundleGenerations(pkg);
                if (pl != null) {
                    if (visited == null) {
                        visited = new HashSet<BundleClassLoader>();
                    }
                    visited.add(this);
                    Iterator pi = ((AbstractList)pl).iterator();
                    while (pi.hasNext()) {
                        Object res;
                        BundleClassLoader cl;
                        BundleGeneration pbg = (BundleGeneration)pi.next();
                        if (pbg == null || (cl = (BundleClassLoader)pbg.getClassLoader()) == null || visited.contains(cl)) continue;
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Required bundle search: " + path + " from #" + pbg.bundle.id);
                        }
                        if ((res = this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited)) == null) continue;
                        return res;
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(this + " Required bundle search: " + "Not found, continuing with local search.");
                    }
                }
            }
            ep = this.bpkgs.getExports(pkg);
        } else {
            ep = null;
        }
        if (this != requestor && ep != null) {
            boolean blocked = true;
            while (ep.hasNext()) {
                if (!((ExportPkg)ep.next()).checkFilter(name)) continue;
                blocked = false;
                break;
            }
            if (blocked) {
                if (this.debug.classLoader) {
                    this.debug.println(this + " Filter check blocked search for: " + name);
                }
                return null;
            }
        }
        if ((av = this.classPath.componentExists(path, onlyFirst)) != null) {
            try {
                return action.get(av, path, name, pkg, this);
            }
            catch (IOException ioe) {
                this.fwCtx.listeners.frameworkError(this.bpkgs.bg.bundle, (Throwable)ioe);
                return null;
            }
        }
        if (ep != null) {
            return null;
        }
        if (pkg != null) {
            pbp = this.bpkgs.getDynamicProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                    try {
                        return this.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != null) {
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Dynamic import search: " + path + " from #" + pbp.bg.bundle.id);
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                    }
                }
            }
            if (this.debug.classLoader) {
                this.debug.println(this + " No dynamic import: " + path);
            }
        }
        return null;
    }

    private static boolean isSystemBundle(BundleImpl bundle) {
        return bundle == bundle.fwCtx.systemBundle;
    }

    private void walkAndAddJars(List dexlist, String path) throws Exception {
        File root = new File(path);
        File[] list = root.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File f = list[i];
            if (f.isDirectory()) {
                this.walkAndAddJars(dexlist, f.getAbsolutePath());
                continue;
            }
            if (!f.getAbsolutePath().endsWith(".jar")) continue;
            if (this.debug.classLoader) {
                this.debug.println("creating DexFile from " + f.getAbsolutePath());
            }
            Object dex = dexFileClassLoadDexMethod.invoke(null, f.getAbsolutePath(), f.getAbsolutePath() + ".dexopt", new Integer(0));
            dexlist.add(dex);
        }
    }

    private Class getDexFileClass(String name) throws Exception {
        if (this.debug.classLoader) {
            this.debug.println("loading dex class " + name);
        }
        if (this.dexFile == null) {
            Object dex;
            this.dexFile = new ArrayList();
            File f = new File(this.archive.getJarLocation());
            if (!f.isDirectory()) {
                if (this.debug.classLoader) {
                    this.debug.println("creating DexFile from " + f);
                }
                dex = dexFileClassLoadDexMethod.invoke(null, f.getAbsolutePath(), f.getAbsolutePath() + ".dexopt", new Integer(0));
                this.dexFile.add(dex);
                if (this.debug.classLoader) {
                    this.debug.println("created DexFile from " + f);
                }
            } else {
                if (this.debug.classLoader) {
                    System.err.println("creating DexFile from " + f + "/classes.dex");
                }
                dex = dexFileClassLoadDexMethod.invoke(null, f.getAbsolutePath() + "/classes.dex", f.getAbsolutePath() + ".dexopt", new Integer(0));
                this.dexFile.add(dex);
                if (this.debug.classLoader) {
                    this.debug.println("created DexFile from " + f + File.pathSeparatorChar + "classes.dex");
                }
                this.walkAndAddJars(this.dexFile, f.getAbsolutePath());
            }
        }
        String path = name.replace('.', '/');
        Iterator i = ((AbstractList)this.dexFile).iterator();
        while (i.hasNext()) {
            Object dex = i.next();
            if (this.debug.classLoader) {
                this.debug.println("trying to load " + path + " from " + dex);
            }
            try {
                Class clz = (Class)dexFileClassLoadClassMethod.invoke(dex, path, this);
                if (clz != null) {
                    if (this.debug.classLoader) {
                        this.debug.println("loaded " + path + " from " + dex);
                    }
                    return clz;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.debug.classLoader) continue;
            this.debug.println("failed to load " + path + " from " + dex);
        }
        throw new ClassNotFoundException("could not find dex class " + path);
    }

    String findLibrary0(String name) {
        return this.classPath.getNativeLibrary(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bDalvik = false;
        try {
            Class<?> dexFileClass = null;
            try {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            dexFileClassLoadDexMethod = dexFileClass.getMethod("loadDex", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            dexFileClassLoadClassMethod = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            bDalvik = true;
        }
        catch (Exception e) {
            dexFileClassLoadDexMethod = null;
            dexFileClassLoadClassMethod = null;
        }
        bHasASM = false;
        bHasCheckedASM = false;
        smex = new SecurityManagerExposer();
        classSearch = new SearchAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Vector items, String path, String name, String pkg, BundleClassLoader cl) throws IOException {
                byte[] bytes = ((FileArchive)items.get(0)).getClassBytes(path);
                if (bytes != null) {
                    if (cl.isBundlePatch()) {
                        bytes = ClassPatcher.getInstance(cl).patch(name, bytes);
                    }
                    if (cl.debug.classLoader) {
                        cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - load class: " + name);
                    }
                    BundleClassLoader bundleClassLoader = cl;
                    synchronized (bundleClassLoader) {
                        Class c = cl.findLoadedClass(name);
                        if (c == null) {
                            if (pkg != null && cl.getPackage(pkg) == null) {
                                cl.definePackage(pkg, null, null, null, null, null, null, null);
                            }
                            if (bDalvik) {
                                try {
                                    c = cl.getDexFileClass(name);
                                }
                                catch (Exception e) {
                                    throw new IOException("Failed to load dex class '" + name + "', " + e);
                                }
                            }
                            if (c == null) {
                                c = cl.protectionDomain == null ? cl.defineClass(name, bytes, 0, bytes.length) : cl.defineClass(name, bytes, 0, bytes.length, cl.protectionDomain);
                            }
                        }
                        return c;
                    }
                }
                return null;
            }
        };
        resourceSearch = new SearchAction(){

            public Object get(Vector items, String path, String name, String pkg, BundleClassLoader cl) throws IOException {
                Vector<URL> answer = new Vector<URL>();
                for (int i = 0; i < items.size(); ++i) {
                    FileArchive fa = (FileArchive)items.elementAt(i);
                    URL url = fa.getBundleGeneration().getURL(fa.getSubId(), path);
                    if (url != null) {
                        if (cl.debug.classLoader) {
                            cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - found: " + path + " -> " + url);
                        }
                    } else {
                        return null;
                    }
                    answer.addElement(url);
                }
                return answer.elements();
            }
        };
    }

    static interface SearchAction {
        public Object get(Vector var1, String var2, String var3, String var4, BundleClassLoader var5) throws IOException;
    }

    static class SecurityManagerExposer
    extends SecurityManager {
        SecurityManagerExposer() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

